#include <stdio.h>
#include <setjmp.h>
#include "cells.h"

extern int linecount;
extern jmp_buf top_level;
extern int ident_char_p();

void fprintd(FILE *, EXP, int);


FILE *output;
#ifdef MSDOS
extern void AbortGraph();
#else
void AbortGraph() { ;; }
#endif
/*****************************************************************************
 *
 *
 *
 */
extern EXP jmpresult;

void c_warn_header(char *str)
{
  	fprintf(stderr, "RefLisp: ***** ");
	fprintf(stderr," %s at line %d: ", str,linecount);
}
void c_warning(char *str, EXP exp)
{
        c_warn_header(str);
	fprints(stderr,exp, PRIN1);
        fprintf(stderr,"\n");
	fflush(stderr);
}
void c_error(char *str, EXP exp)
{
	AbortGraph();
   	c_warning(str,exp);
	/* set up the return value */
	jmpresult = exp;

	/* jump back to the (catch) */
	longjmp(cvoidr(value(lookup("error-tag"))), (int) 0);
}
EXP c_error_func(char *str, EXP exp)
{
	c_error(str,exp);
	return(NIL);
}
void serr(char *str)
{
   AbortGraph();
   fprintf(stderr, "RefLisp: ***** %s at line %d\n", str, linecount);
	longjmp(top_level, 2);
}
void fatal_err(char *str)
{
   AbortGraph();
   fprintf(stderr, "RefLisp: %s at line %d\n", str, linecount);
	longjmp(top_level, 3);
}
/*****************************************************************************
 *
 *  Print the CDR side of a list
 *
 */
void fprintd(FILE *stream, EXP x, int mode)
{
   lif( null(x) ){
   }
   else lif( consp(x) ) {
      fprintf(stream, " ");
      fprints(stream, car(x) , mode );
      fprintd(stream, cdr(x) , mode);
   }
   else {
      fprintf(stream, " . ");
      fprints(stream, x, mode);
   }
}

/*****************************************************************************
 *
 *  print out a symbol, escaping weird characters.
 *
 */
void fprin1_ident(FILE *stream, char *c)
{
	while( *c != '\0') {
		if( !ident_char_p( *c ) )
                	putc( '\\' , stream);
		putc( *c , stream);
      		c++;
        }
}
EXP single_form(EXP x)
{
	lif( consp(cdr(x)) ) {
		lif(null(cdr(cdr(x)))) {
                	return(T);
		}
		else {
                	return(NIL);
                }
	}
        return(T);
}
/*****************************************************************************
 *
 *  print out an s-expression
 *
 */
void fprints(FILE *stream, EXP x, int mode)
{
 	lif( null(x) ) {
	  fprintf(stream, " nil ");
   }
	else if( x == PRINTNAME ) {
      fprintf(stream, "PNAME");
   }
	else
	lif( stringp( x ) ) {
	  if( mode == PRIN1) fprintf(stream, "\"" );
	  if( mode == PRINSYMBOL)
		fprin1_ident(stream, csr(x));
          else
		fprintf(stream, "%s", csr(x) );
	  if( mode == PRIN1) fprintf(stream, "\"" );
   }
	else lif( bigstringp( x ) ) {

	  if( mode == PRIN1) fprintf(stream, "\"" );
		while(x != NIL) {
	  		if( mode == PRINSYMBOL)
				fprin1_ident(stream, csr(x->reg.zpair.zcar));
   		       else
				fprintf(stream, "%s", csr(x->reg.zpair.zcar) );
			x = x->reg.zpair.zcdr;
		}
	  if( mode == PRIN1) fprintf(stream, "\"" );
   }
	else lif( idp( x ) ) {
		EXP name = nameof(x);

		fprints(stream, name, (mode == PRINC?PRINC:PRINSYMBOL));
   }
   else lif( fixp(x) ) {
      fprintf(stream, "%d", cir(x));
   }
   else lif( floatp(x) ) {
	   fprintf(stream, "%g", cflor(x));
   }
   else lif( filep(x) ) {
      fprintf(stream, "<file:%ld>",cor(x));
   }
   else lif( subrp(x) ) {
      fprintf(stream, "<subr:%ld>",cfr(x));
   }
   else lif( fsubrp(x) ) {
      fprintf(stream, "<fsubr:%ld>",cfr(x));
   }
   else lif( consp(x) ) {
	if( mode == PRIN1) {
		lif(eq(car(x), quote)) {
			lif(single_form(x)) {
				fprintf(stream, "'");
				fprints(stream, car(cdr(x)),mode);
				return;
                        }
		}
                else lif(eq(car(x), backquote)) {
			lif(single_form(x)) {
				putc(BQUOTECHAR,stream);
				fprints(stream, car(cdr(x)),mode);
				return;
			}
                }
		else lif(eq(car(x), comma)) {
			lif(single_form(x)) {
				putc(COMMACHAR,stream);
				fprints(stream, car(cdr(x)),mode);
				return;
                	}
		}
		else lif(eq(car(x), comma_at)) {
			lif(single_form(x)) {
				putc(COMMACHAR,stream);
				putc(ATCHAR,stream);
				fprints(stream, car(cdr(x)),mode);
                                return;
			}
		}
		else lif(eq(car(x), func_quote)) {
			lif(single_form(x)) {
				putc(FUNCCHAR,stream);
				putc(QUOTECHAR,stream);
				fprints(stream, car(cdr(x)),mode);
                                return;
                        }
		}
	}

	fprintf(stream, "(");
	fprints(stream, car(x), mode);
	fprintd(stream, cdr(x), mode);
	fprintf(stream, ")");

   }

	else fprintf(stream, " something else");

}
/*****************************************************************************

 *
 *
 *
 */
void c_prints(EXP x)
{
   fprints(stdout, x, PRINC);
}

EXP bprinc1(EXP args, int mode)
{
	lif( consp(args) ) {
		lif( lnot(null(cdr(args)))) {
			fprints(cor(car(cdr(args))), car(args), mode);
		}
                else {
			fprints(output, car(args), mode);
                }
	}
   	return( car(args) );
}
EXP bprinc(EXP args) 
{
	return(bprinc1(args,PRINC));
}
EXP bprin1(EXP args) 
{
	return(bprinc1(args,PRIN1));
}
EXP bwrs(EXP args)
{ 
EXP tmp = NIL;
trace("bwrs: ");
trace_exp(args);

	tmp = newocell(output);
	output = cor(car(args));
   	return( tmp );
}
EXP bwrite(EXP args)
{
register EXP filename = NIL;
FILE *fd;

	filename = car(args);
	lif( lnot(filep(filename))) {
		c_error("non-file in write",filename);
		return(NIL);
	}
	else 
		fd = cor(filename);

	args = cdr(args);
	while( args != NIL) {
		fprints(fd,car(args) , PRINC);
		args = cdr(args);
	}
	return(T);
}
EXP bputcs(EXP args)
{
register EXP filename= NIL;
FILE *fd;

	lif( null(cdr(args)) )
		fd = stdout;
	else {
		filename = car(cdr(args));
		lif(lnot(filep(filename))) {
			serr("non-file passed to putc");
			return(NIL);
		}
		else 
			fd = cor(filename);
	}
	putc( cir(car(args))&127, fd );
	return(T);
}
EXP bflush(EXP args)
{
FILE *fd;
register EXP filename = NIL;

	lif( null(args) )
		fd = stdout;
	else {
		filename = car(args);
		lif( lnot(filep(filename))) {
			serr("non-file passed to flush");
			return(NIL);
		}
		fd = cor(filename);
	} 
	fflush(fd);
	return(T);
}

void InitPrint()
{
   output = stdout;
   set(lookup("force-output"), newfcell(bflush) );
   set(lookup("*standard-output*"), newocell(stdout));
   set(lookup("*standard-input*"), newocell(stdin));
   set(lookup("*error-output*"), newocell(stderr));
   set(lookup("write-char"), newfcell(bputcs) );
   set( lookup("prin1"), newfcell(bprin1));
   set( lookup("princ"), newfcell(bprinc));
   set( lookup("write"), newfcell(bwrite));
   set( lookup("wrs"), newfcell(bwrs));
}
 
