#ifdef UNIX
#include <stdlib.h>
#include <stdio.h>
#include "cells.h"
#include <time.h>
#include <limits.h>
#include <setjmp.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/sem.h>

LISPFUNC(bsemctl)
{
int id = cir(car(args));
int num = cir(nth((int)1, args));
int cmd = cir(nth((int)2, args));
union semun {
	int val;
	struct semid_ds *buf;
	ushort *array;
} arg;
arg.val = cir(nth((int)3, args));

	return(newicell(semctl(id,num,cmd,arg.val)));
}
LISPFUNC(bsemget)
{
key_t key = cir(car(args));
int nsems = cir(nth((int)1, args));
int flag = cir(nth((int)2, args));

	return(newicell(semget(key,nsems,flag)));
}
LISPFUNC(bsemop)
{
int semid = cir(car(args));
struct sembuf sops[1];

sops[0].sem_num = cir(nth((int)1, args));
sops[0].sem_op = cir(nth((int)2, args));
sops[0].sem_flg = cir(nth((int)3, args));

	return(newicell(semop(semid,&sops,(int)1)));
}
LISPFUNC(bpipe)
{
int fildes[2];

	args = args;     /* ARGSUSED */

	if(pipe(fildes) != 0) {
		return(newbigstring(strerror(errno)));
	}
	else {
		return(cons(newocell(fdopen(fildes[0],"r")),
			newocell(fdopen(fildes[1],"w")) ));

	}
}
LISPFUNC(bfork)
{
	args = args;     /* ARGSUSED */

	return(newicell(fork()));
}
#endif
char *InitIPC()
{
#ifdef UNIX
   set(lookup("pipe"), newfcell(bpipe) );

   set(lookup("fork"), newfcell(bfork) );

   set(lookup("semctl"), newfcell(bsemctl) );
   set(lookup("semget"), newfcell(bsemget) );
   set(lookup("semop"), newfcell(bsemop) );
#endif

}


