
#ifndef LASER
#include <stdio.h>
#include "cells.h"
void InitGraph() {};

EXP bpline(EXP args)
{
	args = args;
	return(NIL);
}
#endif

#ifdef LASER
#include <stdio.h>
#include <math.h>
#include <osbind.h>
#include <obdefs.h>
#include <gemdefs.h>
#include "cells.h"

#define PRT 0
#define AUX 1
#define CON 2
#define MIDI 3

#define B_EVSIZE 4
typedef struct b_message {
	int type;
	int used;
	int data[B_EVSIZE];
} B_MSG;

/*
 * System messages 0 .. 1000
 *
 *		User messages are -ve integers
 */
#define B_NULL_MSG		0
#define B_MOUSE_DOWN 	1
#define B_MOUSE_DOWN_SHIFT 	5
#define B_MOUSE_UP		2
#define B_MOUSE_MOVE 	3
#define B_REDRAW		4
/* 
 * FILE
 */
#define B_NEW		11
#define B_OPEN		12
#define B_CLOSE		13
#define B_SAVE		14
#define B_PRINT		15
#define B_QUIT		16
/*
 * EDIT
 */
#define	B_UNDO		21
#define	B_CUT		22
#define	B_COPY		23
#define	B_PASTE		24
#define B_CLEAR		25
#define B_DUPLICATE 26
#define	B_SELECT_ALL 27
/*
 * Other Raw Messages
 */
#define B_KEYB 		100
#define B_MIDI		200
#define B_V24 		300
 
/* GEM juk */
	int apl_id;
	MFDB	myscreen;
	int phys_handle,a,b,c,d;

/* VDI junk */
int vdi_handle;
int contrl[12];
int ptsin[256];
int intout[256];
int ptsout[256];
int intin[256];

#define clipx(z) (z>ScreenWidth?ScreenWidth:z)
#define clipy(z) (z>ScreenHeight?ScreenHeight:z)

/* Standardised screen size */
#define SCREENSIZEX 6400
#define SCREENSIZEY 4000

/* Actual Screen Size */
int	ScreenWidth;
int	ScreenHeight;

/* Scaling from Virtual to Physical Screen size, factors */
#define SCALEX(x) ((int)(((float)x*(float)ScreenWidth)/SCREENSIZEX))
#define SCALEY(x) (ScreenHeight -((int)(((float)x*(float)ScreenHeight)/SCREENSIZEY)))

/* Scaling from Physical to Virtual Screen size, factors */
#define ELACSX(x) ((int)(((float)x*(float)SCREENSIZEX)/ScreenWidth))
#define ELACSY(x) ((int)(((float)(ScreenHeight -x)*(float)SCREENSIZEY)/ScreenHeight))

clip(x,y,m,b)
float *x, *y;
float m, b;
{

	if( *x < 0) {
		*x = 0;
		*y = m*(*x) + b;
	}
	if( *x > SCREENSIZEX) {
		*x = SCREENSIZEX-1;
		*y = m*(*x) + b;
	}
	if( *y > SCREENSIZEY) {
		*y = SCREENSIZEY-1;
		if( m == 0) 
			*x = SCREENSIZEX;
		else
			*x = (*y - b)/m;
	}
	if( *y < 0) {
		*y = 0;
		if( m == 0) 
			*x = SCREENSIZEX;
		else
			*x = (*y - b)/m;
	}
}

#define inside(x,y) (	((x)<SCREENSIZEX) \
					&& ((x) >= 0) \
					&& ((y)<SCREENSIZEY) \
					&& ((y) >= 0))

#define fpequals(a,b) (a-b<1.0E-10)

b_pline( x1, y1, x2, y2)
int x1,y1,x2,y2;
{
  int arry[2][2];
#ifdef DEBUG
printf("b_pline: x1 %d y1 %d x2 %d y2 %d\n",x1,y1,x2,y2);
#endif
  
    arry[0][0] = clipx(SCALEX(x1));
    arry[0][1] = clipy(SCALEY(y1));
    arry[1][0] = clipx(SCALEX(x2));
    arry[1][1] = clipy(SCALEY(y2));

#ifdef DEBUG
{
int i;
printf("b_pline: ");
	for(i=0;i<2;i++)
		printf("%d %d\n", arry[i][0], arry[i][1]);
}
#endif
	v_hide_c(vdi_handle);
    v_pline(vdi_handle, 2, arry);
	v_show_c(vdi_handle,0);
}

b_fpline( x1, y1, x2, y2)
float x1,y1,x2,y2;
{
int arry[2][2];
float m;
float b;			/* y axis intercept */

	if( fpequals(x2, x1) )
		m = 1e-10;
	else
		m = (y2 -y1)/(x2 - x1);	/* slope */ 

	b = y1 - m*x1;
	clip(&x1, &y1, m ,b); 
	clip(&x1, &y1, m ,b);
	clip(&x2, &y2, m ,b);
	clip(&x2, &y2, m ,b);

	if(inside(x1,y1) && inside(x2,y2)) {

#ifdef DEBUG
printf("b_pline: x1 %d y1 %d x2 %d y2 %d\n",x1,y1,x2,y2);
#endif
  
	
    arry[0][0] = SCALEX(x1);
    arry[0][1] = SCALEY(y1);
    arry[1][0] = SCALEX(x2);
    arry[1][1] = SCALEY(y2);

	v_hide_c(vdi_handle);	/* make mouse pointer dissappear,
							* because XOR line over it leave junk 
							* behind.
							*/
    v_pline(vdi_handle, 2, arry);
	v_show_c(vdi_handle,0); /* reappear */
	}
}
EXP bpline(args)
EXP args;
{
EXP x1,y1,x2,y2;

	x1 = car(args);
	y1 = car(cdr(args));
	x2 = car(cdr(cdr(args)));
	y2 = car(cdr(cdr(cdr(args))));

	if( floatp(x1) || floatp(x2) || floatp(y1) || floatp(y2) )
		b_fpline( cflor(x1), cflor(y1), cflor(x2), cflor(y2));
	else
		b_pline( cir(x1), cir(y1), cir(x2), cir(y2));
	return(T);
}

EXP bsetlut(args)
EXP args;
{
int color,newcolor, oldcolor, red, green, blue;

	color = cir(car(args))& 0xf;
	red = cir(car(cdr(args)))& 0xf;
	green = cir(car(cdr(cdr(args))))& 0xf;
	blue = cir(car(cdr(cdr(cdr(args)))));
	newcolor  = blue + (green << 4) + (red << 8) ;
	oldcolor = Setcolor(color, newcolor);

	return( cons( newicell((oldcolor >> 8) & 0xf ) ,
			cons( newicell((oldcolor >> 4) & 0xf), 
			cons( newicell((oldcolor >> 0) & 0xf) , NIL ))));
}

EXP GraphOpen(args)
EXP args;
{


	apl_id = appl_init();
	vdi_handle =open_workstation(&myscreen);

	phys_handle = graf_handle(&a,&b,&c,&d);	
	ScreenWidth = myscreen.fd_w;
	ScreenHeight = myscreen.fd_h;

	v_clrwk(vdi_handle);
	vsl_color(vdi_handle, 3);
	
	return(cons(newicell(SCREENSIZEX),newicell(SCREENSIZEY)));
}


EXP GraphStop(args)
EXP args;
{
	v_show_c(vdi_handle,0);
	
	graf_mouse(0,NULL);
/*	appl_exit(); */
	v_clsvwk(vdi_handle);
	return(T);
}


draw_button(x,y,text,mode)
int mode;
int x,y;
char *text;
{
	int w,h;
	int extent[10];
	int box[4];

	x = SCALEX(x);
	y = SCALEY(y);

	vqt_extent(vdi_handle,text,extent );
	h =extent[5];
	w =extent[2];

	if( mode == 1)
		vst_effects(vdi_handle,0); /* Black on White */
	else
		vst_effects(vdi_handle,1); 

	extent[0] = x;
	extent[1] = y;
	extent[4] = x+w;
	extent[5] = y+h;
	extent[2] = extent[4];
	extent[3] = extent[1];
	extent[6] = extent[0];
	extent[7] = extent[5];
	extent[8] = extent[0];
	extent[9] = extent[1];
	
	v_hide_c(vdi_handle);
	v_justified(vdi_handle,	x +2,
					y + h -2,
					text,
					w-3,0,1); 

	vst_effects(vdi_handle,0); /* normal text font */
	v_pline(vdi_handle, 5, extent);

	v_show_c(vdi_handle, 0);
}
EXP bmode(args)
EXP args;
{
	int mode = cir(car(args));
	
	return(newicell(vswr_mode(vdi_handle, mode)));
}
EXP bcolour(args)
EXP args;
{
	int colour = cir(car(args));
	
	return(newicell(vsl_color(vdi_handle, colour)));
}
EXP bdraw_button(args)
EXP args;
{
EXP textarg = car(cdr(cdr(args)));
int x,y, w,h;
int extent[10];
char buffer[80];

	if(c_tostr(buffer, textarg) == NIL)
		return(NIL);

	x = SCALEX(cir(car(args)));
	y = SCALEY(cir(car(cdr(args))));

	vqt_extent(vdi_handle,buffer,extent );
	h =extent[5];
	w =extent[2];


	vst_effects(vdi_handle,0); /* Black on White */

	extent[0] = x;
	extent[1] = y;
	extent[4] = x+w;
	extent[5] = y+h;
	extent[2] = extent[4];
	extent[3] = extent[1];
	extent[6] = extent[0];
	extent[7] = extent[5];
	extent[8] = extent[0];
	extent[9] = extent[1];
	
	v_hide_c(vdi_handle);
	v_justified(vdi_handle,	x +2,
					y + h -2,
					buffer,
					w-3,0,1); 

	vst_effects(vdi_handle,0); /* normal */
	v_pline(vdi_handle, 5, extent);

	v_show_c(vdi_handle, 0);
	return( cons(newicell(ELACSX(x+w)),newicell(ELACSY(y+h))));

}

getmidievent(event) 
B_MSG *event;
{

	for(event->used = 0; event->used < B_EVSIZE; event->used++) {
		if( Bconstat(MIDI) != 0 ){
			event->data[event->used] = Bconin(MIDI) & 0x00ffL;
		}
		else 
			break;
	}
	if( event->used != 0 )
		event->type = B_MIDI;
	return(event->used);

}
#define LEFTBUTTON 1
#define RIGHTBUTTON 2
#define LSHIFT 1
#define RSHIFT 2

getmousevent(event)
B_MSG *event;
{
static int last_status, last_x, last_y;
int status, x, y, keys;

	vq_key_s(vdi_handle, &keys);
	vq_mouse(vdi_handle, &status, &x, &y);
	
	if( (last_status & LEFTBUTTON)!= (status & LEFTBUTTON) ) {
		if( status & LEFTBUTTON) {
			if( keys & LSHIFT || keys & RSHIFT)
				event->type = B_MOUSE_DOWN_SHIFT;
			else {
				event->type = B_MOUSE_DOWN;
				if( status & RIGHTBUTTON) {
					event->type = B_OPEN;
				}
				
			}
		}
		else 
			event->type = B_MOUSE_UP;
	}
	else if (last_x != x || last_y != y ) {
		event->type = B_MOUSE_MOVE;
	}
	else
		return(0);

	event->used = 3;
	event->data[0]=status;
	event->data[1]=ELACSX(x);
	event->data[2]=ELACSY(y);
	last_status = status;
	last_x = x;
	last_y = y;
	return(1);
}
getevent(event)
B_MSG *event;
{

	event->type = B_NULL_MSG;
	while( event->type == B_NULL_MSG) {
		if(getmousevent(event)) {
			return;
		}
		else if( getmidievent(event) ){
			return;
		}
		else if( Bconstat(CON) != 0) {
			event->type = B_KEYB;
			event->used = 1;
			event->data[0] = Bconin(CON); 
			
		}
	}
}
EXP bgetevent(args)
EXP args;
{
B_MSG latest;
int c;
EXP type, result;

	getevent( &latest);
	result = NIL;
	for( c = latest.used-1; c >= 0 ; c--) {
		result = cons( newicell(latest.data[c]), result ) ;
	}
	switch ( latest.type ) {

		case  B_MOUSE_DOWN :
				type = lookup("*down*");
				break;
		case  B_MOUSE_DOWN_SHIFT :
				type = lookup("*sdown*");
				break;
		case  B_MOUSE_UP :
				type = lookup("*up*");
				break;
		case  B_MOUSE_MOVE :
				type = lookup("*move*");
				break;
		case  B_KEYB 		:
				type = lookup("*keys*");
				break;
		case  B_MIDI		:
				type = lookup("*midi*");
				break;
		case  B_V24 		:
				type = lookup("*rs232*");
				break;
	}
	return(cons( type, result));
}
InitGraph()
{   
	set(lookup("*down*"),	lookup("*down*"));
	set(lookup("*sdown*"),	lookup("*sdown*"));
	set(lookup("*up*"),		lookup("*up*"));
	set(lookup("*move*"),	lookup("*move*"));
	set(lookup("*keys*"),	lookup("*keys*"));
	set(lookup("*midi*"),	lookup("*midi*"));
	set(lookup("*rs232*"),	lookup("*rs232*"));
	set( lookup("line"), newfcell(bpline));
	set( lookup("button"), newfcell(bdraw_button));
	set( lookup("getevent"), newfcell(bgetevent));
	set( lookup("GraphOpen"), newfcell(GraphOpen));
	set( lookup("GraphClose"), newfcell(GraphStop));
	set( lookup("colour"), newfcell(bcolour));
	set( lookup("setlut"), newfcell(bsetlut));
	set( lookup("mode"), newfcell(bmode));

}
#endif /* LASER */


 
