#include <stdio.h>
#include "cells.h"
/*
 *	Function to Increment relative ref counts of an entire tree.
 *	Returns the calling argument;
 */
EXP reference(EXP tree)
{
EXP arg = tree;

	while( tree != NIL ) {
		if( tree->ztype != PAIR) {
			tree->zcount += 1;
			return(arg);
		}
		/* Lists */
		else if( tree ->zcount > 0 ) {
			tree->zcount += 1;
			return(arg);
		}
		else {

			tree->zcount = 1;
			/* NOT USED */
			reference( car (tree) );
		}
		tree = cdr(tree);
	}
	return(arg);
}
/*
 *	Function to decrement use relative ref counts of all cells in a tree.
 */
void dereference(EXP tree)
{
	lwhile( tree ) {
		lif( atom(tree) ) {
				tree->zcount -= 1;
			return;
		}
		else if( tree ->zcount != 1 ) {
				tree->zcount -= 1;
			return;
		}
		else {
			tree->zcount = 0;
			dereference( car (tree) );
		}
		tree = cdr(tree);
	}
}
/*
 *	Function to release all unused cells in a tree.
 */
void erase(EXP tree)
{
EXP next = NIL;

	lwhile( lnot(null(tree) )) {
		if( tree ->zcount !=0 ) 		/* Not unused so quit */
			return;
		lif( atom(tree) ) {
			lif( constantp(tree) )		/* Do not erase constants */
				return;
			c_release(tree);
			return;
		}
		else {				/* it's a list */
			erase( car (tree) );	/* recurse on car side */
			next = cdr(tree);		/* save pointer */
			c_release(tree);		/* free this cell */
		}
		tree = next;			/* and again */
	}
}
/*
 * Combination of dereference() followed by erase()
 */
void purge(EXP tree)
{
EXP next = NIL;


	lwhile( lnot( null(tree) )) {
		lif( atom(tree) ) {
			lif( constantp(tree) )		/* Do not erase constants */
				return;
			if( (tree->zcount -= 1) == 0 ) {
				lif( idp(tree) ) {

					purge(zapval(tree));   /* value */
					purge(zprops(tree));   /* properties */
				}
				c_release(tree);
			}
			return;
		}
		else if( tree ->zcount != 1 ) { /* It's a list with refcount > 1 */
			tree->zcount -= 1;
			return;
		}
		else { 				/* it's a list with ref count == 1 */
			purge( car (tree) );
			next = cdr(tree);
			c_release(tree);
		}
		tree = next;
	}
}

