;;;
;;; shake.lsp		Tree-shaker functions
;;;
;;; 12 Feb 93
;;;

;;
;;	Function to create a list of symbols used by a function. 
;;  This is a useful source of lists for profiling with
;;	(profile) in the file "profile.lsp"

;; For example:
;;
;;	(defun f (a b) (cons a (+ a b)))
;;
;;	(shake-tree 'f) ==> (f cons +)
;;
(defun shake-tree (item &optional syms)
	(shake-tree-aux item)
	syms)

(defun shake-tree-aux (item)
	(cond 
		((member item syms)) 
		((consp item) 
			(shake-tree-aux (car item) )
			(shake-tree-aux (cdr item) ))
		((and (symbolp item) (boundp item) 
			(not (member item syms))) 
				(setq syms (cons item syms))
				(shake-tree-aux (symbol-value item )))  ) )
