;;;	init.lsp                     init.lsp
;;;
;;;	NAME
;;;	   init.lsp      Version 1.0
;;;
;;;	SYNOPSIS
;;;	   This file is read every time LISP is run, and contains
;;;	   defintions of useful functions not in the interpreter.
;;;
;;;
;(ROOM) ; Print out the banner and memory statistics
;;
;; Some commonly used functions, not present in the interpreter.
;
;	Useful atoms:
;
(setq CR "\n")       ; Carriage Return
(setq *eol* "\n")       ; Carriage Return
(setq BLANK '\ )    ; Space character
(setq *tab* "\t")   ; Tab character
;
;   LISP Functions
;
; Shorthand forms for list components
(defun caar (x) (car(car x)))
(defun cdar (x) (cdr(car x)))
(defun cddr (x) (cdr(cdr x)))
(defun caaar (x) (car(car(car x))))
(defun caadr (x) (car(car(cdr x))))
(defun cadar (x) (car(cdr(car x))))
(defun cdaar (x) (cdr(car(car x))))
(defun cdadr (x) (cdr(car(cdr x))))
(defun cddar (x) (cdr(cdr(car x))))
(defun cdddr (x) (cdr(cdr(cdr x))))
;;;
;;; Scheme style stuff
(setq else t)
;;;

(defun min2 ( u v)
  (cond ((> u v) v) (t u)))

; Other functions
;
(defun add1 (x) (+ 1 x))
(defun sub1 (x) (- x 1))
(defun minusp (x) (< x 0))
(defun not (x) (null x))

; useful function to read a file without display of results
(defun loadquiet (f) (load f :print nil :verbose nil))

;; Editor
;;
(defun ed (&rest filenames)
	(cond
		((null filenames) (system "emacs"))
		(t  (system "emacs" (car filenames))) ) )

; Normal & Cattell page 170
(defun subst (a b s)
   (cond
      ((eq s b) a)   
      ((atom s) s)
      (t (cons (subst a b (car s))
             (subst a b (cdr s)) )  ) ) )

; COMMON LISP function which makes a list out of its arguments.
(defun list (&rest _u) _u)

(defun print (object &optional (stream *standard-output*))
	(princ "\n" stream)
	(prin1 object stream)
	(princ " " stream) )

(defun terpri (&optional (stream *standard-output*)) (princ CR stream))

; (last) returns the last element of a list
(defun last (_list)
   (cond
      ((null (cdr _list)) _list)
      (t (last (cdr _list)))))

;N&C page 64
;
;
(df print* (&rest x)
   (princ CR)
   (do-while x
      (princ (eval (car x)))
      (setq x (cdr x)) )
   (princ " ") )

;N&C page 145
(defun mapc (l fn)
   (cond
      ((null l) ())
      (t (cons (fn (car l)) 
             (mapc (cdr l) fn) ) ) ) )

; N&C page 171
; Debugs ordinary (defun (args ...) ... ) type functions.
; ie (scope append) will trace append.
;
(df trace (&rest fn)
   (setq fn (car fn))         ; select first parameter
   (put fn 'olddef (eval fn))   ; save old definition
   (set fn (subst fn 'fn
      '(lambdaq (&rest *x)
         (setq *x (mapc *x eval))
         (print 'fn)(princ " ")(prin1 *x)
         (setq *x (apply (get 'fn 'olddef) *x))
         (print 'fn)(princ "= ")(prin1 *x)
         *x ) ) )
   fn )

; N&C page 171
(df untrace (&rest fn)
   (setq fn (car fn))
   (set fn (get fn 'olddef))
;   (remprop fn 'olddef)
   (list fn 'untraced))

(setq XOR 3) ; Exclusive or screen writing mode
; Graphics modes for (GraphOpen) on MS-DOS
(setq CGA 1)
(setq MCGA 2)
(setq EGA 3)
(setq EGA64 4)
(setq EGAMONO 5)
(setq VGA 9)

(df function (_s2) _s2 )
;;;
;;; Define #! macro to access arbitrary pname symbols.
;;;
(defmacro quser1 (_s) ; 
	(addsym (_bq1 _s)) )
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;		User stuff below here.------>>>
;;;
(defun princ* (&rest _sexp)
	(do-while _sexp
		(princ (car _sexp))
		(setq _sexp (cdr _sexp)) ) )
;;
(load "common.lsp")
;;
;; Treat the command line arguments as a list of files to load.
;;
((lambda (argv)
	(do-while (setq argv (cdr argv))
		(cond ( (equal (load (car argv)) NIL)
				(princ "; *** Warning! Could not load: ")
						(princ (car argv))
						(terpri)))))
	command-line-args )
;;
;; What's the time?
;;
(load "qtime.lsp" :verbose nil)
(english-time)
