
	(extensions t)			; activate extensions

	; handy function to create symbols which look like 
	; function applications
	(defun assert (form result)		
		(set (addsym form) result))

	; Fibonnacci Series
	(defun fib (n)
		; Note total lack of COND statements !!
		(+ (fib (- n 1)) (fib (- n 2))) )
	
	; Declare the terminating conditions of fibonacci series.
	; These are found by APPLY in preference to an application.
	(assert `(,fib 1) 1)	
	(assert `(,fib 0) 1)
	
	;; Here is a memoised version of the fibonnacci series 
	;; which is very much faster than (fib)
	(defun fib-fast (n)
		; The assert statement saves the result for
		; future executions of APPLY
		(assert (list fib-fast n) 
			(+ (fib-fast (- n 1)) (fib-fast (- n 2))) ))

	(assert `(,fib-fast 1) 1)
	(assert `(,fib-fast 0) 1)

(load "times.lsp")
(let ((num 15))
	(princ* "\nTime to execute ordinary Fibonnacci(" num ") : "
		(time:perf (fib num)) " Seconds")
	(princ* "\nTime to execute memoized Fibonnacci(" num ") : "
		(time:perf (fib-fast num)) " Seconds"))

(extensions nil)
