(load "menu.lsp")
(defmenu top
   ("About RefLisp" (ROOM))
     ("Exit RefLisp"   (exit))
     ("Maths Demos"   (menu math-demos))
     ("Regression Testing" (menu regression))
      ("Musical Demos" (menu musicals))
     ("Graphics Demos"  (load "curves.lsp")
						(load "drawing.lsp")
                  		(menu graphics))
	("Push-button Graphics" (load "gob.lsp"))
      ("List Processing" (menu lproc))
      ("Computer Programming" (menu software)))

(defmenu software
   ("Use Micro-Prolog" (load "prolog.lsp"))
   ("Expert Systems" (load "rules.lsp"))
   ("Generating Assembler" (load "gc.lsp"))
   ("Pattern Matching" (load "doctor.lsp"))
   ("Memoization" (load "fib.lsp"))
   ("Execution Profile" (load "profile.lsp")
   		(princ* "Execution Profile of sorting program SORT.LSP:")
		(load "sort.lsp")
		(setq tr (filter (shake-tree 'sort)))
		(princ* "Profiling the functions:\n")
		(print tr)
		(profile tr)
		(sort (gen-ran-list 10))
		(profile-report tr)
		(profile-clear tr))

   ("Run Scheme Programs"
			   (load "scheme.lsp") 
			   (load "account.scm"))
   ("Convert to Lexical Scoping Rules"
			   (load "lexical.lsp")) 
   ("Object-Oriented Finite State Machine" 
			   (load "oops.lsp") 
			   (load "fsmoo.lsp"))
   ("Search source code for functions with 3 arguments." 
		(load "grep.lsp") 
		(grep	'(defun * (* * *) *)
				'(lambda (tok) (print (cadr tok))
						(prin1 (caddr tok))
						(terpri)))))

(defmenu lproc
	 ("Tell the time"  (load "qtime.lsp") (english-time))
	 ("Anagrams" (load "anag.lsp") (find-anag))
	("Find a route in a network. " (load "search.lsp"))
	("Place Queens on a Chess Board" (load "queen.lsp") (queen 4))
   ("Sort some random numbers" 
				  (load "sort.lsp")
                  (sort (gen-ran-list 20))))

(defmenu graphics
   ("Line Drawing" (evrubber))
   ("Selecting with the Mouse" (evhit))
   ("Dragging with the Mouse" (evfollow))
   ("Tracing Mouse & MIDI events" (evprint))
   ("The Clock" (load "clock.lsp") (clock 1000))
   ("Draw the Dragon Curve" (drawd))
   ("Draw the C Curve" (drawc))
   ("Graph Editor" (load "gui.lsp"))
   ("3D Perspective" (load "view.lsp"))
   ("Chaos: Bifurcation" (load "chaos.lsp"))
   ("Draw random lines." (load "fgtest.lsp")(fgtest 1000))
   ("Flight Simulator" (load "fsim.lsp")))

(defmenu musicals
   ("Musical Fractals" (load "fra.lsp")
               (princ* "brownian motion notes" CR)
               (princ* "Press RETURN to continue" CR)
               (read-char)
               (brownba 50)
			   (princ* "i/f noise generated notes" CR)
               (ioverf 50)))

(defmenu regression
   ("Run a Benchmark" (load "benchmar.lsp"))
   ("Maths Functions" (load "mathtest.lsp")))

(defmenu math-demos
   ("Reverse-Polish Calculator" (load "calc.lsp")(calc))
   ("Very Large Numbers" (load "bignum.lsp") (b-power-of-2 100))
   ("Test the Random Number Generator" (load "tstrand.lsp"))
   ("Differential Equations" (load "circle.lsp")(r)))

(menu top)
(princ* "; Type (exit) to leave RefLisp" CR)

