; Load circle if it is not already
(cond ((not (boundp 'circle)) (load "circle.lsp")) (t t))

(defun clock (&optional duration)

    (setq dim (GraphOpen))
    (setq oy (/ (float (cdr dim)) 2.0))
    (setq ox (/ (float (car dim)) 2.0))
   (setq size 1900)
   ; Draw the clock face
   (circle size 180 ox oy)
   ((lambda (hour)
      (do-while (> hour 0)
         (hand (* 5 hour) size (* size 0.10))
         (setq hour (- hour 1)) )
   )12)

	(mode 3)      ; Exclusive OR
   
   ; Now the clock
	(setq time (get-decoded-time))   ; Whats the time
   (setq initialise t)      ; Flag to disp1 that it's initialisation

   (dissec (setq oldsec (car time))) ; Seconds Hand
   (disp1 (setq old time))                  ; Other hands

   (setq initialise nil)
   ; Now loop a 
   
	(cond  			; if duration is NIL (not in arglist)
    	((null duration)
			(do-while t (display (get-decoded-time)))) ; loop forever
		(t  (do-while (> duration 0)
				(display (get-decoded-time))
        		(setq duration (- duration 1)) ) ) )

   (GraphClose) )

(defun handtox () (+ ox (* rad (sin (* 0.1046 (float angle))))))
(defun handtoy () (+ oy (* rad (cos (* 0.1046 (float angle))))))
(defun hand (angle rad len)

   ; First work out the out-side end
   (setq nx (handtox))
   (setq ny (handtoy))

   ; Now work out the inner end
   (setq rad (- rad len))
   (setq mx (handtox))
   (setq my (handtoy))
   (line mx my nx ny) )

;   Display the seconds hand.
(defun dissec (s)
      (hand s (* size 0.8) (* size 0.8)) )

; Display the Clock
(defun display (new)
   (cond 
      ((not (equal (setq s (car new)) oldsec))
		 (dissec oldsec) ; Seconds
		 (dissec  s)    ; Seconds
         (setq oldsec s)

         (cond ((or (zerop s) initialise)
               (disp1 old)
               (disp1 new)
               (setq old new) )) )) )

(defun disp1 (time)
   ((lambda (h m s)
      (hand (+ m (/ s 60.0)) (* size 0.8) (* size 0.8))
         (hand (* 5.0 (+ h (/ (+ m (/ s 60.0)) 60.0))) 
                  (* size 0.6) (* size 0.6) )  )

	  (rem (caddr time) 12)	; Hours
	  (car(cdr time))     	; Minutes
	  (car time))) 			; Seconds
