(define (make-withdraw balance)
	(my-lambda (amount)
				(setq balance (- balance amount))))

(define W1 (make-withdraw 100))

(define (make-account balance)
	(define (snoop m)
		(cond ((eq m 'withdraw) `withdraw)
			((eq m 'deposit) `deposit)
			(else (print "error"))))
	(define (withdraw amount)
		(setq balance (- balance amount))
		balance)
	(define (deposit amount)
		(setq balance (+ balance amount))
		balance)
	(define (dispatch m)
		(cond ((eq m 'withdraw) withdraw)
			((eq m 'deposit) deposit)
			((eq m 'snoop) snoop)
			(else (print "error"))))
	dispatch)


