
;;;; Copyright (c) 1994 Jeff Weisberg
;;;; see the file "License"

;;;; $Id: pred.jl,v 1.3 94/08/07 13:45:43 weisberg Exp Locker: weisberg $

(defun nconsp (x)
  "(nconsp obj) An atom?"
  (atomp x))

(defun listp (x)
  "(listp obj) A list?"
  (or (consp x) (nullp x)))

(defun numberp (x)
  "(numberp obj) A number?"
  (or (intp x)
      (floatp x)
      (doublep x)))

(defun booleanp (x)
  "(booleanp obj) A boolean?"
  (or (eq x #t) (eq x #f)))

(defun nboundp (x)
  "(nboundp x) Not been bound a value?"
  (not (boundp x)))

(defun ndefinedp (x)
  "(ndefinedp x) Not been defined?"
  (not (definedp x)))

(defun nzerop (x)
  "(nzerop x) Not zero?"
  (not (zerop x)))

(defun nnullp (x)
  "(nnullp x) Not ()?"
  (not (nullp x)))

(defun nfalsep (x)
  "(nfalsep x) Not #f?"
  (not (falsep x)))

(defun truep (x)
  "truep x) is x #t?"
  (eq x #t))

