
;;;; Copyright (c) 1994 Jeff Weisberg
;;;; see the file "License"

;;;; $Id: math.jl,v 1.8 94/08/15 15:50:10 weisberg Exp Locker: weisberg $
;; supplemental math routines/extensions

(defvar $+$ +)
(defvar $-$ -)
(defvar $*$ *)
(defvar $/$ /)

;;; the builtins only handle 2 args
;;; these will take any number of args

(defun + argl
  (listop 0 $+$ argl))

(defun * argl
  (listop 1 $*$ argl))

(defun - argl
  (cond
   ((nullp argl) 0)
   ((nullp (cdr argl)) (- 0 (car argl)))
   (#t
    (listop (car argl) $-$ (cdr argl)))))

(defun / argl
  (cond
   ((nullp argl) 1)
   ((nullp (cdr argl)) (/ 1 (car argl)))
   (#t
   (listop (car argl) $/$ (cdr argl)))))

(defun listop (acc op argl)
  (while (nnullp argl)
    (set! acc (op acc (car argl)))
    (set! argl (cdr argl)))
  acc)

(defun max argl
  (extreme > argl))

(defun min argl
  (extreme < argl))

(defun extreme (op argl)
  (if (nullp argl) ()
    (let ((a (car argl))
	  (l (cdr argl)))
      (while (nnullp l)
	(set! a 
	      (if (op a (car l))
		  a
		(car l)))
	(set! l (cdr l)))
      a)))

(defun truncate (x)
  (if (< x 0)
      (- (floor (- x)))
    (floor x)))

(defun round (x)
  (floor (+ x .5)))

(defun gcd (a b)
  "(gcd a b) find the greatest common denominator"
  (cond ((zerop a) b)
	(#t (gcd (% b a) a))))

(defun lcm (a b)
  "(lcm a b) find the least common multiple"
  (abs (/ (* a b) (gcd a b))))

(defun quotient (a b)
  "(quotient a b) the integer division of a b"
  (truncate (/ a b)))


;; the % operator is not garunteed to be either modulo or remainder
;; so lets play ...

(defun remainder (a b)
  "(remainder a b) the remainder of integer division (has the sign of a)"
  (% a (abs b))) ;; is this garunteed to be right?
;; (- a (* b (quotient a b)))

;;; note: I don't think I spelled "garunteed" correctly
;;; but ispell was no help....

(defun modulo (a b)
  "(modulo a b) the modulous of a b (has sign of b)"
  (let ((c (% a b)))
    (cond
     ((or (and (< b 0) (> c 0))
	  (and (> b 0) (< c 0)))
      (+ c b))
     (#t c))))


