
;;;; Copyright (c) 1994 Jeff Weisberg
;;;; see the file "License"

;;;; $Id: expand.jl,v 1.4 94/08/11 15:50:42 weisberg Exp Locker: weisberg $
;; filename expansion

(defun expand-filename (flnm)
  "(expand-filename filename) expand ~ in filename"
  (let (ful)
    (cond
     ((or (match "^~/" flnm) (match "^~$" flnm))
      ;; it matches ~ | ~/...
      (set! ful (nth (getpwuid (getuid)) 7))
      (set! ful (strcat ful (substr flnm 1 (length flnm)))))
     
     ((or (match "^~[^/]*/" flnm) (match "^~[^/]*$" flnm))
      ;; it matches ~name | ~name/...
      (let ((user (substr flnm 1 (length flnm)))
	    i)
	;; find user name
	(set! i (or
		 (let ((foo (strindex flnm ?/)))
		   (if foo (- foo 1) foo))
		 (length flnm)))
	(set! user (substr user 0 i))
	(let ((pwent (getpwnam user)))
	  (if (vectorp pwent)
	      (set! ful (nth (getpwnam user) 7))
	    (error "expand-filename" user "No such user")))
	(set! ful (strcat ful
			  (if (!= i (length flnm))
			      (substr flnm (+ i 1) (length flnm))
			    "")))))
     (#t
      (set! ful flnm)))
    ful))

