/*
    iteration.c -- Iteration.
*/
/*
    Copyright (c) 1984, Taiichi Yuasa and Masami Hagiya.
    Copyright (c) 1990, Giuseppe Attardi.

    ECoLisp is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    See file '../Copyright' for full details.
*/


#include "config.h"

/* Should be just a macro so that it can be redefined:
Floop(object form)
{
	object x;
	object *lex_old = lex_env; lex_dcl;
	object id;
	int nr;

	make_nil_block(nr);

	if (nr != 0) {
		frs_pop();
		lex_env = lex_old;
		RETURN(nr - 1);
	}

	for (x = form; !endp(x); x = CDR(x))
		nr = eval(CAR(x));
	/*  Just !endp(x) is replaced by x != Cnil.  */
/*
	for (x = form;  ;  x = (x == Cnil) ? form : CDR(x))
		nr = eval(CAR(x));
	RETURN(nr);
}
*/

/* Must be kept consistent with struct lex in external.h:

   struct iterator {
	object	iter_var;	-- name of DO variable
	object	iter_spp;	-- T if special
				   If 'spp' != T, it is NIL during
				   initialization, and is the pointer to
				   (var value) in lexical environment
				   during the main loop.
	object	iter_init;
	object	iter_incr;	-- step-form or var (if no step-form is given)
   };

   An array of iterator is allocated in Fdo and FdoA:

	     start ->	|-------|	where each bt is a iterator
			|  bt1	|
			|-------|
			    :
			|-------|
			|  btn	|
			|-------|		     
    	     end ->	| 	|	
*/

void do_bindings(object var_list, struct iterator *bt)
{
	object is, x, y;

	for (is = var_list;  !endp(is);  is = CDR(is), bt++) {
		x = CAR(is);
		bt->iter_spp = Cnil;
		if (type_of(x) == t_symbol) {
		  bt->iter_var = x;
		  bt->iter_init = Cnil;
		  bt->iter_incr = x;
		  continue;
		}
		if (type_of(x) != t_cons)
			FEinvalid_form("The index, ~S, is illegal.", x);
		y = CAR(x);
		check_var(y);
		bt->iter_var = y;
		if (endp(CDR(x))) {
		  bt->iter_init = Cnil;
		  bt->iter_incr = y;
		} else {
			x = CDR(x);
			bt->iter_init = CAR(x);
			if (endp(CDR(x)))
				bt->iter_incr = y;
			else {
				x = CDR(x);
				bt->iter_incr = CAR(x);
				if (!endp(CDR(x)))
				    FEerror("Too many forms to the index ~S.",
					    1, y);
			}
		}
	}
}

Fdo(volatile object arg)
{
	object *lex_old = lex_env; lex_dcl;
	bds_ptr old_bds_top = bds_top;
	object end_test, body, var_list;
	volatile object result;
	int nr;

	if (endp(arg) || endp(CDR(arg)))
		FEtoo_few_argumentsF(arg);
	if (endp(CADR(arg)))
		FEinvalid_form("The DO end-test, ~S, is illegal.",
				CADR(arg));

	var_list = CAR(arg);
	end_test = CAADR(arg);
	result = CDADR(arg);

	make_nil_block(nr);	/* block for non local RETURN */

	if (nr != 0) { nr--; goto END;}

	{ struct iterator *end, *bt;
	  int nvars = length(var_list);
	  struct iterator bindings[nvars]; /*  __GNUC__  */

	  end = &bindings[nvars];

	  do_bindings(var_list, bindings);
	  body = let_bind(CDDR(arg), bindings, end, sizeof(struct iterator));

	  /* Put in spp a reference to the real binding so that it
	     can be updated at each iteration	*/
	  for (bt = bindings;  bt < end;  bt++)
	    if ((enum stype)bt->iter_var->s.s_stype != stp_ordinary)
	      bt->iter_spp = Ct;
	    else if (Null(bt->iter_spp))
	      bt->iter_spp = assoc_eq(bt->iter_var, lex_env[0]);

	LOOP:			/* the main loop */
	  eval(end_test);
	  if (!Null(VALUES(0))) {
	    /* RESULT evaluation */
	    if (endp(result)) {
	      VALUES(0) = Cnil;
	      nr = 1;
	    } else
	      do {
		nr = eval(CAR(result));
		result = CDR(result);
	      } while (!endp(result));
	    goto END;
	  }

	  Ftagbody(body);

	  /* next step */
	  for (bt = bindings;  bt < end;  bt++) {
	    if (bt->iter_incr != bt->iter_var) {
	      eval(bt->iter_incr);
	      bt->iter_init = VALUES(0);
	    }
	  }
	  for (bt = bindings;  bt < end;  bt++) {
	    if (bt->iter_incr != bt->iter_var)
	      if (bt->iter_spp == Ct)
		bt->iter_var->s.s_dbind = bt->iter_init;
	      else
		CADR(bt->iter_spp) = bt->iter_init;
	  }
	  goto LOOP;
	}

END:
	frs_pop();
	bds_unwind(old_bds_top);
	lex_env = lex_old;
	return(nr);
}

FdoA(volatile object arg)
{
	object *lex_old = lex_env; lex_dcl;
	bds_ptr old_bds_top = bds_top;
	object end_test, body, var_list;
	volatile object result;
	int nr;

	if (endp(arg) || endp(CDR(arg)))
		FEtoo_few_argumentsF(arg);
	if (endp(CADR(arg)))
		FEinvalid_form("The DO* end-test, ~S, is illegal.",
				CADR(arg));

	var_list = CAR(arg);
	end_test = CAADR(arg);
	result = CDADR(arg);

	make_nil_block(nr);	/* block for non local RETURN */

	if (nr != 0) { nr--; goto END;}

	{ struct iterator *end, *bt;
	  int nvars = length(var_list);
	  struct iterator bindings[nvars]; /*  __GNUC__  */

	  end = &bindings[nvars];

	  do_bindings(var_list, bindings);
	  body = letA_bind(CDDR(arg), bindings, end, sizeof(struct iterator));

	  for (bt = bindings;  bt < end;  bt++)
	    if ((enum stype)bt->iter_var->s.s_stype != stp_ordinary)
	      bt->iter_spp = Ct;
	    else if (Null(bt->iter_spp))
	      bt->iter_spp = assoc_eq(bt->iter_var, lex_env[0]);

LOOP:	/* the main loop */
	eval(end_test);
	if (!Null(VALUES(0))) {
		/* RESULT evaluation */
		if (endp(result)) {
			VALUES(0) = Cnil;
			nr = 1;
		} else
			do {
			  nr = eval(CAR(result));
			  result = CDR(result);
			} while (!endp(result));
		goto END;
	      }

	  Ftagbody(body);

	  /* next step */
	  for (bt = bindings;  bt < end;  bt++)
	    if (bt->iter_incr != bt->iter_var) {
	      eval(bt->iter_incr);
	      if (bt->iter_spp == Ct)
		bt->iter_var->s.s_dbind = VALUES(0);
	      else
		CADR(bt->iter_spp) = VALUES(0);
	    }
	  goto LOOP;
	}
END:
	frs_pop();
	bds_unwind(old_bds_top);
	lex_env = lex_old;
	return(nr);
}

Fdolist(object arg)
{
	object *lex_old = lex_env; lex_dcl;
	bds_ptr old_bds_top = bds_top;
	struct iterator var, *start = &var;
	object x, listform, body;
	volatile object result;
	int nr;

	if (endp(arg)) FEtoo_few_argumentsF(arg);

	x = CAR(arg);
	if (endp(x)) FEerror("No variable.", 0);
	var.iter_var = CAR(x);
	var.iter_spp = Cnil;
	var.iter_init = Cnil;
	var.iter_incr = Cnil;
	x = CDR(x);
	if (endp(x)) FEerror("No listform.", 0);
	listform = CAR(x);
	x = CDR(x);
	if (endp(x))
		result = Cnil;
	else {
		result = CAR(x);
		if (!endp(CDR(x)))
			FEerror("Too many resultforms.", 0);
	}

	make_nil_block(nr);

	if (nr != 0) { nr--; goto END;}

	eval(listform);
	start->iter_init = VALUES(0);
	body = process_decl(CDR(arg), start, start+1, sizeof(struct iterator));
	bind_var(start->iter_var, Cnil, start->iter_spp);
	if ((enum stype)start->iter_var->s.s_stype != stp_ordinary)
		start->iter_spp = Ct;
	else if (Null(start->iter_spp))
		start->iter_spp = assoc_eq(start->iter_var, lex_env[0]);

LOOP:	/* the main loop */
	if (endp(start->iter_init)) {
		if (start->iter_spp == Ct)
			start->iter_var->s.s_dbind = Cnil;
		else
			CADR(start->iter_spp) = Cnil;
		nr = eval(result);
		goto END;
	}

	if (start->iter_spp == Ct)
		start->iter_var->s.s_dbind = CAR(start->iter_init);
	else
		CADR(start->iter_spp) = CAR(start->iter_init);
	start->iter_init = CDR(start->iter_init);

	Ftagbody(body);

	goto LOOP;

END:
	frs_pop();
	bds_unwind(old_bds_top);
	lex_env = lex_old;
	return(nr);
}

Fdotimes(object arg)
{
	object *lex_old = lex_env; lex_dcl;
	bds_ptr old_bds_top = bds_top;
	struct iterator var, *start = &var;
	object x, body; volatile object countform, result;
	int nr;

	if (endp(arg)) FEtoo_few_argumentsF(arg);

	x = CAR(arg);
	if (endp(x)) FEerror("No variable.", 0);
	var.iter_var = CAR(x);
	var.iter_spp = Cnil;
	var.iter_init = Cnil;
	var.iter_incr = Cnil;
	x = CDR(x);
	if (endp(x))
		FEerror("No countform.", 0);
	countform = CAR(x);
	x = CDR(x);
	if (endp(x))
		result = Cnil;
	else {
		result = CAR(x);
		if (!endp(CDR(x)))
			FEerror("Too many resultforms.", 0);
	}

	make_nil_block(nr);

	if (nr != 0) { nr--; goto END;}

	eval(countform);
	start->iter_init = countform = VALUES(0);
	if (!FIXNUMP(countform) &&
	    type_of(countform) != t_bignum)
		FEwrong_type_argument(Sinteger, countform);
	body = process_decl(CDR(arg), NULL, NULL, 0);
	bind_var(start->iter_var, MAKE_FIXNUM(0), start->iter_spp);
	if ((enum stype)start->iter_var->s.s_stype != stp_ordinary) {
		start->iter_spp = Ct;
		x = start->iter_var->s.s_dbind;
	} else if (Null(start->iter_spp)) {
		start->iter_spp = assoc_eq(start->iter_var, lex_env[0]);
		x = CADR(start->iter_spp);
	} else
		x = start->iter_var->s.s_dbind;

LOOP:	/* the main loop */
	if (number_compare(x, start->iter_init) >= 0) {
		nr = eval(result);
		goto END;
	}

	Ftagbody(body);

	if (start->iter_spp == Ct)
		x = start->iter_var->s.s_dbind = one_plus(x);
	else
		x = CADR(start->iter_spp) = one_plus(x);

	goto LOOP;

END:
	frs_pop();
	bds_unwind(old_bds_top);
	lex_env = lex_old;
	return(nr);
}

init_iteration()
{
/*	make_special_form("LOOP", Floop); */
	make_special_form("DO", Fdo);
	make_special_form("DO*", FdoA);
	make_special_form("DOLIST", Fdolist);
	make_special_form("DOTIMES", Fdotimes);
}
