/*
    lex.c -- Lexical environment.
*/
/*
    Copyright (c) 1984, Taiichi Yuasa and Masami Hagiya.
    Copyright (c) 1990, Giuseppe Attardi.

    ECoLisp is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    See file '../Copyright' for full details.
*/


#include "config.h"

/******** EXPORTS ********/

#ifndef THREADS
object *lex_env;
#endif

object Smacro;
object Sblock;

/******** ------- ********/

object Stag;

object
assoc_eq(key, alist)
object key, alist;
{
	while (!endp(alist)) {
		if (CAAR(alist) == key)
			return(CAR(alist));
		alist = CDR(alist);
	}
	return(Cnil);
}

void lex_fun_bind(name, fun)
object name, fun;
{
  lex_env[1] = CONS(list(3, name, Sfunction, fun), lex_env[1]);
}

void lex_macro_bind(name, exp_fun)
object name, exp_fun;
{
  lex_env[1] = CONS(list(3, name, Smacro, exp_fun), lex_env[1]);			  
}

void lex_tag_bind(tag, id)
object tag, id;
{
  lex_env[2] = CONS(list(3, tag, Stag, id), lex_env[2]);
}

void lex_block_bind(name, id)
object name, id;
{
  lex_env[2] = CONS(list(3, name, Sblock, id), lex_env[2]);
}

object
lex_tag_sch(tag)
object tag;
{
	object alist = lex_env[2];

	while (!endp(alist)) {
		if (eql(CAAR(alist), tag) && CADAR(alist) == Stag)
			return(CAR(alist));
		alist = CDR(alist);
	}
	return(Cnil);
}

object lex_block_sch(name)
object name;
{
	object alist = lex_env[2];

	while (!endp(alist)) {
		if (CAAR(alist) == name && CADAR(alist) == Sblock)
			return(CAR(alist));
		alist = CDR(alist);
	}
	return(Cnil);
}

init_lex()
{
	Sfunction = make_ordinary("FUNCTION");
	enter_mark_origin(&Sfunction);
	Smacro = make_ordinary("MACRO");
	enter_mark_origin(&Smacro);
	Stag = make_ordinary("TAG");
	enter_mark_origin(&Stag);
	Sblock =  make_ordinary("BLOCK");
	enter_mark_origin(&Sblock);
}
