/*
    let.c -- Let, let*.
*/
/*
    Copyright (c) 1984, Taiichi Yuasa and Masami Hagiya.
    Copyright (c) 1990, Giuseppe Attardi.

    ECoLisp is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    See file '../Copyright' for full details.
*/


#include "config.h"

void let_bindings(object var_list, struct let *let)
{
	object x, y;

	for (x = var_list;  !endp(x);  x = CDR(x), let++) {
		y = CAR(x);
		let->let_spp = Cnil;
		if (type_of(y) == t_symbol) {
			check_var(y);
			let->let_var = y;
			let->let_init = Cnil;
		} else {
			endp(y);
			check_var(CAR(y));
			let->let_var = CAR(y);
			let->let_init = CADR(y);
			y = CDR(y);
			if (!endp(y) && !endp(CDR(y)))
			 FEerror("Too many initial forms to the variable ~S.",
				 1, CAR(y));
		}
	}
}

Flet(object form)
{
	object body;
	object *lex_old = lex_env; lex_dcl;
	bds_ptr old_bds_top = bds_top;
	int nr;
	
	if (endp(form))
		FEerror("No argument to LET.", 0);

	lex_copy();

	{ object var_list = CAR(form);
	  int vl = length(var_list);
	  struct let bindings[vl]; /*  __GNUC__  */

	  let_bindings(var_list, bindings);
	  body = let_bind(CDR(form), bindings, &bindings[vl], sizeof(struct let));
	}

	nr = Fprogn(body);

	bds_unwind(old_bds_top);
	lex_env = lex_old;
	RETURN(nr);
}

FletA(object form)
{
	object body;
	object *lex_old = lex_env; lex_dcl;
	bds_ptr old_bds_top;
	int nr;
	
	if (endp(form))
		FEerror("No argument to LET*.", 0);

	lex_copy();
	old_bds_top = bds_top;

	{ object var_list = CAR(form);
	  int vl = length(var_list);
	  struct let bindings[vl]; /*  __GNUC__  */

	  let_bindings(var_list, bindings);
	  body = letA_bind(CDR(form), bindings, &bindings[vl], sizeof(struct let));
	}

	nr = Fprogn(body);

	bds_unwind(old_bds_top);
	lex_env = lex_old;
	RETURN(nr);
}

Fmultiple_value_bind(object form)
{
	object body, values_form, x, y;
	object let;
        int i, n, nr;
	object *lex_old = lex_env; lex_dcl;
	bds_ptr old_bds_top;
	
	if (endp(form))
		FEerror("No argument to MULTIPLE-VALUE-BIND.", 0);
	body = CDR(form);
	if (endp(body))
		FEerror("No values-form to MULTIPLE-VALUE-BIND.", 0);
	values_form = CAR(body);
	body = CDR(body);

	lex_copy();
	old_bds_top = bds_top;

	{ object var_list = CAR(form);
	  int vl = length(var_list);
	  struct let *let, *end, bindings[vl]; /*  __GNUC__  */

	  end = &bindings[vl];
	  let_bindings(var_list, bindings);
	  body = process_decl(body, bindings, end, sizeof(struct let));

	  nr = eval(values_form);

	  for (i = 0, let = bindings; let < end; i++, let++) {
	    if (i < nr) let->let_init = VALUES(i);
	    bind_var(let->let_var, let->let_init, let->let_spp);
	  }
	}

	nr = Fprogn(body);
	bds_unwind(old_bds_top);
	lex_env = lex_old;
	RETURN(nr);
}

#ifndef ANSI
Fcompiler_let(object form)
{
	object body, x, y, v;
	object *lex_old = lex_env; lex_dcl;
	bds_ptr old_bds_top;
	int nr;
	if (endp(form))
		FEerror("No argument to COMPILER-LET.", 0);

	body = CDR(form);

	lex_copy();
	old_bds_top = bds_top;

	{ object var_list = CAR(form);
	  int vl = length(var_list);
	  struct let *let, *end; struct let bindings[vl]; /*  __GNUC__  */

	  end = &bindings[nr];
	  let_bindings(var_list, bindings);
	  body = let_bind(CDR(form), bindings, end, sizeof(struct let));
	  for (let = bindings;  let < end;  let++) {
	    eval(let->let_init);
	    let->let_init = VALUES(0);
	  }
	  for (let = bindings;  let < end;  let++)
	    bind_var(let->let_var, let->let_init, Ct);
	}

	nr = Fprogn(body);

	bds_unwind(old_bds_top);
	lex_env = lex_old;
	RETURN(nr);
}
#endif

Fflet(object args)
{
	object def_list, def, fun, body;
	object *lex_old = lex_env; lex_dcl;
	int nr;

	if (endp(args))
		FEtoo_few_argumentsF(args);
	lex_copy();
	for (def_list = CAR(args); !endp(def_list); def_list = CDR(def_list)) {
		def = CAR(def_list);
		if (endp(def) || endp(CDR(def)) ||
		    type_of(CAR(def)) != t_symbol)
			FEerror("~S~%\
is an illegal function definition in FLET.",
				1, def);
		fun = listA(5, Slambda_block_closure,
			    lex[0], lex[1], lex[2], def);
		lex_fun_bind(CAR(def), fun);
	}
	body = process_decl(CDR(args), NULL, NULL, 0);
	nr = Fprogn(body);
	lex_env = lex_old;
	RETURN(nr);
}

Flabels(object args)
{
	object def_list, def, fun, body;
	object cl;
	object *lex_old = lex_env; lex_dcl;
	int nr;

	if (endp(args))
		FEtoo_few_argumentsF(args);
	
	lex_copy();
	cl = Cnil;
	for (def_list = CAR(args); !endp(def_list); def_list = CDR(def_list)) {
		def = CAR(def_list);
		if (endp(def) || endp(CDR(def)) ||
		    type_of(CAR(def)) != t_symbol)
			FEerror("~S~%\
		is an illegal function definition in LABELS.", 1, def);
		fun = CONS(Cnil, CONS(lex[2], def));
		cl = CONS(fun, cl);
		fun = CONS(Slambda_block_closure, CONS(lex[0], fun));
		lex_fun_bind(CAR(def), fun);
	}
	while (!endp(cl)) {
		CAAR(cl) = lex_env[1];
		cl = CDR(cl);
	}
	body = process_decl(CDR(args), NULL, NULL, 0);
	nr = Fprogn(body);
	lex_env = lex_old;
	RETURN(nr);
}

Fmacrolet(object args)
{
	object def_list, def, body;
	object *lex_old = lex_env; lex_dcl;
	int nr;

	if (endp(args))
		FEtoo_few_argumentsF(args);
	lex_copy();
	for (def_list = CAR(args); !endp(def_list); def_list = CDR(def_list)) {
		def = CAR(def_list);
		if (endp(def) || endp(CDR(def)) ||
		    type_of(CAR(def)) != t_symbol)
			FEerror("~S~%\
is an illegal macro definition in MACROFLET.",
				1, def);
		funcall(4, siSexpand_defmacro,
				   CAR(def),
				   CADR(def),
				   CDDR(def));
		lex_macro_bind(CAR(def), VALUES(0));
	}
	body = process_decl(CDR(args), NULL, NULL, 0);
	nr = Fprogn(body);
	lex_env = lex_old;
	RETURN(nr);
}

init_let()
{
	make_special_form("LET", Flet);
	make_special_form("LET*", FletA);
	make_special_form("MULTIPLE-VALUE-BIND", Fmultiple_value_bind);
	make_special_form("COMPILER-LET", Fcompiler_let);
	make_special_form("FLET",Fflet);
	make_special_form("LABELS",Flabels);
	make_special_form("MACROLET",Fmacrolet);
}
