/*
    conditional.c -- Conditionals.
*/
/*
    Copyright (c) 1984, Taiichi Yuasa and Masami Hagiya.
    Copyright (c) 1990, Giuseppe Attardi.

    ECoLisp is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    See file '../Copyright' for full details.
*/


#include "config.h"

object Sotherwise;

Fif(form)
object form;
{
	if (endp(form) || endp(CDR(form)))
		FEtoo_few_argumentsF(form);
	if (!endp(CDDR(form)) && !endp(CDDDR(form)))
		FEtoo_many_argumentsF(form);
	eval(CAR(form));
	if (Null(VALUES(0)))
		if (endp(CDDR(form)))
			RETURN(1);
		else
			RETURN(eval(CADDR(form)));
	else
		RETURN(eval(CADR(form)));
}

Fcond(args)
object args;
{
	object clause, conseq;
	int nr;

	while (!endp(args)) {
		clause = CAR(args);
		if (type_of(clause) != t_cons)
			FEerror("~S is an illegal COND clause.",1,clause);
		eval(CAR(clause));
		if (!Null(VALUES(0))) {
			conseq = CDR(clause);
			if (endp(conseq)) RETURN(1);
			while (!endp(conseq)) {
				nr = eval(CAR(conseq));
				conseq = CDR(conseq);
			}
			RETURN(nr);
		}
		args = CDR(args);
	}
	VALUES(0) = Cnil;
	RETURN(1);
}

Fcase(arg)
object arg;
{
	object clause, key, conseq, val;
	int nr;

	if (endp(arg))
		FEtoo_few_argumentsF(arg);
	eval(CAR(arg));
	val = VALUES(0);
	arg = CDR(arg);
	while (!endp(arg)) {
		clause = CAR(arg);
		if (type_of(clause) != t_cons)
			FEerror("~S is an illegal CASE clause.",1,clause);
		key = CAR(clause);
		conseq = CDR(clause);
		if (type_of(key) == t_cons)
			do {
				if (eql(CAR(key), val))
					goto FOUND;
				key = CDR(key);
			} while (!endp(key));
		else if (Null(key))
			;
		else if (key == Ct || key == Sotherwise || eql(key, val))
			goto FOUND;
		arg = CDR(arg);
	}
	VALUES(0) = Cnil;
	RETURN(1);

FOUND:
	if (endp(conseq)) {
		VALUES(0) = Cnil;
		RETURN(1);
	}
	do {
		nr = eval(CAR(conseq));
		conseq = CDR(conseq);
	} while (!endp(conseq));
	RETURN(nr);
}

Fwhen(form)
object form;
{	int n;

	if (endp(form))
		FEtoo_few_argumentsF(form);
	eval(CAR(form));
	if (Null(VALUES(0)))
		RETURN(1);
	form = CDR(form);
	if (endp(form)) {
		VALUES(0) = Cnil;
		RETURN(1);
	} else
		do {
			n = eval(CAR(form));
			form = CDR(form);
		} while (!endp(form));
	RETURN(n);
}

Funless(form)
object form;
{	int nr;

	if (endp(form))
		FEtoo_few_argumentsF(form);
	eval(CAR(form));
	if (Null(VALUES(0))) {
		form = CDR(form);
		if (endp(form))
			RETURN(1);
		else {
			do {
				nr = eval(CAR(form));
				form = CDR(form);
			} while (!endp(form));
			RETURN(nr);
		}
	} else {
		VALUES(0) = Cnil;
		RETURN(1);
	}
}

init_conditional()
{
	make_special_form("IF",Fif);
	make_special_form("COND",Fcond);
	make_special_form("CASE",Fcase);
	make_special_form("WHEN",Fwhen);
	make_special_form("UNLESS",Funless);

	Sotherwise = make_ordinary("OTHERWISE");
	enter_mark_origin(&Sotherwise);
}
