/*
    cmpaux.c -- Auxiliaries used in compiled Lisp code.
*/
/*
    Copyright (c) 1984, Taiichi Yuasa and Masami Hagiya.
    Copyright (c) 1990, Giuseppe Attardi.

    ECoLisp is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    See file '../Copyright' for full details.
*/


#include "config.h"
extern char* malloc();

siLspecialp(int narg, object sym)
{
	check_arg(1);
	VALUES(0) = (type_of(sym) == t_symbol &&
				(enum stype)sym->s.s_stype == stp_special) ? Ct : Cnil;
	RETURN(1);
}

int
ifloor(int x, int y)
{
	if (y == 0)
		FEerror("Zero divizor", 0);
	else if (y > 0)
		if (x >= 0)
			return(x/y);
		else
			return(-((-x+y-1))/y);
	else
		if (x >= 0)
			return(-((x-y-1)/(-y)));
		else
			return((-x)/(-y));
}

int
imod(int x, int y)
{
	return(x - ifloor(x, y)*y);
}

/*
 * ----------------------------------------------------------------------
 *	Conversions to C
 * ----------------------------------------------------------------------
 */

char
object_to_char(object x)
{
	int c;

	if (FIXNUMP(x)) return(fix(x));	/* Immediate fixnum */

	switch (type_of(x)) {
	case t_fixnum:
		c = fix(x);  break;
	case t_bignum:
		c = x->big.big_car;  break;
	case t_character:
		c = char_code(x);  break;
	default:
		FEerror("~S cannot be coerce to a C char.", 1, x);
	}
	return(c);
}

int
object_to_int(object x)
{
	int i;

	if (FIXNUMP(x)) return(fix(x));	/* Immediate fixnum */

	switch (type_of(x)) {
	case t_character:
		i = char_code(x);  break;
	case t_fixnum:
		i = fix(x);  break;
	case t_bignum:
		i = x->big.big_car;  break;
	case t_ratio:
		i = number_to_double(x);  break;
	case t_shortfloat:
		i = sf(x);  break;
	case t_longfloat:
		i = lf(x);  break;
	default:
		FEerror("~S cannot be coerce to a C int.", 1, x);
	}
	return(i);
}

char *
object_to_string(object x)
{
  char *p;
  char *str;
  int length;

  switch (type_of(x)) {
  case t_string:
  case t_symbol:
    x->st.st_self[x->st.st_fillp] = '\0';
    return(x->st.st_self);
  default:
    FEerror("~S cannot be coerce to a C char pointer.", 1, x);
    break;
  }
}

float
object_to_float(object x)
{
	float f;

	if (FIXNUMP(x)) return(fix(x));	/* Immediate fixnum */

	switch (type_of(x)) {
	case t_character:
		f = char_code(x);  break;
	case t_fixnum:
		f = fix(x);  break;
	case t_bignum:
	case t_ratio:
		f = number_to_double(x);  break;
	case t_shortfloat:
		f = sf(x);  break;
	case t_longfloat:
		f = lf(x);  break;
	default:
		FEerror("~S cannot be coerce to a C float.", 1, x);
	}
	return(f);
}

double
object_to_double(object x)
{
	double d;

	if (FIXNUMP(x)) return(fix(x));	/* Immediate fixnum */

	switch (type_of(x)) {
	case t_character:
		d = char_code(x);  break;
	case t_fixnum:
		d = fix(x);  break;
	case t_bignum:
	case t_ratio:
		d = number_to_double(x);  break;
	case t_shortfloat:
		d = sf(x);  break;
	case t_longfloat:
		d = lf(x);  break;
	default:
		FEerror("~S cannot be coerce to a C double.", 1, x);
	}
	return(d);
}

init_cmpaux()
{
	make_si_function("SPECIALP",siLspecialp);
}

