/*
    block.c -- Blocks and exits.
*/
/*
    Copyright (c) 1984, Taiichi Yuasa and Masami Hagiya.
    Copyright (c) 1990, Giuseppe Attardi.

    ECoLisp is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    See file '../Copyright' for full details.
*/


#include "config.h"

/******************************* EXPORTS ******************************/

object Sblock;

/******************************* ------- ******************************/

Fblock(object args)
{
	object *lex_old = lex_env; lex_dcl;
	object id;
	int n;

	if (endp(args)) FEtoo_few_argumentsF(args);

	lex_copy();
	id = new_frame_id();
	lex_block_bind(CAR(args), id);
	if (n = frs_push(FRS_CATCH, id))
	  n--;			/* one was added by unwind */
	else {  object body;
		body = CDR(args);
		VALUES(0) = Cnil;
		n = 1;
		while (!endp(body)) {
		  n = eval(CAR(body));
		  body = CDR(body);
		}
	}
	frs_pop();
	lex_env = lex_old;
	RETURN(n);
}

Freturn_from(object args)
{
	object lex_block;
	frame_ptr fr;
	int n;

	if (endp(args))
		FEtoo_few_argumentsF(args);
	if (!endp(CDR(args)) && !endp(CDDR(args)))
		FEtoo_many_argumentsF(args);
	lex_block = lex_block_sch(CAR(args));
	if (Null(lex_block))
		FEerror("The block name ~S is undefined.", 1, CAR(args));
	fr = frs_sch(CADDR(lex_block));
	if (fr == NULL)
		FEerror("The block ~S is missing.", 1, CAR(args));
	if (endp(CDR(args))) {
		VALUES(0) = Cnil;
		n = 0;
	} else
		n = eval(CADR(args));
	unwind(fr, CADDR(lex_block), n+1);	/* +1 since longjmp cannot return 0 */
	/*  never reached  */
}

Freturn(object args)
{
	object lex_block;
	frame_ptr fr;
	int n;

	if (!endp(args) && !endp(CDR(args)))
		FEtoo_many_argumentsF(args);
	lex_block = lex_block_sch(Cnil);
	if (Null(lex_block))
 		FEerror("The block name ~S is undefined.", 1, Cnil);
	fr = frs_sch(CADDR(lex_block));
	if (fr == NULL)
		FEerror("The block ~S is missing.", 1, Cnil);
	if (endp(args)) {
		VALUES(0) = Cnil;
		n = 0;
	} else
		n = eval(CAR(args));
	unwind(fr, CADDR(lex_block), n+1);	/* +1 since longjmp cannot return 0 */
	/*  never reached  */
}

init_block()
{
	Sblock = make_special_form("BLOCK", Fblock);
	enter_mark_origin(&Sblock);
	make_special_form("RETURN-FROM", Freturn_from);
	make_special_form("RETURN", Freturn);
}
