;;(if (null (getenv "/afs/cs/project/clisp/hackers/ram/docs/latexinfo"))
;;  (error "You must define the environment variable /afs/cs/project/clisp/hackers/ram/docs/latexinfo first."))

(defun compile-if-necessary (file)
  (let ((filename (expand-file-name file)))
    (cond ((not (file-exists-p filename))
	   (error "File not found: %s" filename))
	  ((not (file-exists-p (concat filename "c")))
	   (byte-compile-file filename))
	  ((file-newer-than-file-p filename (concat filename "c"))
	   (byte-compile-file filename))
	  (t
	   (message "%s is up to date." filename)))
    )
  )

;;; LaTeXinfo
(setq load-path 
      (cons (setq latexinfo-formats-directory
		  (file-name-as-directory "/afs/cs/project/clisp/hackers/ram/docs/latexinfo/elisp"))
	    load-path))

(load-file  "/afs/cs/project/clisp/hackers/ram/docs/latexinfo/.latexinfo")
(compile-if-necessary "/afs/cs/project/clisp/hackers/ram/docs/latexinfo/elisp/latexinfo.el")
(load-file "/afs/cs/project/clisp/hackers/ram/docs/latexinfo/elisp/latexinfo.elc")
(mapcar 'compile-if-necessary (directory-files "/afs/cs/project/clisp/hackers/ram/docs/latexinfo/elisp" t ".*.el$"))
(find-file  "/afs/cs/project/clisp/hackers/ram/docs/latexinfo/manual/latexinfo2.tex")
(latexinfo-format-buffer t)
(save-some-buffers t)
(kill-emacs 0)
