;;; -*- Package: KERNEL; Log: C.Log -*-
;;;
;;; **********************************************************************
;;; This code was written as part of the CMU Common Lisp project at
;;; Carnegie Mellon University, and has been placed in the public domain.
;;; If you want to use this code or any part of CMU Common Lisp, please contact
;;; Scott Fahlman or slisp-group@cs.cmu.edu.
;;;
(ext:file-comment
  "$Header: type-init.lisp,v 1.4 91/02/20 14:59:54 ram Exp $")
;;;
;;; **********************************************************************
;;;
;;; $Header: type-init.lisp,v 1.4 91/02/20 14:59:54 ram Exp $
;;;
;;;    This file precomputes the translations for commonly used type specifiers
;;; when it is loaded.  This stuff is split off from the other type stuff to
;;; get around problems with everything needing to be loaded before everything
;;; else.  This is the first file which really exercises the type stuff.  This
;;; stuff is also somewhat implementation-dependent in that implementations may
;;; want to precompute other types which are important to them.
;;;
;;; Written by Rob MacLachlan
;;;
(in-package "KERNEL")

(export '*null-type*)


;;; Numeric types...

(precompute-types '((mod 2) (mod 4) (mod 16) (mod #x100) (mod #x10000)
		    (mod #x100000000)
		    (unsigned-byte 1) (unsigned-byte 2) (unsigned-byte 4)
		    (unsigned-byte 8) (unsigned-byte 16) (unsigned-byte 32)
		    (signed-byte 8) (signed-byte 16) (signed-byte 32)))

;;; Builtin symbol type specifiers:

(precompute-types type-specifier-symbols)

(defparameter *null-type* (specifier-type 'null))
