#include <c_decl.h>
#include "sys.h"
#include "lisp.h"

CL_INIT KFisqrt[] =
{
{ CL_FIXNUM, 48 }, /* 0 */
{ RT_CHAR_PTR, (long)"Isqrt: ~S argument must be a nonnegative integer" },
};

void Fisqrt(CL_FORM *base)
{
	if(CL_FIXNUMP(STACK(base, 0)))
	{
		COPY(STACK(base, 0), STACK(base, 1));
		Fminusp(STACK(base, 1));
		bool_result = NOT(CL_TRUEP(STACK(base, 1)));
	}
	else
	{
		bool_result = FALSE;
	}
	if(bool_result)
	{
		COPY(STACK(base, 0), STACK(base, 1));
		Finteger_length(STACK(base, 1));
		LOAD_FIXNUM(1, STACK(base, 2));
		COPY(STACK(base, 1), STACK(base, 3));
		F1minus(STACK(base, 3));
		LOAD_FIXNUM(-1, STACK(base, 4));
		LOAD_FIXNUM(-1, STACK(base, 5));
		Fminusp(STACK(base, 5));
		if(CL_TRUEP(STACK(base, 5)))
		{
			LOAD_FIXNUM(-1, STACK(base, 5));
			Fminus(STACK(base, 5), 1);
			LOAD_FIXNUM(GET_FIXNUM(STACK(base, 3)) >> GET_FIXNUM(STACK(base, 5)), STACK(base, 3));
		}
		else
		{
			LOAD_FIXNUM(-1, STACK(base, 5));
			LOAD_FIXNUM(GET_FIXNUM(STACK(base, 3)) <<  GET_FIXNUM(STACK(base, 5)), STACK(base, 3));
		}
		COPY(STACK(base, 3), STACK(base, 4));
		Fminusp(STACK(base, 4));
		if(CL_TRUEP(STACK(base, 4)))
		{
			LOAD_FIXNUM(1, STACK(base, 4));
			COPY(STACK(base, 3), STACK(base, 5));
			Fminus(STACK(base, 5), 1);
			LOAD_FIXNUM(GET_FIXNUM(STACK(base, 4)) >> GET_FIXNUM(STACK(base, 5)), STACK(base, 2));
		}
		else
		{
			LOAD_FIXNUM(1, STACK(base, 4));
			LOAD_FIXNUM(GET_FIXNUM(STACK(base, 4)) <<  GET_FIXNUM(STACK(base, 3)), STACK(base, 2));
		}
		COPY(STACK(base, 2), STACK(base, 3));
		COPY(STACK(base, 2), STACK(base, 4));
		COPY(STACK(base, 1), STACK(base, 5));
		Foddp(STACK(base, 5));
		if(CL_TRUEP(STACK(base, 5)))
		{
			LOAD_FIXNUM(-1, STACK(base, 5));
		}
		else
		{
			LOAD_FIXNUM(0, STACK(base, 5));
		}
		COPY(STACK(base, 5), STACK(base, 6));
		Fminusp(STACK(base, 6));
		if(CL_TRUEP(STACK(base, 6)))
		{
			COPY(STACK(base, 5), STACK(base, 6));
			Fminus(STACK(base, 6), 1);
			LOAD_FIXNUM(GET_FIXNUM(STACK(base, 4)) >> GET_FIXNUM(STACK(base, 6)), STACK(base, 4));
		}
		else
		{
			LOAD_FIXNUM(GET_FIXNUM(STACK(base, 4)) <<  GET_FIXNUM(STACK(base, 5)), STACK(base, 4));
		}
		Fplus(STACK(base, 3), 2);
		M51_1:;
		COPY(STACK(base, 3), STACK(base, 4));
		F1minus(STACK(base, 4));
		COPY(STACK(base, 2), STACK(base, 5));
		Fle(STACK(base, 4), 2);
		if(CL_TRUEP(STACK(base, 4)))
		{
			COPY(STACK(base, 2), STACK(base, 0));
			goto RETURN64;
		}
		COPY(STACK(base, 2), STACK(base, 4));
		COPY(STACK(base, 3), STACK(base, 5));
		Fplus(STACK(base, 4), 2);
		LOAD_FIXNUM(-1, STACK(base, 5));
		LOAD_FIXNUM(-1, STACK(base, 6));
		Fminusp(STACK(base, 6));
		if(CL_TRUEP(STACK(base, 6)))
		{
			LOAD_FIXNUM(-1, STACK(base, 6));
			Fminus(STACK(base, 6), 1);
			LOAD_FIXNUM(GET_FIXNUM(STACK(base, 4)) >> GET_FIXNUM(STACK(base, 6)), STACK(base, 4));
		}
		else
		{
			LOAD_FIXNUM(-1, STACK(base, 6));
			LOAD_FIXNUM(GET_FIXNUM(STACK(base, 4)) <<  GET_FIXNUM(STACK(base, 6)), STACK(base, 4));
		}
		COPY(STACK(base, 4), STACK(base, 5));
		COPY(STACK(base, 4), STACK(base, 6));
		Fmult(STACK(base, 5), 2);
		COPY(STACK(base, 0), STACK(base, 6));
		Fle(STACK(base, 5), 2);
		if(CL_TRUEP(STACK(base, 5)))
		{
			COPY(STACK(base, 4), STACK(base, 2));
		}
		else
		{
			COPY(STACK(base, 4), STACK(base, 3));
		}
		goto M51_1;
		RETURN64:;
	}
	else
	{
		LOAD_SMSTR((CL_FORM *)&KFisqrt[0], STACK(base, 1)); /* Isqrt: ~S argument must be a nonnegative integer */
		COPY(STACK(base, 0), STACK(base, 2));
		Ferror(STACK(base, 1), 2);
	}
}
