/*------------------------------------------------------------------------------
 * Copyright (C) 1993 Christian-Albrechts-Universitaet zu Kiel
 *-----------------------------------------------------------------------------
 * Projekt  : APPLY - A Practicable And Portable Lisp Implementation
 *            ------------------------------------------------------
 * Funktion : Laufzeitsystem: Funktionen des FFI
 *
 * $Revision: 1.8 $
 * $Log: foreign.c,v $
 * Revision 1.8  1993/07/22  09:13:35  pm
 * Funktionen zur Verwaltung von C-Strukturen
 *
 * Revision 1.7  1993/06/16  14:43:22  hk
 * Copyright Notiz eingefuegt.
 *
 * Revision 1.6  1993/06/04  13:45:45  pm
 * Globale Variable save_stack eingefuegt
 *
 * Revision 1.5  1993/05/31  17:08:07  pm
 * Schreibfehler beseitigt
 *
 * Revision 1.4  1993/05/23  17:53:54  pm
 * alle in C geschriebenen Konstruktor-, Test- und
 * Konvertierungsfunktionen fuer die primitiven Typen implementiert
 *
 * Revision 1.3  1993/05/21  13:55:24  pm
 * c-int in int umbenannt
 *
 * Revision 1.2  1993/05/05  09:10:54  pm
 * einige Funtionen zum Umgang mit c-ints eingebaut
 *
 * Revision 1.1  1993/04/28  14:23:23  pm
 * Initial revision
 *
 *----------------------------------------------------------------------------*/

#include <c_decl.h>
#include "sys.h"

/*------------------------------------------------------------------------------
 * globale Variable, in der die aktuelle Stackposition beim Aufruf
 * einer Call-Out-Funktion gemerkt wird, damit beim Aufruf einer
 * Call-In-Funktion diese Stelle verwendet werden kann.
 *----------------------------------------------------------------------------*/CL_FORM *save_stack;

/*------------------------------------------------------------------------------
 * internal_make_c_struct typsymbol cpointer
 *----------------------------------------------------------------------------*/
void internal_make_c_struct (base)
CL_FORM *base;
{
   CL_FORM *ptr;
   
   ptr = form_alloc(base, 3);
   LOAD_SYMBOL(GET_SYMBOL(STACK(base, 0)), OFFSET(ptr, 0));
   LOAD_FIXNUM(0, OFFSET(ptr,1));
   LOAD_CHAR_PTR(GET_CHAR_PTR(STACK(base, 1)), OFFSET(ptr, 2));
   LOAD_C_STRUCT(ptr, STACK(base, 0));
}


/*------------------------------------------------------------------------------
 * internal_c_struct_p object typsymbol
 *----------------------------------------------------------------------------*/
void internal_c_struct_p (base)
CL_FORM *base;
{
   RET_BOOL((TYPE_OF(STACK(base, 0)) == CL_C_STRUCT) && 
            (GET_SYMBOL(OFFSET(GET_FORM(STACK(base, 0)), 0)) == 
             GET_SYMBOL(STACK(base, 1))));
}

/*------------------------------------------------------------------------------
 * c_struct_p object
 *----------------------------------------------------------------------------*/
void c_struct_p (base)
CL_FORM *base;
{
   RET_BOOL(TYPE_OF(STACK(base, 0)) == CL_C_STRUCT);
}


/*------------------------------------------------------------------------------
 * internal_get_struct_pointer object
 *----------------------------------------------------------------------------*/
void internal_get_struct_pointer (base)
CL_FORM *base;
{
   LOAD_CHAR_PTR(GET_CHAR_PTR(OFFSET(GET_FORM(STACK(base, 0)), 2)),
                 STACK(base, 0));
}


/*------------------------------------------------------------------------------
 * die make_c_<anything> -Funktionen erzeugen Lispobjekte des gewuenschten Typs
 *----------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------
 * make_c_<character> value
 * +---------------+---------+
 * | C_<character> | <value> |
 * +---------------+---------+
 *----------------------------------------------------------------------------*/
void make_c_char (base)
CL_FORM *base;
{
   TYPE_OF(STACK(base, 0)) = CL_C_CHAR;
}

void make_c_unsigned_char (base)
CL_FORM *base;
{
   TYPE_OF(STACK(base, 0)) = CL_C_UNSIGNED_CHAR;
}

/*------------------------------------------------------------------------------
 * make_c_<integer> value
 * +-------------+---------+
 * | C_<integer> | <value> |
 * +-------------+---------+
 *----------------------------------------------------------------------------*/
void make_c_short (base)
CL_FORM *base;
{
   TYPE_OF(STACK(base, 0)) = CL_C_SHORT;
}

void make_c_int (base)
CL_FORM *base;
{
   TYPE_OF(STACK(base, 0)) = CL_C_INT;
}

void make_c_long (base)
CL_FORM *base;
{
   TYPE_OF(STACK(base, 0)) = CL_C_LONG;
}

void make_c_unsigned_short (base)
CL_FORM *base;
{
   TYPE_OF(STACK(base, 0)) = CL_C_UNSIGNED_SHORT;
}

void make_c_unsigned_int (base)
CL_FORM *base;
{
   TYPE_OF(STACK(base, 0)) = CL_C_UNSIGNED_INT;
}

void make_c_unsigned_long (base)
CL_FORM *base;
{
   TYPE_OF(STACK(base, 0)) = CL_C_UNSIGNED_LONG;
}

/*------------------------------------------------------------------------------
 * make_c_<float> value
 * +-----------+------+    +---------+
 * | C_<float> | fptr-+--->| <value> |
 * +-----------+------+    +---------+
 *----------------------------------------------------------------------------*/
void make_c_float (base)
CL_FORM *base;
{
   TYPE_OF(STACK(base, 0)) = CL_C_FLOAT;
}

void make_c_double (base)
CL_FORM *base;
{
   TYPE_OF(STACK(base, 0)) = CL_C_DOUBLE;
}


void make_c_long_double (base)
CL_FORM *base;
{
   TYPE_OF(STACK(base, 0)) = CL_C_LONG_DOUBLE;
}

/*------------------------------------------------------------------------------
 * Die make_lisp_<anything> -Funktionen konvertieren C-Objekte in Lisp-Objekte.
 *----------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------
 * make_lisp_character value
 *----------------------------------------------------------------------------*/
void make_lisp_character (base)
CL_FORM *base;
{
   TYPE_OF(STACK(base, 0)) = CL_CHAR;
}

/*------------------------------------------------------------------------------
 * make_lisp_integer value
 *----------------------------------------------------------------------------*/
void make_lisp_integer (base)
CL_FORM *base;
{
   TYPE_OF(STACK(base, 0)) = CL_FIXNUM;
}

/*------------------------------------------------------------------------------
 * make_lisp_float value
 *----------------------------------------------------------------------------*/
void make_lisp_float (base)
CL_FORM *base;
{
   TYPE_OF(STACK(base, 0)) = CL_FLOAT;
}

/*------------------------------------------------------------------------------
 * Die c_<anything>_p -Funktionen testen auf den gewuenschten Typ.
 *----------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------
 * c_char_p object
 *----------------------------------------------------------------------------*/
void c_char_p (base)
CL_FORM *base;
{
   RET_BOOL(TYPE_OF(STACK(base, 0)) == CL_C_CHAR);
}

/*------------------------------------------------------------------------------
 * c_unsigned_char_p object
 *----------------------------------------------------------------------------*/
void c_unsigned_char_p (base)
CL_FORM *base;
{
   RET_BOOL(TYPE_OF(STACK(base, 0)) == CL_C_UNSIGNED_CHAR);
}

/*------------------------------------------------------------------------------
 * c_short_p object
 *----------------------------------------------------------------------------*/
void c_short_p (base)
CL_FORM *base;
{
   RET_BOOL(TYPE_OF(STACK(base, 0)) == CL_C_SHORT);
}

/*------------------------------------------------------------------------------
 * c_int_p object
 *----------------------------------------------------------------------------*/
void c_int_p (base)
CL_FORM *base;
{
   RET_BOOL(TYPE_OF(STACK(base, 0)) == CL_C_INT);
}

/*------------------------------------------------------------------------------
 * c_long_p object
 *----------------------------------------------------------------------------*/
void c_long_p (base)
CL_FORM *base;
{
   RET_BOOL(TYPE_OF(STACK(base, 0)) == CL_C_LONG);
}

/*------------------------------------------------------------------------------
 * c_unsigned_short_p object
 *----------------------------------------------------------------------------*/
void c_unsigned_short_p (base)
CL_FORM *base;
{
   RET_BOOL(TYPE_OF(STACK(base, 0)) == CL_C_UNSIGNED_SHORT);
}

/*------------------------------------------------------------------------------
 * c_unsigned_int_p object
 *----------------------------------------------------------------------------*/
void c_unsigned_int_p (base)
CL_FORM *base;
{
   RET_BOOL(TYPE_OF(STACK(base, 0)) == CL_C_UNSIGNED_INT);
}

/*------------------------------------------------------------------------------
 * c_unsigned_long_p object
 *----------------------------------------------------------------------------*/
void c_unsigned_long_p (base)
CL_FORM *base;
{
   RET_BOOL(TYPE_OF(STACK(base, 0)) == CL_C_UNSIGNED_LONG);
}

/*------------------------------------------------------------------------------
 * c_float_p object
 *----------------------------------------------------------------------------*/
void c_float_p (base)
CL_FORM *base;
{
   RET_BOOL(TYPE_OF(STACK(base, 0)) == CL_C_FLOAT);
}

/*------------------------------------------------------------------------------
 * c_double_p object
 *----------------------------------------------------------------------------*/
void c_double_p (base)
CL_FORM *base;
{
   RET_BOOL(TYPE_OF(STACK(base, 0)) == CL_C_DOUBLE);
}

/*------------------------------------------------------------------------------
 * c_long_double_p object
 *----------------------------------------------------------------------------*/
void c_long_double_p (base)
CL_FORM *base;
{
   RET_BOOL(TYPE_OF(STACK(base, 0)) == CL_C_LONG_DOUBLE);
}

