#------------------------------------------------------------------------------
# Projekt : CLICC - a Common Lisp to C Compiler
#           -----------------------------------
# Function : Generates executable file from C file wich was generated by clicc.
#            Needs parameter SOURCE = <name> and
#            optionally OPTIMIZE = <-{O | g}>.
#            Uses Environment variable CLICCROOT.
#            Called by clicc/bin/cl and clicc/bin/clg.
#
#            Dependencies:
#            start -> rtl(startup.o) -> program -> rtl -> rtc
#
# $Source: /home3/apply/public/clicc-0.6.1/lib/RCS/makefile.cl,v $
# $Author: hk $
# $Revision: 1.11 $
# $Date: 1993/07/22 09:57:49 $
#------------------------------------------------------------------------------

MODULES =
OPTIMIZE = -O # alternative to -O is -g
CFLAGS	= $(OPTIONS) -I$(CLICCROOT)/lib $(OPTIMIZE)
CC	= acc

ifeq ($(findstring -g,$(OPTIMIZE)), -g)
 RTC	= $(CLICCROOT)/lib/rtc-g.a
 RTL	= $(CLICCROOT)/lib/rtl-g.a
 START	= $(CLICCROOT)/lib/main-g.o
else
 ifeq ($(findstring -pg,$(OPTIMIZE)), -pg)
  RTC	= $(CLICCROOT)/lib/rtc-p.a
  RTL	= $(CLICCROOT)/lib/rtl-p.a
  START	= $(CLICCROOT)/lib/main-p.o
 else
  RTC	= $(CLICCROOT)/lib/rtc.a
  RTL	= $(CLICCROOT)/lib/rtl.a
  START	= $(CLICCROOT)/lib/main.o
 endif
endif

OMODULES = $(MODULES:%=%.o)
OBJECT = $(SOURCE).o
PROGRAM= $(SOURCE)

$(PROGRAM): $(OBJECT) $(START) $(RTC) $(RTL) $(OMODULES)
	$(LINK.c) -o $@ $(START) $(OBJECT) $(OMODULES) $(RTL) $(RTC) $(RTL) -lm


