/*------------------------------------------------------------------------------
 * Copyright (C) 1993 Christian-Albrechts-Universitaet zu Kiel
 *------------------------------------------------------------------------------
 * Projekt  : APPLY - A Practicable And Portable Lisp Implementation
 *            ------------------------------------------------------
 * Funktion : Deklarationen fuer das Laufzeitsystem
 * 
 * $Revision: 1.26 $
 * $Log: c_decl.h,v $
 * Revision 1.26  1993/07/22  08:54:43  pm
 * LOAD- und GET-Funktionen fr C-Strukturen
 *
 * Revision 1.25  1993/07/05  16:03:21  sma
 * Nur eine Zeile und trotzdem ein Fehler...
 *
 * Revision 1.24  1993/07/05  14:34:20  sma
 * OFFSET-Makro eingefuegt, welches anstelle des STACK-Makros benutzt werden
 * soll, wenn dieses nicht mit dem LISP-Stack zusammen eingesetzt wird.
 *
 * Revision 1.23  1993/07/05  12:30:31  hk
 * stack deklariert.
 *
 * Revision 1.22  1993/07/05  12:23:45  hk
 * ILLEGAL_ARGS deklariert.
 *
 * Revision 1.21  1993/06/30  17:10:51  hk
 * Deklaration fuer Ssys eingefuegt.
 *
 * Revision 1.20  1993/06/17  08:59:19  hk
 * Copyright Notiz eingefuegt.
 *
 * Revision 1.19  1993/06/14  16:58:42  hk
 * Deklaration fuer Variable Symbols herausgenommen, Kommentare neu formatiert.
 *
 * Revision 1.18  1993/06/04  18:03:56  wg
 * Tippfehler bei LOAD_C_... eliminiert.
 *
 * Revision 1.17  1993/06/04  13:41:43  pm
 * Globale Variable save_stack deklariert
 *
 * Revision 1.16  1993/05/31  16:57:03  pm
 * Fehler beseitigt
 *
 * Revision 1.15  1993/05/23  17:42:34  pm
 * alle primitiven C-Typen eingebaut
 * LOAD- und GET-Macros dafuer geschrieben
 *
 * Revision 1.14  1993/05/13  13:31:44  pm
 * GET_FOREIGN_INT eingebaut
 *
 * Revision 1.13  1993/05/03  12:26:42  pm
 * Erweiterung um die Tags fuer das FFI
 *
 * Revision 1.12  1993/04/22  10:31:09  hk
 * NIL_VALUE hat Wert 0,
 * SYMBOL und SYMVAL bekommen zusaetzliches Argument base,
 * einen Zeiger auf das Symbol-Array eines Moduls.
 *
 * Revision 1.11  1993/03/25  10:21:53  ft
 * CLASS_SIZE auf 6 erhoeht.
 *
 * Revision 1.10  1993/03/12  10:42:16  ft
 * Deklarationen zur Codegenerierung fuer Klassen.
 *
 * Revision 1.9  1993/02/17  16:21:49  hk
 * CLICC -> APPLY, Revison Keyword.
 *
 * Revision 1.8  1992/12/07  16:53:53  ft
 * Erweiterung um CL_INSTANCE.
 *
 * Revision 1.7  1992/11/26  11:43:48  pm
 * GET_STRING und GET_STREAM rausgeworfen (Relikte)
 *
 * Revision 1.6  1992/09/09  10:03:02  hk
 * Vorkommen von CL_PACKAGE entfernt, da nicht definiert.
 *
 * Revision 1.5  1992/09/08  15:12:26  hk
 * In LOAD_GLOBFUN wird nun GET_GFARG statt faelschlich GET_FORM benutzt.
 *
 * Revision 1.4  1992/09/08  13:46:17  hk
 * Extern Decl. fuer mv_args entfernt, da nicht benutzt.
 *
 * Revision 1.3  1992/04/15  08:59:26  hk
 * Schreibfehler korrigiert.
 *
 * Revision 1.2  1992/04/14  14:29:26  hk
 * CATCHENV in CONTENV und last_catch in last_cont umbenannt.
 *
 * Revision 1.1  1992/03/24  17:20:39  hk
 * Initial revision
 *
 *               1991/01/16            hk
 * BOOL wird durch char ersetzt, damit cproto es richtig erkennt
------------------------------------------------------------------------------*/

#include <stdio.h>
#include <setjmp.h>

/* Wird auf 1 gesetzt, wenn sizeof(int) >= sizeof((char *)) */
/*----------------------------------------------------------*/
#define INT_GE_PTR 1

#define NOT(x)        !(x) /* zur besseren Lesbarkeit des erzeugten Codes */

/*-------------------------------------------------------------------------
 * Typdefinitionen
 *-------------------------------------------------------------------------*/
#define BOOL char
#define FALSE 0
#define TRUE 1

#ifdef __STDC__
typedef void *PTR;
#else
typedef char *PTR;
#endif

/*-------------------------------------------------------------------------
 * Werte fuer NIL, T, UNBOUND
 *-------------------------------------------------------------------------*/
#define NIL_VALUE     0
#define T_VALUE       (CL_FORM *)&Ssys[1*SYM_SIZE]
#define UNBOUND_VALUE 0

/*-------------------------------------------------------------------------
 * Forward-Definition
 *-------------------------------------------------------------------------*/
typedef struct clx_form CL_FORM;

/*-------------------------------------------------------------------------
 * Typen der von CLICC erzeugten C-Funktionen
 *-------------------------------------------------------------------------*/
typedef void GLOBAL_FUN ( /* CL_FORM *base, ... */ );
typedef void LOCAL_FUN  ( /* CL_FORM *base, CL_FORM *display[], ... */ );
typedef void CLOSURE_FUN( /* CL_FORM *base, ... */ );

/*-------------------------------------------------------------------------
 * Datenstruktur fuer globale Funargs
 *-------------------------------------------------------------------------*/
typedef struct
{
   GLOBAL_FUN *fun;
   int par_spec;
}
GLOBAL_FUNARG;

/*-------------------------------------------------------------------------
 * Datenstruktur fuer Downward Functions
 *-------------------------------------------------------------------------*/
typedef struct
{
   LOCAL_FUN *fun;
   int par_spec;
   CL_FORM **display;
}
DOWN_FUNARG;

/*-------------------------------------------------------------------------*
 * Datenstruktur fuer Continuations
 *-------------------------------------------------------------------------*/
typedef struct contenv
{
   CL_FORM *bind_top;
   jmp_buf jmp_buf;
   struct contenv *last;
}
CONTENV;

/*-------------------------------------------------------------------------
 * Datenstruktur der LISP-Objekte
 *-------------------------------------------------------------------------*/
typedef unsigned short TAG;

/*-------------------------------------------------------------------------*/
struct clx_form
{
   TAG tag;
   union
   {
      long            i;
      double         *fl;
      unsigned long  ch; /* Wichtig, kein 'char' nehmen ! (s.u.) */
      long           *i_ptr;
      char           *ch_ptr;
      CL_FORM        *form;
      CL_FORM        *symbol;
      FILE           *cfile;
      CLOSURE_FUN    *fun;
      DOWN_FUNARG    *dfarg;
      GLOBAL_FUNARG  *gfarg;
   } val;
};

/*-------------------------------------------------------------------------
 * Datenstruktur zum Initialisieren von LISP-Objekten
 * Es muss gelten sizeof(long) == sizeof( Komponenten von CL_FORM ),
 * sonst kann fehlerhafter Code erzeugt werden.
 *          CL_FORM          CL_INIT
 *       long: |----|,    long:   |----|
 *       PTR:  |------|   PTR:  |------|
 *       char: |-|        char:      |-|
 *-------------------------------------------------------------------------*/

typedef struct
{
   TAG tag;
   long val;
}
CL_INIT;

/*-------------------------------------------------------------------------
 * Definitionen der Datentypen von LISP-Objekten
 *
 * Bei den Array-Typen ist folgendes zu beachten:
 *    - Der erste Typ sollte bei einer Zahl 16^n beginnen
 *    - Es gilt immer die Reihenfolge T, FIXNUM, FLOAT, CHAR
 *-------------------------------------------------------------------------*/

#define CL_UNBOUND       0
#define CL_FIXNUM        1    /* number */
#define CL_FLOAT         2    /* number */
#define CL_CHAR          3

#define RT_FORM_PTR      4    /* Zeiger auf FORM-Array */
#define RT_FIXNUM_PTR    5    /* Zeiger auf FIXNUM-Array */
#define RT_FLOAT_PTR     6    /* Zeiger auf FLOAT-Array */
#define RT_CHAR_PTR      7    /* Zeiger auf CHAR-Array (String) */

#define CL_SYMBOL       13    /* symbol */
#define CL_NIL          14    /* symbol, list,          sequence */
#define CL_CONS         15    /*         list,          sequence */

#define CL_VEC          16
#define CL_VEC_T        16    /*         vector, array, sequence */
#define CL_VEC_FIXNUM   17    /*         vector, array, sequence */
#define CL_VEC_FLOAT    18    /*         vector, array, sequence */
#define CL_STRING       19    /* string, vector, array, sequence */

#define CL_SMVEC        20
#define CL_SMVEC_T      20    /*         vector, array, sequence */
#define CL_SMVEC_FIXNUM 21    /*         vector, array, sequence */
#define CL_SMVEC_FLOAT  22    /*         vector, array, sequence */
#define CL_SMSTR        23    /* string, vector, array, sequence */

#define CL_SMAR         24
#define CL_SMAR_T       24    /*                 array, sequence */
#define CL_SMAR_FIXNUM  25    /*                 array, sequence */
#define CL_SMAR_FLOAT   26    /*                 array, sequence */
#define CL_SMAR_CHAR    27    /*                 array, sequence */

#define CL_AR           28
#define CL_AR_T         28    /*                 array, sequence */
#define CL_AR_FIXNUM    29    /*                 array, sequence */
#define CL_AR_FLOAT     30    /*                 array, sequence */
#define CL_AR_CHAR      31    /*                 array, sequence */

#define CL_CLOSURE      32    /* function */
#define CL_DOWNFUN      33    /* function */
#define CL_GLOBFUN      34    /* function */

#define CL_CODE         37
#define CL_IND          38
#define CL_STRUCT       39    /* Structure */
#define CL_CFILE        41
#define CL_UNIQUE_TAG   42    /* fuer automatisch generierte CATCH-Tags */

#define CL_INSTANCE     50    /* CLOS Instanz */

#define CL_C_CHAR           60 /* char, signed-char */
#define CL_C_UNSIGNED_CHAR  61 
#define CL_C_SHORT          62 /* short, short-int, signed-short,
                                  signed-short-int */
#define CL_C_INT            63 /* int, signed, signed-int */
#define CL_C_LONG           64 /* long, long-int, signed-long,
                                  signed-long-int */
#define CL_C_UNSIGNED_SHORT 65
#define CL_C_UNSIGNED_INT   66 /* unsigned-int, unsigned */
#define CL_C_UNSIGNED_LONG  67

#define CL_C_FLOAT          68
#define CL_C_DOUBLE         69
#define CL_C_LONG_DOUBLE    70
#define CL_C_STRUCT         71
#define CL_C_UNION          72
#define CL_C_ARRAY          73
#define CL_C_POINTER        74

#define T_SEQ_LO   CL_NIL
#define T_SEQ_HI   CL_AR_CHAR
#define T_VEC_LO   CL_VEC_T
#define T_VEC_HI   CL_SMSTR
#define T_ARR_LO   CL_VEC_T
#define T_ARR_HI   CL_AR_CHAR
#define T_SMAR_LO  CL_SMVEC_T
#define T_SMAR_HI  CL_SMAR_CHAR

/*-------------------------------------------------------------------------
 * Makros fuer den Zugriff auf die Komponenten eines LISP-Objektes
 *-------------------------------------------------------------------------*/

#define TYPE_OF(loc)          ((loc)->tag)
#define SET_TAG(loc, value)   (TYPE_OF(loc) = (value))

#define GET_FIXNUM(loc)         ((loc)->val.i)
#define GET_FIXNUM_PTR(loc)     ((loc)->val.i_ptr)
#define GET_FLOAT(loc)          (*((loc)->val.fl))
#define GET_FLOAT_PTR(loc)      ((loc)->val.fl)
#define GET_CHAR(loc)           (char)((loc)->val.ch)
#define GET_CHAR_PTR(loc)       ((loc)->val.ch_ptr)
#define GET_FORM(loc)           ((loc)->val.form)
#define GET_CAR(loc)            ((loc)->val.form)
#define INDIRECT(loc)           ((loc)->val.form)
#define GET_SYMBOL(loc)         ((loc)->val.symbol)
#define GET_FUN(loc)            ((loc)->val.fun)
#define GET_DFARG(loc)          ((loc)->val.dfarg)
#define GET_GFARG(loc)          ((loc)->val.gfarg)
#define GET_CFILE(loc)          ((loc)->val.cfile)

#define GET_C_CHAR(loc)            (char)((loc)->val.ch)
#define GET_C_UNSIGNED_CHAR(loc)   (unsigned char)((loc)->val.ch)
#define GET_C_SHORT(loc)           (short)((loc)->val.i)
#define GET_C_INT(loc)             (int)((loc)->val.i)
#define GET_C_LONG(loc)            (long)((loc)->val.i)
#define GET_C_UNSIGNED_SHORT(loc)  (unsigned short)((loc)->val.i)
#define GET_C_UNSIGNED_INT(loc)    (unsigned int)((loc)->val.i)
#define GET_C_UNSIGNED_LONG(loc)   (unsigned long)((loc)->val.i)

#define GET_C_STRUCT(loc) ((loc)->val.ch_ptr)

/*-------------------------------------------------------------------------
 * Praedikate zum Testen des Datentyps
 *-------------------------------------------------------------------------*/

#define CL_NILP(loc)       (TYPE_OF (loc) == CL_NIL)
#define CL_TRUEP(loc)      (TYPE_OF (loc) != CL_NIL)
#define CL_UNBOUNDP(loc)   (TYPE_OF (loc) == CL_UNBOUND)

#define CL_FIXNUMP(loc)    (TYPE_OF (loc) == CL_FIXNUM)
#define CL_FLOATP(loc)     (TYPE_OF (loc) == CL_FLOAT)
#define CL_CHARP(loc)      (TYPE_OF (loc) == CL_CHAR)
#define CL_SYMBOLP(loc)    (TYPE_OF (loc) == CL_SYMBOL)
#define CL_CONSP(loc)      (TYPE_OF (loc) == CL_CONS)
#define CL_ATOMP(loc)      (TYPE_OF (loc) != CL_CONS)
#define CL_SMSTRP(loc)     (TYPE_OF (loc) == CL_SMSTR)
#define CL_STRINGP(loc)    (TYPE_OF (loc) == CL_STRING)
#define CL_SMVEC_T_P(loc)  (TYPE_OF (loc) == CL_SMVEC_T)
#define CL_VEC_T_P(loc)    (TYPE_OF (loc) == CL_VEC_T)
#define CL_CLOSUREP(loc)   (TYPE_OF (loc) == CL_CLOSURE)
#define CL_GLOBFUNP(loc)   (TYPE_OF (loc) == CL_GLOBFUN)
#define CL_DOWNFUNP(loc)   (TYPE_OF (loc) == CL_DOWNFUN)
#define CL_STRUCTP(loc)    (TYPE_OF (loc) == CL_STRUCT)

#define LOAD_NIL(loc)          (SET_TAG(loc, CL_NIL),GET_FORM(loc) = NIL_VALUE)
#define LOAD_T(loc)            (SET_TAG(loc, CL_SYMBOL),GET_FORM(loc) = T_VALUE)
#define LOAD_FIXNUM(num, loc)  (SET_TAG(loc, CL_FIXNUM),GET_FIXNUM(loc) = num)
#define LOAD_FLOAT(flptr, loc) (SET_TAG(loc, CL_FLOAT),(loc)->val.fl=flptr)
#define LOAD_CHAR(char, loc)   (SET_TAG(loc, CL_CHAR),((loc)->val.ch=char))

#define LOAD_FORM_PTR(form, loc)   (SET_TAG (loc, RT_FORM_PTR),\
                                    GET_FORM (loc) = (form))
#define LOAD_FIXNUM_PTR(iptr, loc) (SET_TAG (loc, RT_FIXNUM_PTR),\
                                    GET_FIXNUM_PTR (loc) = (iptr))
#define LOAD_FLOAT_PTR(flptr, loc) (SET_TAG (loc, RT_FLOAT_PTR),\
                                    GET_FLOAT_PTR (loc) = (flptr))
#define LOAD_CHAR_PTR(chptr, loc)  (SET_TAG (loc, RT_CHAR_PTR),\
                                    GET_CHAR_PTR (loc) = (chptr))

#define LOAD_CONS(car, loc)      (SET_TAG(loc, CL_CONS),GET_FORM(loc) = car)
#define LOAD_SYMBOL(sym, loc)    (SET_TAG(loc, CL_SYMBOL),GET_FORM(loc) = sym)

#define LOAD_CLASS(class, loc) (SET_TAG(loc, CL_INSTANCE),GET_FORM(loc) = class)

#define LOAD_SMSTR(strptr, loc)   (SET_TAG(loc, CL_SMSTR),\
                                   GET_FORM(loc) = strptr)
#define LOAD_STRING(strptr, loc)  (SET_TAG(loc, CL_STRING),\
                                   GET_FORM(loc) = strptr)
#define LOAD_SMVEC_T(strptr, loc) (SET_TAG(loc, CL_SMVEC_T),\
                                   GET_FORM(loc) = strptr)
#define LOAD_SMAR_T(strptr, loc)  (SET_TAG(loc, CL_SMAR_T),\
                                   GET_FORM(loc) = strptr)

#define LOAD_CODE(fun, loc)      (SET_TAG(loc, CL_CODE),GET_FUN(loc) = fun)
#define LOAD_IND(ptr, loc)       (SET_TAG(loc, CL_IND),GET_FORM(loc) = ptr)
#define LOAD_GLOBFUN(ptr, loc)   (SET_TAG(loc, CL_GLOBFUN),GET_GFARG(loc) = ptr)
#define LOAD_DOWNFUN(ptr, loc)   (SET_TAG(loc, CL_DOWNFUN),GET_DFARG(loc) = ptr)
#define LOAD_CLOSURE(ptr, loc)   (SET_TAG(loc, CL_CLOSURE),GET_FORM(loc) = ptr)
#define LOAD_UNBOUND(sym_val)    SET_TAG(sym_val, CL_UNBOUND)
#define LOAD_STRUCT(ptr, loc)    (SET_TAG(loc, CL_STRUCT),GET_FORM(loc) = ptr)
#define LOAD_CFILE(ptr, loc)     (SET_TAG(loc, CL_CFILE),GET_CFILE(loc) = ptr)
#define LOAD_UNIQUE_TAG(loc)     (SET_TAG(loc, CL_UNIQUE_TAG),\
                                  GET_FIXNUM(loc) = tag_counter++)

#define LOAD_C_CHAR(char, loc) (SET_TAG(loc, CL_C_CHAR),\
                                ((loc)->val.ch) = char)
#define LOAD_C_UNSIGNED_CHAR(char, loc) (SET_TAG(loc, CL_C_UNSIGNED_CHAR),\
                                         ((loc)->val.ch) = (char)char)
#define LOAD_C_SHORT(num, loc) (SET_TAG(loc, CL_C_SHORT),\
                                ((loc)->val.i) = (long)num)
#define LOAD_C_INT(num, loc)  (SET_TAG(loc, CL_C_INT),\
                               ((loc)->val.i) = (long)num)
#define LOAD_C_LONG(num, loc) (SET_TAG(loc, CL_C_LONG),\
                               ((loc)->val.i) = num)
#define LOAD_C_UNSIGNED_SHORT(num, loc) (SET_TAG(loc, CL_C_UNSIGNED_SHORT),\
                                         ((loc)->val.i) = (long)num)
#define LOAD_C_UNSIGNED_INT(num, loc) (SET_TAG(loc, CL_C_UNSIGNED_INT),\
                                       ((loc)->val.i) = (long)num)
#define LOAD_C_UNSIGNED_LONG(num, loc) (SET_TAG(loc, CL_C_UNSIGNED_LONG),\
                                        ((loc)->val.i) = (long)num)

#define LOAD_C_STRUCT(ptr, loc) (SET_TAG(loc, CL_C_STRUCT),\
                                 ((loc)->val.form) = ptr)

/*-------------------------------------------------------------------------*/
/* Aufbau von Symbolen                                                     */
/*-------------------------------------------------------------------------*/

#define OFF_SYM_PNAME         0
#define OFF_SYM_LEN           0
#define OFF_SYM_C_STRING      1
#define OFF_SYM_PLIST         2
#define OFF_SYM_VALUE         3
#define OFF_SYM_PACKAGE       4
#define OFF_SYM_CONSTFLAG     5
/* #define SYM_PNAME(sym)        ((sym) + OFF_SYM_PNAME)  */
#define SYM_PLIST(sym)        (GET_FORM (sym) + OFF_SYM_PLIST)
#define SYM_VALUE(sym)        (GET_FORM (sym) + OFF_SYM_VALUE)
#define SYM_PACKAGE(sym)      (GET_FORM (sym) + OFF_SYM_PACKAGE)
#define SYM_CONSTFLAG(sym)    (GET_FORM (sym) + OFF_SYM_CONSTFLAG)
#define LOAD_SYM_PNAME(sym, loc) LOAD_SMSTR(GET_FORM (sym), loc)
#define SYM_SIZE 6
#define SYMBOL(base, index) (CL_FORM *)&base[SYM_SIZE * index]
#define SYMVAL(base, index) (CL_FORM *)&base[SYM_SIZE * index + OFF_SYM_VALUE]

/*------------------------------------------------------------------------------
 * Zugriff auf Klassen
 *----------------------------------------------------------------------------*/

#define CLASS_SIZE 6
#define CLASS(index) (CL_FORM *)&classes[CLASS_SIZE * index]

/*-------------------------------------------------------------------------
 * Zugriff auf die Komponenten eines Strings / Vektors / Arrays
 *-------------------------------------------------------------------------*/

#define ARRAYP(ar_type)             (CL_VEC_T <= (ar_type) &&\
                                     (ar_type) <= CL_AR_CHAR)
#define VECTORP(ar_type)            (CL_VEC_T <= (ar_type) &&\
                                     (ar_type) <= CL_SMSTR)
/* VECTOR AND NOT SIMPLE */
#define VECTOR_NS_P(ar_type)        (CL_VEC_T <= (ar_type) &&\
                                     (ar_type) <= CL_STRING)
#define SMVECP(ar_type)             (CL_SMVEC_T <= (ar_type) &&\
                                     (ar_type) <= CL_SMSTR)

#define AR_SIZE(ar)                 GET_FIXNUM (ar)
#define AR_BASE(ar)                 ((ar) + 1)
#define AR_RANK(ar)                 TYPE_OF ((ar) - 1)
#define AR_DIM(ar, i)               *(GET_FIXNUM_PTR ((ar) - 1) + (i))
#define AR_DIMS(ar)                 GET_FIXNUM_PTR ((ar) - 1)
#define MAKE_NOT_DISPLACED(ar)      LOAD_NIL ((ar) - 2)
#define DISPLACED_P(ar)             (TYPE_OF ((ar) - 2) != CL_NIL)
#define DISPLACED_TO(ar)            AR_BASE (ar)
#define DISPLACED_INDEX_OFFSET(ar)  ((ar) - 2)
#define MAKE_FILL_PTR(vec)          TYPE_OF ((vec) - 1) = CL_FIXNUM
#define HAS_FILL_PTR(vec)           (TYPE_OF ((vec) - 1) != CL_NIL)
#define FILL_PTR(vec)               ((vec) - 1)
#define GET_FILL_PTR(vec)           AR_SIZE (vec)
#define AR_SIZE_WHEN_FP(vec)        GET_FIXNUM (FILL_PTR (vec))

#define FORM_AR(ar)   GET_FORM       (AR_BASE (ar))
#define FIXNUM_AR(ar) GET_FIXNUM_PTR (AR_BASE (ar))
#define FLOAT_AR(ar)  GET_FLOAT_PTR  (AR_BASE (ar))
#define CHAR_AR(ar)   GET_CHAR_PTR   (AR_BASE (ar))

/*-------------------------------------------------------------------------
 * Makro fuer den Zugriff auf den Stackframe einer LISP-Funktion
 *-------------------------------------------------------------------------*/

#define STACK(base, offset) ((base) + (offset))

/*-------------------------------------------------------------------------
 * Makro fuer den Zugriff auf ein Element eines Vektors von CL_FORMs
 *
 * Dient als Ersatz fuer STACK, wenn STACK nicht im Zusammenhang mit dem
 * LISP-Stack eingesetzt wird. Bitte ggf. umstellen!
 *-------------------------------------------------------------------------*/

#define OFFSET(vector, offset) ((vector) + (offset))

/*-------------------------------------------------------------------------*/
#define EQ(x, y) (GET_FORM(x) == GET_FORM(y) && TYPE_OF(x) == TYPE_OF(y))

#define RET_BOOL(expr) if (expr) { LOAD_T (STACK (base, 0)); }\
                       else { LOAD_NIL (STACK (base, 0)); }

/*-------------------------------------------------------------------------
 * Makro fuer das Kopieren der CL_FORM-Struktur
 * Bei einigen Kompilern muss Komponentenweise kopiert werden.
 *-------------------------------------------------------------------------*/

#define COPY(source, dest) (*(dest) = *(source))

/* Falls komponentenweise kopiert werden muss, dann unbedingt den Typ
   zuerst kopieren !
   Denn sonst wurden Aufrufe der Form
   COPY(SYM_VALUE(STACK(base, 1)), STACK(base, 1))
   nicht korrekt uebersetzt werden.
   #define COPY(source, dest)\
   (dest->tag = source->tag, dest->val = source->val)
*/

/*-------------------------------------------------------------------------
 * Retten / Restaurieren von special Variablen
 * Retten      : 1. Wert auf Binding-Stack, 2. Symbol auf Binding-Stack
 * Restaurieren: alten Wert in die Wert-Zelle des Symbols kopieren
 * 'sym' ist Zeiger auf das Symbol, NICHT Zeiger auf eine CL_FORM mit Typ
 * CL_SYMBOL.
 *-------------------------------------------------------------------------*/

#define POP_SPECIAL bind_top -= 2
#define SAVE_SPECIAL(sym) \
        (COPY(OFF_SYM_VALUE + sym, bind_top),  bind_top++,\
         LOAD_SYMBOL(sym, bind_top), bind_top++)
#define BIND_SPECIAL(sym, new_val) \
        (SAVE_SPECIAL(sym), COPY(new_val, OFF_SYM_VALUE + sym))
#define RESTORE_SPECIAL (POP_SPECIAL, COPY(bind_top, SYM_VALUE(bind_top+1)))

/*-------------------------------------------------------------------------
 * Kopieren von statischen Variablen in den Heap.
 * Parameter: 1. Zeiger auf die statische Variable im Stack
 *            2. Zeiger auf Stack-Top
 *-------------------------------------------------------------------------*/

#define GEN_HEAPVAR(var, top)\
{ CL_FORM *heap_ptr = form_alloc(top, 1);\
  COPY(var, heap_ptr);\
  LOAD_IND(heap_ptr, var);\
}


/*-------------------------------------------------------------------------
 * eigenes set- / longjmp definieren, damit auch  auf Maschinen, in denen
 * gilt sizeof((<type> *)) > sizeof(int), Zeiger als Parameter von longjmp
 * angegeben werden koennen.
 *-------------------------------------------------------------------------*/

#if INT_GE_PTR

#define LONGJMP(buf, value) longjmp(buf, (int)value)
#define SETJMP(buf) setjmp(buf)

#else

extern PTR jmp_value;
#define LONGJMP(buf, value) (jmp_value =  (PTR)value, longjmp(buf, 1))
#define SETJMP(buf) (setjmp(buf) ? jmp_value : NULL)

#endif

/*-------------------------------------------------------------------------
 * Extern Deklarationen
 *-------------------------------------------------------------------------*/
extern char TOO_MANY_ARGS[];    /* in main.c */
extern char ILLEGAL_ARGS[];     /* in main.c */
extern long tag_counter;        /* in main.c */
extern BOOL bool_result;        /* in main.c */
extern CL_FORM *stack;          /* in system.c */
extern int mv_count;            /* in values.c */
extern CL_FORM mv_buf[];        /* in values.c */
extern CL_FORM bind_stack[];    /* in catch.c */
extern CL_FORM *bind_top;       /* in catch.c */
extern CONTENV *last_cont;      /* in catch.c */
extern CL_FORM *save_stack;     /* in foreign.c */
extern CL_INIT Ssys[];          /* in symbols.c */
extern CL_INIT classes[];       /* in generated C Code */

