/*
                                ********

Copyright 1992 by BBN Systems and Technologies, A division of Bolt,
Beranek and Newman Inc.

Permission to use, copy, modify and distribute this software and its
documentation is hereby granted without fee, provided that the above
copyright notice and this permission appear in all copies and in
supporting documentation, and that the name Bolt, Beranek and Newman
Inc. not be used in advertising or publicity pertaining to distribution
of the software without specific, written prior permission.  In
addition, BBN makes no respresentation about the suitability of this
software for any purposes.  It is provided "AS IS" without express or
implied warranties including (but not limited to) all implied warranties
of merchantability and fitness.  In no event shall BBN be liable for any
special, indirect or consequential damages whatsoever resulting from
loss of use, data or profits, whether in an action of contract,
negligence or other tortuous action, arising out of or in connection
with the use or performance of this software.

                                ********
*/

/* Emacs: This is -*- C -*- code. */

/* Built in primitive declarations */

#include "usrdef.h"

long MAX_PRIMITIVE = 431;

/* The number of implemented primitives is 323. */

extern Pointer
       Prim_Zero_Fixnum(),
       Prim_Negative_Fixnum(),
       Prim_Positive_Fixnum(),
       Prim_Equal_Fixnum(),
       Prim_Less_Fixnum(),
       Prim_Greater_Fixnum(),
       Prim_One_Plus_Fixnum(),
       Prim_M_1_Plus_Fixnum(),
       Prim_Plus_Fixnum(),
       Prim_Minus_Fixnum(),
       Prim_Multiply_Fixnum(),
       Prim_Divide_Fixnum(),
       Prim_Gcd_Fixnum(),
       Prim_Apply(),
       Prim_Catch(),
       Prim_Non_Reentrant_Catch(),
       Prim_Enable_Interrupts(),
       Prim_Error_Procedure(),
       Prim_Get_Fixed_Objects_Vector(),
       Prim_Force(),
       Prim_Execute_At_New_Point(),
       Prim_Make_State_Space(),
       Prim_Current_Dynamic_State(),
       Prim_Set_Dynamic_State(),
       Prim_Scode_Eval(),
       Prim_Set_Interrupt_Enables(),
       Prim_Set_Current_History(),
       Prim_Set_Fixed_Objects_Vector(),
       Prim_Translate_To_Point(),
       Prim_With_History_Disabled(),
       Prim_With_Interrupt_Mask(),
       Prim_With_Interrupts_Reduced(),
       Prim_Within_Control_Point(),
       Prim_With_Threaded_Stack(),
       Prim_Hunk3_Cons(),
       Prim_Hunk3_Cxr(),
       Prim_Hunk3_Set_Cxr(),
       Prim_Sys_H3_0(),
       Prim_Sys_H3_1(),
       Prim_Sys_H3_2(),
       Prim_SH3_Set_0(),
       Prim_SH3_Set_1(),
       Prim_SH3_Set_2(),
       Prim_Cons(),
       Prim_Cdr(),
       Prim_Car(),
       Prim_General_Car_Cdr(),
       Prim_Assq(),
       Prim_Length(),
       Prim_Memq(),
       Prim_Set_Car(),
       Prim_Set_Cdr(),
       Prim_Pair(),
       Prim_Sys_Pair(),
       Prim_Sys_Pair_Car(),
       Prim_Sys_Pair_Cdr(),
       Prim_Sys_Pair_Cons(),
       Prim_Sys_Set_Car(),
       Prim_Sys_Set_Cdr(),
       Prim_Eval_Step(),
       Prim_Apply_Step(),
       Prim_Return_Step(),
       Prim_Make_Empty_String(),
       Prim_Make_Fld_String(),
       Prim_Build_String_From_List(),
       Prim_Equal_String_To_List(),
       Prim_Insert_String(),
       Prim_String_Equal(),
       Prim_Overwrite_String(),
       Prim_Substring(),
       Prim_Substring_Search(),
       Prim_Substring_To_List(),
       Prim_Raise_String(),
       Prim_Raise_Char(),
       Prim_String_Less(),
       Prim_String_Position(),
       Prim_Truncate_String(),
       Prim_Vector_8b(),
       Prim_Vector_8b_Cons(),
       Prim_Vec_8b_Size(),
       Prim_List_To_Vector(),
       Prim_Subvector_To_List(),
       Prim_Vector_Cons(),
       Prim_Vector_Ref(),
       Prim_Vector_Set(),
       Prim_Vector_Size(),
       Prim_Sys_List_To_Vector(),
       Prim_Sys_Subvector_To_List(),
       Prim_Sys_Vector(),
       Prim_Sys_Vector_Ref(),
       Prim_Sys_Vec_Set(),
       Prim_Sys_Vec_Size(),
       Prim_subvector_move_right(),
       Prim_subvector_move_left(),
       Prim_vector_fill(),
       Prim_Chk_And_Cln_Input_Channel(),
       Prim_Get_Next_Interrupt_Char(),
       Prim_System_Clock(),
       Prim_Setup_Timer_Interrupt(),
       Prim_Current_Year(),
       Prim_Current_Month(),
       Prim_Current_Day(),
       Prim_Current_Hour(),
       Prim_Current_Minute(),
       Prim_Current_Second(),
       Prim_Non_Restartable_Exit(),
       Prim_Restartable_Exit(),
       Prim_Set_Run_Light(),
       Prim_under_emacs_p(),
       Prim_Close_Lost_Open_Files(),
       Prim_Rehash(),
       Prim_Null(),
       Prim_Eq(),
       Prim_Make_Non_Pointer(),
       Prim_Primitive_Datum(),
       Prim_Prim_Type(),
       Prim_Gc_Type(),
       Prim_Prim_Type_QM(),
       Prim_Primitive_Set_Type(),
       Prim_And_Make_Object(),
       Prim_System_Memory_Ref(),
       Prim_System_Memory_Set(),
       Prim_Dangerous_QM(),
       Prim_Dangerize(),
       Prim_Undangerize(),
       Prim_Make_Cell(),
       Prim_Cell_Contents(),
       Prim_Cell(),
       Prim_Set_Cell_Contents(),
       Prim_Map_Code_To_Address(),
       Prim_Map_Address_To_Code(),
       Prim_Map_Prim_Address_To_Arity(),
       Prim_Non_Marked_Vector_Cons(),
       Prim_Insert_Non_Marked_Vector(),
       Prim_Get_Work(),
       Prim_Touch(),
       Prim_Get_External_Count(),
       Prim_Get_Ext_Name(),
       Prim_Get_Ext_Number(),
       Prim_Lexical_Assignment(),
       Prim_Lexical_Reference(),
       Prim_Local_Reference(),
       Prim_Local_Assignment(),
       Prim_Unassigned_Test(),
       Prim_Unbound_Test(),
       Prim_Unreferenceable_Test(),
       Prim_Temp_Printer(),
       Prim_String_To_Symbol(),
       Prim_Intern_Character_List(),
       Prim_String_Hash(),
       Prim_string_hash_mod(),
       Prim_Character_List_Hash(),
       Prim_Prim_Fasdump(),
       Prim_Band_Dump(),
       Prim_Binary_Fasload(),
       Prim_reload_band_name(),
       Prim_Band_Load(),
       Prim_Garbage_Collect(),
       Prim_Primitive_Purify(),
       Prim_Impurify(),
       Prim_Pure_P(),
       Prim_Constant_P(),
       Prim_Get_Next_Constant(),
       Prim_compiled_code_address_block(),
       Prim_Fix_To_Big(),
       Prim_Big_To_Fix(),
       Prim_Listify_Bignum(),
       Prim_Plus_Bignum(),
       Prim_Minus_Bignum(),
       Prim_Multiply_Bignum(),
       Prim_Divide_Bignum(),
       Prim_Zero_Bignum(),
       Prim_Positive_Bignum(),
       Prim_Negative_Bignum(),
       Prim_Equal_Bignum(),
       Prim_Greater_Bignum(),
       Prim_Less_Bignum(),
       Prim_Plus_Flonum(),
       Prim_Minus_Flonum(),
       Prim_Multiply_Flonum(),
       Prim_Divide_Flonum(),
       Prim_Equal_Flonum(),
       Prim_Greater_Flonum(),
       Prim_Less_Flonum(),
       Prim_Sine_Flonum(),
       Prim_Cosine_Flonum(),
       Prim_Arctan_Flonum(),
       Prim_Exp_Flonum(),
       Prim_Ln_Flonum(),
       Prim_Sqrt_Flonum(),
       Prim_Zero_Flonum(),
       Prim_Positive_Flonum(),
       Prim_Negative_Flonum(),
       Prim_Int_To_Float(),
       Prim_Truncate_Flonum(),
       Prim_Round_Flonum(),
       Prim_Zero(),
       Prim_Positive(),
       Prim_Negative(),
       Prim_One_Plus(),
       Prim_M_1_Plus(),
       Prim_Equal_Number(),
       Prim_Less(),
       Prim_Greater(),
       Prim_Plus(),
       Prim_Minus(),
       Prim_Multiply(),
       Prim_Divide(),
       Prim_Integer_Divide(),
       Prim_Sqrt(),
       Prim_Exp(),
       Prim_Ln(),
       Prim_Sine(),
       Prim_Cosine(),
       Prim_Arctan(),
       Prim_Truncate(),
       Prim_Round(),
       Prim_Floor(),
       Prim_Ceiling(),
       Prim_Make_Char(),
       Prim_Char_Bits(),
       Prim_Char_Code(),
       Prim_Char_To_Integer(),
       Prim_Integer_To_Char(),
       Prim_Char_Downcase(),
       Prim_Char_Upcase(),
       Prim_Ascii_To_Char(),
       Prim_Char_To_Ascii(),
       Prim_Char_Ascii_P(),
       Prim_File_Open_Channel(),
       Prim_File_Close_Channel(),
       Prim_File_Eof_P(),
       Prim_File_Length(),
       Prim_File_Read_Char(),
       Prim_File_Fill_Input_Buffer(),
       Prim_File_Write_Char(),
       Prim_File_Write_String(),
       Prim_File_Exists(),
       Prim_Copy_File(),
       Prim_Rename_File(),
       Prim_Remove_File(),
       Prim_Link_File(),
       Prim_working_dir_pathname(),
       Prim_set_working_dir_pathname(),
       Prim_Make_Directory(),
       Prim_open_directory(),
       Prim_directory_read(),
       Prim_String_Allocate(),
       Prim_String_P(),
       Prim_String_Length(),
       Prim_String_Maximum_Length(),
       Prim_Set_String_Length(),
       Prim_String_Ref(),
       Prim_Vec_8b_Ref(),
       Prim_String_Set(),
       Prim_Vec_8b_Set(),
       Prim_Substring_Move_Right(),
       Prim_Substring_Move_Left(),
       Prim_Vec_8b_Fill(),
       Prim_Vec_8b_Find_Next_Char(),
       Prim_Vec_8b_Find_Prev_Char(),
       Prim_Vec_8b_Find_Next_Char_Ci(),
       Prim_Vec_8b_Find_Prev_Char_Ci(),
       Prim_Find_Next_Char_In_Set(),
       Prim_Find_Prev_Char_In_Set(),
       Prim_Substring_Equal(),
       Prim_Substring_Ci_Equal(),
       Prim_Substring_Less(),
       Prim_Substring_Upcase(),
       Prim_Substring_Downcase(),
       Prim_Match_Forward(),
       Prim_Match_Forward_Ci(),
       Prim_Match_Backward(),
       Prim_Match_Backward_Ci(),
       Prim_Tty_Read_Char_Ready_P(),
       Prim_Tty_Read_Char(),
       Prim_Tty_Read_Char_Immediate(),
       Prim_Tty_Read_Finish(),
       Prim_Tty_Write_Char(),
       Prim_Tty_Write_String(),
       Prim_tty_flush_output(),
       Prim_Tty_Beep(),
       Prim_Tty_Clear(),
       Prim_Photo_Open(),
       Prim_Photo_Close(),
       Prim_Tty_Move_Cursor(),
       Prim_Tty_Get_Cursor(),
       Prim_Screen_X_Size(),
       Prim_Screen_Y_Size(),
       Prim_Clear_To_End_Of_Line(),
       Prim_Microcode_Identify(),
       Prim_Microcode_Tables_Filename(),
       Prim_String_To_Syntax_Entry(),
       Prim_Char_To_Syntax_Code(),
       Prim_Quoted_Char_P(),
       Prim_Scan_Backward_Prefix_Chars(),
       Prim_Scan_Forward_To_Word(),
       Prim_Scan_Word_Forward(),
       Prim_Scan_Word_Backward(),
       Prim_Scan_List_Forward(),
       Prim_Scan_List_Backward(),
       Prim_Scan_Sexps_Forward(),
       Prim_bit_string_allocate(),
       Prim_bit_string_p(),
       Prim_make_bit_string(),
       Prim_bit_string_fill_x(),
       Prim_bit_string_length(),
       Prim_bit_string_ref(),
       Prim_bit_string_clear_x(),
       Prim_bit_string_set_x(),
       Prim_bit_string_zero_p(),
       Prim_bit_string_equal_p(),
       Prim_bit_string_move_x(),
       Prim_bit_string_movec_x(),
       Prim_bit_string_or_x(),
       Prim_bit_string_and_x(),
       Prim_bit_string_andc_x(),
       Prim_bit_substring_move_right_x(),
       Prim_unsigned_to_bit_string(),
       Prim_bit_string_to_unsigned(),
       Prim_read_bits_x(),
       Prim_write_bits_x(),
       Prim_bit_substring_find_next_set_bit(),
       Prim_Inexistent();

static char No_Name[] = "INEXISTENT-PRIMITIVE";

Pointer
Prim_Inexistent()
{
  Primitive_0_Args();

  Primitive_Error(ERR_UNIMPLEMENTED_PRIMITIVE);
}

Pointer (*(Primitive_Procedure_Table[]))() = {
  Prim_Lexical_Assignment              /* 3 "LEXICAL-ASSIGNMENT"                           Primitive   0x0 in lookup.c */,
  Prim_Local_Reference                 /* 2 "LOCAL-REFERENCE"                              Primitive   0x1 in lookup.c */,
  Prim_Local_Assignment                /* 3 "LOCAL-ASSIGNMENT"                             Primitive   0x2 in lookup.c */,
  Prim_Catch                           /* 1 "CALL-WITH-CURRENT-CONTINUATION"               Primitive   0x3 in hooks.c */,
  Prim_Scode_Eval                      /* 2 "SCODE-EVAL"                                   Primitive   0x4 in hooks.c */,
  Prim_Apply                           /* 2 "APPLY"                                        Primitive   0x5 in hooks.c */,
  Prim_Set_Interrupt_Enables           /* 1 "SET-INTERRUPT-ENABLES!"                       Primitive   0x6 in hooks.c */,
  Prim_String_To_Symbol                /* 1 "STRING->SYMBOL"                               Primitive   0x7 in intern.c */,
  Prim_Get_Work                        /* 1 "GET-WORK"                                     Primitive   0x8 in random.c */,
  Prim_Non_Reentrant_Catch             /* 1 "NON-REENTRANT-CALL-WITH-CURRENT-CONTINUATION" Primitive   0x9 in hooks.c */,
  Prim_Current_Dynamic_State           /* 1 "CURRENT-DYNAMIC-STATE"                        Primitive   0xa in hooks.c */,
  Prim_Set_Dynamic_State               /* 1 "SET-CURRENT-DYNAMIC-STATE!"                   Primitive   0xb in hooks.c */,
  Prim_Null                            /* 1 "NULL?"                                        Primitive   0xc in prim.c */,
  Prim_Eq                              /* 2 "EQ?"                                          Primitive   0xd in prim.c */,
  Prim_String_Equal                    /* 2 "STRING-EQUAL?"                                Primitive   0xe in string.c */,
  Prim_Prim_Type_QM                    /* 2 "PRIMITIVE-TYPE?"                              Primitive   0xf in prim.c */,
  Prim_Prim_Type                       /* 1 "PRIMITIVE-TYPE"                               Primitive  0x10 in prim.c */,
  Prim_Primitive_Set_Type              /* 2 "PRIMITIVE-SET-TYPE"                           Primitive  0x11 in prim.c */,
  Prim_Lexical_Reference               /* 2 "LEXICAL-REFERENCE"                            Primitive  0x12 in lookup.c */,
  Prim_Unreferenceable_Test            /* 2 "LEXICAL-UNREFERENCEABLE?"                     Primitive  0x13 in lookup.c */,
  Prim_Make_Char                       /* 2 "MAKE-CHAR"                                    Primitive  0x14 in character.c */,
  Prim_Char_Bits                       /* 1 "CHAR-BITS"                                    Primitive  0x15 in character.c */,
  Prim_Non_Restartable_Exit            /* 0 "EXIT"                                         Primitive  0x16 in sysprim.c */,
  Prim_Char_Code                       /* 1 "CHAR-CODE"                                    Primitive  0x17 in character.c */,
  Prim_Unassigned_Test                 /* 2 "LEXICAL-UNASSIGNED?"                          Primitive  0x18 in lookup.c */,
  Prim_Insert_Non_Marked_Vector        /* 3 "INSERT-NON-MARKED-VECTOR!"                    Primitive  0x19 in random.c */,
  Prim_Restartable_Exit                /* 0 "HALT"                                         Primitive  0x1a in sysprim.c */,
  Prim_Char_To_Integer                 /* 1 "CHAR->INTEGER"                                Primitive  0x1b in character.c */,
  Prim_Memq                            /* 2 "MEMQ"                                         Primitive  0x1c in list.c */,
  Prim_Insert_String                   /* 3 "INSERT-STRING"                                Primitive  0x1d in string.c */,
  Prim_Enable_Interrupts               /* 1 "ENABLE-INTERRUPTS!"                           Primitive  0x1e in hooks.c */,
  Prim_Make_Empty_String               /* 1 "MAKE-EMPTY-STRING"                            Primitive  0x1f in string.c */,
  Prim_Cons                            /* 2 "CONS"                                         Primitive  0x20 in list.c */,
  Prim_Car                             /* 1 "CAR"                                          Primitive  0x21 in list.c */,
  Prim_Cdr                             /* 1 "CDR"                                          Primitive  0x22 in list.c */,
  Prim_Set_Car                         /* 2 "SET-CAR!"                                     Primitive  0x23 in list.c */,
  Prim_Set_Cdr                         /* 2 "SET-CDR!"                                     Primitive  0x24 in list.c */,
  Prim_Touch                           /* 1 "TOUCH"                                        Primitive  0x25 in random.c */,
  Prim_Tty_Get_Cursor                  /* 0 "TTY-GET-CURSOR"                               Primitive  0x26 in ttyio.c */,
  Prim_General_Car_Cdr                 /* 2 "GENERAL-CAR-CDR"                              Primitive  0x27 in list.c */,
  Prim_Hunk3_Cons                      /* 3 "HUNK3-CONS"                                   Primitive  0x28 in hunk.c */,
  Prim_Hunk3_Cxr                       /* 2 "HUNK3-CXR"                                    Primitive  0x29 in hunk.c */,
  Prim_Hunk3_Set_Cxr                   /* 3 "HUNK3-SET-CXR!"                               Primitive  0x2a in hunk.c */,
  Prim_Overwrite_String                /* 3 "INSERT-STRING!"                               Primitive  0x2b in string.c */,
  Prim_Vector_Cons                     /* 2 "VECTOR-CONS"                                  Primitive  0x2c in vector.c */,
  Prim_Vector_Size                     /* 1 "VECTOR-LENGTH"                                Primitive  0x2d in vector.c */,
  Prim_Vector_Ref                      /* 2 "VECTOR-REF"                                   Primitive  0x2e in vector.c */,
  Prim_Set_Current_History             /* 1 "SET-CURRENT-HISTORY!"                         Primitive  0x2f in hooks.c */,
  Prim_Vector_Set                      /* 3 "VECTOR-SET!"                                  Primitive  0x30 in vector.c */,
  Prim_Non_Marked_Vector_Cons          /* 1 "NON-MARKED-VECTOR-CONS"                       Primitive  0x31 in random.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive  0x32 in Findprim.c */,
  Prim_Unbound_Test                    /* 2 "LEXICAL-UNBOUND?"                             Primitive  0x33 in lookup.c */,
  Prim_Integer_To_Char                 /* 1 "INTEGER->CHAR"                                Primitive  0x34 in character.c */,
  Prim_Char_Downcase                   /* 1 "CHAR-DOWNCASE"                                Primitive  0x35 in character.c */,
  Prim_Char_Upcase                     /* 1 "CHAR-UPCASE"                                  Primitive  0x36 in character.c */,
  Prim_Ascii_To_Char                   /* 1 "ASCII->CHAR"                                  Primitive  0x37 in character.c */,
  Prim_Char_Ascii_P                    /* 1 "CHAR-ASCII?"                                  Primitive  0x38 in character.c */,
  Prim_Char_To_Ascii                   /* 1 "CHAR->ASCII"                                  Primitive  0x39 in character.c */,
  Prim_Garbage_Collect                 /* 1 "GARBAGE-COLLECT"                              Primitive  0x3a in memmag.c */,
  Prim_Plus_Fixnum                     /* 2 "PLUS-FIXNUM"                                  Primitive  0x3b in fixnum.c */,
  Prim_Minus_Fixnum                    /* 2 "MINUS-FIXNUM"                                 Primitive  0x3c in fixnum.c */,
  Prim_Multiply_Fixnum                 /* 2 "MULTIPLY-FIXNUM"                              Primitive  0x3d in fixnum.c */,
  Prim_Divide_Fixnum                   /* 2 "DIVIDE-FIXNUM"                                Primitive  0x3e in fixnum.c */,
  Prim_Equal_Fixnum                    /* 2 "EQUAL-FIXNUM?"                                Primitive  0x3f in fixnum.c */,
  Prim_Less_Fixnum                     /* 2 "LESS-THAN-FIXNUM?"                            Primitive  0x40 in fixnum.c */,
  Prim_Positive_Fixnum                 /* 1 "POSITIVE-FIXNUM?"                             Primitive  0x41 in fixnum.c */,
  Prim_One_Plus_Fixnum                 /* 1 "ONE-PLUS-FIXNUM"                              Primitive  0x42 in fixnum.c */,
  Prim_M_1_Plus_Fixnum                 /* 1 "MINUS-ONE-PLUS-FIXNUM"                        Primitive  0x43 in fixnum.c */,
  Prim_Truncate_String                 /* 2 "TRUNCATE-STRING!"                             Primitive  0x44 in string.c */,
  Prim_Substring                       /* 3 "SUBSTRING"                                    Primitive  0x45 in string.c */,
  Prim_Zero_Fixnum                     /* 1 "ZERO-FIXNUM?"                                 Primitive  0x46 in fixnum.c */,
  Prim_Undangerize                     /* 1 "MAKE-OBJECT-SAFE"                             Primitive  0x47 in prim.c */,
  Prim_Dangerize                       /* 1 "MAKE-OBJECT-DANGEROUS"                        Primitive  0x48 in prim.c */,
  Prim_Dangerous_QM                    /* 1 "OBJECT-DANGEROUS?"                            Primitive  0x49 in prim.c */,
  Prim_Substring_To_List               /* 3 "SUBSTRING->LIST"                              Primitive  0x4a in string.c */,
  Prim_Make_Fld_String                 /* 2 "MAKE-FILLED-STRING"                           Primitive  0x4b in string.c */,
  Prim_Plus_Bignum                     /* 2 "PLUS-BIGNUM"                                  Primitive  0x4c in bignum.c */,
  Prim_Minus_Bignum                    /* 2 "MINUS-BIGNUM"                                 Primitive  0x4d in bignum.c */,
  Prim_Multiply_Bignum                 /* 2 "MULTIPLY-BIGNUM"                              Primitive  0x4e in bignum.c */,
  Prim_Divide_Bignum                   /* 2 "DIVIDE-BIGNUM"                                Primitive  0x4f in bignum.c */,
  Prim_Listify_Bignum                  /* 2 "LISTIFY-BIGNUM"                               Primitive  0x50 in bignum.c */,
  Prim_Equal_Bignum                    /* 2 "EQUAL-BIGNUM?"                                Primitive  0x51 in bignum.c */,
  Prim_Less_Bignum                     /* 2 "LESS-THAN-BIGNUM?"                            Primitive  0x52 in bignum.c */,
  Prim_Positive_Bignum                 /* 1 "POSITIVE-BIGNUM?"                             Primitive  0x53 in bignum.c */,
  Prim_File_Open_Channel               /* 2 "FILE-OPEN-CHANNEL"                            Primitive  0x54 in fileio.c */,
  Prim_File_Close_Channel              /* 1 "FILE-CLOSE-CHANNEL"                           Primitive  0x55 in fileio.c */,
  Prim_Prim_Fasdump                    /* 3 "PRIMITIVE-FASDUMP"                            Primitive  0x56 in fasdump.c */,
  Prim_Binary_Fasload                  /* 1 "BINARY-FASLOAD"                               Primitive  0x57 in fasload.c */,
  Prim_String_Position                 /* 3 "STRING-POSITION"                              Primitive  0x58 in string.c */,
  Prim_String_Less                     /* 2 "STRING-LESS?"                                 Primitive  0x59 in string.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive  0x5a in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive  0x5b in Findprim.c */,
  Prim_Rehash                          /* 2 "REHASH"                                       Primitive  0x5c in daemon.c */,
  Prim_Length                          /* 1 "LENGTH"                                       Primitive  0x5d in list.c */,
  Prim_Assq                            /* 2 "ASSQ"                                         Primitive  0x5e in list.c */,
  Prim_Build_String_From_List          /* 1 "LIST->STRING"                                 Primitive  0x5f in string.c */,
  Prim_Equal_String_To_List            /* 2 "EQUAL-STRING-TO-LIST?"                        Primitive  0x60 in string.c */,
  Prim_Make_Cell                       /* 1 "MAKE-CELL"                                    Primitive  0x61 in prim.c */,
  Prim_Cell_Contents                   /* 1 "CELL-CONTENTS"                                Primitive  0x62 in prim.c */,
  Prim_Cell                            /* 1 "CELL?"                                        Primitive  0x63 in prim.c */,
  Prim_Raise_Char                      /* 1 "CHARACTER-UPCASE"                             Primitive  0x64 in string.c */,
  Prim_Character_List_Hash             /* 1 "CHARACTER-LIST-HASH"                          Primitive  0x65 in intern.c */,
  Prim_Gcd_Fixnum                      /* 2 "GCD-FIXNUM"                                   Primitive  0x66 in fixnum.c */,
  Prim_Fix_To_Big                      /* 1 "COERCE-FIXNUM-TO-BIGNUM"                      Primitive  0x67 in bignum.c */,
  Prim_Big_To_Fix                      /* 1 "COERCE-BIGNUM-TO-FIXNUM"                      Primitive  0x68 in bignum.c */,
  Prim_Plus_Flonum                     /* 2 "PLUS-FLONUM"                                  Primitive  0x69 in flonum.c */,
  Prim_Minus_Flonum                    /* 2 "MINUS-FLONUM"                                 Primitive  0x6a in flonum.c */,
  Prim_Multiply_Flonum                 /* 2 "MULTIPLY-FLONUM"                              Primitive  0x6b in flonum.c */,
  Prim_Divide_Flonum                   /* 2 "DIVIDE-FLONUM"                                Primitive  0x6c in flonum.c */,
  Prim_Equal_Flonum                    /* 2 "EQUAL-FLONUM?"                                Primitive  0x6d in flonum.c */,
  Prim_Less_Flonum                     /* 2 "LESS-THAN-FLONUM?"                            Primitive  0x6e in flonum.c */,
  Prim_Zero_Bignum                     /* 1 "ZERO-BIGNUM?"                                 Primitive  0x6f in bignum.c */,
  Prim_Truncate_Flonum                 /* 1 "TRUNCATE-FLONUM"                              Primitive  0x70 in flonum.c */,
  Prim_Round_Flonum                    /* 1 "ROUND-FLONUM"                                 Primitive  0x71 in flonum.c */,
  Prim_Int_To_Float                    /* 1 "COERCE-INTEGER-TO-FLONUM"                     Primitive  0x72 in flonum.c */,
  Prim_Sine_Flonum                     /* 1 "SINE-FLONUM"                                  Primitive  0x73 in flonum.c */,
  Prim_Cosine_Flonum                   /* 1 "COSINE-FLONUM"                                Primitive  0x74 in flonum.c */,
  Prim_Arctan_Flonum                   /* 1 "ARCTAN-FLONUM"                                Primitive  0x75 in flonum.c */,
  Prim_Exp_Flonum                      /* 1 "EXP-FLONUM"                                   Primitive  0x76 in flonum.c */,
  Prim_Ln_Flonum                       /* 1 "LN-FLONUM"                                    Primitive  0x77 in flonum.c */,
  Prim_Sqrt_Flonum                     /* 1 "SQRT-FLONUM"                                  Primitive  0x78 in flonum.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive  0x79 in Findprim.c */,
  Prim_Get_Fixed_Objects_Vector        /* 0 "GET-FIXED-OBJECTS-VECTOR"                     Primitive  0x7a in hooks.c */,
  Prim_Set_Fixed_Objects_Vector        /* 1 "SET-FIXED-OBJECTS-VECTOR!"                    Primitive  0x7b in hooks.c */,
  Prim_List_To_Vector                  /* 1 "LIST->VECTOR"                                 Primitive  0x7c in vector.c */,
  Prim_Subvector_To_List               /* 3 "SUBVECTOR->LIST"                              Primitive  0x7d in vector.c */,
  Prim_Pair                            /* 1 "PAIR?"                                        Primitive  0x7e in list.c */,
  Prim_Negative_Fixnum                 /* 1 "NEGATIVE-FIXNUM?"                             Primitive  0x7f in fixnum.c */,
  Prim_Negative_Bignum                 /* 1 "NEGATIVE-BIGNUM?"                             Primitive  0x80 in bignum.c */,
  Prim_Greater_Fixnum                  /* 2 "GREATER-THAN-FIXNUM?"                         Primitive  0x81 in fixnum.c */,
  Prim_Greater_Bignum                  /* 2 "GREATER-THAN-BIGNUM?"                         Primitive  0x82 in bignum.c */,
  Prim_String_Hash                     /* 1 "STRING-HASH"                                  Primitive  0x83 in intern.c */,
  Prim_Sys_Pair_Cons                   /* 3 "SYSTEM-PAIR-CONS"                             Primitive  0x84 in list.c */,
  Prim_Sys_Pair                        /* 1 "SYSTEM-PAIR?"                                 Primitive  0x85 in list.c */,
  Prim_Sys_Pair_Car                    /* 1 "SYSTEM-PAIR-CAR"                              Primitive  0x86 in list.c */,
  Prim_Sys_Pair_Cdr                    /* 1 "SYSTEM-PAIR-CDR"                              Primitive  0x87 in list.c */,
  Prim_Sys_Set_Car                     /* 2 "SYSTEM-PAIR-SET-CAR!"                         Primitive  0x88 in list.c */,
  Prim_Sys_Set_Cdr                     /* 2 "SYSTEM-PAIR-SET-CDR!"                         Primitive  0x89 in list.c */,
  Prim_string_hash_mod                 /* 2 "STRING-HASH-MOD"                              Primitive  0x8a in intern.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive  0x8b in Findprim.c */,
  Prim_Set_Cell_Contents               /* 2 "SET-CELL-CONTENTS!"                           Primitive  0x8c in prim.c */,
  Prim_And_Make_Object                 /* 2 "&MAKE-OBJECT"                                 Primitive  0x8d in prim.c */,
  Prim_Sys_H3_0                        /* 1 "SYSTEM-HUNK3-CXR0"                            Primitive  0x8e in hunk.c */,
  Prim_SH3_Set_0                       /* 2 "SYSTEM-HUNK3-SET-CXR0!"                       Primitive  0x8f in hunk.c */,
  Prim_Map_Address_To_Code             /* 2 "MAP-MACHINE-ADDRESS-TO-CODE"                  Primitive  0x90 in random.c */,
  Prim_Sys_H3_1                        /* 1 "SYSTEM-HUNK3-CXR1"                            Primitive  0x91 in hunk.c */,
  Prim_SH3_Set_1                       /* 2 "SYSTEM-HUNK3-SET-CXR1!"                       Primitive  0x92 in hunk.c */,
  Prim_Map_Code_To_Address             /* 2 "MAP-CODE-TO-MACHINE-ADDRESS"                  Primitive  0x93 in random.c */,
  Prim_Sys_H3_2                        /* 1 "SYSTEM-HUNK3-CXR2"                            Primitive  0x94 in hunk.c */,
  Prim_SH3_Set_2                       /* 2 "SYSTEM-HUNK3-SET-CXR2!"                       Primitive  0x95 in hunk.c */,
  Prim_Map_Prim_Address_To_Arity       /* 1 "PRIMITIVE-PROCEDURE-ARITY"                    Primitive  0x96 in random.c */,
  Prim_Sys_List_To_Vector              /* 2 "SYSTEM-LIST-TO-VECTOR"                        Primitive  0x97 in vector.c */,
  Prim_Sys_Subvector_To_List           /* 3 "SYSTEM-SUBVECTOR-TO-LIST"                     Primitive  0x98 in vector.c */,
  Prim_Sys_Vector                      /* 1 "SYSTEM-VECTOR?"                               Primitive  0x99 in vector.c */,
  Prim_Sys_Vector_Ref                  /* 2 "SYSTEM-VECTOR-REF"                            Primitive  0x9a in vector.c */,
  Prim_Sys_Vec_Set                     /* 3 "SYSTEM-VECTOR-SET!"                           Primitive  0x9b in vector.c */,
  Prim_With_History_Disabled           /* 1 "WITH-HISTORY-DISABLED"                        Primitive  0x9c in hooks.c */,
  Prim_subvector_move_right            /* 5 "SUBVECTOR-MOVE-RIGHT!"                        Primitive  0x9d in vector.c */,
  Prim_subvector_move_left             /* 5 "SUBVECTOR-MOVE-LEFT!"                         Primitive  0x9e in vector.c */,
  Prim_vector_fill                     /* 4 "SUBVECTOR-FILL!"                              Primitive  0x9f in vector.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive  0xa0 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive  0xa1 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive  0xa2 in Findprim.c */,
  Prim_Vector_8b_Cons                  /* 1 "VECTOR-8B-CONS"                               Primitive  0xa3 in string.c */,
  Prim_Vector_8b                       /* 1 "VECTOR-8B?"                                   Primitive  0xa4 in string.c */,
  Prim_Vec_8b_Ref                      /* 2 "VECTOR-8B-REF"                                Primitive  0xa5 in stringprim.c */,
  Prim_Vec_8b_Set                      /* 3 "VECTOR-8B-SET!"                               Primitive  0xa6 in stringprim.c */,
  Prim_Zero_Flonum                     /* 1 "ZERO-FLONUM?"                                 Primitive  0xa7 in flonum.c */,
  Prim_Positive_Flonum                 /* 1 "POSITIVE-FLONUM?"                             Primitive  0xa8 in flonum.c */,
  Prim_Negative_Flonum                 /* 1 "NEGATIVE-FLONUM?"                             Primitive  0xa9 in flonum.c */,
  Prim_Greater_Flonum                  /* 2 "GREATER-THAN-FLONUM?"                         Primitive  0xaa in flonum.c */,
  Prim_Intern_Character_List           /* 1 "INTERN-CHARACTER-LIST"                        Primitive  0xab in intern.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive  0xac in Findprim.c */,
  Prim_Vec_8b_Size                     /* 1 "VECTOR-8B-SIZE"                               Primitive  0xad in string.c */,
  Prim_Sys_Vec_Size                    /* 1 "SYSTEM-VECTOR-SIZE"                           Primitive  0xae in vector.c */,
  Prim_Force                           /* 1 "FORCE"                                        Primitive  0xaf in hooks.c */,
  Prim_Primitive_Datum                 /* 1 "PRIMITIVE-DATUM"                              Primitive  0xb0 in prim.c */,
  Prim_Make_Non_Pointer                /* 1 "MAKE-NON-POINTER-OBJECT"                      Primitive  0xb1 in prim.c */,
  Prim_Temp_Printer                    /* 1 "DEBUGGING-PRINTER"                            Primitive  0xb2 in debug.c */,
  Prim_Raise_String                    /* 1 "STRING-UPCASE"                                Primitive  0xb3 in string.c */,
  Prim_Primitive_Purify                /* 2 "PRIMITIVE-PURIFY"                             Primitive  0xb4 in purify.c */,
  Prim_compiled_code_address_block     /* 1 "COMPILED-CODE-ADDRESS->BLOCK"                 Primitive  0xb5 in comutl.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive  0xb6 in Findprim.c */,
  Prim_Band_Dump                       /* 2 "DUMP-BAND"                                    Primitive  0xb7 in fasdump.c */,
  Prim_Substring_Search                /* 2 "SUBSTRING-SEARCH"                             Primitive  0xb8 in string.c */,
  Prim_Band_Load                       /* 1 "LOAD-BAND"                                    Primitive  0xb9 in fasload.c */,
  Prim_Constant_P                      /* 1 "CONSTANT?"                                    Primitive  0xba in purutl.c */,
  Prim_Pure_P                          /* 1 "PURE?"                                        Primitive  0xbb in purutl.c */,
  Prim_Gc_Type                         /* 1 "PRIMITIVE-GC-TYPE"                            Primitive  0xbc in prim.c */,
  Prim_Impurify                        /* 1 "PRIMITIVE-IMPURIFY"                           Primitive  0xbd in purutl.c */,
  Prim_With_Threaded_Stack             /* 2 "WITH-THREADED-CONTINUATION"                   Primitive  0xbe in hooks.c */,
  Prim_Within_Control_Point            /* 2 "WITHIN-CONTROL-POINT"                         Primitive  0xbf in hooks.c */,
  Prim_Set_Run_Light                   /* 1 "SET-RUN-LIGHT!"                               Primitive  0xc0 in sysprim.c */,
  Prim_File_Eof_P                      /* 1 "FILE-EOF?"                                    Primitive  0xc1 in fileio.c */,
  Prim_File_Read_Char                  /* 1 "FILE-READ-CHAR"                               Primitive  0xc2 in fileio.c */,
  Prim_File_Fill_Input_Buffer          /* 2 "FILE-FILL-INPUT-BUFFER"                       Primitive  0xc3 in fileio.c */,
  Prim_File_Length                     /* 1 "FILE-LENGTH"                                  Primitive  0xc4 in fileio.c */,
  Prim_File_Write_Char                 /* 2 "FILE-WRITE-CHAR"                              Primitive  0xc5 in fileio.c */,
  Prim_File_Write_String               /* 2 "FILE-WRITE-STRING"                            Primitive  0xc6 in fileio.c */,
  Prim_Close_Lost_Open_Files           /* 1 "CLOSE-LOST-OPEN-FILES"                        Primitive  0xc7 in daemon.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive  0xc8 in Findprim.c */,
  Prim_With_Interrupts_Reduced         /* 2 "WITH-INTERRUPTS-REDUCED"                      Primitive  0xc9 in hooks.c */,
  Prim_Eval_Step                       /* 3 "PRIMITIVE-EVAL-STEP"                          Primitive  0xca in step.c */,
  Prim_Apply_Step                      /* 3 "PRIMITIVE-APPLY-STEP"                         Primitive  0xcb in step.c */,
  Prim_Return_Step                     /* 2 "PRIMITIVE-RETURN-STEP"                        Primitive  0xcc in step.c */,
  Prim_Tty_Read_Char_Ready_P           /* 1 "TTY-READ-CHAR-READY?"                         Primitive  0xcd in ttyio.c */,
  Prim_Tty_Read_Char                   /* 0 "TTY-READ-CHAR"                                Primitive  0xce in ttyio.c */,
  Prim_Tty_Read_Char_Immediate         /* 0 "TTY-READ-CHAR-IMMEDIATE"                      Primitive  0xcf in ttyio.c */,
  Prim_Tty_Read_Finish                 /* 0 "TTY-READ-FINISH"                              Primitive  0xd0 in ttyio.c */,
  Prim_bit_string_allocate             /* 1 "BIT-STRING-ALLOCATE"                          Primitive  0xd1 in bitstr.c */,
  Prim_make_bit_string                 /* 2 "MAKE-BIT-STRING"                              Primitive  0xd2 in bitstr.c */,
  Prim_bit_string_p                    /* 1 "BIT-STRING?"                                  Primitive  0xd3 in bitstr.c */,
  Prim_bit_string_length               /* 1 "BIT-STRING-LENGTH"                            Primitive  0xd4 in bitstr.c */,
  Prim_bit_string_ref                  /* 2 "BIT-STRING-REF"                               Primitive  0xd5 in bitstr.c */,
  Prim_bit_substring_move_right_x      /* 5 "BIT-SUBSTRING-MOVE-RIGHT!"                    Primitive  0xd6 in bitstr.c */,
  Prim_bit_string_set_x                /* 2 "BIT-STRING-SET!"                              Primitive  0xd7 in bitstr.c */,
  Prim_bit_string_clear_x              /* 2 "BIT-STRING-CLEAR!"                            Primitive  0xd8 in bitstr.c */,
  Prim_bit_string_zero_p               /* 1 "BIT-STRING-ZERO?"                             Primitive  0xd9 in bitstr.c */,
  Prim_bit_substring_find_next_set_bit /* 3 "BIT-SUBSTRING-FIND-NEXT-SET-BIT"              Primitive  0xda in bitstr.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive  0xdb in Findprim.c */,
  Prim_unsigned_to_bit_string          /* 2 "UNSIGNED-INTEGER->BIT-STRING"                 Primitive  0xdc in bitstr.c */,
  Prim_bit_string_to_unsigned          /* 1 "BIT-STRING->UNSIGNED-INTEGER"                 Primitive  0xdd in bitstr.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive  0xde in Findprim.c */,
  Prim_read_bits_x                     /* 3 "READ-BITS!"                                   Primitive  0xdf in bitstr.c */,
  Prim_write_bits_x                    /* 3 "WRITE-BITS!"                                  Primitive  0xe0 in bitstr.c */,
  Prim_Make_State_Space                /* 1 "MAKE-STATE-SPACE"                             Primitive  0xe1 in hooks.c */,
  Prim_Execute_At_New_Point            /* 4 "EXECUTE-AT-NEW-POINT"                         Primitive  0xe2 in hooks.c */,
  Prim_Translate_To_Point              /* 1 "TRANSLATE-TO-STATE-POINT"                     Primitive  0xe3 in hooks.c */,
  Prim_Get_Next_Constant               /* 0 "GET-NEXT-CONSTANT"                            Primitive  0xe4 in purutl.c */,
  Prim_Microcode_Identify              /* 0 "MICROCODE-IDENTIFY"                           Primitive  0xe5 in boot.c */,
  Prim_Zero                            /* 1 "ZERO?"                                        Primitive  0xe6 in generic.c */,
  Prim_Positive                        /* 1 "POSITIVE?"                                    Primitive  0xe7 in generic.c */,
  Prim_Negative                        /* 1 "NEGATIVE?"                                    Primitive  0xe8 in generic.c */,
  Prim_Equal_Number                    /* 2 "&="                                           Primitive  0xe9 in generic.c */,
  Prim_Less                            /* 2 "&<"                                           Primitive  0xea in generic.c */,
  Prim_Greater                         /* 2 "&>"                                           Primitive  0xeb in generic.c */,
  Prim_Plus                            /* 2 "&+"                                           Primitive  0xec in generic.c */,
  Prim_Minus                           /* 2 "&-"                                           Primitive  0xed in generic.c */,
  Prim_Multiply                        /* 2 "&*"                                           Primitive  0xee in generic.c */,
  Prim_Divide                          /* 2 "&/"                                           Primitive  0xef in generic.c */,
  Prim_Integer_Divide                  /* 2 "INTEGER-DIVIDE"                               Primitive  0xf0 in generic.c */,
  Prim_One_Plus                        /* 1 "1+"                                           Primitive  0xf1 in generic.c */,
  Prim_M_1_Plus                        /* 1 "-1+"                                          Primitive  0xf2 in generic.c */,
  Prim_Truncate                        /* 1 "TRUNCATE"                                     Primitive  0xf3 in generic.c */,
  Prim_Round                           /* 1 "ROUND"                                        Primitive  0xf4 in generic.c */,
  Prim_Floor                           /* 1 "FLOOR"                                        Primitive  0xf5 in generic.c */,
  Prim_Ceiling                         /* 1 "CEILING"                                      Primitive  0xf6 in generic.c */,
  Prim_Sqrt                            /* 1 "SQRT"                                         Primitive  0xf7 in generic.c */,
  Prim_Exp                             /* 1 "EXP"                                          Primitive  0xf8 in generic.c */,
  Prim_Ln                              /* 1 "LOG"                                          Primitive  0xf9 in generic.c */,
  Prim_Sine                            /* 1 "SIN"                                          Primitive  0xfa in generic.c */,
  Prim_Cosine                          /* 1 "COS"                                          Primitive  0xfb in generic.c */,
  Prim_Arctan                          /* 1 "&ATAN"                                        Primitive  0xfc in generic.c */,
  Prim_Tty_Write_Char                  /* 1 "TTY-WRITE-CHAR"                               Primitive  0xfd in ttyio.c */,
  Prim_Tty_Write_String                /* 1 "TTY-WRITE-STRING"                             Primitive  0xfe in ttyio.c */,
  Prim_Tty_Beep                        /* 0 "TTY-BEEP"                                     Primitive  0xff in ttyio.c */,
  Prim_Tty_Clear                       /* 0 "TTY-CLEAR"                                    Primitive 0x100 in ttyio.c */,
  Prim_Get_External_Count              /* 0 "GET-EXTERNAL-COUNTS"                          Primitive 0x101 in extern.c */,
  Prim_Get_Ext_Name                    /* 1 "GET-EXTERNAL-NAME"                            Primitive 0x102 in extern.c */,
  Prim_Get_Ext_Number                  /* 2 "GET-EXTERNAL-NUMBER"                          Primitive 0x103 in extern.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x104 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x105 in Findprim.c */,
  Prim_Get_Next_Interrupt_Char         /* 0 "GET-NEXT-INTERRUPT-CHARACTER"                 Primitive 0x106 in sysprim.c */,
  Prim_Chk_And_Cln_Input_Channel       /* 2 "CHECK-AND-CLEAN-UP-INPUT-CHANNEL"             Primitive 0x107 in sysprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x108 in Findprim.c */,
  Prim_System_Clock                    /* 0 "SYSTEM-CLOCK"                                 Primitive 0x109 in sysprim.c */,
  Prim_File_Exists                     /* 1 "FILE-EXISTS?"                                 Primitive 0x10a in fileio.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x10b in Findprim.c */,
  Prim_Tty_Move_Cursor                 /* 2 "TTY-MOVE-CURSOR"                              Primitive 0x10c in ttyio.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x10d in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x10e in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x10f in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x110 in Findprim.c */,
  Prim_Copy_File                       /* 2 "COPY-FILE"                                    Primitive 0x111 in fileio.c */,
  Prim_Rename_File                     /* 2 "RENAME-FILE"                                  Primitive 0x112 in fileio.c */,
  Prim_Remove_File                     /* 1 "REMOVE-FILE"                                  Primitive 0x113 in fileio.c */,
  Prim_Link_File                       /* 3 "LINK-FILE"                                    Primitive 0x114 in fileio.c */,
  Prim_Make_Directory                  /* 1 "MAKE-DIRECTORY"                               Primitive 0x115 in fileio.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x116 in Findprim.c */,
  Prim_set_working_dir_pathname        /* 1 "SET-WORKING-DIRECTORY-PATHNAME!"              Primitive 0x117 in fileio.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x118 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x119 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x11a in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x11b in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x11c in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x11d in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x11e in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x11f in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x120 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x121 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x122 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x123 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x124 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x125 in Findprim.c */,
  Prim_Current_Year                    /* 0 "CURRENT-YEAR"                                 Primitive 0x126 in sysprim.c */,
  Prim_Current_Month                   /* 0 "CURRENT-MONTH"                                Primitive 0x127 in sysprim.c */,
  Prim_Current_Day                     /* 0 "CURRENT-DAY"                                  Primitive 0x128 in sysprim.c */,
  Prim_Current_Hour                    /* 0 "CURRENT-HOUR"                                 Primitive 0x129 in sysprim.c */,
  Prim_Current_Minute                  /* 0 "CURRENT-MINUTE"                               Primitive 0x12a in sysprim.c */,
  Prim_Current_Second                  /* 0 "CURRENT-SECOND"                               Primitive 0x12b in sysprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x12c in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x12d in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x12e in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x12f in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x130 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x131 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x132 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x133 in Findprim.c */,
  Prim_Clear_To_End_Of_Line            /* 0 "CLEAR-TO-END-OF-LINE"                         Primitive 0x134 in ttyio.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x135 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x136 in Findprim.c */,
  Prim_With_Interrupt_Mask             /* 2 "WITH-INTERRUPT-MASK"                          Primitive 0x137 in hooks.c */,
  Prim_String_P                        /* 1 "STRING?"                                      Primitive 0x138 in stringprim.c */,
  Prim_String_Length                   /* 1 "STRING-LENGTH"                                Primitive 0x139 in stringprim.c */,
  Prim_String_Ref                      /* 2 "STRING-REF"                                   Primitive 0x13a in stringprim.c */,
  Prim_String_Set                      /* 3 "STRING-SET!"                                  Primitive 0x13b in stringprim.c */,
  Prim_Substring_Move_Right            /* 5 "SUBSTRING-MOVE-RIGHT!"                        Primitive 0x13c in stringprim.c */,
  Prim_Substring_Move_Left             /* 5 "SUBSTRING-MOVE-LEFT!"                         Primitive 0x13d in stringprim.c */,
  Prim_String_Allocate                 /* 1 "STRING-ALLOCATE"                              Primitive 0x13e in stringprim.c */,
  Prim_String_Maximum_Length           /* 1 "STRING-MAXIMUM-LENGTH"                        Primitive 0x13f in stringprim.c */,
  Prim_Set_String_Length               /* 2 "SET-STRING-LENGTH!"                           Primitive 0x140 in stringprim.c */,
  Prim_Vec_8b_Fill                     /* 4 "VECTOR-8B-FILL!"                              Primitive 0x141 in stringprim.c */,
  Prim_Vec_8b_Find_Next_Char           /* 4 "VECTOR-8B-FIND-NEXT-CHAR"                     Primitive 0x142 in stringprim.c */,
  Prim_Vec_8b_Find_Prev_Char           /* 4 "VECTOR-8B-FIND-PREVIOUS-CHAR"                 Primitive 0x143 in stringprim.c */,
  Prim_Vec_8b_Find_Next_Char_Ci        /* 4 "VECTOR-8B-FIND-NEXT-CHAR-CI"                  Primitive 0x144 in stringprim.c */,
  Prim_Vec_8b_Find_Prev_Char_Ci        /* 4 "VECTOR-8B-FIND-PREVIOUS-CHAR-CI"              Primitive 0x145 in stringprim.c */,
  Prim_Find_Next_Char_In_Set           /* 4 "SUBSTRING-FIND-NEXT-CHAR-IN-SET"              Primitive 0x146 in stringprim.c */,
  Prim_Find_Prev_Char_In_Set           /* 4 "SUBSTRING-FIND-PREVIOUS-CHAR-IN-SET"          Primitive 0x147 in stringprim.c */,
  Prim_Substring_Equal                 /* 6 "SUBSTRING=?"                                  Primitive 0x148 in stringprim.c */,
  Prim_Substring_Ci_Equal              /* 6 "SUBSTRING-CI=?"                               Primitive 0x149 in stringprim.c */,
  Prim_Substring_Less                  /* 6 "SUBSTRING<?"                                  Primitive 0x14a in stringprim.c */,
  Prim_Substring_Upcase                /* 3 "SUBSTRING-UPCASE!"                            Primitive 0x14b in stringprim.c */,
  Prim_Substring_Downcase              /* 3 "SUBSTRING-DOWNCASE!"                          Primitive 0x14c in stringprim.c */,
  Prim_Match_Forward                   /* 6 "SUBSTRING-MATCH-FORWARD"                      Primitive 0x14d in stringprim.c */,
  Prim_Match_Backward                  /* 6 "SUBSTRING-MATCH-BACKWARD"                     Primitive 0x14e in stringprim.c */,
  Prim_Match_Forward_Ci                /* 6 "SUBSTRING-MATCH-FORWARD-CI"                   Primitive 0x14f in stringprim.c */,
  Prim_Match_Backward_Ci               /* 6 "SUBSTRING-MATCH-BACKWARD-CI"                  Primitive 0x150 in stringprim.c */,
  Prim_Photo_Open                      /* 1 "PHOTO-OPEN"                                   Primitive 0x151 in ttyio.c */,
  Prim_Photo_Close                     /* 0 "PHOTO-CLOSE"                                  Primitive 0x152 in ttyio.c */,
  Prim_Setup_Timer_Interrupt           /* 2 "SETUP-TIMER-INTERRUPT"                        Primitive 0x153 in sysprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x154 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x155 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x156 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x157 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x158 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x159 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x15a in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x15b in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x15c in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x15d in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x15e in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x15f in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x160 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x161 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x162 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x163 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x164 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x165 in Findprim.c */,
  Prim_Screen_X_Size                   /* 0 "SCREEN-X-SIZE"                                Primitive 0x166 in ttyio.c */,
  Prim_Screen_Y_Size                   /* 0 "SCREEN-Y-SIZE"                                Primitive 0x167 in ttyio.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x168 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x169 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x16a in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x16b in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x16c in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x16d in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x16e in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x16f in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x170 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x171 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x172 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x173 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x174 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x175 in Findprim.c */,
  Prim_String_To_Syntax_Entry          /* 1 "STRING->SYNTAX-ENTRY"                         Primitive 0x176 in syntax.c */,
  Prim_Scan_Word_Forward               /* 4 "SCAN-WORD-FORWARD"                            Primitive 0x177 in syntax.c */,
  Prim_Scan_Word_Backward              /* 4 "SCAN-WORD-BACKWARD"                           Primitive 0x178 in syntax.c */,
  Prim_Scan_List_Forward               /* 7 "SCAN-LIST-FORWARD"                            Primitive 0x179 in syntax.c */,
  Prim_Scan_List_Backward              /* 7 "SCAN-LIST-BACKWARD"                           Primitive 0x17a in syntax.c */,
  Prim_Scan_Sexps_Forward              /* 7 "SCAN-SEXPS-FORWARD"                           Primitive 0x17b in syntax.c */,
  Prim_Scan_Forward_To_Word            /* 4 "SCAN-FORWARD-TO-WORD"                         Primitive 0x17c in syntax.c */,
  Prim_Scan_Backward_Prefix_Chars      /* 4 "SCAN-BACKWARD-PREFIX-CHARS"                   Primitive 0x17d in syntax.c */,
  Prim_Char_To_Syntax_Code             /* 2 "CHAR->SYNTAX-CODE"                            Primitive 0x17e in syntax.c */,
  Prim_Quoted_Char_P                   /* 4 "QUOTED-CHAR?"                                 Primitive 0x17f in syntax.c */,
  Prim_Microcode_Tables_Filename       /* 0 "MICROCODE-TABLES-FILENAME"                    Primitive 0x180 in boot.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x181 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x182 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x183 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x184 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x185 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x186 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x187 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x188 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x189 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x18a in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x18b in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x18c in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x18d in Findprim.c */,
  Prim_Error_Procedure                 /* 3 "ERROR-PROCEDURE"                              Primitive 0x18e in hooks.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x18f in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x190 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x191 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x192 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x193 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x194 in Findprim.c */,
  Prim_System_Memory_Ref               /* 2 "SYSTEM-MEMORY-REF"                            Primitive 0x195 in prim.c */,
  Prim_System_Memory_Set               /* 3 "SYSTEM-MEMORY-SET!"                           Primitive 0x196 in prim.c */,
  Prim_bit_string_fill_x               /* 2 "BIT-STRING-FILL!"                             Primitive 0x197 in bitstr.c */,
  Prim_bit_string_move_x               /* 2 "BIT-STRING-MOVE!"                             Primitive 0x198 in bitstr.c */,
  Prim_bit_string_movec_x              /* 2 "BIT-STRING-MOVEC!"                            Primitive 0x199 in bitstr.c */,
  Prim_bit_string_or_x                 /* 2 "BIT-STRING-OR!"                               Primitive 0x19a in bitstr.c */,
  Prim_bit_string_and_x                /* 2 "BIT-STRING-AND!"                              Primitive 0x19b in bitstr.c */,
  Prim_bit_string_andc_x               /* 2 "BIT-STRING-ANDC!"                             Primitive 0x19c in bitstr.c */,
  Prim_bit_string_equal_p              /* 2 "BIT-STRING=?"                                 Primitive 0x19d in bitstr.c */,
  Prim_working_dir_pathname            /* 0 "WORKING-DIRECTORY-PATHNAME"                   Primitive 0x19e in fileio.c */,
  Prim_open_directory                  /* 1 "OPEN-DIRECTORY"                               Primitive 0x19f in fileio.c */,
  Prim_directory_read                  /* 0 "DIRECTORY-READ"                               Primitive 0x1a0 in fileio.c */,
  Prim_under_emacs_p                   /* 0 "UNDER-EMACS?"                                 Primitive 0x1a1 in sysprim.c */,
  Prim_tty_flush_output                /* 0 "TTY-FLUSH-OUTPUT"                             Primitive 0x1a2 in ttyio.c */,
  Prim_reload_band_name                /* 0 "RELOAD-BAND-NAME"                             Primitive 0x1a3 in fasload.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x1a4 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x1a5 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x1a6 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x1a7 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x1a8 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x1a9 in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x1aa in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x1ab in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x1ac in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x1ad in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x1ae in Findprim.c */,
  Prim_Inexistent                      /* 0 No_Name                                        Primitive 0x1af in Findprim.c */
};

int Primitive_Arity_Table[] = {
  3,
  2,
  3,
  1,
  2,
  2,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  2,
  2,
  2,
  1,
  2,
  2,
  2,
  2,
  1,
  0,
  1,
  2,
  3,
  0,
  1,
  2,
  3,
  1,
  1,
  2,
  1,
  1,
  2,
  2,
  1,
  0,
  2,
  3,
  2,
  3,
  3,
  2,
  1,
  2,
  1,
  3,
  1,
  0,
  2,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  2,
  2,
  2,
  2,
  2,
  2,
  1,
  1,
  1,
  2,
  3,
  1,
  1,
  1,
  1,
  3,
  2,
  2,
  2,
  2,
  2,
  2,
  2,
  2,
  1,
  2,
  1,
  3,
  1,
  3,
  2,
  0,
  0,
  2,
  1,
  2,
  1,
  2,
  1,
  1,
  1,
  1,
  1,
  2,
  1,
  1,
  2,
  2,
  2,
  2,
  2,
  2,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  0,
  0,
  1,
  1,
  3,
  1,
  1,
  1,
  2,
  2,
  1,
  3,
  1,
  1,
  1,
  2,
  2,
  2,
  0,
  2,
  2,
  1,
  2,
  2,
  1,
  2,
  2,
  1,
  2,
  1,
  2,
  3,
  1,
  2,
  3,
  1,
  5,
  5,
  4,
  0,
  0,
  0,
  1,
  1,
  2,
  3,
  1,
  1,
  1,
  2,
  1,
  0,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  2,
  1,
  0,
  2,
  2,
  1,
  1,
  1,
  1,
  1,
  2,
  2,
  1,
  1,
  1,
  2,
  1,
  2,
  2,
  1,
  0,
  2,
  3,
  3,
  2,
  1,
  0,
  0,
  0,
  1,
  2,
  1,
  1,
  2,
  5,
  2,
  2,
  1,
  3,
  0,
  2,
  1,
  0,
  3,
  3,
  1,
  4,
  1,
  0,
  0,
  1,
  1,
  1,
  2,
  2,
  2,
  2,
  2,
  2,
  2,
  2,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  0,
  0,
  0,
  1,
  2,
  0,
  0,
  0,
  2,
  0,
  0,
  1,
  0,
  2,
  0,
  0,
  0,
  0,
  2,
  2,
  1,
  3,
  1,
  0,
  1,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  2,
  1,
  1,
  2,
  3,
  5,
  5,
  1,
  1,
  2,
  4,
  4,
  4,
  4,
  4,
  4,
  4,
  6,
  6,
  6,
  3,
  3,
  6,
  6,
  6,
  6,
  1,
  0,
  2,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  1,
  4,
  4,
  7,
  7,
  7,
  4,
  4,
  2,
  4,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  3,
  0,
  0,
  0,
  0,
  0,
  0,
  2,
  3,
  2,
  2,
  2,
  2,
  2,
  2,
  2,
  0,
  1,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0
};

char *Primitive_Name_Table[] = {
  "LEXICAL-ASSIGNMENT",
  "LOCAL-REFERENCE",
  "LOCAL-ASSIGNMENT",
  "CALL-WITH-CURRENT-CONTINUATION",
  "SCODE-EVAL",
  "APPLY",
  "SET-INTERRUPT-ENABLES!",
  "STRING->SYMBOL",
  "GET-WORK",
  "NON-REENTRANT-CALL-WITH-CURRENT-CONTINUATION",
  "CURRENT-DYNAMIC-STATE",
  "SET-CURRENT-DYNAMIC-STATE!",
  "NULL?",
  "EQ?",
  "STRING-EQUAL?",
  "PRIMITIVE-TYPE?",
  "PRIMITIVE-TYPE",
  "PRIMITIVE-SET-TYPE",
  "LEXICAL-REFERENCE",
  "LEXICAL-UNREFERENCEABLE?",
  "MAKE-CHAR",
  "CHAR-BITS",
  "EXIT",
  "CHAR-CODE",
  "LEXICAL-UNASSIGNED?",
  "INSERT-NON-MARKED-VECTOR!",
  "HALT",
  "CHAR->INTEGER",
  "MEMQ",
  "INSERT-STRING",
  "ENABLE-INTERRUPTS!",
  "MAKE-EMPTY-STRING",
  "CONS",
  "CAR",
  "CDR",
  "SET-CAR!",
  "SET-CDR!",
  "TOUCH",
  "TTY-GET-CURSOR",
  "GENERAL-CAR-CDR",
  "HUNK3-CONS",
  "HUNK3-CXR",
  "HUNK3-SET-CXR!",
  "INSERT-STRING!",
  "VECTOR-CONS",
  "VECTOR-LENGTH",
  "VECTOR-REF",
  "SET-CURRENT-HISTORY!",
  "VECTOR-SET!",
  "NON-MARKED-VECTOR-CONS",
  No_Name,
  "LEXICAL-UNBOUND?",
  "INTEGER->CHAR",
  "CHAR-DOWNCASE",
  "CHAR-UPCASE",
  "ASCII->CHAR",
  "CHAR-ASCII?",
  "CHAR->ASCII",
  "GARBAGE-COLLECT",
  "PLUS-FIXNUM",
  "MINUS-FIXNUM",
  "MULTIPLY-FIXNUM",
  "DIVIDE-FIXNUM",
  "EQUAL-FIXNUM?",
  "LESS-THAN-FIXNUM?",
  "POSITIVE-FIXNUM?",
  "ONE-PLUS-FIXNUM",
  "MINUS-ONE-PLUS-FIXNUM",
  "TRUNCATE-STRING!",
  "SUBSTRING",
  "ZERO-FIXNUM?",
  "MAKE-OBJECT-SAFE",
  "MAKE-OBJECT-DANGEROUS",
  "OBJECT-DANGEROUS?",
  "SUBSTRING->LIST",
  "MAKE-FILLED-STRING",
  "PLUS-BIGNUM",
  "MINUS-BIGNUM",
  "MULTIPLY-BIGNUM",
  "DIVIDE-BIGNUM",
  "LISTIFY-BIGNUM",
  "EQUAL-BIGNUM?",
  "LESS-THAN-BIGNUM?",
  "POSITIVE-BIGNUM?",
  "FILE-OPEN-CHANNEL",
  "FILE-CLOSE-CHANNEL",
  "PRIMITIVE-FASDUMP",
  "BINARY-FASLOAD",
  "STRING-POSITION",
  "STRING-LESS?",
  No_Name,
  No_Name,
  "REHASH",
  "LENGTH",
  "ASSQ",
  "LIST->STRING",
  "EQUAL-STRING-TO-LIST?",
  "MAKE-CELL",
  "CELL-CONTENTS",
  "CELL?",
  "CHARACTER-UPCASE",
  "CHARACTER-LIST-HASH",
  "GCD-FIXNUM",
  "COERCE-FIXNUM-TO-BIGNUM",
  "COERCE-BIGNUM-TO-FIXNUM",
  "PLUS-FLONUM",
  "MINUS-FLONUM",
  "MULTIPLY-FLONUM",
  "DIVIDE-FLONUM",
  "EQUAL-FLONUM?",
  "LESS-THAN-FLONUM?",
  "ZERO-BIGNUM?",
  "TRUNCATE-FLONUM",
  "ROUND-FLONUM",
  "COERCE-INTEGER-TO-FLONUM",
  "SINE-FLONUM",
  "COSINE-FLONUM",
  "ARCTAN-FLONUM",
  "EXP-FLONUM",
  "LN-FLONUM",
  "SQRT-FLONUM",
  No_Name,
  "GET-FIXED-OBJECTS-VECTOR",
  "SET-FIXED-OBJECTS-VECTOR!",
  "LIST->VECTOR",
  "SUBVECTOR->LIST",
  "PAIR?",
  "NEGATIVE-FIXNUM?",
  "NEGATIVE-BIGNUM?",
  "GREATER-THAN-FIXNUM?",
  "GREATER-THAN-BIGNUM?",
  "STRING-HASH",
  "SYSTEM-PAIR-CONS",
  "SYSTEM-PAIR?",
  "SYSTEM-PAIR-CAR",
  "SYSTEM-PAIR-CDR",
  "SYSTEM-PAIR-SET-CAR!",
  "SYSTEM-PAIR-SET-CDR!",
  "STRING-HASH-MOD",
  No_Name,
  "SET-CELL-CONTENTS!",
  "&MAKE-OBJECT",
  "SYSTEM-HUNK3-CXR0",
  "SYSTEM-HUNK3-SET-CXR0!",
  "MAP-MACHINE-ADDRESS-TO-CODE",
  "SYSTEM-HUNK3-CXR1",
  "SYSTEM-HUNK3-SET-CXR1!",
  "MAP-CODE-TO-MACHINE-ADDRESS",
  "SYSTEM-HUNK3-CXR2",
  "SYSTEM-HUNK3-SET-CXR2!",
  "PRIMITIVE-PROCEDURE-ARITY",
  "SYSTEM-LIST-TO-VECTOR",
  "SYSTEM-SUBVECTOR-TO-LIST",
  "SYSTEM-VECTOR?",
  "SYSTEM-VECTOR-REF",
  "SYSTEM-VECTOR-SET!",
  "WITH-HISTORY-DISABLED",
  "SUBVECTOR-MOVE-RIGHT!",
  "SUBVECTOR-MOVE-LEFT!",
  "SUBVECTOR-FILL!",
  No_Name,
  No_Name,
  No_Name,
  "VECTOR-8B-CONS",
  "VECTOR-8B?",
  "VECTOR-8B-REF",
  "VECTOR-8B-SET!",
  "ZERO-FLONUM?",
  "POSITIVE-FLONUM?",
  "NEGATIVE-FLONUM?",
  "GREATER-THAN-FLONUM?",
  "INTERN-CHARACTER-LIST",
  No_Name,
  "VECTOR-8B-SIZE",
  "SYSTEM-VECTOR-SIZE",
  "FORCE",
  "PRIMITIVE-DATUM",
  "MAKE-NON-POINTER-OBJECT",
  "DEBUGGING-PRINTER",
  "STRING-UPCASE",
  "PRIMITIVE-PURIFY",
  "COMPILED-CODE-ADDRESS->BLOCK",
  No_Name,
  "DUMP-BAND",
  "SUBSTRING-SEARCH",
  "LOAD-BAND",
  "CONSTANT?",
  "PURE?",
  "PRIMITIVE-GC-TYPE",
  "PRIMITIVE-IMPURIFY",
  "WITH-THREADED-CONTINUATION",
  "WITHIN-CONTROL-POINT",
  "SET-RUN-LIGHT!",
  "FILE-EOF?",
  "FILE-READ-CHAR",
  "FILE-FILL-INPUT-BUFFER",
  "FILE-LENGTH",
  "FILE-WRITE-CHAR",
  "FILE-WRITE-STRING",
  "CLOSE-LOST-OPEN-FILES",
  No_Name,
  "WITH-INTERRUPTS-REDUCED",
  "PRIMITIVE-EVAL-STEP",
  "PRIMITIVE-APPLY-STEP",
  "PRIMITIVE-RETURN-STEP",
  "TTY-READ-CHAR-READY?",
  "TTY-READ-CHAR",
  "TTY-READ-CHAR-IMMEDIATE",
  "TTY-READ-FINISH",
  "BIT-STRING-ALLOCATE",
  "MAKE-BIT-STRING",
  "BIT-STRING?",
  "BIT-STRING-LENGTH",
  "BIT-STRING-REF",
  "BIT-SUBSTRING-MOVE-RIGHT!",
  "BIT-STRING-SET!",
  "BIT-STRING-CLEAR!",
  "BIT-STRING-ZERO?",
  "BIT-SUBSTRING-FIND-NEXT-SET-BIT",
  No_Name,
  "UNSIGNED-INTEGER->BIT-STRING",
  "BIT-STRING->UNSIGNED-INTEGER",
  No_Name,
  "READ-BITS!",
  "WRITE-BITS!",
  "MAKE-STATE-SPACE",
  "EXECUTE-AT-NEW-POINT",
  "TRANSLATE-TO-STATE-POINT",
  "GET-NEXT-CONSTANT",
  "MICROCODE-IDENTIFY",
  "ZERO?",
  "POSITIVE?",
  "NEGATIVE?",
  "&=",
  "&<",
  "&>",
  "&+",
  "&-",
  "&*",
  "&/",
  "INTEGER-DIVIDE",
  "1+",
  "-1+",
  "TRUNCATE",
  "ROUND",
  "FLOOR",
  "CEILING",
  "SQRT",
  "EXP",
  "LOG",
  "SIN",
  "COS",
  "&ATAN",
  "TTY-WRITE-CHAR",
  "TTY-WRITE-STRING",
  "TTY-BEEP",
  "TTY-CLEAR",
  "GET-EXTERNAL-COUNTS",
  "GET-EXTERNAL-NAME",
  "GET-EXTERNAL-NUMBER",
  No_Name,
  No_Name,
  "GET-NEXT-INTERRUPT-CHARACTER",
  "CHECK-AND-CLEAN-UP-INPUT-CHANNEL",
  No_Name,
  "SYSTEM-CLOCK",
  "FILE-EXISTS?",
  No_Name,
  "TTY-MOVE-CURSOR",
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  "COPY-FILE",
  "RENAME-FILE",
  "REMOVE-FILE",
  "LINK-FILE",
  "MAKE-DIRECTORY",
  No_Name,
  "SET-WORKING-DIRECTORY-PATHNAME!",
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  "CURRENT-YEAR",
  "CURRENT-MONTH",
  "CURRENT-DAY",
  "CURRENT-HOUR",
  "CURRENT-MINUTE",
  "CURRENT-SECOND",
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  "CLEAR-TO-END-OF-LINE",
  No_Name,
  No_Name,
  "WITH-INTERRUPT-MASK",
  "STRING?",
  "STRING-LENGTH",
  "STRING-REF",
  "STRING-SET!",
  "SUBSTRING-MOVE-RIGHT!",
  "SUBSTRING-MOVE-LEFT!",
  "STRING-ALLOCATE",
  "STRING-MAXIMUM-LENGTH",
  "SET-STRING-LENGTH!",
  "VECTOR-8B-FILL!",
  "VECTOR-8B-FIND-NEXT-CHAR",
  "VECTOR-8B-FIND-PREVIOUS-CHAR",
  "VECTOR-8B-FIND-NEXT-CHAR-CI",
  "VECTOR-8B-FIND-PREVIOUS-CHAR-CI",
  "SUBSTRING-FIND-NEXT-CHAR-IN-SET",
  "SUBSTRING-FIND-PREVIOUS-CHAR-IN-SET",
  "SUBSTRING=?",
  "SUBSTRING-CI=?",
  "SUBSTRING<?",
  "SUBSTRING-UPCASE!",
  "SUBSTRING-DOWNCASE!",
  "SUBSTRING-MATCH-FORWARD",
  "SUBSTRING-MATCH-BACKWARD",
  "SUBSTRING-MATCH-FORWARD-CI",
  "SUBSTRING-MATCH-BACKWARD-CI",
  "PHOTO-OPEN",
  "PHOTO-CLOSE",
  "SETUP-TIMER-INTERRUPT",
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  "SCREEN-X-SIZE",
  "SCREEN-Y-SIZE",
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  "STRING->SYNTAX-ENTRY",
  "SCAN-WORD-FORWARD",
  "SCAN-WORD-BACKWARD",
  "SCAN-LIST-FORWARD",
  "SCAN-LIST-BACKWARD",
  "SCAN-SEXPS-FORWARD",
  "SCAN-FORWARD-TO-WORD",
  "SCAN-BACKWARD-PREFIX-CHARS",
  "CHAR->SYNTAX-CODE",
  "QUOTED-CHAR?",
  "MICROCODE-TABLES-FILENAME",
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  "ERROR-PROCEDURE",
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  "SYSTEM-MEMORY-REF",
  "SYSTEM-MEMORY-SET!",
  "BIT-STRING-FILL!",
  "BIT-STRING-MOVE!",
  "BIT-STRING-MOVEC!",
  "BIT-STRING-OR!",
  "BIT-STRING-AND!",
  "BIT-STRING-ANDC!",
  "BIT-STRING=?",
  "WORKING-DIRECTORY-PATHNAME",
  "OPEN-DIRECTORY",
  "DIRECTORY-READ",
  "UNDER-EMACS?",
  "TTY-FLUSH-OUTPUT",
  "RELOAD-BAND-NAME",
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name,
  No_Name
};

