#ifndef lint
static char *RcsId="$Id: xwindow.c,v 2.10 91/03/13 21:47:11 keisuke Exp $";
#endif

/* Functions for Handling Windows on X11R4
 * This file is part of YY-server of YYonX (1.3 Distribution)
 * $Id: xwindow.c,v 2.10 91/03/13 21:47:11 keisuke Exp $
 */

/****************************************************************************
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   Version 1.0 90/02/26 by Keisuke 'Keiko' Tanaka
;;;				(keisuke@csrl.aoyama.ac.jp)
;;;   Version 2.0 90/08/27 by Keisuke 'Keiko' Tanaka
;;;			Page Mode Territory is supported
;;;   Version 2.4 90/11/05 by Keisuke 'Keiko' Tanaka
;;;			Copyright Notice is rewritten
;;;
****************************************************************************/

/****************************************************************************
  $Revision: 2.10 $ Written by Keisuke 'Keiko' Tanaka
  $Date: 91/03/13 21:47:11 $
****************************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include "yydefs.h"
#include "yypacket.h"
#include "xwindow.h"
#include "territory.h"
#include <X11/keysym.h>

static void key_press();
static void parse_button_press_event();
static void parse_button_release_event();
static void parse_mouse_motion_event();
static void report_mouse_event();

int x_err_handler(disp, er)
    Display *disp;
    XErrorEvent *er;
{
    char message[128];
    XGetErrorText(disp, er->error_code, message, sizeof(message));
    warning("Error on X-Protocol (%s)\n", message);
    warning(" Error Code: %d\n", er->error_code);
    warning(" Request Code: %d\n", er->request_code);
    warning(" Minor Code: %d\n", er->minor_code);
}

set_error_handler()
{
    XSetErrorHandler(x_err_handler);
}

sync_x_server(xp)
    x_private *xp;
{
    XFlush(xp->xDisp);
}

get_events_on_x_server(ch, wait_network)
    yy_comm_channel *ch;
    bool wait_network;
{
    x_private *xp = XPRIVATE(ch);
    XEvent event;
    int i;
    debug_setfunc("xwindow-event", "get_event_on_x_server");
    while ((i = XEventsQueued(xp->xDisp, QueuedAfterReading))) {
	debug_print(1, "XQUEUE has %d events\n", i);
	XNextEvent(xp->xDisp, &event);
	debug_print(1, "Catch Event from X Server %d\n", event.type);
	parse_event(ch, xp, &event);
    }
    debug_endfunc("get_event_on_x_server");
}


parse_event(ch, xp, ev)
    yy_comm_channel *ch;
    x_private *xp;
    XEvent *ev;
{
    register territory_entry *tr;
    debug_setfunc("xwindow-event", "parse_event");
    switch (ev->type) {
    default:
	debug_print(5, "Unknown Event Type %d\n", ev->type);
	break;
    case KeyPress: {
	debug_print(5, "KeyPress Event\n");
	tr = search_territory_from_win(ev->xexpose.window);
	if (NULLTERRITORY(tr) || !NULLTERRITORY(tr->teParent))
	    break; /* This Territory is not ROOT */
	debug_print(6, "  *** Event on Territory#%d\n", tr->teID);
	key_press(ch, xp, ev);
	break;
    }
    case KeyRelease:
	debug_print(5, "KeyRelease Event\n");
	break;
    case ButtonPress: {
	debug_print(5, "ButtonPress Event\n");
	XUngrabPointer(xp->xDisp, ev->xbutton.time);
	tr = search_territory_from_win(ev->xbutton.window);
	if (NULLTERRITORY(tr) ||
	    !(tr->teEventMask & YYMASK_BUTTON_PRESS))
	    break; /* Uuum.. What's this? */
	debug_print(6, "  *** Event on Territory#%d\n", tr->teID);
	parse_button_press_event(ch, tr, ev);
	break;
    }
    case ButtonRelease: {
	debug_print(5, "ButtonRelease Event\n");
	tr = search_territory_from_win(ev->xbutton.window);
	if (NULLTERRITORY(tr) ||
	    !(tr->teEventMask & YYMASK_BUTTON_RELEASE))
	    break; /* Uuum.. What's this? */
	debug_print(6, "  *** Event on Territory#%d\n", tr->teID);
	parse_button_release_event(ch, tr, ev);
	break;
    }
    case MotionNotify: {
	debug_print(5, "MotionNotify Event\n");
	tr = search_territory_from_win(ev->xmotion.window);
	if (NULLTERRITORY(tr) ||
	    !(tr->teEventMask & YYMASK_MOVE))
	    break; /* Uuum.. What's this? */
	debug_print(6, "  *** Event on Territory#%d\n", tr->teID);
	parse_mouse_motion_event(ch, tr, ev);
	break;
    }
    case EnterNotify:
    case LeaveNotify: {
	int mask;
	if (ev->type == EnterNotify) {
	    mask = YYMASK_ENTER;
	    debug_print(5, "EnterNotify Event\n");
	} else {
	    mask = YYMASK_LEAVE;
	    debug_print(5, "LeaveNotify Event\n");
	}
	tr = search_territory_from_win(ev->xcrossing.window);
	if (NULLTERRITORY(tr) || !(tr->teEventMask & mask))
	    break; /* Uuum.. What's this? */
	debug_print(6, "  *** Event on Territory#%d\n", tr->teID);
	report_mouse_event(ch, tr->teID, mask,
			   ev->xcrossing.x, ev->xcrossing.y);
	break;
    }
    case FocusIn:
	debug_print(5, "FocusIn Event\n");
	break;
    case FocusOut:
	debug_print(5, "FocusOut Event\n");
	break;
    case KeymapNotify:
	debug_print(5, "KeymapNotify Event\n");
	break;
    case Expose: {
	debug_print(5, "Expose Event (Count:%d)\n", ev->xexpose.count);
	/* if (ev->xexpose.count > 0)
	 * break; /* We may have more Expose event */
	tr = search_territory_from_win(ev->xexpose.window);
	if(tr != (TERRITORY *)NULL && IsVisibleTerritory(tr)) {
	    static void do_expose();
	    do_expose(XPRIVATE(ch), tr, ev);
	    ch->ccXNeedFlush = TRUE;
	}
	break;
    }
    case GraphicsExpose:
	debug_print(5, "GraphicsExpose Event\n");
	break;
    case NoExpose:
	debug_print(5, "NoExpose Event\n");
	break;
    case VisibilityNotify:
	debug_print(5, "VisibilityNotify Event\n");
	break;
    case CreateNotify:
	debug_print(5, "CreateNotify Event\n");
	break;
    case DestroyNotify:
	debug_print(5, "DestroyNotify Event\n");
	break;
    case UnmapNotify:
	debug_print(5, "UnmapNotify Event\n");
	break;
    case MapNotify:
	debug_print(5, "MapNotify Event\n");
	break;
    case MapRequest:
	debug_print(5, "MapRequest Event\n");
	break;
    case ReparentNotify:
	debug_print(5, "ReparentNotify Event\n");
	break;
    case ConfigureNotify:
	debug_print(5, "ConfigureNotify Event\n");
	break;
    case ConfigureRequest:
	debug_print(5, "ConfigureRequest Event\n");
	break;
    case GravityNotify:
	debug_print(5, "GravityNotify Event\n");
	break;
    case ResizeRequest:
	debug_print(5, "ResizeRequest Event\n");
	break;
    case CirculateNotify:
	debug_print(5, "CirculateNotify Event\n");
	break;
    case CirculateRequest:
	debug_print(5, "CirculateRequest Event\n");
	break;
    case PropertyNotify:
	debug_print(5, "PropertyNotify Event\n");
	break;
    case SelectionClear:
	debug_print(5, "SelectionClear Event\n");
	break;
    case SelectionRequest:
	debug_print(5, "SelectionRequest Event\n");
	break;
    case SelectionNotify:
	debug_print(5, "SelectionNotify Event\n");
	break;
    case ColormapNotify:
	debug_print(5, "ColormapNotify Event\n");
	break;
    case ClientMessage:
	debug_print(5, "ClientMessage Event\n");
	break;
    case MappingNotify:
	debug_print(5, "MappingNotify Event\n");
	break;
    }
    debug_endfunc("parse_event");
}

static void do_expose(xp, tr, ev)
    register x_private *xp;
    register TERRITORY *tr;
    register XEvent *ev;
{
    register TERRITORY_X_ENTRY *tx = GetTerritoryXEntry(tr);
    debug_setfunc("xwindow-event", "do_expose");
    if (IsDrawableTerritory(tr)) {
	debug_print(5, " Copy (%d,%d)[%d,%d] on TR#%d\n",
		    ev->xexpose.x, ev->xexpose.y,
		    ev->xexpose.width, ev->xexpose.height, tr->teID);
	XSetFunction(xp->xDisp, tx->txGC, GXcopy);
	XCopyArea(xp->xDisp, tx->txPixmap, tx->txWindow,
		  tx->txGC, ev->xexpose.x, ev->xexpose.y,
		  ev->xexpose.width, ev->xexpose.height,
		  ev->xexpose.x, ev->xexpose.y);
    } else if (tr->teTRType != TR_FENCE && tx->txWindow != (Window)NULL) {
	debug_print(5, " Clear (%d,%d)[%d,%d] on TR#%d\n",
		    ev->xexpose.x, ev->xexpose.y,
		    ev->xexpose.width, ev->xexpose.height,
		    tr->teID);
	XSetFunction(xp->xDisp, tx->txGC, GXclear);
	XClearArea(xp->xDisp, tx->txWindow,
		   ev->xexpose.x, ev->xexpose.y,
		   ev->xexpose.width, ev->xexpose.height,
		   False);
    }
    debug_setfunc("xwindow-event", "do_expose");
    return;
}


#define CHECKBUTTON(tr,tm,ev,em)	(((tr)->teEventMask & (tm)) && \
					 ((ev)->xbutton.button == (em)))
#define BUTTONSTATE(tr,tm,ev,em)	(((tr)->teEventMask & (tm)) && \
					 ((ev)->xbutton.state & (em)))
#define CROSSINGSTATE(tr,tm,ev,em)	(((tr)->teEventMask & (tm)) && \
					 ((ev)->xcrossing.state & (em)))

int parse_button_state(em, press_or_release, st)
	int em;	/* Event Mask */
	int press_or_release;
	int st;	/* Status */
{
	int mask = 0;

	press_or_release &= em;
	if (st & Button3Mask)
		mask |= (press_or_release &
			 (YYMASK_RIGHT_PRESS|YYMASK_RIGHT_RELEASE));
	if (st & Button2Mask)
		mask |= (press_or_release &
			 (YYMASK_MIDDLE_PRESS|YYMASK_MIDDLE_RELEASE));
	if (st & Button1Mask)
		mask |= (press_or_release &
			 (YYMASK_LEFT_PRESS|YYMASK_LEFT_RELEASE));
	if (st & Mod1Mask)
		mask |= (em & YYMASK_META);
	if (st & ControlMask)
		mask |= (em & YYMASK_CTRL);
	if (st & ShiftMask)
		mask |= (em & YYMASK_SHIFT);
	return mask;
}

static void parse_button_press_event(ch, tr, ev)
	yy_comm_channel *ch;
	register territory_entry *tr;
	XEvent *ev;
{
	int mask = 0;
	debug_setfunc("xwindow-event", "parse_button_press_event");
	debug_print(3, "Button: 0%o - EventMask: 0%o\n",
		    ev->xbutton.button, tr->teEventMask);
	if (CHECKBUTTON(tr, YYMASK_RIGHT_PRESS, ev, Button3))
		mask |= YYMASK_RIGHT_PRESS;
	else if (CHECKBUTTON(tr, YYMASK_MIDDLE_PRESS, ev, Button2))
		mask |= YYMASK_MIDDLE_PRESS;
	else if (CHECKBUTTON(tr, YYMASK_LEFT_PRESS, ev, Button1))
		mask |= YYMASK_LEFT_PRESS;
	else
		return;
	debug_print(3, "Button#%d\n", ev->xbutton.button);
	debug_print(3, "Button State 0%o\n", ev->xbutton.state);
	mask |= parse_button_state(tr->teEventMask, 0, ev->xbutton.state);
	/* Now, we have some event */
	report_mouse_event(ch, tr->teID, mask, ev->xbutton.x, ev->xbutton.y);
	debug_endfunc("parse_button_press_event");
	return;
}

static void parse_button_release_event(ch, tr, ev)
	yy_comm_channel *ch;
	register territory_entry *tr;
	XEvent *ev;
{
	int mask = 0;
	debug_setfunc("xwindow-event", "parse_button_release_event");
	debug_print(3, "Button: 0%o - EventMask: 0%o\n",
		    ev->xbutton.button, tr->teEventMask);
	if (CHECKBUTTON(tr, YYMASK_RIGHT_RELEASE, ev, Button3))
		mask |= YYMASK_RIGHT_RELEASE;
	else if (CHECKBUTTON(tr, YYMASK_MIDDLE_RELEASE, ev, Button2))
		mask |= YYMASK_MIDDLE_RELEASE;
	else if (CHECKBUTTON(tr, YYMASK_LEFT_RELEASE, ev, Button1))
		mask |= YYMASK_LEFT_RELEASE;
	else
		return;
	debug_print(3, "Button#%d\n", ev->xbutton.button);
	debug_print(3, "Button State 0%o\n", ev->xbutton.state);
	mask |= parse_button_state(tr->teEventMask, 0, ev->xbutton.state);
	/* Now, we have some event */
	report_mouse_event(ch, tr->teID, mask, ev->xbutton.x, ev->xbutton.y);
	debug_endfunc("parse_button_release_event");
	return;
}

static void parse_mouse_motion_event(ch, tr, ev)
	yy_comm_channel *ch;
	register territory_entry *tr;
	XEvent *ev;
{
	int mask = YYMASK_MOVE;
	debug_setfunc("xwindow-event", "parse_mouse_motion_event");
	debug_print(3, " - EventMask: 0%o\n", tr->teEventMask);
	mask |= parse_button_state(tr->teEventMask, YYMASK_BUTTON_PRESS,
				   ev->xmotion.state);
	debug_print(3, "Button State 0%o\n", ev->xmotion.state);
	report_mouse_event(ch, tr->teID, mask,
			   ev->xmotion.x, ev->xmotion.y);
	debug_endfunc("parse_mouse_motion_event");
	return;
}

static void report_mouse_event(ch, id, mask, x, y)
	yy_comm_channel *ch;
{
	yy_packet *event;
	debug_setfunc("xwindow-event", "report_mouse_event");
	event = ALLOC_EVENTPACKET(YYCOMMAND_MOUSE_EVENT);
	debug_print(5, "Event on Territory#%d (%d,%d) - mask:0%o\n",
		    id, x, y, mask);
	append_packet_entry_integer(event, id);
	append_packet_entry_integer(event, mask);
	append_packet_entry_integer(event, x);
	append_packet_entry_integer(event, y);
	put_packet_on_sendq(QUE(ch), event);
	debug_endfunc("report_mouse_event");
}

static void report_key_event(ch, id, leng, str)
    yy_comm_channel *ch;
    int id;
    int leng;
    char *str;
{
    yy_packet *event;
    debug_setfunc("xwindow-event", "report_key_event");
    debug_print(5, "   to Territory#%d\n", id);
    event = ALLOC_EVENTPACKET(YYCOMMAND_KEY_EVENT);
    append_packet_entry_integer(event, id);
    append_packet_entry_string_with_length(event, leng, str);
    put_packet_on_sendq(QUE(ch), event);
    debug_endfunc("report_key_event");
}

typedef struct _x_event_control {
	KeySym ecLastKeySym;
	Time ecLastKeyTime;
	int ecMaxLengString;
	char *ecKeyString;
	char *ecCurKeyString;
	int ecLengKeyString;
} x_event_control;

static void key_press(ch, xp, ev)
	yy_comm_channel *ch;
	x_private *xp;
	XEvent *ev;
{
    KeySym key;
    char string[10];
    int leng;
    territory_entry *tr = selected_territory();

    debug_setfunc("xwindow", "key_press");
    if (NULLTERRITORY(tr)) {
	debug_print(1, "No selected territory...\n");
	return;
    }
    leng = XLookupString(ev, string, sizeof(string), &key, NULL);
    string[leng] = EOS;
    debug_print(10, "Key Pressed\nLength=%d (%s)\n", leng, string);
    if (tr->teTRType == TR_PAGE) {
	keyin_on_input_territory(ch, tr, leng, string);
    } else {
	switch (key) {
	case XK_Delete:
	    debug_print(10, "Delete Key Pressed\n");
	    report_key_event(ch, tr->teID, leng, string);
	    break;
	case XK_Return:
	case XK_Linefeed:
	    debug_print(10, "Return Key Pressed\n");
	    report_key_event(ch, tr->teID, leng, string);
	    break;
	case XK_Shift_L:
	    debug_print(10, "Shift(L) Key Pressed\n"); break;
	case XK_Shift_R:
	    debug_print(10, "Shift(R) Key Pressed\n"); break;
	case XK_Control_L:
	    debug_print(10, "Control(L) Key Pressed\n"); break;
	case XK_Control_R:
	    debug_print(10, "Control(R) Key Pressed\n"); break;
	case XK_Meta_L:
	    debug_print(10, "Meta(L) Key Pressed\n"); break;
	case XK_Meta_R:
	    debug_print(10, "Meta(R) Key Pressed\n"); break;
	case XK_Alt_L:
	    debug_print(10, "Alt(L) Key Pressed\n"); break;
	case XK_Alt_R:
	    debug_print(10, "Alt(R) Key Pressed\n"); break;
	case XK_Super_L:
	    debug_print(10, "Super(L) Key Pressed\n"); break;
	case XK_Super_R:
	    debug_print(10, "Super(R) Key Pressed\n"); break;
	case XK_Hyper_L:
	    debug_print(10, "Hyper(L) Key Pressed\n"); break;
	case XK_Hyper_R:
	    debug_print(10, "Hyper(R) Key Pressed\n"); break;
	default:
	    if (!IsCursorKey(key) && !IsFunctionKey(key)) {
		debug_print(10, "Normal Key Pressed\n");
		report_key_event(ch, tr->teID, leng, string);
	    }
	    break;
	}
	debug_endfunc("key_press");
    }
}


x_color get_x_color(xp, name)
	x_private *xp;
	char *name;
{
	XColor c0, c1;
	debug_setfunc("xwindow", "get_x_color");
	debug_print(2, "Color Name : '%s'\n", name);
	if (XAllocNamedColor(xp->xDisp, xp->xColor, name, &c1, &c0) == 0) {
		c1.pixel = BlackPixel(xp->xDisp, xp->xScreen);
	}
	debug_print(2, "Color Code : %lu\n", c1.pixel);
	debug_endfunc("get_x_color");
	return c1.pixel;
}

yy_packet *yycom_query_color(ch, pkt)
	yy_comm_channel *ch;
	yy_packet *pkt;
{
	x_private *xp = XPRIVATE(ch);
	XColor color;
	yy_packet *repl;
	char c_name[16];

	debug_setfunc("xwindow", "yycom_query_color");
	color.red = (u_short)(read_packet_entry_integer(pkt) & 0xffff);
	color.green = (u_short)(read_packet_entry_integer(pkt) & 0xffff);
	color.blue = (u_short)(read_packet_entry_integer(pkt) & 0xffff);
	debug_print(1, "Allocate color for (R:%d,G:%d,B:%d)\n",
		    color.red, color.green, color.blue);
	if (XAllocColor(xp->xDisp, xp->xColor, &color) == (Status)0) {
		debug_print(1, "Cannot Allocate color\n");
		debug_endfunc("yycom_query_color");
		return create_error_packet(pkt, YYERROR_NOCOLOR);
	}
	debug_print(1, "Pixel value is %lu\n", color.pixel);
	repl = ALLOC_ACKPACKET(pkt);
	append_packet_entry_integer(repl, color.pixel);
	debug_endfunc("yycom_query_color");
	return repl;
}

yy_packet *yycom_debug_list_color(ch, pkt)
	yy_comm_channel *ch;
	yy_packet *pkt;
{
	x_private *xp = XPRIVATE(ch);
	int len;
	char name[256];
	x_color color;
	yy_packet *repl;
	debug_setfunc("xwindow", "yycom_debug_list_color");
	len = read_packet_entry_integer(pkt);
	debug_print(5, "Length = %d\n", len);
	read_packet_entry_string(pkt, len, name);
	debug_print(5, "Name = %d\n", len);
	color = get_x_color(xp, name);
	debug_print(1, "Color Code for '%s' is %lu\n", name, color);
	repl = ALLOC_ACKPACKET(pkt);
	append_packet_entry_color(repl, color);
	debug_endfunc("yycom_debug_list_color");
	return (yy_packet *)NULL;
}

yy_packet *yycom_debug_do_input(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    int id;
    int leng;
    char buf[256];
    yy_packet *event;
    debug_setfunc("xwindow", "yycom_debug_do_input");
    id = read_packet_entry_integer(pkt);
    leng = read_packet_entry_integer(pkt);
    debug_print(1, "Echo Back String (Length = %d) on TR#%d\n", leng, id);
    read_packet_entry_string(pkt, leng, buf);
    event = ALLOC_EVENTPACKET(YYCOMMAND_KEY_EVENT);
    append_packet_entry_integer(event, id);
    append_packet_entry_string_with_length(event, leng, buf);
    put_packet_on_sendq(QUE(ch), event);
    debug_endfunc("yycom_debug_do_input");
    return (yy_packet *)NULL;
}
