/* Header File for Page Mode Territory
 * This file is part of YY-server of YYonX (1.3 Distribution)
 * $Id: page.h,v 2.0.1.11 91/03/13 21:47:01 keisuke Exp $
 */

/****************************************************************************
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   Version 1.0 90/08/26 by Keisuke 'Keiko' Tanaka
;;;				(keisuke@csrl.aoyama.ac.jp)
;;;			Create for Page Mode Territory
;;;   Version 2.0 90/08/27 by Keisuke 'Keiko' Tanaka
;;;			Refine for distribution
;;;   Version 2.0.1.1 90/11/05 by Keisuke 'Keiko' Tanaka
;;;			Branch for OLD Page Mode Territory
;;;			This branch should be removed..
;;;   Version 2.0.1.2 90/11/05 by Keisuke 'Keiko' Tanaka
;;;			Copyright Notice is rewritten
;;;
****************************************************************************/

/****************************************************************************
  $Revision: 2.0.1.11 $ Written by Keisuke 'Keiko' Tanaka
  $Date: 91/03/13 21:47:01 $
****************************************************************************/

struct _char_position {
    int log_x, log_y;	/* Logical Position */
    int phs_x, phs_y;	/* Physical Position */
} ;
typedef struct _char_position	CPOS;

struct _page_string {
    int posLin;
    int posX;		/* Physical Offset for top of line (in pixel) */
    int width;
    int nchar;
    int leng;
    char ptr[2];
    int  fid;
    struct _page_string *psNext;
    struct _page_string *psPrev;
    struct _page_one_line *psLine;
} ;
typedef struct _page_string	PAGESTR;
struct _page_one_line {
    struct _page_line_buf {
	char *lbBuf;
	struct _page_line_buf *lbNext;
    } plBuf;
    struct _page_string *plFirstStr;
    int plColNum;
    int plLineNum;	/* The Number of Physical Line */
    struct _page_one_line *plNextLine;
    struct _page_one_line *plPrevLine;
    struct _page_block *plBlock;
} ;
typedef struct _page_one_line	PAGELINE;
struct _page_block {
    int pbLogicalLines;
    int pbPhysicalLines;
    struct _page_one_line *pbFirstLine;
    struct _page_block *pbNextBlock;
    struct _page_block *pbPrevBlock;
} ;
typedef struct _page_block	PAGEBLOCK;
struct _page_plane {
    int ppLogicalLines;
    int ppPhysicalLines;
    struct _page_block *ppBlocks;
} ;
typedef struct _page_plane	PAGEPLANE;

#define MAXLINEINPAGEBLOCK	20

struct _territory_page_control {
    int pcPageMode;		/* MODE */
    int pcDefFontID;		/* Font ID */
    YYFONT *pcDefFont;		/* Default Font */
    int pcCSX, pcCSY;
    int pcCSW, pcCSH;
    int pcCurXPos, pcCurYPos;	/* Current C-Cursor Position */
    int pcCurColumn, pcCurLine;	/* Current Phisical Position */
    int pcMaxColumn, pcMaxLine;	/* Current size of C-Plane */
    int pcXpixel, pcYpixel;	/* start point (pixel) */
    int pcHeadOff;		/* Offset for Head (pixel) */
    int pcTailOff;		/* Offset for Head (pixel) */
    int pcLineSkip;
    bool pcDoKeyInput;
    TERRITORY *pcKeyInTerritory;
    char pcKeyInCtrlBuf[256];
    struct keyin_control pcKeyInSync;
    struct keyin_control pcKeyInTerm;
    struct keyin_control pcKeyInIntr;
    int pcInputLeng;
    char *pcInputPtr;
    char pcInputBuf[256];
    int pcInStartCol, pcInStartLin, pcInTailCol;
    char *pcInStartPtr, *pcInTailPtr;
#ifdef WNNKINPUT
    char *pcKanjiPtr;
    char pcYomiBuf[256];
    char pcKanjiBuf[256];
#endif /*WNNKINPUT*/
    PAGEPLANE	pcPagePlane;	/* Page Character Map */
} ;
typedef struct _territory_page_control		TERRITORY_PAGE;

#define PG_MODE		0303
#define PG_HMODE	0100
#define PG_VMODE	0200
#define PG_LTMODE	0001
#define PG_LBMODE	0002
#define PG_HLT		0101
#define PG_HLB		0102
#define PG_VLT		0201
#define PG_VLB		0202

#define DRAW_TEXT_DIR_H		0
#define DRAW_TEXT_DIR_V		1
#define PAGE_DIR(pg)		(((pg)->pcPageMode & PG_HMODE)? 0: 1)

#define PGMOVE_DONTMOVE		0
#define PGMOVE_ABSOLUTE		1
#define PGMOVE_RELATIVE		2
#define PGCSMOVE_DONTMOVE	0
#define PGCSMOVE_ABSOLUTE	1
#define PGCSMOVE_RELATIVE	2

extern void clear_page_territory();
extern void move_page_territory();
extern void move_page_cursor();
extern TERRITORY *create_input_territory();
extern void abort_keyin();
extern void send_keyin_data();
