#ifndef lint
static char *RcsId="$Id: input.c,v 2.33 91/03/14 12:48:47 keisuke Exp $";
#endif

/* Support Character Input on Page Territory
 * This file is part of YY-server of YYonX (1.3 Distribution)
 * $Id: input.c,v 2.33 91/03/14 12:48:47 keisuke Exp $
 */

/****************************************************************************
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   Version 1.0 90/06/07 by Keisuke 'Keiko' Tanaka
;;;				(keisuke@csrl.aoyama.ac.jp)
;;;   Version 2.0 90/08/27 by Keisuke 'Keiko' Tanaka
;;;			Page Mode Territory is supported
;;;   Version 2.3 90/11/05 by Keisuke 'Keiko' Tanaka
;;;			Copyright Notice is rewritten
;;;
****************************************************************************/

/****************************************************************************
  $Revision: 2.33 $ Written by Keisuke 'Keiko' Tanaka
  $Date: 91/03/14 12:48:47 $
****************************************************************************/

#include <stdio.h>
#include <sys/types.h>
#ifdef WNNKINPUT
#include <Wnn4/rk_spclval.h>
#include <Wnn4/jllib.h>
#endif /*WNNKINPUT*/
#include "yydefs.h"
#include "yypacket.h"
#include "xwindow.h"
#include "territory.h"
#include "yyfont.h"
#ifdef WNNKINPUT
#define INPUTEDITTABLENORMAL	0
#define INPUTEDITTABLEKANA	1
#define INPUTEDITTABLEKANJI	2
#endif /*WNNKINPUT*/

/*
 * KeyInput
 */

static void put_initial_string_on_page(ch, tr, pg, input_tr, input_pg,
				       col, lin)
    yy_comm_channel *ch;
    TERRITORY *tr, *input_tr;
    TERRITORY_PAGE *pg, *input_pg;
    int col, lin;
{
    PAGEPLANE *plane = &pg->pcPagePlane;
    PAGELINE *pl;
    int c = col;
    int l = lin;
    move_page_cursor(ch, input_tr, input_pg, PGCSMOVE_ABSOLUTE, 0, 0);
    if (plane->ppBlocks != (PAGEBLOCK *)NULL &&
	(pl = plane->ppBlocks->pbFirstLine) != (PAGELINE *)NULL) {
	while (l-- > 0 && pl != (PAGELINE *)NULL)
	    pl = pl->plNextLine;
	if (pl != (PAGELINE *)NULL && pl->plFirstStr != (PAGESTR *)NULL) {
	    PAGESTR *ps = pl->plFirstStr;
	    for ( ; c > 0 && ps != (PAGESTR *)NULL; c--, ps = ps->psNext) {
		put_string_on_page(ch, input_tr, input_pg,
				   input_pg->pcCurXPos, input_pg->pcCurYPos,
				   input_pg->pcDefFontID, ps->leng, ps->ptr);
	    }
	}
    }
    move_page_cursor(ch, input_tr, input_pg, PGCSMOVE_ABSOLUTE, col, 0);
}

TERRITORY *create_input_territory(ch, tr, pg, col, lin, fid, err_code)
    yy_comm_channel *ch;
    TERRITORY *tr;
    TERRITORY_PAGE *pg;
    int col, lin;
    int fid;
    int err_code;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY *input_tr = (TERRITORY *)NULL;
    TERRITORY_PAGE *input_pg;
    /* Create Input Territory */
    debug_setfunc("page", "create_input_territory");
    debug_print(3, "Create Input Territory on <%d,%d> of Page#%d\n",
		col, lin, tr->teID);
    move_page_cursor(ch, tr, pg, PGCSMOVE_ABSOLUTE, col, lin);
    debug_print(3, "Input Territory - (%d,%d)[%d,%d]\n", 0, lin*pg->pcLineSkip,
		tr->teWidth, pg->pcHeadOff+pg->pcTailOff);
    input_tr = create_territory(ch, 0, lin*pg->pcLineSkip,
				tr->teWidth, pg->pcHeadOff+pg->pcTailOff,
				tr->teID, TRUE, TRUE, TR_PAGE, err_code);
    if (input_tr == (TERRITORY *)NULL)
	goto send_reply;
    /* set_page_attribute */
    input_pg = &input_tr->teModeEnt.tPageControl;
    input_pg->pcDefFontID = (fid > 0? fid: pg->pcDefFontID);
    input_pg->pcDefFont = call_font(ch, input_pg->pcDefFontID);
    input_pg->pcHeadOff = MAX(MAXB1ASCENT(input_pg->pcDefFont),
			      MAXB2ASCENT(input_pg->pcDefFont));
    input_pg->pcTailOff = MAX(MAXB1DESCENT(input_pg->pcDefFont),
			      MAXB2DESCENT(input_pg->pcDefFont));
    input_pg->pcLineSkip = pg->pcLineSkip;
    input_pg->pcPageMode = pg->pcPageMode;
    yy_gc_setdefaultoperation(XPRIVATE(ch)->xDisp, XEntry(input_tr)->txGC);
    yy_gc_setdefaultcolor(XPRIVATE(ch)->xDisp, XEntry(input_tr)->txGC);
    /* Input Data */
    pg->pcInputLeng = 0;
    pg->pcInputPtr = pg->pcInputBuf;
    pg->pcInStartCol = col;
    pg->pcInStartPtr = pg->pcInputBuf;
    pg->pcInTailCol = col;
    pg->pcInTailPtr = pg->pcInputBuf;
    pg->pcInStartLin = lin;
    put_initial_string_on_page(ch, tr, pg, input_tr, input_pg, col, lin);
 send_reply:
    debug_endfunc("create_input_territory");
    return input_tr;
}

void abort_keyin(ch, tr, pg)
    yy_comm_channel *ch;
    TERRITORY *tr;
    TERRITORY_PAGE *pg;
{
    debug_setfunc("page", "abort_keyin");
    if (pg->pcInputLeng > 0) {
	yy_gc_setdefaultoperation(XPRIVATE(ch)->xDisp, XEntry(tr)->txGC);
	yy_gc_setdefaultcolor(XPRIVATE(ch)->xDisp, XEntry(tr)->txGC);
	put_string_on_page(ch, tr, pg, pg->pcCurXPos-1, pg->pcCurYPos,
			   pg->pcDefFontID,
			   pg->pcInputLeng, pg->pcInputBuf);
	sync_x_server(XPRIVATE(ch));
    }
    destroy_territory(ch, pg->pcKeyInTerritory, TRUE);
    pg->pcDoKeyInput = FALSE;
    debug_endfunc("abort_keyin");
}


void send_keyin_data(ch, tr, pg)
    yy_comm_channel *ch;
    TERRITORY *tr;
    TERRITORY_PAGE *pg;
{
    yy_packet *event;
    int total_size = 0;
    debug_setfunc("page", "send_keyin_data");
    event = ALLOC_EVENTPACKET(YYCOMMAND_KEY_EVENT);
    append_packet_entry_integer(event, tr->teID);
    debug_print(5, "Send %dcharacters\n", pg->pcInputLeng);
    if (pg->pcInputLeng > 0)
	append_packet_entry_string_with_length(event, pg->pcInputLeng,
					       pg->pcInputBuf);
    else {
	append_packet_entry_integer(event, pg->pcInputLeng);
	append_packet_entry_integer(event, pg->pcInputLeng); /* Dummy */
    }
    put_packet_on_sendq(QUE(ch), event);
    debug_endfunc("send_keyin_data");
}

check_keyin_control(ctrl, leng, str)
    struct keyin_control *ctrl;
    int leng;
    char *str;
{
    register int loop;
    register char *s;
    debug_setfunc("page", "check_keyin_control");
    debug_print(4, "check for <%c>(0%d)\n", (isprint(*str)? *str: ' '), *str);
    for (loop = ctrl->kcLeng, s = ctrl->kcStr; loop > 0; s++, loop--) {
	debug_print(4, " with <%c>(0%d)\n", (isprint(*s)? *s: ' '), *s);
	if (*s == *str)
	    return TRUE;
    }
    debug_endfunc("check_keyin_control");
    return FALSE;
}

void input_inseart_one_char(ch, tr, pg, input_tr, input_pg, leng, str)
    yy_comm_channel *ch;
    TERRITORY *tr;
    TERRITORY_PAGE *pg;
    TERRITORY *input_tr;
    TERRITORY_PAGE *input_pg;
    int leng;
    char *str;
{
    PAGEPLANE *plane = &input_pg->pcPagePlane;
    debug_setfunc("page", "input_insert_one_char");
    if (*str == '\n' || *str == '\r' || isprint(*str)) {
	register int len = (pg->pcInTailPtr - pg->pcInputPtr);
	register int loop;
	register char *s1, *s2;
	int ocol, olin;
	for (loop = len, s1 = pg->pcInTailPtr-1, s2 = pg->pcInTailPtr;
	     loop > 0; s1--, s2--, loop--)
	    *s2 = *s1;
	pg->pcInputLeng += 1;
	*pg->pcInputPtr = *str;
	ocol = input_pg->pcCurXPos;
	olin = input_pg->pcCurYPos;
	put_string_on_page(ch, input_tr, input_pg, ocol, olin,
			   input_pg->pcDefFontID, len+1, pg->pcInputPtr, 1);
	sync_x_server(XPRIVATE(ch));
	move_page_cursor(ch, input_tr, input_pg, PGCSMOVE_ABSOLUTE,
			 ocol+1, olin);
	pg->pcInputPtr++;
	pg->pcInTailCol++; pg->pcInTailPtr++;
    }

    if (check_keyin_control(&pg->pcKeyInTerm, leng, str) ||
	check_keyin_control(&pg->pcKeyInIntr, leng, str)) {
	/* λ or  */
	/* put string on territory */
#ifdef notdef
	if (pg->pcInputLeng > 0) {
	    yy_gc_setdefaultoperation(XPRIVATE(ch)->xDisp, XEntry(tr)->txGC);
	    yy_gc_setdefaultcolor(XPRIVATE(ch)->xDisp, XEntry(tr)->txGC);
	    put_string_on_page(ch, tr, pg, pg->pcCurXPos-1, pg->pcCurYPos,
			       pg->pcDefFontID,
			       pg->pcInputLeng, pg->pcInputBuf);
	    sync_x_server(XPRIVATE(ch));
	    if (*str == '\n' || *str == '\r')
		move_page_cursor(ch, tr, pg, PGCSMOVE_ABSOLUTE,
				 0, pg->pcCurYPos+1);
	}
#endif
	send_keyin_data(ch, tr, pg);
	abort_keyin(ch, tr, pg);
	goto send_reply;
    }
    if (check_keyin_control(&pg->pcKeyInSync, leng, str)) {
	send_keyin_data(ch, tr, pg);
    }
 send_reply:
    debug_endfunc("input_insert_one_char");
}


void input_beginning_of_line(ch, tr, pg, input_tr, input_pg, leng, str)
    yy_comm_channel *ch;
    TERRITORY *tr;
    TERRITORY_PAGE *pg;
    TERRITORY *input_tr;
    TERRITORY_PAGE *input_pg;
    int leng;
    char *str;
{
    if (pg->pcInputPtr > pg->pcInStartPtr) {
	pg->pcInputPtr = pg->pcInStartPtr;
	move_page_cursor(ch, input_tr, input_pg, PGCSMOVE_ABSOLUTE,
			 pg->pcInStartCol, input_pg->pcCurYPos);
    }
}

void input_backward_char(ch, tr, pg, input_tr, input_pg, leng, str)
    yy_comm_channel *ch;
    TERRITORY *tr;
    TERRITORY_PAGE *pg;
    TERRITORY *input_tr;
    TERRITORY_PAGE *input_pg;
    int leng;
    char *str;
{
    if (pg->pcInputPtr > pg->pcInStartPtr) {
	pg->pcInputPtr--;
	move_page_cursor(ch, input_tr, input_pg, PGCSMOVE_RELATIVE, -1, 0);
    }
}

void input_delete_char(ch, tr, pg, input_tr, input_pg, leng, str)
    yy_comm_channel *ch;
    TERRITORY *tr, *input_tr;
    TERRITORY_PAGE *pg, *input_pg;
    int leng;
    char *str;
{
    if (pg->pcInputPtr < pg->pcInTailPtr) {
	register int len = (pg->pcInTailPtr - pg->pcInputPtr);
	register int loop;
	register char *s1, *s2;
	int ocol, olin;
	s1 = pg->pcInputPtr;
	s2 = pg->pcInputPtr+1;
	for (loop = len-1; loop > 0; loop--)
	    *s1++ = *s2++;
	*s1 = ' ';
	ocol = input_pg->pcCurXPos;
	olin = input_pg->pcCurYPos,
	put_string_on_page(ch, input_tr, input_pg, ocol, olin,
			   input_pg->pcDefFontID, len, pg->pcInputPtr);
	move_page_cursor(ch, input_tr, input_pg,
			 PGCSMOVE_ABSOLUTE, ocol, olin);
	pg->pcInputLeng--;
	pg->pcInTailCol--; pg->pcInTailPtr--;
    }
}

void input_end_of_line(ch, tr, pg, input_tr, input_pg, leng, str)
    yy_comm_channel *ch;
    TERRITORY *tr, *input_tr;
    TERRITORY_PAGE *pg, *input_pg;
    int leng;
    char *str;
{
    if (pg->pcInputPtr < pg->pcInTailPtr) {
	move_page_cursor(ch, input_tr, input_pg, PGCSMOVE_ABSOLUTE,
			 pg->pcInTailCol, input_pg->pcCurYPos);
	pg->pcInputPtr = pg->pcInTailPtr;
    }
}

void input_forward_char(ch, tr, pg, input_tr, input_pg, leng, str)
    yy_comm_channel *ch;
    TERRITORY *tr;
    TERRITORY_PAGE *pg;
    TERRITORY *input_tr;
    TERRITORY_PAGE *input_pg;
    int leng;
    char *str;
{
    if (pg->pcInputPtr < pg->pcInTailPtr) {
	move_page_cursor(ch, input_tr, input_pg, PGCSMOVE_RELATIVE, 1, 0);
	pg->pcInputPtr++;
    }
}

void input_delete_backward_char(ch, tr, pg, input_tr, input_pg, leng, str)
    yy_comm_channel *ch;
    TERRITORY *tr, *input_tr;
    TERRITORY_PAGE *pg, *input_pg;
    int leng;
    char *str;
{
    if (pg->pcInputPtr > pg->pcInStartPtr) {
	move_page_cursor(ch, input_tr, input_pg, PGCSMOVE_RELATIVE, -1, 0);
	pg->pcInputPtr--;
	input_delete_char(ch, tr, pg, input_tr, input_pg, leng, str);
    }
}

void input_delete_line(ch, tr, pg, input_tr, input_pg, leng, str)
    yy_comm_channel *ch;
    TERRITORY *tr;
    TERRITORY_PAGE *pg;
    TERRITORY *input_tr;
    TERRITORY_PAGE *input_pg;
    int leng;
    char *str;
{
    if (pg->pcInputPtr < pg->pcInTailPtr) {
	char *s = pg->pcInStartPtr;
	register int loop = (pg->pcInTailPtr - pg->pcInputPtr);
	while (loop-- > 0)
	    *s++ = ' ';
	put_string_on_page(ch, input_tr, input_pg, pg->pcInStartCol, 0,
			   input_pg->pcDefFontID,
			   pg->pcInputLeng, pg->pcInStartPtr);
	pg->pcInputLeng = (pg->pcInputPtr - pg->pcInStartPtr);
	pg->pcInTailPtr = pg->pcInputPtr;
	pg->pcInTailCol = pg->pcInStartCol + pg->pcInputLeng;
	move_page_cursor(ch, input_tr, input_pg, PGCSMOVE_ABSOLUTE,
			 pg->pcInTailCol, input_pg->pcCurYPos);
    }
}

void input_kill_line(ch, tr, pg, input_tr, input_pg, leng, str)
    yy_comm_channel *ch;
    TERRITORY *tr;
    TERRITORY_PAGE *pg;
    TERRITORY *input_tr;
    TERRITORY_PAGE *input_pg;
    int leng;
    char *str;
{
    if (pg->pcInputPtr > pg->pcInStartPtr) {
	char *s1 = pg->pcInStartPtr;
	char *s2 = pg->pcInputPtr;
	register int loop1 = (pg->pcInputPtr - pg->pcInStartPtr);
	register int loop2 = (pg->pcInTailPtr - pg->pcInputPtr);
	int newlen = loop2;

	while (loop1-- > 0)
	    *s1++ = *s2++;
	while (loop2-- > 0)
	    *s1++ = ' ';
	put_string_on_page(ch, input_tr, input_pg, pg->pcInStartCol, 0,
			   input_pg->pcDefFontID,
			   pg->pcInputLeng, pg->pcInStartPtr);
	move_page_cursor(ch, input_tr, input_pg,
			 PGCSMOVE_ABSOLUTE, pg->pcInStartCol, 0);
	pg->pcInputLeng = newlen;
	pg->pcInputPtr = pg->pcInStartPtr;
	pg->pcInTailPtr = pg->pcInStartPtr + newlen;
	pg->pcInTailCol = pg->pcInStartCol + newlen;
    }
}

void input_redraw(ch, tr, pg, input_tr, input_pg, leng, str)
    yy_comm_channel *ch;
    TERRITORY *tr;
    TERRITORY_PAGE *pg;
    TERRITORY *input_tr;
    TERRITORY_PAGE *input_pg;
    int leng;
    char *str;
{
    sync_x_server(XPRIVATE(ch));
}

#ifdef WNNKINPUT
static int KInputMode = 0;

void input_start_kana_input(ch, tr, pg, input_tr, input_pg, leng, str)
    yy_comm_channel *ch;
    TERRITORY *tr;
    TERRITORY_PAGE *pg;
    TERRITORY *input_tr;
    TERRITORY_PAGE *input_pg;
    int leng;
    char *str;
{
    kinput_start_kana_input(input_pg);
    restore_input_edit_func_table(INPUTEDITTABLEKANA);
}
#endif /*WNNKINPUT*/


typedef struct _input_edit_func_table {
    int ftCharCode;
    void (*ftEditFunc)();
    struct _input_edit_func_table *ftNext;
} input_edit_func_table;

struct edit_funcs {
    char *efLabel;
    void (*efFunc)();
} ;

struct edit_func_init_table {
    char *eiCode;
    char *eiFuncLabel;
} ;

struct edit_funcs EditFuncTable[] = {
{ "inseart-character", input_inseart_one_char },
{ "beginning-of-line", input_beginning_of_line },
{ "backward-char", input_backward_char },
{ "delete-char", input_delete_char },
{ "end-of-line", input_end_of_line },
{ "forward-char", input_forward_char },
{ "delete-backward-char", input_delete_backward_char },
{ "kill-line", input_kill_line },
{ "redraw", input_redraw },
#ifdef WNNKINPUT
{ "start-kana-input", input_start_kana_input },
#endif /*WNNKINPUT*/
};

static input_edit_func_table *EditFuncs =
    (input_edit_func_table *)NULL;

static void append_edit_func_table(code, func_name)
    int code;
    char *func_name;
{
    struct edit_funcs *efunc;
    input_edit_func_table *newent;
    int loop;
    debug_setfunc("input", "append_edit_func_table");
    /* Get Call Address for the function */
    efunc = EditFuncTable;
    loop = sizeof(EditFuncTable)/sizeof(struct edit_funcs);
    for ( ; !strSAME(efunc->efLabel, func_name) ; efunc++, loop--)
	if (loop <= 0)
	    return;	/* No such function */
    /* Allocate Room for the function */
    newent = (input_edit_func_table *)memALLOC(sizeof(input_edit_func_table));
    if (newent == (input_edit_func_table *)NULL)
	return;
    debug_print(5, "charcode 0%o for '%s'\n", code, func_name);
    newent->ftCharCode = code;
    newent->ftEditFunc = efunc->efFunc;
    newent->ftNext = EditFuncs;
    EditFuncs = newent;
    debug_endfunc("append_edit_func_table");
}

static bool is_edit_control_char(c)
    register u_char c;
{
    return((isalpha(c) || c == '^'));
}

static bool is_edit_label_char(c)
    register u_char c;
{
    return((isalpha(c) || c == '-'));
}

char *skip_matched_char(str, func)
    register char *str;
    bool (*func)();
{
    if (*str == EOS)
	return (char *)NULL;
    while (*str != EOS && (*func)(*str))
	str++;
    return str;
}

char *skip_unmatched_char(str, func)
    register char *str;
    bool (*func)();
{
    if (*str == EOS)
	return (char *)NULL;
    while (*str != EOS && !(*func)(*str))
	str++;
    return str;
}

int get_charcode(str)
    register char *str;
{
    register bool ctrlcode = FALSE;
    register int code = 0;
    if (*str == '^') {
	ctrlcode = TRUE; str++;
    }
    if (!isalpha(*str))
	return 0;
    code = *str;
    if (ctrlcode)
	code &= 037;
    return code;
}


void init_edit_func_table(file)
    char *file;
{
    FILE *fp;
    char readbuf[BUFSIZ];
    debug_setfunc("input", "init_edit_func_table");
    /* Set Default Function */
    append_edit_func_table((-1), "inseart-character");
    if ((fp = fopen(file, "r")) == (FILE *)NULL) {
	return;
    }
    while (fgets(readbuf, sizeof(readbuf), fp) != (char *)NULL) {
	char *ctrlchar, *label, *e;
	if (!is_edit_control_char(readbuf[0]))
	    continue;
	/* Get Control Char */
	ctrlchar = &readbuf[0];
	e = skip_matched_char(ctrlchar, is_edit_control_char);
	if (e == (char *)NULL) continue;
	*e++ = EOS;
	/* Get Label */
	label = skip_unmatched_char(e, is_edit_label_char);
	if (label == (char *)NULL) continue;
	e = skip_matched_char(label, is_edit_label_char);
	if (e == (char *)NULL) continue;
	*e++ = EOS;
	debug_print(5, "Edit Function '%s' is called by '%s'\n",
		    label, ctrlchar);
	append_edit_func_table(get_charcode(ctrlchar), label);
    }
    fclose(fp);
    debug_endfunc("init_edit_func_table");
}

#ifdef WNNKINPUT
void init_kanji_edit_func_table()
{
    EditFuncs = (input_edit_func_table *)NULL;
    append_edit_func_table(get_charcode("^a", "XX"));
    append_edit_func_table(get_charcode("^a", "XX"));
    append_edit_func_table(get_charcode("^a", "XX"));
    set_input_edit_func_table(INPUTEDITTABLEKANA);
    EditFuncs = (input_edit_func_table *)NULL;
    append_edit_func_table(get_charcode("^a", "XX"));
    append_edit_func_table(get_charcode("^a", "XX"));
    append_edit_func_table(get_charcode("^a", "XX"));
    set_input_edit_func_table(INPUTEDITTABLEKANA);
}

static u_char kinput_buffer[128];
static int kinput_buffer_leng = 0;

int push_kinput_string(leng, str)
    int leng;
    u_char *str;
{
    while (leng > 0) {
	leng--;
	kinput_buffer[kinput_buffer_leng++] = *(str+leng);
    }
}

int pop_kinput_string()
{
    if (kinput_buffer_leng > 0) {
	register int ret = kinput_buffer[--kinput_buffer_leng];
	return ret;
    }
    return EOF;
}

void kinput_kana_inseart(ch, tr, pg, input_tr, input_pg, leng, str)
    yy_comm_channel *ch;
    TERRITORY *tr;
    TERRITORY_PAGE *pg;
    TERRITORY *input_tr;
    TERRITORY_PAGE *input_pg;
    int leng;
    char *str;
{
    input_inseart_one_char(ch, tr, pg, input_tr, input_pg, leng, str);
}
#endif /*WNNKINPUT*/


keyin_on_input_territory(ch, tr, leng, str)
    yy_comm_channel *ch;
    TERRITORY *tr;
    int leng;
    char *str;
{
    /* Ϥ줿ʸ򸫤ưʲ input_ function 椫Ĥ
       ӸƤӽФ
       */
    TERRITORY_PAGE *pg;
    TERRITORY *input_tr;
    TERRITORY_PAGE *input_pg;
    input_edit_func_table *ent;
    debug_setfunc("page", "keyin_on_input_territory");
    pg = &tr->teModeEnt.tPageControl;
    if (pg->pcPageMode == 0 || !pg->pcDoKeyInput) {
	/* This Territory has no input procedure - ignore this input */
	goto send_reply;
    }
    input_tr = pg->pcKeyInTerritory;
    input_pg = &input_tr->teModeEnt.tPageControl;
    delete_character_cursor(ch, input_tr, input_pg);
#ifdef WNNKINPUT
    if (KInputMode > 0) {
	u_int i;
	u_char work[4];
	push_kinput_string(leng, str);
	for (;;) {
	    i = romkan_getc();
	    if (i == EOLTTR || i == CHMSIG || i == NISEBP || i == LTREOF ||
		i == REDRAW || i == NISEDL)
		break;
	    if (i & (0377<<8)) { /* 2 */
		work[0] = ((i >> 8) & 0377); work[1] = (i & 0377);
		kinput_kana_inseart(ch, tr, pg, input_tr, input_pg,2,work);
	    } else {
		work[0] = (u_char)(i & 0377);
		for (ent = EditFuncs;
		     ent != (input_edit_func_table *)NULL; ent = ent->ftNext) {
		    if (work[0] == ent->ftCharCode) {
			(*ent->ftEditFunc)(ch,tr,pg,input_tr,input_pg,1,work);
			break;
		    }
		}
		if (ent == (input_edit_func_table *)NULL)
		    kinput_kana_inseart(ch,tr,pg,input_tr,input_pg, 1,work);
	    }
	}
    } else {
	for (ent = EditFuncs;
	     ent != (input_edit_func_table *)NULL; ent = ent->ftNext) {
	    if (*str == ent->ftCharCode) {
		(*ent->ftEditFunc)(ch, tr, pg, input_tr, input_pg, leng, str);
	    }
	}
    }
#else /*!WNNKINPUT*/
    for (ent = EditFuncs;
	 ent != (input_edit_func_table *)NULL; ent = ent->ftNext) {
	if (*str == ent->ftCharCode) {
	    (*ent->ftEditFunc)(ch, tr, pg, input_tr, input_pg, leng, str);
	}
    }
    if (ent == (input_edit_func_table *)NULL)
	input_inseart_one_char(ch, tr, pg, input_tr, input_pg, leng, str);
#endif /*!WNNKINPUT*/
    put_character_cursor_on_page(ch, input_tr, input_pg);
    sync_x_server(XPRIVATE(ch));
 send_reply:
    debug_endfunc("keyin_on_input_territory");
}



/*
 * Local variables:
 * eval: (set-kanji-fileio-code 'EUC)
 * end:
 */
