#ifndef lint
static char *RcsId="$Id: error.c,v 2.6 91/03/13 21:46:50 keisuke Exp $";
#endif

/* Support Error on YY-server
 * This file is part of YY-server of YYonX (1.3 Distribution)
 * $Id: error.c,v 2.6 91/03/13 21:46:50 keisuke Exp $
 */

/****************************************************************************
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   Version 1.0 90/03/19 by Keisuke 'Keiko' Tanaka
;;;				(keisuke@csrl.aoyama.ac.jp)
;;;   Version 2.0 90/08/27 by Keisuke 'Keiko' Tanaka
;;;			Page Mode Territory is supported
;;;   Version 2.1 90/11/05 by Keisuke 'Keiko' Tanaka
;;;			Copyright Notice is rewritten
;;;
****************************************************************************/

/****************************************************************************
  $Revision: 2.6 $ Written by Keisuke 'Keiko' Tanaka
  $Date: 91/03/13 21:46:50 $
****************************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include "yydefs.h"
#include "yypacket.h"

struct err_code_tab {
	int erCode;
	char *erLabel;
} ;

struct err_code_tab ErrCodes[] = {
{ YYERROR_NOTYYPACKET, "Not YY Packet!!" },
{ YYERROR_NODISP, "No Such Display" },
{ YYERROR_NOTERRITORY, "No such Territory!!" },
{ YYERROR_NOCOLOR, "No such Color Name" },
{ -1, "Unknown Error" }
} ;

yy_packet *create_error_packet(pkt, errcode)
	yy_packet *pkt;
	int errcode;
{
	yy_packet *repl;
	debug_setfunc("control", "create_error_packet");
	if (debug_on(1)) {
		struct err_code_tab *err = ErrCodes;
		for (err = ErrCodes; err->erCode > 0; err++)
			if (err->erCode == errcode)
				break;
		debug_print(1, "YY ERROR (CODE:%d, '%s')\n",
			    errcode, err->erLabel);
	}
	repl = ALLOC_ERRPACKET(pkt);
	append_packet_entry_integer(repl, errcode);
	debug_endfunc("create_error_packet");
	return repl;
}
