#ifndef lint
static char *RcsId="$Id: comm.c,v 2.16 91/03/13 21:46:39 keisuke Exp $";
#endif

/* Routines for YY-protocol
 * This file is part of YY-server of YYonX (1.3 Distribution)
 * $Id: comm.c,v 2.16 91/03/13 21:46:39 keisuke Exp $
 */

/****************************************************************************
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   Version 1.0 90/02/26 by Keisuke 'Keiko' Tanaka
;;;				(keisuke@csrl.aoyama.ac.jp)
;;;   Version 2.0 90/08/27 by Keisuke 'Keiko' Tanaka
;;;			Page Mode Territory is supported
;;;   Version 2.2 90/11/05 by Keisuke 'Keiko' Tanaka
;;;			Copyright Notice is rewritten
;;;
****************************************************************************/

/****************************************************************************
  $Revision: 2.16 $ Written by Keisuke 'Keiko' Tanaka
  $Date: 91/03/13 21:46:39 $
****************************************************************************/

#include <stdio.h>
#include <ctype.h>
#include <signal.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <netinet/in.h>
#include "yydefs.h"
#include "yypacket.h"

/*
 * Communication
 */

extern int YYPacketBlockSize;

static void recv_yy_packet();
static void send_yy_packet();
static void send_yy_event_packet();

#define QUE(c)		(&(c)->ccSystemQueue)
#define SENDQ(c)	((c)->ccSystemQueue.sysqSend)
#define SENDEVENTQ(c)	((c)->ccSystemQueue.sysqEvent)
#define READQ(c)	((c)->ccSystemQueue.sysqRead)
#define RECVQ(c)	((c)->ccSystemQueue.sysqRecv)
#define WRITEQ(c)	((c)->ccSystemQueue.sysqWrite)

static yy_font_table *alloc_font_table();

yy_comm_channel *make_channel(no)
    int no; /* Server Number */
{
    yy_comm_channel *ch;
    int fd;
    debug_setfunc("network", "make_channel");
    /* Get One Channel for YY client */
    ch = (yy_comm_channel *)malloc(sizeof(yy_comm_channel));
    if (ch == (yy_comm_channel *)NULL)
	return (yy_comm_channel *)NULL;
    /* Entries for X Window System */
    ch->ccXFd = -1;
    ch->ccXNeedFlush = FALSE;
    ch->ccXPrivate = (char *)NULL;
    /* Entries for YY Client */
    ch->ccYYServNo = no;
    ch->ccYYCmdCH.FD = ch->ccYYEvtCH.FD = -1;	/* Socket */
    ch->ccYYSyncCount = ch->ccYYSyncPacketNum = 0;
    /* Font Table */
    ch->ccFontTable = alloc_font_table(YYFONTINFOFILE);
    /* Packet Queue */
    SENDQ(ch) = RECVQ(ch) = SENDEVENTQ(ch) = (YYPKTQUEENT *)NULL;
    READQ(ch) = WRITEQ(ch) = (YYPKTQUEENT *)NULL;
    /* TimeOut Table */
    ch->ccYYWaitTime = DEFAULTTIMEOUT*1000;
    ch->ccYYXFlushCount = (TIMEOUTFORXFLUSH/DEFAULTTIMEOUT);
    ch->ccYYKeyinCount = (TIMEOUTFORKEYIN/DEFAULTTIMEOUT);
#ifdef DEBUG
    /* Debug Table */
    ch->ccDeBugTable.dbWriteBlocked = 0;
    ch->ccDeBugTable.dbTimer.tv_sec = 0;
    ch->ccDeBugTable.dbTimer.tv_usec = 0;
#endif
    /* Create New Sockets for waiting YY Request */
    if (wait_connection(&(ch->ccYYChannel), no) < 0) {
	fprintf(stderr, "Can't Setup Connection with YY Client..\n");
	return (yy_comm_channel *)NULL;
    }
    debug_endfunc("make_channel");
    return ch;
}

int set_inet_port(no)
    int no;	/* Server # */
{
    struct sockaddr_in addr;
    int retry;
    int sock;
    debug_setfunc("network", "set_inet_port");
    if ((sock = socket(PF_INET, SOCK_STREAM, 0)) < 0) {
	perror("Socket");
	return -1;
    }
    bzero((char *)&addr, sizeof(addr));
    addr.sin_family = PF_INET;
    addr.sin_port = htons(YYPROTO_INET_PORT+no);
    debug_print(1, "waiting on PORT#%d\n", ntohs(addr.sin_port));
    retry = 5;
    while (bind(sock, (struct sockaddr *)&addr, sizeof(addr)) < 0) {
	if (--retry == 0) {
	    perror("bind");
	    return -1;
	}
	sleep(5);
    }
    if (listen(sock, 1) < 0) {
	perror("listen");
	return -1;
    }
    debug_endfunc("set_inet_port");
    return sock;
}

int set_unix_port(no)
    int no;
{
    int sock;
    struct sockaddr_un addr;
    int retry;
    debug_setfunc("network", "set_unix_port");
    if ((sock = socket(PF_UNIX, SOCK_STREAM, 0)) < 0) {
	perror("Socket");
	return -1;
    }
    bzero((char *)&addr, sizeof(addr));
    addr.sun_family = PF_UNIX;
    sprintf(addr.sun_path, "%s%d", YYPROTO_UNIX_PORT, no);
    unlink(addr.sun_path);
    debug_print(1, "waiting on PORT'%s'\n", addr.sun_path);
    retry = 5;
    while (bind(sock, (struct sockaddr *)&addr, sizeof(addr)) < 0) {
	if (--retry == 0) {
	    perror("bind");
	    return -1;
	}
	sleep(5);
    }
    if (listen(sock, 1) < 0) {
	perror("listen");
	return -1;
    }
    debug_endfunc("set_unix_port");
    return sock;
}

int wait_first_connection(ireq, ureq)
    int ureq;	/* UNIX Domain */
    int ireq;	/* INET Doamin */
{
    int width = MAX(ureq, ireq)+1;
    fd_set rfds;

    debug_setfunc("network", "wait_first_connection");
    for (;;) {
	FD_ZERO(&rfds);
	FD_SET(ireq, &rfds);
	FD_SET(ureq, &rfds);
	if (select(width, &rfds, NULL, NULL, NULL) < 0) {
	    perror("Select");
	    return -1;
	}
	if (FD_ISSET(ireq, &rfds))
	    return ireq;
	if (FD_ISSET(ureq, &rfds))
	    return ureq;
    }
    /*NOTREACHED*/
}

int wait_second_connection(req)
    int req;
{
    struct sockaddr addr;
    int addrlen;
    int sock;
    debug_setfunc("network", "wait_second_connection");
    addrlen = sizeof(addr);
    if ((sock = accept(req, &addr, &addrlen)) < 0) {
	perror("accept");
	return -1;
    }
    debug_print(1, "accept request on %d/%s\n", sock,
		(addr.sa_family == PF_UNIX? "UNIX": "INET"));
    debug_endfunc("wait_second_connection");
    return sock;
}


int wait_connection(yych, no)
    struct _yy_channel_for_yy_client *yych;
{
    int req;	/* Request Port to be Accepted */
    struct sockaddr addr;
    int addrlen;

    debug_setfunc("network", "wait_connection");
    /* Create Two Request Ports */
    if ((yych->yyUnixReqFd = set_unix_port(no)) < 0 ||
	(yych->yyInetReqFd = set_inet_port(no)) < 0) {
	fprintf(stderr, "Can't Create Socket (for Request)!!\n");
	return -1;
    }
    /* Wait First Request on Request Port */
    req = wait_first_connection(yych->yyUnixReqFd,yych->yyInetReqFd);
    if (req < 0) {
	fprintf(stderr, "Can't Find New Request!!\n");
	return -1;
    }
    /* Accept Connection Request */
    addrlen = sizeof(addr);
    if ((yych->yyCmdCH.FD = accept(req, &addr, &addrlen)) < 0) {
	perror("Accept");
	return -1;
    }
    if ((yych->yyStatBuf.csDomain = addr.sa_family) == PF_UNIX) {
	/* UNIX Domain */
	debug_print(1, "accept request on %d/UNIX\n",
		    yych->yyCmdCH.FD);
	req = set_unix_port(yych->yyServNo+1);
    } else {
	debug_print(1, "accept request on %d/INET\n",
		    yych->yyCmdCH.FD);
	req = set_inet_port(yych->yyServNo+1);
    }
    yych->yyMaxPacketSize = get_packet_size(yych->yyCmdCH.FD);
    if ((yych->yyEvtCH.FD = wait_second_connection(req)) < 0)
	return -1;
    debug_endfunc("wait_connection");
    return 0;
}

void timeout_on_yy_connection()
{
    cleanup(EX_IOERR, "I/O Error on TCP connection for YY\n");
}

send_to_yy_connection(sock, buf, leng)
    int sock;
    u_char *buf;
    int leng;
{
    register u_char *s = buf;
    register int l = leng;
    void (*old_func)();
    
    debug_setfunc("network", "send_to_yy_connection");
    old_func = signal(SIGALRM, timeout_on_yy_connection);
    while (l > 0) {
	register int slen;
	alarm(5);
	if ((slen = send(sock, s, l, 0)) <= 0) {
	    if (slen < 0) {
		cleanup(EX_IOERR, "Output Error on YY Connection\n");
	    }
	    cleanup(EX_OK, "YY Connection has been closed...\n");
	}
	alarm(0);
	l -= slen;
	s += slen;
    }
    signal(SIGALRM, old_func);
    debug_endfunc("send_to_yy_connection");
    return leng;
}

int recv_from_yy_connection(sock, buf, leng)
    int sock;
    u_char *buf;
    int leng;
{
    register u_char *s = buf;
    register int l = leng;
    void (*old_func)();

    debug_setfunc("network", "recv_from_yy_connection");
    old_func = signal(SIGALRM, timeout_on_yy_connection);
    while (l > 0) {
	register int rlen;
	fd_set rfds;
	FD_ZERO(&rfds);
	FD_SET(sock, &rfds);
	if ((rlen = select(sock+1, &rfds, NULL, NULL, NULL)) < 0) {
	    extern int errno;
	    cleanup(EX_IOERR, "Error on select(READ) (%d)\n", errno);
	}
	alarm(10);
	if ((rlen = recv(sock, s, l, 0)) <= 0) {
	    if (rlen < 0) {
		extern int errno;
		cleanup(EX_IOERR, "Input Error on YY Connection (%d)\n",
			errno);
	    }
	    cleanup(EX_OK, "YY Connection has been closed...\n");
	}
	alarm(0);
	l -= rlen;
	s += rlen;
    }
    signal(SIGALRM, old_func);
    debug_endfunc("recv_from_yy_connection");
    return leng;
}


int get_packet_size(sock)
    int sock;
{
    int leng, rlen;
    char buf[8];
    char *s;
    int magic, size;
    debug_setfunc("network", "get_packet_size");

    /* Recv first 8 octets
     * Packet Format:
     *  +--------+--------+--------+--------+
     *  |  M  A  G  I  C  N  U  M  B  E  R  |
     *  +--------+--------+--------+--------+
     *  |  P  A  C  K  E  T  S  I  Z  E     |
     *  +--------+--------+--------+--------+
     */
    recv_from_yy_connection(sock, buf, 8);
    bcopy(buf, (char *)&magic, 4);
    bcopy(&buf[4], (char *)&size, 4); size <<= 2;
    debug_print(1, "YYPacketBlockSize in YY-Client is %d\n", size);
    debug_print(1, "YY-Server assumes %d\n", YYPacketBlockSize);
    if (YYPacketBlockSize < size) {
	debug_print(1, " .. No! YYPacketBlockSize = %d\n", YYPacketBlockSize);
	size = YYPacketBlockSize;
    } else {
	debug_print(1, " .. OK! We accept it\n", YYPacketBlockSize);
	YYPacketBlockSize = size;
    }
    size >>= 2; bcopy((char *)&size, &buf[4], 4);
    send_to_yy_connection(sock, buf, 8);
    debug_endfunc("get_packet_size");
    return (size >> 2);
}



int wait_for_request(channel)
    yy_comm_channel *channel;
{
    int xfd = channel->ccXFd;
    int yyfd = channel->ccYYFd;
    int yyfd2 = channel->ccYYFd2;
    int width = 0;
    fd_set rfds, wfds;
    YYPKTQUEENT *rq;
    int ret;
    yy_timeout_table timecount;
    struct timeval timeout;
#ifdef DEBUG
    bool check_norm_blocked = FALSE;
    bool check_event_blocked = FALSE;
#endif

    debug_setfunc("network", "wait_for_request");
    timecount.toXFlushCount = channel->ccYYXFlushCount;
    timecount.toKeyinCount = channel->ccYYKeyinCount;
    timecount.toDClickCount = channel->ccYYDClickCount;
 retry:
    FD_ZERO(&rfds);
    FD_ZERO(&wfds);
    /* X input */
    if (xfd >= 0) {
	debug_print(8, " waiting on X-connection (recv)\n");
	get_events_on_x_server(channel, FALSE);
	width = MAX(width, xfd);
	FD_SET(xfd, &rfds);
    }
    /* YY input */
    if (yyfd >= 0) {
	debug_print(8, " waiting on YY-connection (recv)\n");
	width = MAX(width, yyfd);
	FD_SET(yyfd, &rfds);
	if (SENDQ(channel) != (YYPKTQUEENT *)NULL) {
	    debug_print(8, " waiting on YY-connection (send)\n");
	    FD_SET(yyfd, &wfds);
#ifdef DEBUG
	    check_norm_blocked = TRUE;
#endif
	}
    }
    /* YY Event */
    if (yyfd2 >= 0) {
	if (SENDEVENTQ(channel) != (YYPKTQUEENT *)NULL) {
	    debug_print(8, " waiting on YY-connection (event)\n");
	    width = MAX(width, yyfd2);
	    FD_SET(yyfd2, &wfds);
#ifdef DEBUG
	    check_event_blocked = TRUE;
#endif
	}
    }
    /* Waiting.. */
    timeout.tv_sec = 0;
    timeout.tv_usec = channel->ccYYWaitTime;
    debug_print(8, " with TIMEOUT (%dusec)\n", timeout.tv_usec);
    ret = select(width+1, &rfds, &wfds, NULL, &timeout);
    if (ret < 0) {
	fprintf(stderr, "ERROR ON SELECT!!!!!");
	return -1;
    }
    if (ret == 0) {
	/* TimeOut */
	register bool doretry = TRUE;
	debug_print(8, "Timeout.. \n");
	if (channel->ccXNeedFlush &&
	    (--timecount.toXFlushCount) <= 0) {
	    debug_print(8, "Send XFlush Request\n");
	    sync_x_server(channel->ccXPrivate);
	    channel->ccXNeedFlush = FALSE;
	    doretry = FALSE;
	}
	if (channel->ccYYHaveKeyIN &&
	    (--timecount.toKeyinCount) <= 0) {
	    debug_print(8, "Send Keyin Data\n");
	    send_keyin_string(channel);
	    doretry = FALSE;
	}
	sched_animation(channel);
	if (doretry)
	    goto retry;
    } else {
	/* X Event? */
	if (xfd >= 0 && FD_ISSET(xfd, &rfds)) {
	    /* get next X event */
	    debug_print(8, " recv packet on X-connection\n");
	    get_events_on_x_server(channel, TRUE);
	}
	/* YY Packet? */
	if (yyfd >= 0 && FD_ISSET(yyfd, &rfds)) {
	    /* recv and make recv queue */
	    debug_print(8, " recv packet on YY-connection\n");
	    (void)recv_yy_packet(yyfd, QUE(channel));
	}
	if (yyfd >= 0 && FD_ISSET(yyfd, &wfds)) {
	    /* send and remove from queue */
	    debug_print(8, " we can send packet on YY-connection\n");
	    (void)send_yy_packet(yyfd, QUE(channel));
	}
#ifdef DEBUG
	else if (check_norm_blocked)
	    channel->ccDeBugTable.dbWriteBlocked++;
#endif
	if (yyfd2 >= 0 && FD_ISSET(yyfd2, &wfds)) {
	    /* send event packet and remove from queue */
	    debug_print(8, " we can send event on YY-connection\n");
	    (void)send_yy_event_packet(yyfd2, QUE(channel));
	}
#ifdef DEBUG
	else if (check_event_blocked)
	    channel->ccDeBugTable.dbWriteBlocked++;
#endif
    }
    if (READQ(channel) != (YYPKTQUEENT *)NULL) {
	debug_print(8, " we have a YY packet in the queue\n");
	dispatch_command(channel, get_packet_from_readq(QUE(channel)));
    }
    sched_animation(channel);
    debug_endfunc("wait_for_request");
    return 0;
}

send_keyin_string(CH)
    yy_comm_channel *CH;
{
    debug_setfunc("network", "send_keyin_string");
    debug_endfunc("send_keyin_string");
}

#define YYHEADERSIZE	sizeof(yy_packet_header)

static void recv_yy_packet(yyfd, queue)
    int yyfd;
    yy_packet_system_queue *queue;
{
    int leng, pleng, body;
    byte *bp = (byte *)alloc_packet_data_area();
    debug_setfunc("network", "recv_yy_packet");
    debug_print(5, "Allocate %dbytes for new packet\n", YYPacketBlockSize);
    /* Recv Header Info */
    recv_from_yy_connection(yyfd, bp, YYHEADERSIZE);
    debug_print(5, "recv Header Info\n");
    if (debug_on(7)) {
	register int l; register byte *s;
	for (l = YYHEADERSIZE, s = bp; l > 0 ; l--, s++)
	    debug_print(7, " %02x", ((*s)&0377));
	debug_print(7, "\n");
    }
    /* Get Packet Length */
    bcopy(bp, (byte *)&pleng, 4);
    pleng = ((pleng & 07777) << 2);
    body = pleng - YYHEADERSIZE;
    debug_print(5, "Header said length is %d (body:%d)\n", pleng, body);
    recv_from_yy_connection(yyfd, bp+YYHEADERSIZE, body);
    debug_print(9, " recv one block (LENGTH:%d)\n", pleng);
    put_block_on_recvq(queue, bp, pleng);
    debug_endfunc("recv_yy_packet");
}

static void send_yy_packet(yyfd, queue)
    int yyfd;
    yy_packet_system_queue *queue;
{
    int leng;
    byte *bp;
    debug_setfunc("network", "send_yy_packet");
    if (get_block_from_sendq(queue, &bp, &leng) > 0) {
	debug_print(9, " send one block (LENGTH:%d)\n",leng);
	if (send(yyfd, bp, leng, 0) != leng) {
	    fprintf(stderr, "BOOOOOOM!! (in send)\n");
	    return;
	}
    }
    debug_endfunc("send_yy_packet");
}

static void send_yy_event_packet(fd, queue)
    int fd;
    yy_packet_system_queue *queue;
{
    int leng;
    byte *bp;
    debug_setfunc("network", "send_yy_event_packet");
    if (get_block_from_eventq(queue, &bp, &leng) > 0) {
	debug_print(9, " send one block (LENGTH:%d)\n",leng);
	if (send(fd, bp, leng, 0) != leng) {
	    fprintf(stderr, "BOOOOOOM!! (in send)\n");
	    return;
	}
    }
    debug_endfunc("send_yy_event_packet");
}

void sync_packet(channel, cmd, pkt)
    yy_comm_channel *channel;
    int cmd;
    yy_packet *pkt;
{
    debug_setfunc("packet", "sync_packet");
    if (pkt == (yy_packet *)NULL) {
	channel->ccYYSyncCount--;
	if (channel->ccYYSyncCount > 0)
	    return;
	pkt = alloc_new_yy_packet(cmd, YYPACKETTYPE_SYNC, 0, NULL);
	channel->ccYYSyncCount = channel->ccYYSyncPacketNum;
	debug_print(3, "Send Sync Packet (%d)\n",
		    channel->ccYYSyncPacketNum);
    } else {
	channel->ccYYSyncCount = channel->ccYYSyncPacketNum;
    }
    put_packet_on_sendq(QUE(channel), pkt);
    debug_endfunc("sync_packet");
}

#ifdef DEBUG
yy_packet *yycom_debug_show_table(CH, pkt)
	yy_comm_channel *CH;
	yy_packet *pkt;
{
	debug_setfunc("debug", "yycom_debug_show_table");
	debug_print(1, "Write Block: %d\n", CH->ccDeBugTable.dbWriteBlocked);
	debug_print(1, "Timer: %5d.%06d\n",
		    CH->ccDBTimer.tv_sec, CH->ccDBTimer.tv_usec);
	debug_endfunc("yycom_debug_show_table");
	return (yy_packet *)NULL;
}
#endif /* DEBUG */

#ifdef notdef
#define IPCCHTYPE_UDPPORT	01
#define IPCCHTYPE_TCPPORT	02

#define IPCCHTYPE_LOCAL		010
#define IPCCHTYPE_REMOTE	020

#define IPCCHTYPE_RECVONLY	0100
#define IPCCHTYPE_SENDONLY	0200
#define IPCCHTYPE_SENDRECV	0400

#define IPCCHSTAT_ACTIVE	01
#define IPCCHSTAT_ERROR		02

typedef struct _yy_ipc_channel_ YYIPCCHANNEL;
struct _yy_ipc_channel_ {
    int ipcFD;
    int ipcType;
    int ipcStatus;
    struct yypktquetab *ipc;
    char *ipcPrivate;
    struct ipcfunctab *ipcFuncs;
} ;

int local_udp_ipc_open(ipcch)
    YYIPCCHANNEL *ipcch;
{
    if (ipcch->Status & IPCCHSTAT_ACTIVE)
	return 0;
    if (ipcch->Status & IPCCHSTAT_ERROR)
	return 1;
    
    
}

#endif
/*
 * Local variables:
 * eval: (set-kanji-fileio-code 'EUC)
 * end:
 */
