#ifndef lint
static char *RcsId="$Id: com_page.c,v 2.6.2.17 91/03/13 21:46:23 keisuke Exp $";
#endif

/* Function to support Page Territory
 * This file is part of YY-server of YYonX (1.3 Distribution)
 * $Id: com_page.c,v 2.6.2.17 91/03/13 21:46:23 keisuke Exp $
 */

/****************************************************************************
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   Version 1.0 90/08/26 by Keisuke 'Keiko' Tanaka
;;;				(keisuke@csrl.aoyama.ac.jp)
;;;   Version 2.0 90/08/27 by Keisuke 'Keiko' Tanaka
;;;			Page Mode Territory is supported
;;;   Version 2.6.2.1 90/11/05 by Keisuke 'Keiko' Tanaka
;;;			Branch for Distribution version 1.2
;;;			functions in com_page.c should be rewitten,
;;;			and this branch must be removed after new codes
;;;   Version 2.6.2.2 90/11/05 by Keisuke 'Keiko' Tanaka
;;;			Copyright Notice is rewritten
;;;
****************************************************************************/

/****************************************************************************
  $Revision: 2.6.2.17 $ Written by Keisuke 'Keiko' Tanaka
  $Date: 91/03/13 21:46:23 $
****************************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include "yydefs.h"
#include "yypacket.h"
#include "xwindow.h"
#include "territory.h"
#include "yyfont.h"

/*
 * Page Mode Territory
 */

static void dump_page_plane(plane)
    PAGEPLANE *plane;
{
    int b_no = 0;
    PAGEBLOCK *pb;
    debug_setfunc("page", "dump_page_plane");
    debug_print(1, "Total Line=%d, Physical Line=%d\n",
		plane->ppLogicalLines, plane->ppPhysicalLines);
    for (pb = plane->ppBlocks; pb != (PAGEBLOCK *)NULL; pb = pb->pbNextBlock) {
	PAGELINE *pl;
	int lin = pb->pbLogicalLines;
	b_no++;
	debug_print(2, " Block#%d (Logical Line=%d, Physical Line=%d)\n",
		    b_no, pb->pbLogicalLines, pb->pbPhysicalLines);
	for (pl = pb->pbFirstLine; lin > 0; pl = pl->plNextLine, lin--) {
	    PAGESTR *ps;
	    debug_print(3, "  Line#%d (Column=%d, Physical Line=%d)\n",
			pb->pbLogicalLines-lin+1, pl->plColNum, pl->plLineNum);
	    for (ps = pl->plFirstStr; ps != (PAGESTR *)NULL; ps = ps->psNext) {
		debug_print(4, "   String: Nchar=%d, Leng=%d, FID=%d\n",
			    ps->nchar, ps->leng, ps->fid);
		debug_print(4, "           posX=%d, posLin=%d, Width=%d\n",
			    ps->posX, ps->posLin, ps->width);
	    }
	}
    }
    debug_endfunc("dump_page_plane");
}

get_cursor_size(ch, tr, pg, col, row, x, y, w, h)
    yy_comm_channel *ch;
    TERRITORY *tr;
    TERRITORY_PAGE *pg;
    int *x, *y, *w, *h;
{
    int c = col;
    int r = row;
    int p_row = 0;
    PAGELINE *pl;

    if (pg->pcPagePlane.ppBlocks != (PAGEBLOCK *)NULL) {
	PAGELINE *pl = pg->pcPagePlane.ppBlocks->pbFirstLine;
	while (pl != (PAGELINE *)NULL && r > 0) {
	    p_row += pl->plLineNum; pl = pl->plNextLine; r--;
	}
	if (pl != (PAGELINE *)NULL) {
	    register PAGESTR *ps = pl->plFirstStr;
	    register PAGESTR *pr = (PAGESTR *)NULL;
	    while (ps != (PAGESTR *)NULL && c > 0) {
		c--; 	ps = (pr = ps)->psNext;
	    }
	    if (ps != (PAGESTR *)NULL) {
		*x = ps->posX;
		*y = (p_row+ps->posLin)*pg->pcLineSkip;
		*w = ps->width;
		*h = pg->pcLineSkip;
	    } else if (pr != (PAGESTR *)NULL) {
		TEXTBOX *cs;
		cs = YYTextSize(ch, pg->pcDefFontID, PAGE_DIR(pg),1," ",0,0);
		*x = pr->posX + pr->width + cs->w*c;
		*y = (p_row+pr->posLin)*pg->pcLineSkip;
		*w = cs->w;
		*h = pg->pcLineSkip;
	    } else {
		TEXTBOX *cs;
		cs = YYTextSize(ch, pg->pcDefFontID, PAGE_DIR(pg),1," ",0,0);
		*x = col*cs->w;
		*y = p_row*pg->pcLineSkip;
		*w = cs->w;
		*h = pg->pcLineSkip;
	    }
	} else {
	    TEXTBOX *cs;
	    cs = YYTextSize(ch, pg->pcDefFontID, PAGE_DIR(pg), 1, " ", 0, 0);
	    *x = cs->w*col;
	    *y = (p_row+r) * pg->pcLineSkip;
	    *w = cs->w;
	    *h = pg->pcLineSkip;
	}
    } else {
	TEXTBOX *cs;
	cs = YYTextSize(ch, pg->pcDefFontID, PAGE_DIR(pg), 1, " ", 0, 0);
	*x = cs->w*col;
	*y = r * pg->pcLineSkip;
	*w = cs->w;
	*h = pg->pcLineSkip;
    }
}

draw_character_cursor(ch, tr, pg, x, y, w, h)
    yy_comm_channel *ch;
    TERRITORY *tr;
    TERRITORY_PAGE *pg;
    int x, y, w, h;
{
    GC wgc;
    x_private *xp = XPRIVATE(ch);
    TERRITORY_X_ENTRY *tx = GetTerritoryXEntry(tr);
    XGCValues gcv;

    gcv.function = GXequiv;
    gcv.foreground = tx->txBackGroundColor.xcPixel;
    wgc = XCreateGC(xp->xDisp, tx->txWindow, (GCFunction|GCForeground), &gcv);
    XCopyGC(xp->xDisp, tx->txGC, GCBackground, wgc);
    XFillRectangle(xp->xDisp, tx->txWindow, wgc, x, y, w, h);
    sync_x_server(XPRIVATE(ch));
    XFreeGC(xp->xDisp, wgc);
}

    
put_character_cursor_on_page(ch, tr, pg)
    yy_comm_channel *ch;
    TERRITORY *tr;
    TERRITORY_PAGE *pg;
{
    int x, y, w, h;
    debug_setfunc("input", "put_character_cursor_on_page");
    get_cursor_size(ch, tr, pg, pg->pcCurXPos, pg->pcCurYPos, &x, &y, &w, &h);
    draw_character_cursor(ch, tr, pg, x, y, w, h);
    pg->pcCSX = x, pg->pcCSY = y;
    pg->pcCSW = w, pg->pcCSH = h;
    debug_print(1, "Put Character Cursor on Territory (%d,%d)[%d,%d]\n",
		x, y, w, h);
    debug_endfunc("put_character_cursor_on_page");
}

delete_character_cursor(ch, tr, pg)
    yy_comm_channel *ch;
    TERRITORY *tr;
    TERRITORY_PAGE *pg;
{
    debug_setfunc("input", "delete_character_cursor");
    if (pg->pcCSX >= 0) {
	draw_character_cursor(ch, tr, pg,
			      pg->pcCSX, pg->pcCSY, pg->pcCSW, pg->pcCSH);
	debug_print(1, "Remove Character Cursor on Territory (%d,%d)[%d,%d]\n",
		    pg->pcCSX, pg->pcCSY, pg->pcCSW, pg->pcCSH);
    }
    debug_endfunc("delete_character_cursor");
}


void clear_page_territory(ch, tr, color)
    yy_comm_channel *ch;
    TERRITORY *tr;
    x_color color;
{
    TERRITORY_PAGE *pg = GetPageTerritoryEnt(tr); /* Page Control Block */
    debug_setfunc("page", "clear_page_territory");
    pg->pcCSX = pg->pcCSY = -1;
    pg->pcCurXPos = pg->pcCurYPos = 0;
    pg->pcCurColumn = pg->pcCurLine = 0;
    pg->pcMaxColumn = pg->pcMaxLine = 0;
    pg->pcXpixel = pg->pcYpixel = 0;
    pg->pcDoKeyInput = FALSE;
    /* destroy page plane */
    if (pg->pcPagePlane.ppBlocks != (PAGEBLOCK *)NULL) {
	PAGEBLOCK *pb = pg->pcPagePlane.ppBlocks;
	PAGELINE *pl = pg->pcPagePlane.ppBlocks->pbFirstLine;
	while (pl != (PAGELINE *)NULL) {
	    register PAGELINE *next_pl = pl->plNextLine;
	    register PAGESTR *ps = pl->plFirstStr;
	    while (ps != (PAGESTR *)NULL) {
		register PAGESTR *next_ps = ps->psNext;
		(void)free((char *)ps);
		ps = next_ps;
	    }
	    (void)free((char *)pl);
	    pl = next_pl;
	}
	while (pb != (PAGEBLOCK *)NULL) {
	    register PAGEBLOCK *next_pb = pb->pbNextBlock;
	    (void)free((char *)pb);
	    pb = next_pb;
	}
	pg->pcPagePlane.ppBlocks = (PAGEBLOCK *)NULL;
    }
    pg->pcPagePlane.ppLogicalLines = 0;
    pg->pcPagePlane.ppPhysicalLines = 0;
    debug_endfunc("clear_page_territory");
}

PAGESTR *create_empty_pagestr()
{
    PAGESTR *ps;
    if ((ps = (PAGESTR *)memALLOC(sizeof(PAGESTR))) != (PAGESTR *)NULL)
	bzero((char *)ps, sizeof(PAGESTR));
    return ps;
}

PAGELINE *create_one_empty_line()
{
    PAGELINE *pl;
    if ((pl = (PAGELINE *)memALLOC(sizeof(PAGELINE))) != (PAGELINE *)NULL)
	bzero((char *)pl, sizeof(PAGELINE));
    return pl;
}

PAGEBLOCK *create_one_empty_block()
{
    PAGEBLOCK *pb;
    if ((pb = (PAGEBLOCK *)memALLOC(sizeof(PAGEBLOCK))) != (PAGEBLOCK *)NULL)
	bzero((char *)pb, sizeof(PAGEBLOCK));
    return pb;
}

static void crack_page_block(pb)
    PAGEBLOCK *pb;
{
    PAGEBLOCK *newpb = create_one_empty_block();
    PAGELINE *pl = pb->pbFirstLine;
    int line = pb->pbLogicalLines - 1;
    while (line-- > 0)
	pl = pl->plNextLine;
    newpb->pbFirstLine = pl;
    newpb->pbLogicalLines = 1;
    newpb->pbPhysicalLines = pl->plLineNum;
    pb->pbLogicalLines--;
    pb->pbPhysicalLines -= pl->plLineNum;
    /* Link Info */
    newpb->pbNextBlock = pb->pbNextBlock;
    newpb->pbPrevBlock = pb;
    if (pb->pbNextBlock != (PAGEBLOCK *)NULL)
	pb->pbNextBlock->pbPrevBlock = newpb;
    pb->pbNextBlock = newpb;
    pl->plBlock = newpb;
}

PAGELINE *append_one_empty_line(plane, pl)
    PAGEPLANE *plane;
    PAGELINE *pl;
{
    PAGEBLOCK *pb = pl->plBlock;
    PAGELINE *new = create_one_empty_line();
    new->plLineNum = 1;
    new->plNextLine = pl->plNextLine;
    new->plPrevLine = pl;
    if (pl->plNextLine != (PAGELINE *)NULL)
	pl->plNextLine->plPrevLine = new;
    pl->plNextLine = new;
    new->plBlock = pb;
    pb->pbLogicalLines++;
    pb->pbPhysicalLines++;
    plane->ppLogicalLines++;
    plane->ppPhysicalLines++;
    if (pb->pbLogicalLines > MAXLINEINPAGEBLOCK)
	crack_page_block(pb);
    return new;
}

PAGELINE *insert_one_line(plane, line)
    PAGEPLANE *plane;
    int line;
{
    PAGEBLOCK *pb;
    PAGELINE *pl;
    debug_setfunc("page", "insert_one_line");
    debug_print(1, "Insert One Line after Line#%d\n", line);
    /* Search Block to which the line should be inserted */
    if ((pb = plane->ppBlocks) == (PAGEBLOCK *)NULL) {
	plane->ppBlocks = pb = create_one_empty_block();
	pl = create_one_empty_line();
	/* Create line+1 blank lines */
	plane->ppLogicalLines = plane->ppPhysicalLines = 1;
	pb->pbFirstLine = pl;
	pb->pbLogicalLines = pb->pbPhysicalLines = 1;
	pl->plLineNum = 1;
	pl->plBlock = pb;
	while (line-- > 0)
	    pl = append_one_empty_line(plane, pl);
    } else if (line == 0) {
	pl = create_one_empty_line();
	pl->plLineNum = 1;
	pl->plBlock = pb;
	pl->plNextLine = pb->pbFirstLine;
	if (pb->pbFirstLine != (PAGELINE *)NULL)
	    pb->pbFirstLine->plPrevLine = pl;
	pb->pbFirstLine = pl;
	pb->pbLogicalLines++;
	pb->pbPhysicalLines++;
	plane->ppLogicalLines++;
	plane->ppPhysicalLines++;
	if (pb->pbLogicalLines > MAXLINEINPAGEBLOCK)
	    crack_page_block(pb);
    } else {
	while (pb->pbNextBlock != (PAGEBLOCK *)NULL) {
	    if (line <= pb->pbLogicalLines)
		break;
	    line -= pb->pbLogicalLines;
	    pb = pb->pbNextBlock;
	}
	for (pl = pb->pbFirstLine;
	     pl->plNextLine != (PAGELINE *)NULL && line > 0; line--) {
	    pl = pl->plNextLine;
	}
	while (line-- >= 0)
	    pl = append_one_empty_line(plane, pl);
    }
    (void)dump_page_plane(plane);
    debug_endfunc("append_one_line");
    return pl;
}

#define KCODE(c)		((c)&0200)

struct _string_box {
    int lt_x, lt_y;
    int base_x, base_y;
    int ascent, descent;
    int width, height;
    struct _string_box *next;
} ;

typedef struct _string_box STRINGBOX;

static STRINGBOX *create_one_stringbox()
{
    STRINGBOX *sb;
    if ((sb = (STRINGBOX *)memALLOC(sizeof(STRINGBOX))) != (STRINGBOX *)NULL)
	bzero((char *)sb, sizeof(STRINGBOX));
    return sb;
}

static STRINGBOX *over_write_string(ch, tr, pg, pl, col, fid, leng, str, n_col,
				    top_string, end_string, end_line,
				    overwrite)
    yy_comm_channel *ch;	/* Communication Channel */
    TERRITORY *tr;		/* Page Territory */
    TERRITORY_PAGE *pg;		/* Page Control Block */
    PAGELINE *pl;
    int col;
    int fid;
    int leng;
    char *str;
    int *n_col;
    PAGESTR **top_string;
    PAGESTR **end_string;
    PAGESTR **end_line;
    bool *overwrite;
{
    PAGESTR *cur = pl->plFirstStr;
    PAGESTR *last = (PAGESTR *)NULL;
    STRINGBOX *top_sb, *cur_sb;
    int cs_col = col;

    debug_setfunc("page", "over_write_string");
    debug_print(5, "over write (Column:<%d>, FID:%d, Length:%d)\n",
		col, fid, leng);
    *overwrite = TRUE;
    /* Get Location for over-writing */
    for ( ; cur != (PAGESTR *)NULL ; cur = (last = cur)->psNext) {
	if (col < cur->nchar)
	    break;
	col -= cur->nchar;
    }
    *top_string = (PAGESTR *)NULL;
    if (cur == (PAGESTR *)NULL && col > 0)
	goto termination;	/* Can't insert */

    if (cur == (PAGESTR *)NULL) {
	cur = create_empty_pagestr();
	cur->psLine = pl;
	if ((cur->psPrev = last) != (PAGESTR *)NULL)
	    last->psNext = cur;
	else
	    pl->plFirstStr = cur;
	pl->plColNum++;
	*overwrite = FALSE;
    }
    *top_string = cur;
    /* String Box */
    top_sb = cur_sb = create_one_stringbox();

    /* Do Over Write */
    for ( ; leng > 0 ; cur = (last = cur)->psNext) {
	TEXTBOX *char_size;
	if (cur == (PAGESTR *)NULL) {
	    cur = create_empty_pagestr();
	    cur->psLine = pl;
	    cur->psPrev = last;
	    if (last != (PAGESTR *)NULL)
		last->psNext = cur;
	    pl->plColNum++;
	}
	/* Set Character Information */
	cur->fid = fid;
	cur->nchar = 1;
	if (KCODE(*str)) {
	    cur->leng = 2;
	    cur->ptr[0] = *str++; cur->ptr[1] = *str++;
	} else {
	    cur->leng = 1;
	    cur->ptr[0] = *str++;
	}
	leng -= cur->leng;
	cs_col++;
	char_size = YYTextSize(ch, fid, PAGE_DIR(pg), cur->leng, cur->ptr,0,0);
	cur->width = char_size->w;
	/* Set Position */
	if (last == (PAGESTR *)NULL) {
	    cur->posX = 0;
	    cur->posLin = 0;
	    cur_sb->base_y = 0;
	    cur_sb->width = char_size->w;
	    cur_sb->ascent = char_size->y;
	    cur_sb->descent = char_size->y + char_size->h;
	} else if (last->posX + last->width + cur->width > tr->teWidth) {
	    cur->posLin = last->posLin + 1;
	    cur->posX = 0;
	    cur_sb->next = create_one_stringbox();
	    cur_sb = cur_sb->next;
	    cur_sb->base_y = cur->posLin * pg->pcLineSkip;
	    cur_sb->width = char_size->w;
	    cur_sb->ascent = char_size->y;
	    cur_sb->descent = char_size->y + char_size->h;
	} else {
	    cur->posLin = last->posLin;
	    cur->posX = last->posX + last->width;
	    cur_sb->base_y = cur->posLin * pg->pcLineSkip;
	    cur_sb->width += char_size->w;
	    cur_sb->ascent = MIN(cur_sb->ascent,char_size->y);
	    cur_sb->descent = MAX(cur_sb->descent,(char_size->y+char_size->h));
	}
    }
    *end_string = last;

    /* check */
    for ( ; cur != (PAGESTR *)NULL ; cur = (last = cur)->psNext) {
	if (last->posX + last->width + cur->width > tr->teWidth) {
	    cur->posLin = last->posLin + 1;
	    cur->posX = 0;
	} else {
	    cur->posLin = last->posLin;
	    cur->posX = last->posX + last->width;
	}
    }
    *end_line = last;
    *n_col = cs_col;
    pl->plBlock->pbPhysicalLines -= (pl->plLineNum - last->posLin - 1);
    pg->pcPagePlane.ppPhysicalLines -= (pl->plLineNum - last->posLin - 1);
    pl->plLineNum = last->posLin + 1;
    top_sb->base_x = (*top_string)->posX;
 termination:
    debug_endfunc("over_write_string");
    return top_sb;
}

STRINGBOX *put_string_on_line(ch, tr, pg, base_y, pl, col, fid, leng, str, input)
    yy_comm_channel *ch;	/* Communication Channel */
    TERRITORY *tr;		/* Territory */
    TERRITORY_PAGE *pg;		/* Page COntrol Block */
    int base_y;			/* Base Line (Y Position) - pixel */
    PAGELINE *pl;
    int col;
    int fid;
    int leng;
    char *str;
    int input;
{
    int old_linenum;
    PAGESTR *ps;
    int n_col;
    PAGESTR *top_string, *end_string, *end_line;
    bool overwrite;
    STRINGBOX *top_sb, *sb;

    debug_setfunc("page", "put_string_on_line");
    debug_print(6, "%d Characters on (X,%d) using Font#%d\n",
		leng, base_y, fid);
    if (col > pl->plColNum) {
	/* inseart (col-pl->plColNum) spaces */
	register int c;
	for (c = pl->plColNum; c < col; c++) {
	    top_sb = over_write_string(ch, tr, pg, pl, c, pg->pcDefFontID,
				       1, " ", &n_col, &top_string,
				       &end_string, &end_line, &overwrite);
	    for (sb = top_sb; sb != (STRINGBOX *)NULL; ) {
		STRINGBOX *next = sb->next;
		free((char *)sb);
		sb = next;
	    }
	}
    }
    old_linenum = pl->plLineNum;
    top_sb = over_write_string(ch, tr, pg, pl, col, fid, leng, str,
			       &n_col, &top_string, &end_string, &end_line,
			       &overwrite);
    /* expand this page territory */
#define TOTALPHYSICLINNUM(pg)	((pg)->pcPagePlane.ppPhysicalLines)
#define GETPAGEHEIGHT(pg)	((pg)->pcHeadOff + (pg)->pcTailOff \
				 + (TOTALPHYSICLINNUM(pg)-1)*(pg)->pcLineSkip)
    debug_print(4, "Psysical lines (Total): %d\n", TOTALPHYSICLINNUM(pg));
    if (GETPAGEHEIGHT(pg) > tr->teHeight) {
	int nh = GETPAGEHEIGHT(pg);
	yy_packet *event;
	debug_print(5, "Do resize [%d,%d]=>[%d,%d]\n",
		    tr->teWidth, tr->teHeight, tr->teWidth, nh);
	(void) resize_territory(ch, tr, tr->teX, tr->teY-pg->pcLineSkip*2,
				tr->teWidth, nh, 0, 0, 0, 0);
	if (input) {
	    if (tr->teParent->teHeight < tr->teY + tr->teHeight) {
		int new_y, new_h;
		new_h = tr->teY + tr->teHeight;
		new_y = tr->teParent->teY - (new_h - tr->teParent->teHeight);
		(void) resize_territory(ch, tr->teParent, tr->teParent->teX,
					new_y, tr->teParent->teWidth, new_h,
					0, 0, 0, 0);
		event = ALLOC_EVENTPACKET(YYCOMMAND_CHANGE_PAGE_SIZE);
		append_packet_entry_integer(event, tr->teParent->teID);
		append_packet_entry_integer(event, tr->teParent->teX);
		append_packet_entry_integer(event, new_y);
		append_packet_entry_integer(event, tr->teParent->teWidth);
		append_packet_entry_integer(event, new_h);
		put_packet_on_sendq(QUE(ch), event);
	    }
	} else {
	    event = ALLOC_EVENTPACKET(YYCOMMAND_CHANGE_PAGE_SIZE);
	    append_packet_entry_integer(event, tr->teID);
	    append_packet_entry_integer(event, tr->teX);
	    append_packet_entry_integer(event, tr->teY-pg->pcLineSkip*2);
	    append_packet_entry_integer(event, tr->teWidth);
	    append_packet_entry_integer(event, nh);
	    put_packet_on_sendq(QUE(ch), event);
	}
    }

    if (pl->plLineNum != old_linenum) {
#define DIST(line, pg)		((line)*((pg)->pcLineSkip))
#define BASE_TO_TOP(base, pg)	((base) - ((pg)->pcHeadOff))
	x_private *xp = XPRIVATE(ch);
	TERRITORY_X_ENTRY *tx = GetTerritoryXEntry(tr);
	int cur_next_top = BASE_TO_TOP((base_y+DIST(old_linenum,pg)), pg);
	int new_next_top = BASE_TO_TOP((base_y+DIST((pl->plLineNum),pg)), pg);
	int pix_w, pix_h;
	int copy_ow, copy_oh;
	int copy_nw, copy_nh;
	GC wgc;
	Pixmap wpix;
	XGCValues gcv;
	debug_print(4, "Psysical line %d => %d\n", old_linenum, pl->plLineNum);

	/* Create Woking Pixmap */
	pix_w = tr->teWidth;
	pix_h = tr->teHeight - MIN(cur_next_top,new_next_top);
	wpix = XCreatePixmap(xp->xDisp, tx->txWindow, pix_w, pix_h,
			     DefaultDepth(xp->xDisp, xp->xScreen));
	/* Clear This Pixmap */
	gcv.function = GXcopy;
	wgc = XCreateGC(xp->xDisp, tx->txWindow, GCFunction, &gcv);
	XCopyGC(xp->xDisp, tx->txGC, (GCForeground|GCBackground), wgc);
	(void) clear_pixmap(xp, wpix, wgc, pix_w, pix_h,
			    &tx->txBackGroundColor);
	/* get copy area */
	copy_ow = copy_nw = tr->teWidth;
	copy_oh = MIN((tr->teHeight-cur_next_top),pix_h);
	/* Scroll Up or Down */
	if (pl->plLineNum > old_linenum) {
	    /* Scroll Down */
	    copy_nh = MIN(tr->teHeight-cur_next_top, pix_h);
	    debug_print(4, " CopyArea (%d,%d)[%d,%d] => (%d,%d)\n",
			0, cur_next_top, copy_ow, copy_oh,
			0, ((pl->plLineNum-old_linenum)*pg->pcLineSkip));
	    XCopyArea(xp->xDisp, tx->txPixmap, wpix, wgc,
		      0, cur_next_top, copy_ow, copy_oh,
		      0, ((pl->plLineNum-old_linenum)*pg->pcLineSkip));
	    debug_print(4, " CopyArea (%d,%d)[%d,%d] => (%d,%d)\n",
			0, 0, copy_nw, copy_nh, 0, cur_next_top);
	    XCopyArea(xp->xDisp, wpix, tx->txPixmap, wgc,
		      0, 0, copy_nw, copy_nh, 0, cur_next_top);
	    if (IsVisibleTerritory(tr)) {
		XCopyArea(xp->xDisp, wpix, tx->txWindow, wgc,
			  0, 0, copy_nw, copy_nh, 0, cur_next_top);
	    }
	} else {
	    /* Scroll Up */
	    copy_nh = MIN(tr->teHeight-new_next_top, pix_h);
	    debug_print(4, " CopyArea (%d,%d)[%d,%d] => (%d,%d)\n",
			0, cur_next_top, copy_ow, copy_oh, 0, 0);
	    XCopyArea(xp->xDisp, tx->txPixmap, wpix, wgc,
		      0, cur_next_top, copy_ow, copy_oh, 0, 0);
	    debug_print(4, " CopyArea (%d,%d)[%d,%d] => (%d,%d)\n",
			0, 0, copy_nw, copy_nh, 0, new_next_top);
	    XCopyArea(xp->xDisp, wpix, tx->txPixmap, wgc,
		      0, 0, copy_nw, copy_nh, 0, new_next_top);
	    if (IsVisibleTerritory(tr)) {
		XCopyArea(xp->xDisp, wpix, tx->txWindow, wgc,
			  0, 0, copy_nw, copy_nh, 0, new_next_top);
	    }
	}
	XFreeGC(xp->xDisp, wgc);
	XFreePixmap(xp->xDisp, wpix);
    }
    /* Update Character Cursor Position */
    pg->pcCurXPos = n_col;


    /* draw text */
    ps = top_string;
    while (ps != (PAGESTR *)NULL) {
	int fid = ps->fid;
	int wleng = 0;
	int lin = ps->posLin;
	char buf[32];
	char *s = buf;
	int base_x = ps->posX;
	int olin = (-1);
	for ( ; ps != (PAGESTR *)NULL && ps->posLin == lin && ps->fid == fid;
	     ps = ps->psNext) {
	    register int l = ps->leng;
	    register char *p;
	    if (wleng + l > sizeof(buf))
		break;
	    for (p = ps->ptr, wleng += l; l > 0; l--)
		*s++ = *p++;
	}
	if (wleng > 0) {
	    if (olin != lin && overwrite) {
		GC wgc;
		Pixmap wpix;
		XGCValues gcv;
		x_private *xp = XPRIVATE(ch);
		TERRITORY_X_ENTRY *tx = GetTerritoryXEntry(tr);
		int pix_w = tr->teWidth;
		int pix_h = pg->pcHeadOff + pg->pcTailOff;
		int x = base_x;
		int y = base_y+(lin*pg->pcLineSkip)-pg->pcHeadOff;
		wpix = XCreatePixmap(xp->xDisp, tx->txWindow, pix_w, pix_h,
				     DefaultDepth(xp->xDisp, xp->xScreen));
		/* Clear This Pixmap */
		gcv.function = GXcopy;
		wgc = XCreateGC(xp->xDisp, tx->txWindow, GCFunction, &gcv);
		XCopyGC(xp->xDisp, tx->txGC, (GCForeground|GCBackground), wgc);
		(void) clear_pixmap(xp, wpix, wgc, pix_w, pix_h,
				    &tx->txBackGroundColor);
		XCopyArea(xp->xDisp, wpix, tx->txPixmap, wgc,
			  0, 0, pix_w, pix_h, x, y);
		if (IsVisibleTerritory(tr)) {
		    XCopyArea(xp->xDisp, wpix, tx->txWindow, wgc,
			      0, 0, pix_w, pix_h, x, y);
		}
		XFreeGC(xp->xDisp, wgc);
		XFreePixmap(xp->xDisp, wpix);
		olin = lin;
	    }
	    do_draw_text_on_page(ch, tr, base_x, base_y+(lin*pg->pcLineSkip),
				 fid, wleng, buf);
	}
    }
    for (sb = top_sb; sb != (STRINGBOX *)NULL; sb = sb->next) {
	sb->base_y += base_y;
	sb->lt_x = sb->base_x;
	sb->lt_y = sb->base_y + sb->ascent;
	sb->height = sb->descent - sb->ascent;
	debug_print(8, "STRING BOX: (%d,%d)[%d,%d]\n",
		    sb->lt_x, sb->lt_y, sb->width, sb->height);
    }
    debug_endfunc("put_string_on_line");
    return top_sb;
}

STRINGBOX *put_string_on_page(ch, tr, pg, col, lin, fid, leng, str, input)
    yy_comm_channel *ch;	/* Communication Channel */
    TERRITORY *tr;		/* Territory */
    TERRITORY_PAGE *pg;		/* Page COntrol Block */
    int col, lin;		/* Cursor Position */
    int fid;			/* font ID */
    int leng;			/* byte length */
    char *str;			/* string */
    int input;
{
    int p_lin = 0;		/* physical line number */
    PAGELINE *pl;
    int base_y;
    int cs_lin = lin;		/* Character Cursor */
    STRINGBOX *sb;
    char *s;
    int l;
    debug_setfunc("page", "put_string_on_page");
    debug_print(5, "Put String at (%d,%d) on Page#%d (Length=%d)\n",
		col, lin, tr->teID, leng);
    if (lin+1 > pg->pcPagePlane.ppLogicalLines)
	insert_one_line(&pg->pcPagePlane, lin);
    for (pl = pg->pcPagePlane.ppBlocks->pbFirstLine; lin > 0; lin--) {
	p_lin += pl->plLineNum;
	pl = pl->plNextLine;
    }
    /* get pixel value of base line */
    base_y = pg->pcHeadOff + p_lin * pg->pcLineSkip;
    for (s = str, l = leng; l > 0; s++, l--)
	if (*s == '\n' || *s == '\r')
	    break;
    if (leng-l > 0) {
	sb = put_string_on_line(ch, tr, pg, base_y, pl,col,fid,(leng-l),str,input);
	pg->pcCurYPos = cs_lin;
    } else {
	sb = (STRINGBOX *)NULL;
	pg->pcCurXPos = 0, pg->pcCurYPos = cs_lin+1;
    }
    (void)dump_page_plane(&pg->pcPagePlane);
    debug_print(3, "Current Cursor Position: <%d,%d>\n",
		pg->pcCurXPos, pg->pcCurYPos);
    debug_endfunc("put_string_on_page");
    return sb;
}



CPOS *get_logical_poision(plane, x, y)
    PAGEPLANE *plane;
    int x, y;	/* physical position */
{
    static CPOS pos;
    debug_setfunc("page", "get_logical_position");
    pos.phs_x = x;
    pos.phs_y = y;

    pos.log_x = x;
    pos.log_y = y;
    debug_endfunc("get_logical_position");
    return &pos;
}

CPOS *get_physical_poision(plane, x, y)
    PAGEPLANE *plane;
    int x, y;	/* physical position */
{
    static CPOS pos;
    debug_setfunc("page", "get_physical_position");
    pos.log_x = x;
    pos.log_y = y;

    pos.phs_x = x;
    pos.phs_y = y;
    debug_endfunc("get_physical_position");
    return &pos;
}

/***************************************************************************
 * Commands on Page Mode Territory
 ***************************************************************************/

yy_packet *yycom_set_page_attribute(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    TERRITORY *tr;
    TERRITORY_PAGE *pg;
    int err_code = YYNOERROR;
    yy_packet *repl;
    int dir, coor;
    int x, y;

    debug_setfunc("page", "yycom_set_page_attribute");
    /* set_page_attribute(tr,font,skip,dirction,coordinate,x,y) */
    tr = search_territory(read_packet_entry_integer(pkt));
    if (tr == (TERRITORY *)NULL || tr->teTRType != TR_PAGE) {
	err_code = YYERROR_NOTERRITORY; goto send_reply;
    }
    pg = &tr->teModeEnt.tPageControl;
    pg->pcDefFontID = read_packet_entry_integer(pkt);
    if ((pg->pcDefFont = call_font(ch, pg->pcDefFontID)) == (YYFONT *)NULL) {
	err_code = YYERROR_NOFONT; goto send_reply;
    }
    pg->pcHeadOff = MAX(MAXB1ASCENT(pg->pcDefFont),MAXB2ASCENT(pg->pcDefFont));
    pg->pcTailOff = MAX(MAXB1DESCENT(pg->pcDefFont),MAXB2DESCENT(pg->pcDefFont));
    pg->pcLineSkip = read_packet_entry_integer(pkt);
    dir = read_packet_entry_integer(pkt);
    coor = read_packet_entry_integer(pkt);
    if (pg->pcPageMode == 0)
	pg->pcPageMode = (dir == 0? (coor == 0? PG_HLT: PG_HLB):
			  (coor == 0? PG_VLT: PG_VLB));
    x = read_packet_entry_integer(pkt);
    y = read_packet_entry_integer(pkt);
    debug_print(5, "Page Territory#%d\n", tr->teID);
    debug_print(6, "Line Skip: %d, Mode: 0%o, Cursor: (%d,%d)\n",
		pg->pcLineSkip, pg->pcPageMode, x, y);
    debug_print(6, "Logical Line = %d, Physical Line = %d\n",
		pg->pcPagePlane.ppLogicalLines,
		pg->pcPagePlane.ppPhysicalLines);
    debug_print(6, "Offset = [%d,%d]\n", pg->pcHeadOff, pg->pcTailOff);
 send_reply:
    if (err_code == YYNOERROR) {
	repl = ALLOC_ACKPACKET(pkt);
	append_packet_entry_integer(repl, tr->teID);
    } else {
        repl = ALLOC_ERRPACKET(pkt);
        SETYYERRORCODE(repl, 0); SETYYERRORCODE(repl, err_code);
    }
    debug_endfunc("yycom_set_page_attribute");
    return repl;
}

void move_page_territory(ch, tr, pg, mode, col, lin)
    yy_comm_channel *ch;
    TERRITORY *tr;
    TERRITORY_PAGE *pg;
    int mode;
    int col, lin;
{
    /* */
}

void move_page_cursor(ch, tr, pg, mode, col, lin)
    yy_comm_channel *ch;
    TERRITORY *tr;
    TERRITORY_PAGE *pg;
    int mode;
    int col, lin;
{
    debug_setfunc("page", "move_page_cursor");
    switch (mode) {
    case PGCSMOVE_ABSOLUTE:
	pg->pcCurXPos = MAX(0,col);
	pg->pcCurYPos = MAX(0,lin);
	break;
    case PGCSMOVE_RELATIVE:
	pg->pcCurXPos = MAX(0,(pg->pcCurXPos+col));
	pg->pcCurYPos = MAX(0,(pg->pcCurYPos+lin));
	break;
    default:
	/* DO NOT MOVE */
	break;
    }
    debug_print(5, "New Character Cursor Position: <%d,%d>\n",
		pg->pcCurXPos, pg->pcCurYPos);
    debug_endfunc("move_page_cursor");
}


/***************************************************************************
 ***** Command 81
 *****
 *****  Change Location of Page-Mode_Territory
 *****
 ***************************************************************************/

yy_packet *yycom_move_page_territory(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    TERRITORY *tr;
    TERRITORY_PAGE *pg;
    int err_code = YYNOERROR;
    yy_packet *repl = (yy_packet *)NULL;
    int tr_move_mode;
    int tr_lin, tr_col;
    int cs_move_mode;
    int cs_lin, cs_col;

    debug_setfunc("page", "yycom_set_page_attribute");
    if ((tr = catch_territory(pkt, TR_PAGE, &repl)) == (TERRITORY *)NULL) {
	err_code = YYERROR_NOTERRITORY; goto send_reply;
    }
    pg = &tr->teModeEnt.tPageControl;
    if (pg->pcPageMode == 0) { /* Attributes have not been set */
	err_code = YYERROR_NOTERRITORY; goto send_reply;
    }
    tr_col = read_packet_entry_integer(pkt);
    tr_lin = read_packet_entry_integer(pkt);
    tr_move_mode = read_packet_entry_integer(pkt);
    cs_col = read_packet_entry_integer(pkt);
    cs_lin = read_packet_entry_integer(pkt);
    cs_move_mode = read_packet_entry_integer(pkt);
    if (tr_move_mode != 0)
	move_page_territory(ch, tr, pg, tr_move_mode, tr_col, tr_lin);
    if (cs_move_mode != 0)
	move_page_cursor(ch, tr, pg, cs_move_mode, cs_col, cs_lin);
 send_reply:
    if (err_code != YYNOERROR && repl == (yy_packet *)NULL) {
        repl = ALLOC_ERRPACKET(pkt); SETYYERRORCODE(repl, err_code);
    }
    debug_endfunc("yycom_set_page_attribute");
    return repl;
}

/***************************************************************************
 ***** Command 82
 *****
 *****  Start Input Procedure on Page-Mode_Territory
 *****
 ***************************************************************************/

static char *read_string_on_input_control_table(pkt, s, kcp)
    yy_packet *pkt;
    register char *s;
    register struct keyin_control *kcp;
{
    register int leng = read_packet_entry_integer(pkt);
    debug_setfunc("page", "read_string_on_input_control_table");
    kcp->kcStr = s;
    kcp->kcLeng = leng;
    if (leng > 0) {
	debug_print(6, "Read %dcharacters\n", leng);
	read_packet_entry_string(pkt, leng, s);
	if (debug_on(8)) {
	    if (isprint(*s))
		debug_print(8, "Special Function is called by <%c>\n", *s);
	    else
		debug_print(8, "Special Function is called by <0%o>\n", *s);
	}
	s += kcp->kcLeng;
    } else {
	/* skip 4bytes */
	read_packet_entry_integer(pkt);
    }
    debug_endfunc("read_string_on_input_control_table");
    return s;
}

yy_packet *yycom_start_input(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    TERRITORY *tr;
    TERRITORY_PAGE *pg;
    int err_code = YYNOERROR;
    yy_packet *repl = (yy_packet *)NULL;
    int col, lin, echo;
    char *s;
    char c;
    int leng;

    debug_setfunc("page", "yycom_start_input");
    if ((tr = catch_territory(pkt, TR_PAGE, &repl)) == (TERRITORY *)NULL) {
	err_code = YYERROR_NOTERRITORY; goto send_reply;
    }
    pg = &tr->teModeEnt.tPageControl;
    if (pg->pcPageMode == 0 || pg->pcDoKeyInput) {
	/* We can't start input procedure on this territory */
	err_code = YYERROR_NOTERRITORY; goto send_reply;
    }
    col = read_packet_entry_integer(pkt);
    lin = read_packet_entry_integer(pkt);
    echo = read_packet_entry_integer(pkt);
    debug_print(5, "Input on Page Territory (%d,%d) - Mode:%d\n",
		col, lin, echo);
    /* Read Control Words */
    s = pg->pcKeyInCtrlBuf;
    s = read_string_on_input_control_table(pkt, s, &pg->pcKeyInSync);
    s = read_string_on_input_control_table(pkt, s, &pg->pcKeyInTerm);
    s = read_string_on_input_control_table(pkt, s, &pg->pcKeyInIntr);
    /* Create Input Territory */
    pg->pcKeyInTerritory = create_input_territory(ch, tr, pg, col, lin,
						  pg->pcDefFontID, &err_code);
    if (pg->pcKeyInTerritory == (TERRITORY *)NULL) {
	err_code = YYERROR_NOTERRITORY; goto send_reply;
    }
    pg->pcDoKeyInput = TRUE;
    c = ' ';
    keyin_on_input_territory(ch, tr, 1, &c);
    c = 0x8;
    keyin_on_input_territory(ch, tr, 1, &c);
 send_reply:
    if (err_code != YYNOERROR && repl == (yy_packet *)NULL) {
        repl = ALLOC_ERRPACKET(pkt); SETYYERRORCODE(repl, err_code);
    }
    debug_setfunc("yycom_start_input");
    return repl;
}


/***************************************************************************
 ***** Command 83
 *****
 *****  Abort Input Procedure on Page-Mode_Territory
 *****
 ***************************************************************************/

yy_packet *yycom_abort_input(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    TERRITORY *tr;
    TERRITORY_PAGE *pg;
    int err_code = YYNOERROR;
    yy_packet *repl = (yy_packet *)NULL;

    debug_setfunc("page", "yycom_abort_input");
    if ((tr = catch_territory(pkt, TR_PAGE, &repl)) == (TERRITORY *)NULL) {
	err_code = YYERROR_NOTERRITORY; goto send_reply;
    }
    pg = &tr->teModeEnt.tPageControl;
    if (pg->pcPageMode == 0 || !pg->pcDoKeyInput) {
	/* This Territory has no input procedure - ignore this command */
	goto send_reply;
    }
    abort_keyin(ch, tr, pg);
 send_reply:
    if (err_code != YYNOERROR && repl == (yy_packet *)NULL) {
        repl = ALLOC_ERRPACKET(pkt); SETYYERRORCODE(repl, err_code);
    }
    debug_setfunc("yycom_abort_input");
    return repl;
}

/***************************************************************************
 ***** Command 84
 *****
 *****  Draw Text on Page-Mode_Territory
 *****
 ***************************************************************************/

static STRINGBOX *append_stringbox(top, sb)
    register STRINGBOX *top, *sb;
{
    register STRINGBOX *sb2 = top;
    if (top == (STRINGBOX *)NULL)
	return sb;
    while (sb2->next != (STRINGBOX *)NULL)
	sb2 = sb2->next;
    sb2->next = sb;
    return top;
}

static STRINGBOX *draw_text_on_page(ch, pkt, tr, pg, fid)
    yy_comm_channel *ch;
    yy_packet *pkt;
    TERRITORY *tr;
    TERRITORY_PAGE *pg;
    int fid;
{
    int leng;	/* length of string */
    int offset, size;
    int col, lin;
    char buf[256];
    STRINGBOX *top_sb = (STRINGBOX *)NULL;

    debug_setfunc("font", "draw_text_on_page");
    col = pg->pcCurXPos;
    lin = pg->pcCurYPos;
    leng = read_packet_entry_integer(pkt);
    offset = 0;
    size = (sizeof(buf) & ~3);
    debug_print(5, "Draw - Length=%d at (%d,%d)\n", leng, col, lin);
    while (leng > 0) {
	int rleng = MIN(leng,(size-offset));
	int wleng;
	char *s, *e;
	read_packet_entry_string(pkt, rleng, &buf[offset]);
	leng -= rleng;		/* length on packet */
	offset += rleng;	/* length on buf */
	for (s = e = buf, wleng = 0; offset > 0; e++, offset--) {
	    if (KCODE(*e)) {
		if (offset < 2)
		    break;
		wleng += 2;
		e++, offset--;
	    } else if (*e == '\n' || *e == '\r') {
		if (wleng > 0) {
		    STRINGBOX *sb;
		    sb = put_string_on_page(ch, tr, pg, col, lin,
					    fid, wleng, s, 0);
		    top_sb = append_stringbox(top_sb, sb);
		}
		/* goto next line */
		col = 0; lin++;
		s = e + 1;
		wleng = 0;
		move_page_cursor(ch, tr, pg, PGCSMOVE_ABSOLUTE,
				 0, pg->pcCurYPos+1);
	    } else {
		if (iscntrl(*e))
		    *e = ' ';
		wleng++;
	    }
	}
	if (wleng > 0) {
	    STRINGBOX *sb;
	    sb = put_string_on_page(ch, tr, pg, col, lin, fid, wleng, s, 0);
	    top_sb = append_stringbox(top_sb, sb);
	}
    }
    debug_endfunc("draw_text_on_page");
    return top_sb;
}

yy_packet *yycom_draw_text_on_page(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    TERRITORY *tr;
    TERRITORY_PAGE *pg;
    int font_id;
    int err_code = YYNOERROR;
    yy_packet *repl = (yy_packet *)NULL;
    STRINGBOX *top_sb;

    debug_setfunc("page", "yycom_draw_text_on_page");
    if ((tr = catch_territory(pkt, TR_PAGE, &repl)) == (TERRITORY *)NULL) {
	err_code = YYERROR_NOTERRITORY; goto send_reply;
    }
    pg = &tr->teModeEnt.tPageControl;
    if (pg->pcPageMode == 0) {
	/* This Territory has no input procedure - ignore this command */
	err_code = YYERROR_NOTERRITORY; goto send_reply;
    }
    /* Change GC for drawing */
    change_gc(XPRIVATE(ch)->xDisp, XEntry(tr)->txGC, pkt,
	      (YYGC_OPERATION|YYGC_COLOR), (YYGC *)NULL, XPRIVATE(ch));
    font_id = read_packet_entry_integer(pkt);
    debug_print(5, "Draw Text (Font ID: %d)\n", font_id);
    if (font_id == 0) {
	font_id = pg->pcDefFontID;
	debug_print(6, "Use Default Font (Font ID: %d)\n", font_id);
    }
    debug_print(6, "Current Cursor Position: (%d,%d)\n",
		pg->pcCurXPos, pg->pcCurYPos);
    /* Get String */
    top_sb = draw_text_on_page(ch, pkt, tr, pg, font_id);
    repl = ALLOC_ACKPACKET(pkt);
    if (top_sb != (STRINGBOX *)NULL) {
	int blk = 0;
	STRINGBOX *sb = top_sb;
	int x_top = top_sb->lt_x;
	int y_top = top_sb->lt_y;
	int x_tail = 0;
	int height = 0;
	for (sb = top_sb; sb != (STRINGBOX *)NULL; ) {
	    STRINGBOX *next = sb->next;
	    x_top = MIN(x_top, sb->lt_x);
	    y_top = MIN(y_top, sb->lt_y);
	    x_tail = MAX(x_tail, (sb->lt_x+sb->width));
	    height += sb->height;
	    free((char *)sb);
	    sb = next;
	}
	debug_print(8, "   StringBOX: (%d,%d)[%d,%d]\n",
		    x_top, y_top, (x_tail-x_top), height);
	append_packet_entry_integer(repl, x_top);
	append_packet_entry_integer(repl, y_top);
	append_packet_entry_integer(repl, (x_tail-x_top));
	append_packet_entry_integer(repl, height);
    } else {
	append_packet_entry_integer(repl, 0);
	append_packet_entry_integer(repl, 0);
	append_packet_entry_integer(repl, 0);
	append_packet_entry_integer(repl, 0);
    }
    append_packet_entry_integer(repl, pg->pcCurXPos);
    append_packet_entry_integer(repl, pg->pcCurYPos);
    
 send_reply:

    if (err_code != YYNOERROR && repl == (yy_packet *)NULL) {
        repl = ALLOC_ERRPACKET(pkt); SETYYERRORCODE(repl, err_code);
    }
    debug_endfunc("yycom_draw_text_on_page");
    return repl;
}

/***************************************************************************
 ***** Command 85
 *****
 *****  Get Pixel Position from (column,line) pair
 *****
 ***************************************************************************/

yy_packet *yycom_get_position_on_page(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    TERRITORY *tr;
    TERRITORY_PAGE *pg;
    int col, lin;
    int err_code = YYNOERROR;
    yy_packet *repl = (yy_packet *)NULL;

    debug_setfunc("page", "yycom_get_position_on_page");
    if ((tr = catch_territory(pkt, TR_PAGE, &repl)) == (TERRITORY *)NULL) {
	err_code = YYERROR_NOTERRITORY; goto send_reply;
    }
    pg = &tr->teModeEnt.tPageControl;
    if (pg->pcPageMode == 0) {
	/* This Territory has no input procedure - ignore this command */
	err_code = YYERROR_NOTERRITORY; goto send_reply;
    }
    /* Get Info. */

 send_reply:
    if (err_code != YYNOERROR && repl == (yy_packet *)NULL) {
        repl = ALLOC_ERRPACKET(pkt); SETYYERRORCODE(repl, err_code);
    }
    debug_endfunc("yycom_get_position_on_page");
    return repl;
}

/*
 * Local variables:
 * eval: (set-kanji-fileio-code 'EUC)
 * end:
 */
