#ifndef lint
static char *RcsId="$Id: com_init.c,v 2.7 91/03/13 21:46:21 keisuke Exp $";
#endif

/* InitialSet for YY-server
 * This file is part of YY-server of YYonX (1.3 Distribution)
 * $Id: com_init.c,v 2.7 91/03/13 21:46:21 keisuke Exp $
 */

/****************************************************************************
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   Version 1.0 90/02/26 by Keisuke 'Keiko' Tanaka
;;;				(keisuke@csrl.aoyama.ac.jp)
;;;   Version 2.0 90/08/27 by Keisuke 'Keiko' Tanaka
;;;			Page Mode Territory is supported
;;;   Version 2.2 90/11/05 by Keisuke 'Keiko' Tanaka
;;;			Copyright Notice is rewritten
;;;
****************************************************************************/

/****************************************************************************
  $Revision: 2.7 $ Written by Keisuke 'Keiko' Tanaka
  $Date: 91/03/13 21:46:21 $
****************************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include "yydefs.h"
#include "yypacket.h"
#include "xwindow.h"

/*
 * Initialize
 */

struct yy_client_info {
	int ycVersion;
	int ycRelease;
	int ycSyncCounter;
	int ycMouseStayTime;
	char *ycXServer;
} ;
struct yy_server_info {
	int ysVersion;
	int ysRelease;
	int ysSyncCounter;
	int ysMouseStayTime;
} ;
struct yy_client_info YYClientInfo;
struct yy_server_info YYServerInfo;

yy_packet *yycom_init(ch, pkt)
	yy_comm_channel *ch;
	yy_packet *pkt;
{
	int id, leng, err;
	yy_packet *repl;
	x_private *xp;
	static char xserver_name[64];
	static char window_name[64];
	static char icon_name[64];

	debug_setfunc("init", "Initialize-YY");
	if (ch->ccXFd >= 0) {
		/* We already have the connection with the X server.. */
		/* Ignore this packet */
		return create_error_packet(pkt, YYERROR_NOTYYPACKET);
	}
	if ((id = read_packet_entry_integer(pkt)) != YYPROTO_MAGIC) {
		/* This is not YY Packet */
		return create_error_packet(pkt, YYERROR_NOTYYPACKET);
	}
	YYClientInfo.ycVersion = read_packet_entry_integer(pkt);
	YYClientInfo.ycRelease = read_packet_entry_integer(pkt);
	/* check version and release */
	YYClientInfo.ycSyncCounter = read_packet_entry_integer(pkt);
	YYClientInfo.ycMouseStayTime = read_packet_entry_integer(pkt);
	if ((err = check_client_info(&YYClientInfo, &YYServerInfo)) > 0) {
		return create_error_packet(pkt, err);
	}
	/* Sync Counter */
	ch->ccYYSyncPacketNum = YYServerInfo.ysSyncCounter;
	/* X Server Name */
	leng = read_packet_entry_integer(pkt);
	read_packet_entry_string(pkt, leng, xserver_name);
	YYClientInfo.ycXServer = xserver_name;
	if ((err = make_connection_with_x_server(ch, xserver_name)) > 0) {
		repl = ALLOC_ERRPACKET(pkt);
		append_packet_entry_integer(pkt, err);
		return repl;
	}
	debug_print(5, "Connect X Server on '%s'\n", xserver_name);
	xp = XPRIVATE(ch);
	if ((leng = read_packet_entry_integer(pkt)) > 0) {
		read_packet_entry_string(pkt, leng, window_name);
		xp->xWindowName = window_name;
	} else
		xp->xWindowName = YYWINDOWNAME;
	if ((leng = read_packet_entry_integer(pkt)) > 0) {
		read_packet_entry_string(pkt, leng, icon_name);
		xp->xIconName = icon_name;
	} else
		xp->xIconName = YYICONNAME;
	debug_print(5, "Window Name:'%s', Icon Name:'%s'\n",
		    xp->xWindowName, xp->xIconName);

	/* create reply packet */
	repl = ALLOC_ACKPACKET(pkt);
	append_packet_entry_integer(repl, YYPROTO_MAGIC);
	append_packet_entry_integer(repl, YYServerInfo.ysVersion);
	append_packet_entry_integer(repl, YYServerInfo.ysRelease);
	append_packet_entry_integer(repl, YYServerInfo.ysSyncCounter);
	append_packet_entry_integer(repl, YYServerInfo.ysMouseStayTime);
	append_packet_entry_integer(repl,
				    DisplayWidth(xp->xDisp, xp->xScreen));
	append_packet_entry_integer(repl,
				    DisplayHeight(xp->xDisp, xp->xScreen));
	append_packet_entry_string(repl, YYSERVER_LABEL);

	/* We finish initialization without any trouble */
	ch->ccXFd = ConnectionNumber(xp->xDisp);
	/* Fix Command Search Table for Another Commands */
	fix_command_search_table();
	debug_print(5, "Finish Initialize Procedures withour any error\n");
	debug_endfunc("Initialize-YY");
	return repl;

}

int check_client_info(ci, si)
	struct yy_client_info *ci;
	struct yy_server_info *si;
{
	/* This is a prototype version.. */
	si->ysVersion = ci->ycVersion;
	si->ysRelease = ci->ycRelease;
	si->ysSyncCounter = ci->ycSyncCounter;
	si->ysMouseStayTime = ci->ycMouseStayTime;
	return 0;
}

static x_private XPrivateArea;
bool YYSynchronizeMode;

int make_connection_with_x_server(ch, xserver)
	yy_comm_channel *ch;
	char *xserver;	/* X server (Display) */
{
	x_private *xp = &XPrivateArea;

	ch->ccXPrivate = (char *)xp;
	debug_setfunc("xwindow", "make_connection_with_x_server");
	debug_print(1, "Open Display on '%s'\n", xserver);
	if ((xp->xDisp = XOpenDisplay(xserver)) == NULL) {
		debug_print(1, "Can't open display '%s'\n",
			    XDisplayName(xserver));
		return YYERROR_NODISP;
	}
	XSetCloseDownMode(xp->xDisp, DestroyAll);
	if (YYSynchronizeMode) {
	    debug_print(1, "X-server Syncronize!!!\n");
	    XSynchronize(xp->xDisp, 1);
	}
	debug_print(1, "Display on '%s' has been opend\n",
		    XDisplayName(xserver));
	xp->xScreen = DefaultScreen(xp->xDisp);
	xp->xColor = DefaultColormap(xp->xDisp, xp->xScreen);
	debug_endfunc("make_connection_with_x_server");
	return 0;
}
