/* Drawing on Territory
 * This file is part of YY-server of YYonX (1.3 Distribution)
 * $Id: com_draw.c,v 2.16 91/03/15 20:51:01 keisuke Exp $
 */

#ifndef lint
static char *RcsId
    = "$Id: com_draw.c,v 2.16 91/03/15 20:51:01 keisuke Exp $";
#endif

/****************************************************************************
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   Version 1.0 90/02/28 by Keisuke 'Keiko' Tanaka
;;;				(keisuke@csrl.aoyama.ac.jp)
;;;   Version 2.0 90/08/27 by Keisuke 'Keiko' Tanaka
;;;			Page Mode Territory is supported
;;;   Version 2.2 90/11/05 by Keisuke 'Keiko' Tanaka
;;;			Copyright Notice is rewritten
;;;   Version 2.10 90/01/31 by Keisuke 'Keiko' Tanaka
;;;			Support YY-Image
;;;
****************************************************************************/

/****************************************************************************
  $Revision: 2.16 $ Written by Keisuke 'Keiko' Tanaka
  $Date: 91/03/15 20:51:01 $
****************************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include "yydefs.h"
#include "yypacket.h"
#include "xwindow.h"
#include "territory.h"

/*
 * Drawing on Territory
 */


/* int set_int_on_gcv(pkt, mask, val_p, min, max)
 *
 * ѥå pkt ҤȤɤ߽Фơ*val_p ˥åȤ
 * åȤ mask Ϳ줿֤ͤ
 */
static int set_int_on_gcv(pkt, mask, val_p, min, max)
    yy_packet *pkt;	/* ѥå */
    u_long mask;	/* δؿ */
    int *val_p;		/* ꤹ륢ɥ쥹 */
    int min, max;	/* ꤹ٤ϰ */
{
    register int val = read_packet_entry_integer(pkt);
    if ((min >= 0 && val < min) || (max > 0 && val > max))
	return 0;
    *val_p = val;
    return mask;
}
    

void yy_gc_setoperation(disp, gc, operation)
    Display *disp;
    GC gc;
    int operation;
{
    XGCValues gcv;
    debug_setfunc("xwindow", "yy_gc_setoperation");
    gcv.function = operation;
    XChangeGC(disp, gc, GCFunction, &gcv);
    debug_endfunc("yy_gc_setoperation");
}


void yy_gc_setdefaultoperation(disp, gc)
    Display *disp;
    GC gc;
{
    yy_gc_setoperation(disp, gc, GXcopy);
}

void yy_gc_setcolor(disp, gc, color)
    Display *disp;
    GC gc;
    register x_color color;
{
    XGCValues gcv;
    debug_setfunc("xwindow", "yy_gc_setcolor");
    gcv.foreground = color;
    XChangeGC(disp, gc, GCForeground, &gcv);
    debug_endfunc("yy_gc_setcolor");
}

void yy_gc_setdefaultcolor(disp, gc)
    Display *disp;
    GC gc;
{
    yy_gc_setcolor(disp, gc, BlackPixel(disp, DefaultScreen(disp)));
}

/*
 */
void change_gc(disp, gc, pkt, mask, yygc)
    Display *disp;
    GC gc;
    yy_packet *pkt;
    int mask;
    YYGC *yygc;
{
    u_long xmask = 0;
    XGCValues gcv;
    debug_setfunc("xwindow", "change_gc");
    /* ǥեȾ */
    xmask = (GCLineStyle|GCFillStyle);
    gcv.line_style = LineSolid;
    gcv.fill_style = FillSolid;
    if (mask & YYGC_LINWIDTH) {
	xmask |= set_int_on_gcv(pkt, GCLineWidth, &gcv.line_width, 0, -1);
	debug_print(5, "XChangeGC(GCLineWidth, %d)\n", gcv.line_width);
	if ((xmask & GCLineWidth) && yygc != (YYGC *)NULL)
	    yygc->yygcLineWidth = MAX(gcv.line_width, 1);
    }
    if (mask & YYGC_OPERATION)
	xmask |= set_int_on_gcv(pkt, GCFunction, &gcv.function,
				GXclear, GXset);
    if (mask & YYGC_EDGE)
	xmask |= set_int_on_gcv(pkt, GCCapStyle, &gcv.cap_style,
				CapNotLast, CapProjecting);
    if (mask & YYGC_CONNECT)
	xmask |= set_int_on_gcv(pkt, GCJoinStyle, &gcv.join_style,
				JoinMiter, JoinBevel);
    if (mask & YYGC_COLOR) {
	register x_color color;
	color = read_packet_entry_color(pkt);
	debug_print(5, "XChangeGC(GCForeground, %lu)\n", color);
	xmask |= GCForeground;
	gcv.foreground = color;
    }
    if (mask & YYGC_DASH) {
	int leng = read_packet_entry_integer(pkt);
	if (leng > 0) {
	    u_char dash_pattern1[8];
	    u_char dash_pattern2[8];
	    u_char c, cur;
	    register u_char *s;
	    register int loop = 8;
	    register int len;
	    read_packet_entry_string(pkt, 1, dash_pattern1);
	    c = dash_pattern1[0];
	    s = dash_pattern2;
	    for (len = 0, cur = 0; loop-- > 0 ; c <<= 1) {
		if ((c & 0200) == cur) {
		    len++;
		} else {
		    if (len > 0) { *s++ = len; len = 0; }
		    cur = (c & 0200);
		}
	    }
	    if (s == dash_pattern2) {
		*s++ = 4; *s++ = 4;
	    }
	    xmask |= GCLineStyle;
	    gcv.line_style = LineOnOffDash;
	    XSetDashes(disp, gc, 0, dash_pattern2, (s - dash_pattern2));
	}
    }
    if (mask & YYGC_FILL)
	xmask |= set_int_on_gcv(pkt, GCFillRule, &gcv.fill_rule,
				EvenOddRule, WindingRule);
    if (mask & YYGC_PATTERN) {
	int tr_id = read_packet_entry_integer(pkt);
	register territory_entry *ttr;
	if (tr_id > 0 &&
	    (ttr = search_territory(tr_id)) != (TERRITORY *)NULL) {
	    xmask |= (GCFillStyle|GCTile);
	    gcv.fill_style = FillTiled;
	    gcv.tile = ttr->teXEnt.txPixmap;
	}
    }
    if (mask & YYGC_ARCMODE)
	xmask |= set_int_on_gcv(pkt, GCArcMode, &gcv.arc_mode,
				ArcChord, ArcPieSlice);
    if (xmask)
	XChangeGC(disp, gc, xmask, &gcv);
    debug_endfunc("change_gc");
}


/***************************************************************************
 ***** Command 20
 *****
 *****  Draw Point
 *****
 ***************************************************************************/
yy_packet *yycom_draw_point(CH, pkt)
    yy_comm_channel *CH;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(CH);
    TERRITORY *tr;
    TERRITORY_X_ENTRY *tx;
    yy_packet *err;
    int x, y;

#ifdef DEBUG_PRINT
    debug_setfunc("draw", "yycom_draw_point");
#endif /*DEBUG_PRINT*/
    if ((tr = catch_territory(pkt, TR_DRAWABLE, &err)) == (TERRITORY *)NULL)
	goto send_reply;
    err = (yy_packet *)NULL;
    tx = GetTerritoryXEntry(tr);

    /* draw_point(tr,x,y,ope,color) */
    x = read_packet_entry_integer(pkt);
    y = read_packet_entry_integer(pkt);
    change_gc(xp->xDisp, tx->txGC, pkt, (YYGC_OPERATION|YYGC_COLOR),
	      (YYGC *)NULL, xp);
#ifdef DEBUG_PRINT
    debug_printf(1, "draw_point(%d,%d,%d)\n", tr->teID, x, y);
#endif /*DEBUG_PRINT*/
    XDrawPoint(xp->xDisp, tx->txPixmap, tx->txGC, x, y);
    if (IsVisibleTerritory(tr)) {
	XDrawPoint(xp->xDisp, tx->txWindow, tx->txGC, x, y);
	CH->ccXNeedFlush = TRUE;
    }
 send_reply:
    debug_endfunc("yycom_draw_point");
    return err;
}


/***************************************************************************
 ***** Command 21
 *****
 *****  Draw Line
 *****
 ***************************************************************************/

yy_packet *yycom_draw_line(CH, pkt)
    yy_comm_channel *CH;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(CH);
    TERRITORY *tr;
    TERRITORY_X_ENTRY *tx;
    yy_packet *err;
    int x1, y1, x2, y2;
#ifdef DEBUG_PRINT
    debug_setfunc("draw", "yycom_draw_line");
#endif /*DEBUG_PRINT*/
    if ((tr = catch_territory(pkt, TR_DRAWABLE, &err)) == (TERRITORY *)NULL)
	goto send_reply;
    err = (yy_packet *)NULL;
    tx = GetTerritoryXEntry(tr);
    /* draw_line(tr, x1, y1, x2, y2, wid, ope, edge, color, dash) */
    x1 = read_packet_entry_integer(pkt); y1 = read_packet_entry_integer(pkt);
    x2 = read_packet_entry_integer(pkt); y2 = read_packet_entry_integer(pkt);
    change_gc(xp->xDisp, tx->txGC, pkt,
	      (YYGC_LINWIDTH|YYGC_OPERATION|YYGC_EDGE|YYGC_COLOR|YYGC_DASH),
	      (YYGC *)NULL, xp);
    XDrawLine(xp->xDisp, tx->txPixmap, tx->txGC, x1, y1, x2, y2);
    if (IsVisibleTerritory(tr)) {
	XDrawLine(xp->xDisp, tx->txWindow, tx->txGC, x1, y1, x2, y2);
	CH->ccXNeedFlush = TRUE;
    }
 send_reply:
#ifdef DEBUG_PRINT
    debug_endfunc("yycom_draw_line");
#endif /*DEBUG_PRINT*/
    return err;
}


/***************************************************************************
 ***** Command 26
 *****
 *****  Draw Rectangle
 *****
 ***************************************************************************/

yy_packet *yycom_draw_rectangle(CH, pkt)
    yy_comm_channel *CH;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(CH);
    TERRITORY *tr;
    TERRITORY_X_ENTRY *tx;
    yy_packet *err;
    int x, y, w, h;
    YYGC yygc_val;

    debug_setfunc("draw", "yycom_draw_rectangle");
    if ((tr = catch_territory(pkt, TR_DRAWABLE, &err)) == (TERRITORY *)NULL) {
	debug_endfunc("yycom_draw_point");
	return err;
    }
    tx = GetTerritoryXEntry(tr);
    /* draw_rectangle(tr,x,y,w,h,wid,ope,color,dash) */
    x = read_packet_entry_integer(pkt);
    y = read_packet_entry_integer(pkt);
    w = read_packet_entry_integer(pkt);
    h = read_packet_entry_integer(pkt);
    change_gc(xp->xDisp, tx->txGC, pkt,
	      (YYGC_LINWIDTH|YYGC_OPERATION|YYGC_COLOR|YYGC_DASH),
	      &yygc_val, xp);
    x += (yygc_val.yygcLineWidth >> 1);
    y += (yygc_val.yygcLineWidth >> 1);
    w -= yygc_val.yygcLineWidth;
    h -= yygc_val.yygcLineWidth;
    debug_print(1, " Draw Rectangle (%d,%d)[%d,%d] on Territory#%d\n",
		x, y, w, h, tr->teID);
    XDrawRectangle(xp->xDisp, tx->txPixmap, tx->txGC, x, y, w, h);
    if (IsVisibleTerritory(tr)) {
	CH->ccXNeedFlush = TRUE;
	XDrawRectangle(xp->xDisp, tx->txWindow, tx->txGC, x, y, w, h);
    }
    debug_endfunc("yycom_draw_rectangle");
    return (yy_packet *)NULL;
}


static yy_packet *do_draw_lines(CH, pkt, polygon)
    yy_comm_channel *CH;
    yy_packet *pkt;
    bool polygon;
{
    x_private *xp = XPRIVATE(CH);
    TERRITORY *tr;
    TERRITORY_X_ENTRY *tx;
    yy_packet *err;
    XPoint *points, *p;
    int n, l;

    debug_setfunc("draw", "do_draw_lines");
    if ((tr = catch_territory(pkt, TR_DRAWABLE, &err)) == (TERRITORY *)NULL) {
	debug_endfunc("yycom_draw_point");
	return err;
    }
    tx = GetTerritoryXEntry(tr);
    /* draw_lines(n, pointes, points, ..) */
    n = read_packet_entry_integer(pkt);
    points = (XPoint *)calloc(n+1, sizeof(XPoint));
    for (p = points, l = n; l > 0; p++, l--) {
	p->x = read_packet_entry_integer(pkt);
	p->y = read_packet_entry_integer(pkt);
    }
    if (polygon) {
	p->x = points->x; p->y = points->y; n++;
	change_gc(xp->xDisp, tx->txGC, pkt,
		  (YYGC_LINWIDTH|YYGC_OPERATION|
		   YYGC_CONNECT|YYGC_COLOR|YYGC_DASH), (YYGC *)NULL, xp);
    } else
	change_gc(xp->xDisp, tx->txGC, pkt,
		  (YYGC_LINWIDTH|YYGC_OPERATION|YYGC_EDGE|
		   YYGC_CONNECT|YYGC_COLOR|YYGC_DASH), (YYGC *)NULL, xp);
    XDrawLines(xp->xDisp, tx->txPixmap, tx->txGC, points, n, CoordModeOrigin);
    if (IsVisibleTerritory(tr)) {
	XDrawLines(xp->xDisp, tx->txWindow, tx->txGC,
		   points, n, CoordModeOrigin);
	CH->ccXNeedFlush = TRUE;
    }
    debug_endfunc("do_draw_lines");
    return (yy_packet *)NULL;
}


/***************************************************************************
 ***** Command 23
 *****
 *****  Draw Lines
 *****
 ***************************************************************************/

yy_packet *yycom_draw_lines(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    return do_draw_lines(ch, pkt, FALSE);
}

/***************************************************************************
 ***** Command 24
 *****
 *****  Draw Polygon
 *****
 ***************************************************************************/

yy_packet *yycom_draw_polygon(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    return do_draw_lines(ch, pkt, TRUE);
}


/***************************************************************************
 ***** Command 22
 *****
 *****  Draw Circle
 *****
 ***************************************************************************/

yy_packet *yycom_draw_circle(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY *tr;
    TERRITORY_X_ENTRY *tx;
    yy_packet *err;
    int x, y, r;
    debug_setfunc("draw", "yycom_draw_circle");
    if ((tr = catch_territory(pkt, TR_DRAWABLE, &err)) == (TERRITORY *)NULL) {
	debug_endfunc("yycom_draw_point");
	return err;
    }
    tx = GetTerritoryXEntry(tr);
    /* draw_circle(tr,x,y,r) */
    x = read_packet_entry_integer(pkt);
    y = read_packet_entry_integer(pkt);
    r = read_packet_entry_integer(pkt);
    x -= r;
    y -= r;
    r <<= 1;
    change_gc(xp->xDisp, tx->txGC, pkt,
	      (YYGC_LINWIDTH|YYGC_OPERATION|YYGC_COLOR|YYGC_DASH),
	      (YYGC *)NULL, xp);
    XDrawArc(xp->xDisp, tx->txPixmap, tx->txGC, x, y, r, r, 0, YYPI2);
    if (IsVisibleTerritory(tr)) {
	XDrawArc(xp->xDisp, tx->txWindow, tx->txGC, x, y, r, r, 0, YYPI2);
	ch->ccXNeedFlush = TRUE;
    }
    debug_endfunc("yycom_draw_circle");
    return (yy_packet *)NULL;
}


/***************************************************************************
 ***** Command 25
 *****
 *****  Draw Arc
 *****
 ***************************************************************************/

yy_packet *yycom_draw_arc(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY *tr;
    TERRITORY_X_ENTRY *tx;
    yy_packet *err;
    int x, y, r; int a1, a2, a0, a_diff;

    debug_setfunc("draw", "yycom_draw_arc");
    if ((tr = catch_territory(pkt, TR_DRAWABLE, &err)) == (TERRITORY *)NULL) {
	debug_endfunc("yycom_draw_point");
	return err;
    }
    tx = GetTerritoryXEntry(tr);
    /* draw_arc(tr,x,y,r,a1,a2,wid,ope,color,dash) */
    x = read_packet_entry_integer(pkt);
    y = read_packet_entry_integer(pkt);
    r = read_packet_entry_integer(pkt);
    x -= r; y -= r; r <<= 1;
    a1 = (read_packet_entry_integer(pkt) % YYPI2);
    a2 = (read_packet_entry_integer(pkt) % YYPI2);
    if (a1 < 0) a1 += YYPI2;
    if (a2 < 0) a2 += YYPI2;
    a1 = YYPI2 - a1; a2 = YYPI2 - a2;
    if (a1 < a2) { a0 = a1; a_diff = a2 - a1; }
    else	{ a0 = a2; a_diff = a1 - a2; }
    change_gc(xp->xDisp, tx->txGC, pkt,
	      (YYGC_LINWIDTH|YYGC_OPERATION|YYGC_COLOR|YYGC_DASH),
	      (YYGC *)NULL, xp);
    XDrawArc(xp->xDisp, tx->txPixmap, tx->txGC, x, y, r, r, a0, a_diff);
    if (IsVisibleTerritory(tr)) {
	XDrawArc(xp->xDisp, tx->txWindow, tx->txGC, x, y, r, r, a0, a_diff);
	ch->ccXNeedFlush = TRUE;
    }
    debug_endfunc("yycom_draw_arc");
    return (yy_packet *)NULL;
}


/*****************************
 *****                   *****
 *****   Fill Commands   *****
 *****                   *****
 *****************************/

/***************************************************************************
 ***** Command 27
 *****
 *****  Draw Filled Polygon
 *****
 ***************************************************************************/

yy_packet *yycom_fill_polygon(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY *tr;
    TERRITORY_X_ENTRY *tx;
    yy_packet *err;
    XPoint *points, *p;
    int n, l;
    debug_setfunc("fill", "yycom_fill_polygon");
    if ((tr = catch_territory(pkt, TR_DRAWABLE, &err)) == (TERRITORY *)NULL) {
	debug_endfunc("yycom_draw_point");
	return err;
    }
    tx = GetTerritoryXEntry(tr);
    /* draw_lines(n, pointes, points, ..) */
    n = read_packet_entry_integer(pkt);
    points = (XPoint *)calloc(n+1, sizeof(XPoint));
    for (p = points, l = n; l > 0; p++, l--) {
	p->x = read_packet_entry_integer(pkt);
	p->y = read_packet_entry_integer(pkt);
    }
    p->x = points->x; p->y = points->y; n++;
    change_gc(xp->xDisp, tx->txGC, pkt,
	      (YYGC_OPERATION|YYGC_CONNECT|YYGC_COLOR|YYGC_FILL|YYGC_PATTERN),
	      (YYGC *)NULL, xp);
    XFillPolygon(xp->xDisp, tx->txPixmap, tx->txGC, points, n,
		 Convex, CoordModeOrigin);
    if (IsVisibleTerritory(tr)) {
	XFillPolygon(xp->xDisp, tx->txWindow, tx->txGC,
		     points, n, Convex, CoordModeOrigin);
	ch->ccXNeedFlush = TRUE;
    }

    debug_endfunc("yycom_fill_polygon");
    return (yy_packet *)NULL;
}


/***************************************************************************
 ***** Command 28
 *****
 *****  Draw Filled Rectangle
 *****
 ***************************************************************************/

yy_packet *yycom_fill_rectangle(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY *tr;
    TERRITORY_X_ENTRY *tx;
    yy_packet *err;
    int x, y; int w, h;
    YYGC yygc_val;
    debug_setfunc("fill", "yycom_fill_rectangle");
    if ((tr = catch_territory(pkt, TR_DRAWABLE, &err)) == (TERRITORY *)NULL) {
	debug_endfunc("yycom_draw_point");
	return err;
    }
    tx = GetTerritoryXEntry(tr);
    /* fill_rectangle(x,y,w,h,ope,color) */
    x = read_packet_entry_integer(pkt);
    y = read_packet_entry_integer(pkt);
    w = read_packet_entry_integer(pkt);
    h = read_packet_entry_integer(pkt);
    change_gc(xp->xDisp, tx->txGC, pkt,
	      (YYGC_OPERATION|YYGC_COLOR|YYGC_PATTERN), &yygc_val, xp);
    XFillRectangle(xp->xDisp, tx->txPixmap, tx->txGC, x, y, w, h);
    if (IsVisibleTerritory(tr)) {
	XFillRectangle(xp->xDisp, tx->txWindow, tx->txGC, x, y, w, h);
	ch->ccXNeedFlush = TRUE;
    }
    debug_endfunc("yycom_fill_rectangle");
    return (yy_packet *)NULL;
}

/***************************************************************************
 ***** Command 29
 *****
 *****  Draw Filled Circle
 *****
 ***************************************************************************/

yy_packet *yycom_fill_circle(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY *tr;
    TERRITORY_X_ENTRY *tx;
    yy_packet *err;
    int x, y, r;

    debug_setfunc("fill", "yycom_fill_circle");
    if ((tr = catch_territory(pkt, TR_DRAWABLE, &err)) == (TERRITORY *)NULL) {
	debug_endfunc("yycom_draw_point");
	return err;
    }
    tx = GetTerritoryXEntry(tr);
    /* fill_circle(x,y,r,ope,color) */
    x = read_packet_entry_integer(pkt);
    y = read_packet_entry_integer(pkt);
    r = read_packet_entry_integer(pkt);
    x -= r; y -= r;
    r <<= 1;
    change_gc(xp->xDisp, tx->txGC, pkt,
	      (YYGC_OPERATION|YYGC_COLOR|YYGC_PATTERN), (YYGC *)NULL, xp);
    XFillArc(xp->xDisp, tx->txPixmap, tx->txGC, x, y, r, r, 0, YYPI2);
    if (IsVisibleTerritory(tr)) {
	XFillArc(xp->xDisp, tx->txWindow, tx->txGC, x, y, r, r, 0, YYPI2);
	ch->ccXNeedFlush = TRUE;
    }
    debug_endfunc("yycom_fill_circle");
    return (yy_packet *)NULL;
}


/***************************************************************************
 ***** Command 30
 *****
 *****  Draw Filled Arc
 *****
 ***************************************************************************/

yy_packet *yycom_fill_arc(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY *tr;
    TERRITORY_X_ENTRY *tx;
    yy_packet *err;
    int x, y, r; int a1, a2, a0, a_diff;
    debug_setfunc("fill", "yycom_fill_arc");
    if ((tr = catch_territory(pkt, TR_DRAWABLE, &err)) == (TERRITORY *)NULL) {
	debug_endfunc("yycom_draw_point");
	return err;
    }
    tx = GetTerritoryXEntry(tr);
    /* draw_arc(tr,x,y,r,a1,a2,wid,ope,color,dash) */
    x = read_packet_entry_integer(pkt);
    y = read_packet_entry_integer(pkt);
    r = read_packet_entry_integer(pkt);
    x -= r; y -= r; r <<= 1;
    a1 = (read_packet_entry_integer(pkt) % YYPI2);
    a2 = (read_packet_entry_integer(pkt) % YYPI2);
    if (a1 < 0) a1 += YYPI2;
    if (a2 < 0) a2 += YYPI2;
    a1 = YYPI2 - a1; a2 = YYPI2 - a2;
    if (a1 < a2) { a0 = a1; a_diff = a2 - a1; }
    else	{ a0 = a2; a_diff = a1 - a2; }
    change_gc(xp->xDisp, tx->txGC, pkt,
	      (YYGC_OPERATION|YYGC_COLOR|YYGC_PATTERN|YYGC_ARCMODE),
	      (YYGC *)NULL, xp);
    XFillArc(xp->xDisp, tx->txPixmap, tx->txGC, x, y, r, r, a0, a_diff);
    if (IsVisibleTerritory(tr)) {
	XFillArc(xp->xDisp, tx->txWindow, tx->txGC, x, y, r, r, a0, a_diff);
	ch->ccXNeedFlush = TRUE;
    }
    debug_endfunc("yycom_fill_arc");
    return (yy_packet *)NULL;
}


/***************************************************************************
 ***** Command 41
 *****
 *****  Draw Oval
 *****
 ***************************************************************************/

yy_packet *yycom_draw_oval(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY *tr;
    TERRITORY_X_ENTRY *tx;
    yy_packet *err;
    int x, y, w, h; int a1, a2, a0, a_diff;
    debug_setfunc("draw", "yycom_draw_oval");
    if ((tr = catch_territory(pkt, TR_DRAWABLE, &err)) == (TERRITORY *)NULL) {
	debug_endfunc("yycom_draw_point");
	return err;
    }
    tx = GetTerritoryXEntry(tr);
    /* draw_arc(tr,x,y,r,a1,a2,wid,ope,color,dash) */
    x = read_packet_entry_integer(pkt);
    y = read_packet_entry_integer(pkt);
    w = read_packet_entry_integer(pkt);
    h = read_packet_entry_integer(pkt);
    x -= (w >> 1); y -= (h >> 1);
    a1 = (read_packet_entry_integer(pkt) % YYPI2);
    a2 = (read_packet_entry_integer(pkt) % YYPI2);
    if (a1 < 0) a1 += YYPI2;
    if (a2 < 0) a2 += YYPI2;
    a1 = YYPI2 - a1; a2 = YYPI2 - a2;
    if (a1 < a2) { a0 = a1; a_diff = a2 - a1; }
    else	{ a0 = a2; a_diff = a1 - a2; }
    change_gc(xp->xDisp, tx->txGC, pkt,
	      (YYGC_LINWIDTH|YYGC_OPERATION|YYGC_COLOR|YYGC_DASH),
	      (YYGC *)NULL, xp);
    XDrawArc(xp->xDisp, tx->txPixmap, tx->txGC, x, y, w, h, a0, a_diff);
    if (IsVisibleTerritory(tr)) {
	XDrawArc(xp->xDisp, tx->txWindow, tx->txGC, x, y, w, h, a0, a_diff);
	ch->ccXNeedFlush = TRUE;
    }
    debug_endfunc("yycom_draw_oval");
    return (yy_packet *)NULL;
}


/***************************************************************************
 ***** Command 42
 *****
 *****  Draw Filled Oval
 *****
 ***************************************************************************/

yy_packet *yycom_fill_oval(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY *tr;
    TERRITORY_X_ENTRY *tx;
    yy_packet *err;
    int x, y, w, h; int a1, a2, a0, a_diff;
    debug_setfunc("fill", "yycom_fill_oval");
    if ((tr = catch_territory(pkt, TR_DRAWABLE, &err)) == (TERRITORY *)NULL) {
	debug_endfunc("yycom_draw_point");
	return err;
    }
    tx = GetTerritoryXEntry(tr);
    x = read_packet_entry_integer(pkt);
    y = read_packet_entry_integer(pkt);
    w = read_packet_entry_integer(pkt);
    h = read_packet_entry_integer(pkt);
    x -= (w >> 1); y -= (h >> 1);
    a1 = (read_packet_entry_integer(pkt) % YYPI2);
    a2 = (read_packet_entry_integer(pkt) % YYPI2);
    if (a1 < 0) a1 += YYPI2;
    if (a2 < 0) a2 += YYPI2;
    a1 = YYPI2 - a1; a2 = YYPI2 - a2;
    if (a1 < a2) { a0 = a1; a_diff = a2 - a1; }
    else	{ a0 = a2; a_diff = a1 - a2; }
    change_gc(xp->xDisp, tx->txGC, pkt,
	      (YYGC_OPERATION|YYGC_COLOR|YYGC_PATTERN|YYGC_ARCMODE),
	      (YYGC *)NULL, xp);
    XFillArc(xp->xDisp, tx->txPixmap, tx->txGC, x, y, w, h, a0, a_diff);
    if (IsVisibleTerritory(tr)) {
	XFillArc(xp->xDisp, tx->txWindow, tx->txGC, x, y, w, h, a0, a_diff);
	ch->ccXNeedFlush = TRUE;
    }
    debug_endfunc("yycom_fill_oval");
    return (yy_packet *)NULL;
}





/***
 * Bitmap Operation
 */

yy_packet *yycom_create_bitmap(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY *tr;
    TERRITORY_X_ENTRY *tx;
    yy_packet *err;
    yy_packet *repl;
    debug_setfunc("bitmap", "yycom_create_bitmap");
    debug_endfunc("yycom_create_bitmap");
    return (yy_packet *)NULL;
}


yy_packet *yycom_operate_bitblt(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY *tr;
    TERRITORY_X_ENTRY *tx;
    yy_packet *err;
    yy_packet *repl;
    debug_setfunc("bitmap", "yycom_operate_bitblt");
    debug_endfunc("yycom_operate_bitblt");
    return (yy_packet *)NULL;
}


yy_packet *yycom_save_picture(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY *tr;
    TERRITORY_X_ENTRY *tx;
    yy_packet *err;
    yy_packet *repl;
    debug_setfunc("bitmap", "yycom_save_picture");
    debug_endfunc("yycom_save_picture");
    return (yy_packet *)NULL;
}


yy_packet *yycom_load_picture(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY *tr;
    TERRITORY_X_ENTRY *tx;
    yy_packet *err;
    yy_packet *repl;
    debug_setfunc("bitmap", "yycom_load_picture");
    debug_endfunc("yycom_load_picture");
    return (yy_packet *)NULL;
}


yy_packet *yycom_translate_picture(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY *tr;
    TERRITORY_X_ENTRY *tx;
    yy_packet *err;
    yy_packet *repl;
    debug_setfunc("bitmap", "yycom_translate_picture");
    debug_endfunc("yycom_translate_picture");
    return (yy_packet *)NULL;
}


yy_packet *yycom_rotate_picture(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY *tr;
    TERRITORY_X_ENTRY *tx;
    yy_packet *err;
    yy_packet *repl;
    debug_setfunc("bitmap", "yycom_rotate_picture");
    debug_endfunc("yycom_rotate_picture");
    return (yy_packet *)NULL;
}


yy_packet *yycom_get_image(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY *tr;
    TERRITORY_X_ENTRY *tx;
    yy_packet *err;
    yy_packet *repl;
    int x, y, w, h;
    int lt_x, lt_y, rb_x, rb_y;
    int format;
    XImage *im;
    debug_setfunc("image", "yycom_get_image");
    if ((tr = catch_territory(pkt, TR_DRAWABLE, &err)) == (TERRITORY *)NULL) {
	debug_endfunc("yycom_draw_point");
	return err;
    }
    tx = GetTerritoryXEntry(tr);
    /* x, y, w, h */
    x = read_packet_entry_integer(pkt);
    y = read_packet_entry_integer(pkt);
    w = read_packet_entry_integer(pkt);
    h = read_packet_entry_integer(pkt);
    format = read_packet_entry_integer(pkt);
    if (format != YYIMAGEFORM_YY) {
	err = ALLOC_ERRPACKET(pkt);
	SETYYERRORCODE(err, 0);
	SETYYERRORCODE(err, YYERROR_TYPEMISMATCH);
	return err;
    }
    lt_x = MAX(x, 0); lt_y = MAX(y, 0);
    rb_x = MIN((x+w),tr->teWidth); rb_y = MIN((y+h),tr->teHeight);
    /* Get Image */
    debug_print(5, "GetImage on TR#%d (%d,%d)[%d,%d] -> (%d,%d)[%d,%d]\n",
		tr->teID, x, y, w, h, lt_x, lt_y, (rb_x-lt_x), (rb_y-lt_y));
    im = XGetImage(xp->xDisp, tx->txPixmap,
		   lt_x, lt_y, (rb_x-lt_x), (rb_y-lt_y), AllPlanes, ZPixmap);
    repl = ALLOC_ACKPACKET(pkt);
    append_packet_entry_integer(repl, tr->teID);
    append_packet_entry_integer(repl, w);
    append_packet_entry_integer(repl, h);
    if (DefaultDepth(xp->xDisp, xp->xScreen) > 1) {
	/* Color */
	int wx, wy, lx, ly;
	append_packet_entry_integer(repl, (YYIMAGEFORM_COLOR|YYIMAGEFORM_YY));
	append_packet_entry_integer(repl, w*h*4);
	for (wy = y, ly = h; ly > 0 ; wy++, ly--) {
	    if (wy >= lt_y && wy < rb_y) {
		for (wx = x, lx = w; lx > 0 ; wx++, lx--) {
		    if (wx >= lt_x && wx < rb_x) {
			u_long pixel = XGetPixel(im, (wx-lt_x), (wy-lt_y));
			append_packet_entry_integer(repl, pixel);
		    } else
			append_packet_entry_integer(repl, 0);
		}
	    } else {
		for (lx = w; lx > 0 ; lx--)
		    append_packet_entry_integer(repl, 0);
	    }
	}
    } else { /* B&W */
	int wx, wy, lx, ly, ll;
	u_long cc;
	append_packet_entry_integer(repl, (YYIMAGEFORM_BW|YYIMAGEFORM_YY));
	append_packet_entry_integer(repl, (w*h+3)>>2);
	ll = 16; cc = 0;
	for (wy = y, ly = h; ly > 0 ; wy++, ly--) {
	    for (wx = x, lx = w; lx > 0 ; wx++, lx--) {
		cc <<= 2;
		if (wy >= lt_y && wy < rb_y && wx >= lt_x && wx < rb_x) {
		    u_long pixel = XGetPixel(im, (wx-lt_x), (wy-lt_y));
		    cc |= (pixel & 1);
		}
		ll--;
		if (ll <= 0) {
		    append_packet_entry_integer(repl, cc);
		    ll = 16; cc = 0;
		}
	    }
	}
	if (ll < 16) {
	    cc <<= (ll>>1);
	    append_packet_entry_integer(repl, cc);
	}
    }
    XDestroyImage(im);
    debug_endfunc("yycom_get_image");
    return (yy_packet *)repl;
}


yy_packet *yycom_put_image(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY *tr;
    TERRITORY_X_ENTRY *tx;
    yy_packet *err;
    yy_packet *repl;
    int x, y, w, h;
    int lt_x, lt_y, rb_x, rb_y;
    int format, bytes;
    XImage *im;

    debug_setfunc("image", "yycom_put_image");

    if ((tr = catch_territory(pkt, TR_DRAWABLE, &err)) == (TERRITORY *)NULL) {
	debug_endfunc("yycom_draw_point");
	return err;
    }
    tx = GetTerritoryXEntry(tr);
    /* x, y, w, h */
    x = read_packet_entry_integer(pkt);
    y = read_packet_entry_integer(pkt);
    w = read_packet_entry_integer(pkt);
    h = read_packet_entry_integer(pkt);
    format = read_packet_entry_integer(pkt);
    bytes = read_packet_entry_integer(pkt);
    if ((format & 0377) != YYIMAGEFORM_YY) {
	err = ALLOC_ERRPACKET(pkt);
	SETYYERRORCODE(err, 0);
	SETYYERRORCODE(err, YYERROR_TYPEMISMATCH);
	return err;
    }
    if (x >= tr->teWidth || y >= tr->teHeight || (x+w) < 0 || (y+h) < 0)
	goto send_reply;
    lt_x = MAX(x, 0); lt_y = MAX(y, 0);
    rb_x = MIN((x+w),tr->teWidth); rb_y = MIN((y+h),tr->teHeight);
    im = XGetImage(xp->xDisp, tx->txPixmap,
		   lt_x, lt_y, (rb_x-lt_x), (rb_y-lt_y), AllPlanes, ZPixmap);
    debug_print(5, "PutImage on (%d,%d)[%d,%d] from (%d,%d)[%d,%d]\n",
		x, y, w, h, lt_x, lt_y, (rb_x-lt_x), (rb_y-lt_y));
    if (format & YYIMAGEFORM_COLOR) {
	/* color */
	int wx, wy, lx, ly;
	debug_print(7, "Color Image\n");
	for (wy = y, ly = h; ly > 0 ; wy++, ly--) {
	    for (wx = x, lx = w; lx > 0 ; wx++, lx--) {
		u_long pixel = read_packet_entry_integer(pkt);
		XPutPixel(im, (wx-lt_x), (wy-lt_y),
			  (wy >= lt_y && wy < rb_y && wx >= lt_x && wx < rb_x?
		       pixel: BlackPixel(xp->xDisp, xp->xScreen)));
	    }
	}
    } else if (format & YYIMAGEFORM_GRAY) {
	/* Gray */ 
	debug_print(7, "Gray Image\n");
    } else {
	/* B&W */
	int wx, wy, lx, ly, ll;
	u_long cc;
	debug_print(7, "B&W Image\n");
	cc = read_packet_entry_integer(pkt); ll = 16;
	for (wy = y, ly = h; ly > 0 ; wy++, ly--) {
	    for (wx = x, lx = w; lx > 0 ; wx++, lx--) {
		if (wy >= lt_y && wy < rb_y && wx >= lt_x && wx < rb_x) {
		    u_long pixel;
		    pixel = ((cc >> 30) & 3);
		    XPutPixel(im, (wx-lt_x), (wy-lt_y), pixel);
		}
		ll--;
		if (ll > 0) {
		    cc <<= 2;
		} else {
		    cc = read_packet_entry_integer(pkt); ll = 16;
		}
	    }
	}
    }
    XSetFunction(xp->xDisp, tx->txGC, GXcopy);
    XPutImage(xp->xDisp, tx->txPixmap, tx->txGC, im, 0, 0,
	      lt_x, lt_y, (rb_x-lt_x), (rb_y-lt_y));
    if (IsVisibleTerritory(tr)) {
	XPutImage(xp->xDisp, tx->txWindow, tx->txGC, im, 0, 0,
		  lt_x, lt_y, (rb_x-lt_x), (rb_y-lt_y));
	ch->ccXNeedFlush = TRUE;
    }
    XDestroyImage(im);
 send_reply:
    debug_endfunc("yycom_put_image");
    return (yy_packet *)NULL;
}

/*
 * Local variables:
 * eval: (set-kanji-fileio-code 'EUC)
 * end:
 */
