/* Header File for Dummy CLient for YY-server
 * This file is part of YY-server of YYonX (1.2 Distribution)
 * $Header: /home/prophet/keisuke/work/YY/keisuke-client/RCS/cmd.h,v 1.4 90/11/05 21:03:59 keisuke Exp $
 */

/****************************************************************************
;;;
;;;  Copyright (C) 1989,1990 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notice appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification.
;;;
;;; The principle designer and the project manager is Prof. Masayuki Ida
;;; of Computer Science Research Laboratory. Questions and inqueries about
;;; the overall issues should be addressed to ida@csrl.aoyama.ac.jp.
;;; Any person obtaining a copy of this software is requested to send
;;; their name and post office or electronic mail address to:
;;;    Prof. Masayuki Ida
;;;    CSRL, Information Science Research Center
;;;    Aoyama Gakuin University
;;;    4-4-25 Shibuya, Shibuya-ku Tokyo, JAPAN 150
;;;    ida@csrl.aoyama.ac.jp
;;; There is a mailing list for YY named yyonx@csrl.aoyama.ac.jp
;;; To request a subsrciption, send E-mail to yyonx-request@csrl.aoyama.ac.jp
;;;
;;; Authors:
;;;   Version 1.0 90/02/27 by Keisuke 'Keiko' Tanaka
;;;				(keisuke@csrl.aoyama.ac.jp)
;;;   Version 2.4 90/11/05 by Keisuke 'Keiko' Tanaka
;;;			Copyright Notice was rewritten
;;;
****************************************************************************/

/****************************************************************************
  $Revision: 1.4 $ Written by Keisuke 'Keiko' Tanaka
  $Date: 90/11/05 21:03:59 $
****************************************************************************/

typedef char *command_function;

struct _command_entry {
	int cmdVal;
	char *cmdLabel;
	command_function (*cmdFunc)();
	char *cmdArgs;
	char *cmdComment;
} ;
typedef struct _command_entry command_entry;

struct _command_control_entry {
	command_entry *ceTable;
	int ceTableSize;
	int ceDoneInit;
	int ceDoneSave;
	int ceExitFlag;
	int ceNoEchoFlag;
	int ceErrCode;
	int ceMaxCmdLeng;
	char *ceHelpFmt;
} ;
typedef struct _command_control_entry CMD;

#define CMDERRCODE(ctrl)	((ctrl)->ceErrCode)
#define CMDSETEXIT(ctrl)	((ctrl)->ceExitFlag = 1)
#define CMDCHKEXIT(ctrl)	((ctrl)->ceExitFlag)

#define CMDTBLSIZE(ct)	(sizeof(ct)/sizeof(command_entry))

#define CMDMAXONELINE	1024
#define CMDMAXARGS	1024

extern CMD *cmd_init();
extern void cmd_fprintf();
extern char *cmd_getstr();
extern command_function cmd_help();
extern command_function cmd_exit();
extern command_function cmd_execute();
extern command_function cmd_call();
extern void cmd_term();
