/* Parse user input command and do it */
#ifndef lint
static char RcsID[] = "$Header: /home/prophet/keisuke/work/YY/keisuke-client/RCS/cmd.c,v 1.4 90/11/05 21:03:57 keisuke Exp $";
#endif

/* Command Table and Command Dispatch Function for Dummy Client
 * This file is part of YY-server of YYonX (1.2 Distribution)
 * $Header: /home/prophet/keisuke/work/YY/keisuke-client/RCS/cmd.c,v 1.4 90/11/05 21:03:57 keisuke Exp $
 */

/****************************************************************************
;;;
;;;  Copyright (C) 1989,1990 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notice appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification.
;;;
;;; The principle designer and the project manager is Prof. Masayuki Ida
;;; of Computer Science Research Laboratory. Questions and inqueries about
;;; the overall issues should be addressed to ida@csrl.aoyama.ac.jp.
;;; Any person obtaining a copy of this software is requested to send
;;; their name and post office or electronic mail address to:
;;;    Prof. Masayuki Ida
;;;    CSRL, Information Science Research Center
;;;    Aoyama Gakuin University
;;;    4-4-25 Shibuya, Shibuya-ku Tokyo, JAPAN 150
;;;    ida@csrl.aoyama.ac.jp
;;; There is a mailing list for YY named yyonx@csrl.aoyama.ac.jp
;;; To request a subsrciption, send E-mail to yyonx-request@csrl.aoyama.ac.jp
;;;
;;; Authors:
;;;   Version 1.0 90/02/27 by Keisuke 'Keiko' Tanaka
;;;				(keisuke@csrl.aoyama.ac.jp)
;;;   Version 1.4 90/11/05 by Keisuke 'Keiko' Tanaka
;;;			Copyright Notice was rewritten
;;;
****************************************************************************/

/****************************************************************************
  $Revision: 1.4 $ Written by Keisuke 'Keiko' Tanaka
  $Date: 90/11/05 21:03:57 $
****************************************************************************/

#include <stdio.h>
#include <ctype.h>
#include <curses.h>
#include "cmd.h"

#ifdef MAX
#undef MAX
#endif
#define MAX(a1,a2)	((a1)>(a2)? (a1): (a2))

#define NOMEMORY	"Can't allocate momory\n"

CMD *cmd_init(table, nent)
	command_entry *table;
	int nent;
{
	CMD *ctrl = (CMD *)malloc(sizeof(CMD));
	command_entry *ce;
	int max, loop;
	static char buf[20];

	if (ctrl == (CMD *)NULL) {
		fprintf(stderr, NOMEMORY); return (CMD *)NULL;
	}
	bzero((char *)ctrl, sizeof(CMD));

	ctrl->ceTable = (command_entry *)calloc(nent, sizeof(command_entry));
	if (ctrl->ceTable == (command_entry *)NULL) {
		(void) free((char *)ctrl);
		fprintf(stderr, NOMEMORY); return (CMD *)NULL;
	}
	bcopy((char *)table, (char *)ctrl->ceTable,
	      nent*sizeof(command_entry));
	ctrl->ceTableSize = nent;
	for (ce = table, loop = nent, max = 0; loop > 0; ce++, loop--)
		max = MAX(max,strlen(ce->cmdLabel));
	sprintf(buf, "%%%ds  %%s\n", max);
	ctrl->ceHelpFmt = buf;
	ctrl->ceMaxCmdLeng = max;
	initscr(); ctrl->ceDoneInit = 1;
	savetty(); ctrl->ceDoneSave = 1;
	crmode();
	noecho();
	scrollok(stdscr,TRUE);
	clear();
	refresh();
	ctrl->ceExitFlag = 0;
	return ctrl;
}

#ifndef EOL
#define EOL		'\n'
#endif
#ifndef EOS
#define EOS		'\0'
#endif
#ifndef SINGLEQUOTE
#define SINGLEQUOTE	'\''
#endif
#ifndef DOUBLEQUOTE
#define DOUBLEQUOTE	'\"'
#endif

void cmd_fprintf(dummy, fmt, a1, a2, a3, a4, a5, a6)
	FILE *dummy;
	char *fmt;
{
	printw(fmt, a1, a2, a3, a4, a5, a6);
	refresh();
}

char *cmd_getstr(line, size, fmt, a1, a2, a3, a4, a5, a6)
	char *line;
	int size;
	char *fmt;
{
	char prompt[256];
	register char *s;
	register int leng;
	register char c;
	register int limit = size;
	int top_y, top_x;

	sprintf(prompt, fmt, a1, a2, a3, a4, a5, a6);
	clrtoeol(); addstr(prompt); refresh();
	s = line; leng = 0;
	getyx(stdscr, top_y, top_x);
	while ((c = getch()) != EOL) {
		if (!isprint(c)) {
			/* Control Caracter */
			if (c == CTRL(h)) {
				if (leng > 0) {
					s--; leng--; limit++;
					addch(c); delch(); refresh();
				}
			} else if (c == CTRL(u)) {
				register int y, x;
				getyx(stdscr, y, x);
				if (y == top_y) {
					move(top_y,top_x); clrtoeol();
				} else {
					move(y, 0); clrtoeol();
					addstr(prompt);
					getyx(stdscr, top_y, top_x);
				}
				refresh();
				s = line; leng = 0; limit = size;
			} else if (c == CTRL(r)) {
				addch(EOL); clrtoeol(); addstr(prompt);
				getyx(stdscr, top_y, top_x);
				*s = EOS;
				addstr(line); refresh();
			}
			continue;
		}
		/* Normal Caracter */
		if (limit > 0) {
			*s++ = c; leng++; limit--;
			addch(c); refresh();
		}
	}
	addch(EOL); refresh();
	*s = EOS;
	return line;
}

command_function cmd_help(ctrl, private, def_val, def_arg, ac, av)
	CMD *ctrl;
	char *private;
	int def_val;
	char *def_arg;
	int ac;
	char *av[];
{
	command_entry *ce;
	int loop;
	for (ce = ctrl->ceTable, loop = ctrl->ceTableSize;
	     loop > 0; ce++, loop--)
		printw(ctrl->ceHelpFmt, ce->cmdLabel, ce->cmdComment);
	refresh();
	return (command_function)NULL;
}

command_function cmd_exit(ctrl, private, def_val, def_arg, ac, av)
	CMD *ctrl;
	char *private;
	int def_val;
	char *def_arg;
	int ac;
	char *av[];
{
	CMDSETEXIT(ctrl);
	return (command_function)NULL;
}

static void cmd_list(ctrl, line, leng)
	CMD *ctrl;
	char *line;
	int leng;
{
	command_entry *ce;
	int loop;
	addch(EOL);
	for (ce = ctrl->ceTable, loop = ctrl->ceTableSize;
	     loop > 0; ce++, loop--) {
		if (leng == 0 || strncmp(ce->cmdLabel, line, leng) == 0) {
			addstr(ce->cmdLabel); addch(EOL);
		}
	}
	refresh();
}

static int cmd_expand(ctrl, line, ptr, size, lim)
	CMD *ctrl;
	char *line;
	char **ptr;
	int *size, *lim;
{
	command_entry *ce, *pending;
	int loop;
	int leng = *size;
	int num = 0;
	if (leng == 0) {
		cmd_list(ctrl, line, leng);
		return -1;
	}
	/* Fixed? */
	**ptr = EOS;
	for (ce = ctrl->ceTable, loop = ctrl->ceTableSize;
	     loop > 0; ce++, loop--) {
		if (strcmp(ce->cmdLabel, line) == 0) {
			register int fixpoint = *size;
			if (*lim > 0) {
				**ptr = ' '; addch(' '); refresh();
				(*ptr)++; (*size)++; (*lim)--;
			}
			return fixpoint;
		}
		if (strncmp(ce->cmdLabel, line, leng) == 0) {
			pending = ce; num++;
		}
	}
	if (num == 0) {
		addstr("\n?\n"); refresh();
		*ptr = line;
		*size = 0; *lim = CMDMAXONELINE;
		return -1;
	}
	if (num == 1) {
		char *s = pending->cmdLabel + leng;
		while (*s != EOS && *lim > 0) {
			addch(*s);
			**ptr = *s++; (*ptr)++;
			(*size)++; (*lim)--;
		}
		refresh();
		return *size;
	}
	cmd_list(ctrl, line, leng);
	return -1;
}

command_function cmd_call(ctrl, private, line, size, fix)
	CMD *ctrl;
	char *private;
	char *line;
	int size, fix;
{
	char *args[CMDMAXARGS];
	char buf[CMDMAXONELINE+1];
	int narg;
	if (size == 0) {
		addstr("What?\n");
		return (command_function)NULL;
	}
	strcpy(buf, line);
	if (fix == 0) { /* Not Fixed Yet */
		args[0] = line;
		narg = 1;
	} else {
		register char *s = buf;
		register char **ss = args;
		int lim = CMDMAXARGS;
		narg = 0;
		while (*s != EOS && lim > 0 && narg >= 0) {
			/* Skip While Space */
			while (isspace(*s))
				s++;
			if (*s == EOS)
				break;
			if (*s == SINGLEQUOTE || *s == DOUBLEQUOTE) {
				register char c = *s++;
				*ss++ = s; narg++; lim--;
				for ( ; ; s++) {
					if (*s == EOS) {
						narg = -1;
						break;
					} else if (*s == c) {
						*s++ = EOS;
						break;
					}
				}
				continue;
			}
			*ss++ = s; narg++; lim--;
			for ( ; *s != EOS; s++)
				if (isspace(*s)) {
					*s++ = EOS;
					break;
				}
		}
	}
	if (narg < 0) {
		printw("Can't Parse '%s'\n", line);
		return (command_function)NULL;
	} else if (narg > 0) {
		register command_entry *ce;
		register int loop;
#ifdef CMDDEBUG
		int i; char **ss;
		for (i = narg, ss = args; i > 0; i--, ss++)
			printw("'%s'(%d)\n", *ss, i);
		refresh();
#endif CMDDEBUG		
		for (ce = ctrl->ceTable, loop = ctrl->ceTableSize;
		     loop > 0; ce++, loop--)
			if (strcmp(ce->cmdLabel, args[0]) == 0)
				break;
		if (loop == 0) {
			printw("Unknown Command '%s'\n", args[0]);
			return (command_function)NULL;
		}
		if (ce->cmdFunc == NULL) {
			printw("Command '%s' is not available (yet)\n",
			       args[0]);
			return (command_function)NULL;
		}
		return (*ce->cmdFunc)(ctrl, private, ce->cmdVal, ce->cmdArgs,
				      narg, args);
	}
	addstr("What?\n");
	return (command_function)NULL;
}

command_function cmd_execute(ctrl, private, fmt, a1, a2, a3, a4, a5, a6)
	CMD *ctrl;
	char *private;
	char *fmt;
{
	char line[CMDMAXONELINE+1];
	int c;
	int top_y, top_x;
	int tail_y, tail_x;
	int y, x;
	char *s;
	int limit = CMDMAXONELINE;
	int size = 0;
	int fix = 0;
	char prompt[256];

	sprintf(prompt, fmt, a1, a2, a3, a4, a5, a6);
	clrtoeol(); addstr(prompt); refresh();
	s = line; size = 0;
	getyx(stdscr, top_y, top_x);
	while ((c = getch()) != EOL) {
		if (!isprint(c)) {
			/* Control Caracter */
			if (c == CTRL(h)) {
				if (size > 0) {
					s--; size--; limit++;
					if (size < fix)
						fix = 0;
					addch(c); delch(); refresh();
				}
			} else if (c == CTRL(u)) {
				getyx(stdscr, y, x);
				if (y == top_y) {
					move(top_y,top_x); clrtoeol();
				} else {
					move(y, 0); clrtoeol();
					addstr(prompt);
					getyx(stdscr, top_y, top_x);
				}
				refresh();
				s = line; size = 0; limit = CMDMAXONELINE;
				fix = 0;
			} else if (c == CTRL(r)) {
				addch(EOL); clrtoeol(); addstr(prompt);
				getyx(stdscr, top_y, top_x);
				*s = EOS;
				addstr(line);
				refresh();
			}
			continue;
		}
		if (c == ' ' && fix == 0) {
			fix = cmd_expand(ctrl, line, &s, &size, &limit);
			if (fix < 0) {
				addstr(prompt); refresh();
				getyx(stdscr, top_y, top_x);
				if (size > 0)
					addstr(line);
				refresh();
				fix = 0;
			}
			continue;
		}
		if (c == '?' && fix == 0) {
			*s = EOS;
			cmd_list(ctrl, line, size);
			addstr(prompt); getyx(stdscr, top_y, top_x);
			addstr(line); refresh();
			continue;
		}
		/* Normal Caracter */
		if (limit > 0) {
			*s++ = c; size++; limit--;
			addch(c); refresh();
		}
	}
	addch(EOL); refresh();
	*s = EOS;
#ifdef CMDDEBUG
	printw("%s(%d)\n", line, fix); refresh();
#endif CMDDEBUG
	return(cmd_call(ctrl, private, line, size, fix));
}

void cmd_term(ctrl)
	CMD *ctrl;
{
	if (ctrl->ceDoneSave)
		resetty();
	if (ctrl->ceDoneInit)
		endwin();
}
