/* Main routine for YY dummy client */
#ifndef lint
static char RcsID[] = "$Header: /home/prophet/keisuke/work/YY/keisuke-client/RCS/client.c,v 1.10 90/11/05 21:03:39 keisuke Exp $";
#endif

/* Dummy Client for YY-server
 *  This Client is used fot Debugging
 * This file is part of YY-server of YYonX (1.2 Distribution)
 * $Header: /home/prophet/keisuke/work/YY/keisuke-client/RCS/client.c,v 1.10 90/11/05 21:03:39 keisuke Exp $
 */

/****************************************************************************
;;;
;;;  Copyright (C) 1989,1990 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notice appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification.
;;;
;;; The principle designer and the project manager is Prof. Masayuki Ida
;;; of Computer Science Research Laboratory. Questions and inqueries about
;;; the overall issues should be addressed to ida@csrl.aoyama.ac.jp.
;;; Any person obtaining a copy of this software is requested to send
;;; their name and post office or electronic mail address to:
;;;    Prof. Masayuki Ida
;;;    CSRL, Information Science Research Center
;;;    Aoyama Gakuin University
;;;    4-4-25 Shibuya, Shibuya-ku Tokyo, JAPAN 150
;;;    ida@csrl.aoyama.ac.jp
;;; There is a mailing list for YY named yyonx@csrl.aoyama.ac.jp
;;; To request a subsrciption, send E-mail to yyonx-request@csrl.aoyama.ac.jp
;;;
;;; Authors:
;;;   Version 1.0 90/02/27 by Keisuke 'Keiko' Tanaka
;;;				(keisuke@csrl.aoyama.ac.jp)
;;;   Version 1.10 90/11/05 by Keisuke 'Keiko' Tanaka
;;;			Copyright Notice was rewritten
;;;
****************************************************************************/

/****************************************************************************
  $Revision: 1.10 $ Written by Keisuke 'Keiko' Tanaka
  $Date: 90/11/05 21:03:39 $
****************************************************************************/


#include <stdio.h>
#include <fcntl.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <netinet/in.h>
#include <netdb.h>
#include <strings.h>
#include "yydefs.h"
#include "yypacket.h"
#include "cmd.h"

int YYPacketBlockSize;

command_function make_command(ctrl, loc_arg, def_val, def_arg, ac, av)
    CMD *ctrl;		/* Command Control Block */
    char *loc_arg;
    int def_val;
    char *def_arg;
    int ac;
    char *av[];
{
    debug_setfunc("control", "make_command");
    debug_endfunc("make_command");
}

command_function exit_command(ctrl, loc_arg, def_val, def_arg, ac, av)
    CMD *ctrl;
    char *loc_arg;
    int def_val;
    char *def_arg;
    int ac;
    char *av[];
{
    CMDSETEXIT(ctrl);
    return (command_function)NULL;
}

command_function sleep_command(ctrl, loc_arg, def_val, def_arg, ac, av)
    CMD *ctrl;
    char *loc_arg;
    int def_val;
    char *def_arg;
    int ac;
    char *av[];
{
    int time = 3;
    if (ac > 1)
	if ((time = atoi(av[1])) <= 0)
	    time = 3;
    sleep(time);
    return (command_function)NULL;
}

command_function echo_command(ctrl, loc_arg, def_val, def_arg, ac, av)
    CMD *ctrl;
    char *loc_arg; int def_val; char *def_arg;
    int ac; char *av[];
{
	ctrl->ceNoEchoFlag = 0;
	return (command_function)NULL;
}

command_function noecho_command(ctrl, loc_arg, def_val, def_arg, ac, av)
	CMD *ctrl;
	char *loc_arg; int def_val; char *def_arg;
	int ac; char *av[];
{
	ctrl->ceNoEchoFlag = 1;
	return (command_function)NULL;
}

struct cmd_arg {
	int argType;
	int defVal;
	char *defPtr;
	char *argLabel;
} ;
#define ARG_INT 	1
#define ARG_STR 	2

#define HAVEVALDEF(a)	((a)->argType == ARG_INT && (a)->defVal >= 0)
#define HAVESTRDEF(a)	((a)->argType == ARG_STR && (a)->defPtr != NULL)

command_function push_yy_packet(ctrl, loc_arg, def_val, def_arg, ac, av)
	CMD *ctrl;
	char *loc_arg;
	int def_val;
	char *def_arg;
	int ac;
	char *av[];
{
	int sock = (int)loc_arg;
	struct cmd_arg *targ = (struct cmd_arg *)def_arg;
	yy_packet *pkt;
	char str[256];
	char *usr_input;
	int echo = (!ctrl->ceNoEchoFlag);

	ac--, av++;
	pkt = alloc_new_yy_packet(def_val, YYPACKETTYPE_COMMAND, 0, NULL);
	while (targ->argType > 0) {
		if (ac > 0 && echo) {
			if (HAVEVALDEF(targ))
				printw(" %s[%d]=>",
				       targ->argLabel, targ->defVal);
			else
				printw(" %s[%s]=>", targ->argLabel,
				       (HAVESTRDEF(targ)? targ->defPtr: ""));
			if (strcmp(*av, "-") == 0)
				av[0][0] = EOS;
			cmd_fprintf(NULL, "%s\n", *av);
			ac--;
			usr_input = *av++;
		} else if (ac > 0) {
			if (strcmp(*av, "-") == 0)
				av[0][0] = EOS;
			ac--;
			usr_input = *av++;
		} else {
			if (HAVEVALDEF(targ))
				usr_input = cmd_getstr(str, sizeof(str),
						       " %s[%d]=>",
						       targ->argLabel,
						       targ->defVal);
			else
				usr_input = cmd_getstr(str, sizeof(str),
						       " %s[%s]=>",
						       targ->argLabel,
						       (HAVESTRDEF(targ)?
							targ->defPtr: ""));
		}
		if (*usr_input == EOS && targ->argType == ARG_INT) {
			if (targ->defVal < 0) {
				ac = 0;
				continue;
			}
			append_packet_entry_integer(pkt, targ->defVal);
			targ++;
			continue;
		}
		if (*usr_input == EOS && targ->argType == ARG_STR) {
			register char *s;
			if ((s = targ->defPtr) == NULL)
				append_packet_entry_integer(pkt, 0);
			else
				append_packet_entry_string(pkt, s);
			targ++;
			continue;
		}
		if (targ->argType == ARG_INT)
			append_packet_entry_integer(pkt, atoi(usr_input));
		else
			append_packet_entry_string(pkt, usr_input);
		targ++;
	}
	fix_yy_packet(pkt);
	if (echo)
		dump_yy_packet(pkt);
	send_packet(sock, pkt);
	return (command_function)NULL;
}

struct TimerEnt {
	int Running;
	struct timeval SystemTotal;
	struct timeval UserTotal;
	struct timeval RealTotal;
	struct timeval SystemStart;
	struct timeval UserStart;
	struct timeval RealStart;
	struct timeval SystemLast;
	struct timeval UserLast;
	struct timeval RealLast;
} ;

struct TimerEnt Timer;

timevalsub(a, b, c)
	struct timeval *a, *b, *c;
{
	c->tv_sec = a->tv_sec - b->tv_sec;
	if ((c->tv_usec = a->tv_usec - b->tv_usec) < 0) {
		c->tv_sec--;
		c->tv_usec += 1000000;
	}
}

timevaladd(a, b)
	struct timeval *a, *b;
{
	a->tv_sec += b->tv_sec;
	a->tv_usec += b->tv_usec;
	if (a->tv_usec > 1000000) {
		a->tv_sec++;
		a->tv_usec -= 1000000;
	}
}

command_function timer_set(ctrl, loc_arg, def_val, def_arg, ac, av)
	CMD *ctrl;
	char *loc_arg;
	int def_val;
	char *def_arg;
	int ac;
	char *av[];
{
	if (ac < 2) {
		cmd_fprintf(0, "No Operation\n");
		return (command_function)NULL;
	}
	if (strcmp(av[1], "reset") == 0) {
		Timer.Running = 0;
		Timer.SystemTotal.tv_sec = Timer.SystemTotal.tv_usec = 0;
		Timer.UserTotal.tv_sec = Timer.UserTotal.tv_usec = 0;
		Timer.RealTotal.tv_sec = Timer.RealTotal.tv_usec = 0;
		return (command_function)NULL;
	}
	if (strcmp(av[1], "on") == 0) {
		struct timeval curtime;
		struct rusage curusage;
		Timer.Running = 1;
		gettimeofday(&curtime, (struct timezone *)NULL);
		Timer.RealStart.tv_sec = curtime.tv_sec;
		Timer.RealStart.tv_usec = curtime.tv_usec;
		getrusage(RUSAGE_SELF, &curusage);
		Timer.SystemStart.tv_sec = curusage.ru_stime.tv_sec;
		Timer.SystemStart.tv_usec = curusage.ru_stime.tv_usec;
		Timer.UserStart.tv_sec = curusage.ru_utime.tv_sec;
		Timer.UserStart.tv_usec = curusage.ru_utime.tv_usec;
		return (command_function)NULL;
	}
	if (strcmp(av[1], "off") == 0) {
		struct timeval curtime;
		struct rusage curusage;
		Timer.Running = 0;
		gettimeofday(&curtime, (struct timezone *)NULL);
		timevalsub(&curtime, &Timer.RealStart, &Timer.RealLast);
		timevaladd(&Timer.RealTotal, &Timer.RealLast);
		getrusage(RUSAGE_SELF, &curusage);
		timevalsub(&curusage.ru_stime, &Timer.SystemStart,
			   &Timer.SystemLast);
		timevalsub(&curusage.ru_utime, &Timer.UserStart,
			   &Timer.UserLast);
		timevaladd(&Timer.SystemTotal, &Timer.SystemLast);
		timevaladd(&Timer.UserTotal, &Timer.UserLast);
		return (command_function)NULL;
	}
	if (strcmp(av[1], "disp") == 0) {
		cmd_fprintf(0, "Real: %d.%06d\n",
			    Timer.RealTotal.tv_sec, Timer.RealTotal.tv_usec);
		cmd_fprintf(0, "System: %d.%06d\n",
			    Timer.SystemTotal.tv_sec,
			    Timer.SystemTotal.tv_usec);
		cmd_fprintf(0, "User: %d.%06d\n",
			    Timer.UserTotal.tv_sec, Timer.UserTotal.tv_usec);
		return (command_function)NULL;
	}
	if (strcmp(av[1], "real") == 0) {
		cmd_fprintf(0, "Real: %d.%06d\n",
			    Timer.RealLast.tv_sec, Timer.RealLast.tv_usec);
		return (command_function)NULL;
	}
	if (strcmp(av[1], "system") == 0) {
		cmd_fprintf(0, "System: %d.%06d\n",
			    Timer.SystemLast.tv_sec,
			    Timer.SystemLast.tv_usec);
		return (command_function)NULL;
	}
	if (strcmp(av[1], "user") == 0) {
		cmd_fprintf(0, "User: %d.%06d\n",
			    Timer.UserLast.tv_sec, Timer.UserLast.tv_usec);
		return (command_function)NULL;
	}
	return (command_function)NULL;
}

command_function read_file(ctrl, loc_arg, def_val, def_arg, ac, av)
	CMD *ctrl;
	char *loc_arg;
	int def_val;
	char *def_arg;
	int ac;
	char *av[];
{
	FILE *fp;
	int sock = (int)loc_arg;
	char line[CMDMAXONELINE];
	if (ac < 2) {
		cmd_fprintf(0, "No File Name\n");
		return (command_function)NULL;
	}
	if ((fp = fopen(av[1], "r")) == (FILE *)NULL) {
		cmd_fprintf(0, "'%s': No such file\n", av[1]);
		return (command_function)NULL;
	}
	/* cmd_fprintf(0, "Reading '%s'...\n", av[1]); */
	while (fgets(line, sizeof(line), fp)) {
		register char *s;
		if ((s = index(line, EOL)) != (char *)NULL)
			*s = EOS;
		if (line[0] != EOS && line[0] != '#') {
			cmd_call(ctrl, loc_arg, line, strlen(line), 1);
			if (CMDCHKEXIT(ctrl))
				break;
			recv_packet(sock);
		}
	}
	fclose(fp);
	return (command_function)NULL;
}

struct cmd_arg yy_init_arg[] = {
{ ARG_INT, YYPROTO_MAGIC, NULL, "Magic" },
{ ARG_INT, YYPROTO_VERSION, NULL, "Version" },
{ ARG_INT, YYPROTO_RELEASE, NULL, "Release" },
{ ARG_INT, YYPROTO_SYNC_COUNTER, NULL, "Sync" },
{ ARG_INT, YYPROTO_MOUSE_STAY_TIME, NULL, "Mouse" },
{ ARG_STR, 0, "prophet:0", "Server" },
{ ARG_STR, 0, NULL, "Window Name" },
{ ARG_STR, 0, NULL, "Icon Name" },
{ -1, 0, NULL, NULL }
} ;
struct cmd_arg yy_root_arg[] = {
{ ARG_INT, 0, NULL, "X Position" },
{ ARG_INT, 0, NULL, "Y Position" },
{ ARG_INT, YYWINDEFAULTWIDTH, NULL, "Windth" },
{ ARG_INT, YYWINDEFAULTHEIGHT, NULL, "Height" },
{ ARG_INT, 0, NULL, "Parent" },
{ ARG_INT, 1, NULL, "Display" },
{ ARG_INT, 0, NULL, "Drawable" },
{ -1, 0, NULL, NULL }
} ;
struct cmd_arg yy_create_arg[] = {
{ ARG_INT, 0, NULL, "X Position" },
{ ARG_INT, 0, NULL, "Y Position" },
{ ARG_INT, YYWINDEFAULTWIDTH, NULL, "Windth" },
{ ARG_INT, YYWINDEFAULTHEIGHT, NULL, "Height" },
{ ARG_INT, -1, NULL, "Parent" },
{ ARG_INT, 1, NULL, "Display" },
{ ARG_INT, 1, NULL, "Drawable" },
{ -1, 0, NULL, NULL }
} ;
struct cmd_arg yy_display_arg[] = {
{ ARG_INT, -1, NULL, "No" },
{ ARG_INT, -1, NULL, "Visible" },
{ -1, 0, NULL, NULL }
} ;
struct cmd_arg yy_move_arg[] = {
{ ARG_INT, -1, NULL, "No" },
{ ARG_INT, -1, NULL, "X Position" },
{ ARG_INT, -1, NULL, "Y Position" },
{ -1, 0, NULL, NULL }
} ;
struct cmd_arg yy_resize_arg[] = {
{ ARG_INT, -1, NULL, "No" },
{ ARG_INT, -1, NULL, "X Position" },
{ ARG_INT, -1, NULL, "Y Position" },
{ ARG_INT, -1, NULL, "Windth" },
{ ARG_INT, -1, NULL, "Height" },
{ ARG_INT, -1, NULL, "New X Position" },
{ ARG_INT, -1, NULL, "New Y Position" },
{ -1, 0, NULL, NULL }
} ;
struct cmd_arg yy_destroy_arg[] = {
{ ARG_INT, -1, NULL, "No" },
{ -1, 0, NULL, NULL }
} ;
struct cmd_arg yy_reparent_arg[] = {
{ ARG_INT, -1, NULL, "No" },
{ ARG_INT, -1, NULL, "Parent" },
{ ARG_INT, -1, NULL, "X Position" },
{ ARG_INT, -1, NULL, "Y Position" },
{ -1, 0, NULL, NULL }
} ;
struct cmd_arg yy_raise_arg[] = {
{ ARG_INT, -1, NULL, "No" },
{ -1, 0, NULL, NULL }
} ;
struct cmd_arg yy_lower_arg[] = {
{ ARG_INT, -1, NULL, "No" },
{ -1, 0, NULL, NULL }
} ;
struct cmd_arg yy_draw_point_arg[] = {
{ ARG_INT, -1, NULL, "No" },
{ ARG_INT, -1, NULL, "X Position" },
{ ARG_INT, -1, NULL, "Y Position" },
{ ARG_INT, 15, NULL, "Operation" },
{ ARG_INT, 0, NULL, "Color" },
{ -1, 0, NULL, NULL }
} ;
struct cmd_arg yy_draw_line_arg[] = {
{ ARG_INT, -1, NULL, "No" },
{ ARG_INT, -1, NULL, "X1 Position" },
{ ARG_INT, -1, NULL, "Y1 Position" },
{ ARG_INT, -1, NULL, "X2 Position" },
{ ARG_INT, -1, NULL, "Y2 Position" },
{ ARG_INT, 1, NULL, "Line Width" },
{ ARG_INT, 15, NULL, "Operation" },
{ ARG_INT, 0, NULL, "Edge" },
{ ARG_INT, 0, NULL, "Color" },
{ ARG_INT, 0, NULL, "Dash" },
{ -1, 0, NULL, NULL }
} ;
struct cmd_arg yy_draw_rectangle_arg[] = {
{ ARG_INT, -1, NULL, "No" },
{ ARG_INT, -1, NULL, "X Position" },
{ ARG_INT, -1, NULL, "Y Position" },
{ ARG_INT, -1, NULL, "Width" },
{ ARG_INT, -1, NULL, "Height" },
{ ARG_INT, 1, NULL, "Line Width" },
{ ARG_INT, 15, NULL, "Operation" },
{ ARG_INT, 0, NULL, "Color" },
{ ARG_INT, 0, NULL, "Dash" },
{ -1, 0, NULL, NULL }
} ;
struct cmd_arg yy_draw_lines_arg[] = {
{ ARG_INT, -1, NULL, "No" },
{ ARG_INT, 3, NULL, "Number of Points" },
{ ARG_INT, -1, NULL, "X1 Position" },
{ ARG_INT, -1, NULL, "Y1 Position" },
{ ARG_INT, -1, NULL, "X2 Position" },
{ ARG_INT, -1, NULL, "Y2 Position" },
{ ARG_INT, -1, NULL, "X3 Position" },
{ ARG_INT, -1, NULL, "Y3 Position" },
{ ARG_INT, 1, NULL, "Line Width" },
{ ARG_INT, 15, NULL, "Operation" },
{ ARG_INT, 0, NULL, "Edge" },
{ ARG_INT, 0, NULL, "Joint" },
{ ARG_INT, 0, NULL, "Color" },
{ ARG_INT, 0, NULL, "Dash" },
{ -1, 0, NULL, NULL }
} ;
struct cmd_arg yy_draw_polygon_arg[] = {
{ ARG_INT, -1, NULL, "No" },
{ ARG_INT, 3, NULL, "Number of Points" },
{ ARG_INT, -1, NULL, "X1 Position" },
{ ARG_INT, -1, NULL, "Y1 Position" },
{ ARG_INT, -1, NULL, "X2 Position" },
{ ARG_INT, -1, NULL, "Y2 Position" },
{ ARG_INT, -1, NULL, "X3 Position" },
{ ARG_INT, -1, NULL, "Y3 Position" },
{ ARG_INT, 1, NULL, "Line Width" },
{ ARG_INT, 15, NULL, "Operation" },
{ ARG_INT, 0, NULL, "Joint" },
{ ARG_INT, 0, NULL, "Color" },
{ ARG_INT, 0, NULL, "Dash" },
{ -1, 0, NULL, NULL }
} ;
struct cmd_arg yy_draw_circle_arg[] = {
{ ARG_INT, -1, NULL, "No" },
{ ARG_INT, -1, NULL, "X Position" },
{ ARG_INT, -1, NULL, "Y Position" },
{ ARG_INT, -1, NULL, "Radious" },
{ ARG_INT, 1, NULL, "Line Width" },
{ ARG_INT, 15, NULL, "Operation" },
{ ARG_INT, 0, NULL, "Color" },
{ ARG_INT, 0, NULL, "Dash" },
{ -1, 0, NULL, NULL }
} ;
struct cmd_arg yy_draw_arc_arg[] = {
{ ARG_INT, -1, NULL, "No" },
{ ARG_INT, -1, NULL, "X Position" },
{ ARG_INT, -1, NULL, "Y Position" },
{ ARG_INT, -1, NULL, "Radious" },
{ ARG_INT, -1, NULL, "Angle1" },
{ ARG_INT, -1, NULL, "Angle2" },
{ ARG_INT, 1, NULL, "Line Width" },
{ ARG_INT, 15, NULL, "Operation" },
{ ARG_INT, 0, NULL, "Color" },
{ ARG_INT, 0, NULL, "Dash" },
{ -1, 0, NULL, NULL }
} ;
struct cmd_arg yy_load_font_arg[] = {
{ ARG_STR, -1, NULL, "Font Name" },
{ -1, 0, NULL, NULL }
} ;
struct cmd_arg yy_draw_text_arg[] = {
{ ARG_INT, -1, NULL, "No" },
{ ARG_INT, -1, NULL, "X Position" },
{ ARG_INT, -1, NULL, "Y Position" },
{ ARG_INT, 15, NULL, "Operation" },
{ ARG_INT, 0, NULL, "Color" },
{ ARG_INT, 1, NULL, "Font ID" },
{ ARG_STR, 0, "TEST TEST", "Text" },
{ -1, 0, NULL, NULL }
} ;
struct cmd_arg yy_draw_rtext_arg[] = {
{ ARG_INT, -1, NULL, "No" },
{ ARG_INT, -1, NULL, "X Position" },
{ ARG_INT, -1, NULL, "Y Position" },
{ ARG_INT, 15, NULL, "Operation" },
{ ARG_INT, 0, NULL, "Color" },
{ ARG_INT, 1, NULL, "Font ID" },
{ ARG_INT, 1, NULL, "X Scale" },
{ ARG_INT, 1, NULL, "Y Scale" },
{ ARG_INT, 0, NULL, "Angle" },
{ ARG_STR, 0, "TEST TEST", "Text" },
{ -1, 0, NULL, NULL }
} ;
struct cmd_arg yy_select_territory_arg[] = {
{ ARG_INT, -1, NULL, "No" },
{ -1, 0, NULL, NULL }
} ;
struct cmd_arg yy_set_event_mask_arg[] = {
{ ARG_INT, -1, NULL, "No" },
{ ARG_INT, 511, NULL, "Mask" },
{ -1, 0, NULL, NULL }
} ;
struct cmd_arg yy_clear_territory_arg[] = {
{ ARG_INT, -1, NULL, "No" },
{ ARG_INT, 0, NULL, "Color" },
{ -1, 0, NULL, NULL }
} ;
struct cmd_arg yy_draw_background_arg[] = {
{ ARG_INT, -1, NULL, "No" },
{ ARG_INT, -1, NULL, "Pattern" },
{ -1, 0, NULL, NULL }
} ;
struct cmd_arg yy_query_color_arg[] = {
{ ARG_INT, -1, NULL, "Red" },
{ ARG_INT, -1, NULL, "Green" },
{ ARG_INT, -1, NULL, "Blue" },
{ -1, 0, NULL, NULL }
} ;
struct cmd_arg yy_create_cursor_territory_arg[] = {
{ ARG_INT, -1, NULL, "Width" },
{ ARG_INT, -1, NULL, "Height" },
{ ARG_INT, -1, NULL, "Parent" },
{ ARG_INT, -1, NULL, "HotSpot (X)" },
{ ARG_INT, -1, NULL, "HotSpot (Y)" },
{ ARG_INT, -1, NULL, "BitMap" },
{ -1, 0, NULL, NULL }
} ;
struct cmd_arg yy_move_cursor_hotspot_arg[] = {
{ ARG_INT, -1, NULL, "No" },
{ ARG_INT, -1, NULL, "HotSpot (X)" },
{ ARG_INT, -1, NULL, "HotSpot (Y)" },
{ -1, 0, NULL, NULL }
} ;
struct cmd_arg yy_display_cursor_arg[] = {
{ ARG_INT, -1, NULL, "No" },
{ -1, 0, NULL, NULL }
} ;
struct cmd_arg yy_set_page_attribute_arg[] = {
{ ARG_INT, -1, NULL, "No" },
{ ARG_INT, -1, NULL, "Font ID" },
{ ARG_INT, -1, NULL, "Line Skip" },
{ ARG_INT, 0, NULL, "Direction" },
{ ARG_INT, 0, NULL, "Coodinate" },
{ ARG_INT, -1, NULL, "Cursor Column" },
{ ARG_INT, -1, NULL, "Cursor Line" },
{ -1, 0, NULL, NULL }
} ;
struct cmd_arg yy_move_page_territory_arg[] = {
{ ARG_INT, -1, NULL, "No" },
{ ARG_INT, -1, NULL, "Column" },
{ ARG_INT, -1, NULL, "Line" },
{ ARG_INT, 0, NULL, "Territory Move" },
{ ARG_INT, -1, NULL, "Cursor Column" },
{ ARG_INT, -1, NULL, "Cursor Line" },
{ ARG_INT, 0, NULL, "Cursor Move" },
{ -1, 0, NULL, NULL }
} ;
struct cmd_arg yy_draw_text_on_page_arg[] = {
{ ARG_INT, -1, NULL, "No" },
{ ARG_INT, 3, NULL, "Operation" },
{ ARG_INT, 1, NULL, "Color" },
{ ARG_INT, 0, NULL, "Font ID" },
{ ARG_STR, 0, "TEST TEST", "Text" },
{ -1, 0, NULL, NULL }
} ;
struct cmd_arg yy_debug_reset_timer_arg[] = {
{ -1, 0, NULL, NULL }
} ;
struct cmd_arg yy_debug_set_timer_arg[] = {
{ ARG_INT, -1, NULL, "CMD No" },
{ ARG_INT, -1, NULL, "ON(1), OFF(0)" },
{ -1, 0, NULL, NULL }
} ;
struct cmd_arg yy_debug_show_table_arg[] = {
{ -1, 0, NULL, NULL }
} ;
struct cmd_arg yy_debug_list_color_arg[] = {
{ ARG_STR, 0, "black", "Color Name" },
{ -1, 0, NULL, NULL }
} ;
struct cmd_arg yy_debug_list_territory_arg[] = {
{ -1, 0, NULL, NULL }
} ;


command_entry ClientCmdTable[] = {
{ 0, "exit", exit_command, NULL, "Exit" },
{ 0, "quit", exit_command, NULL, "Exit" },
{ 0, "sleep", sleep_command, NULL, "Sleep" },
{ 0, "echo", echo_command, NULL, "Echo" },
{ 0, "noecho", noecho_command, NULL, "Noecho" },
{ 0, "help", cmd_help, NULL, "Help" },
{ 0, "timer", timer_set, NULL, "Timer Control" },
{ 0, "read", read_file, NULL, "Read File" },
{ YYCOMMAND_INIT, "init", push_yy_packet,
	  (char *)yy_init_arg, "Command Name" },
{ YYCOMMAND_CREATE_TERRITORY, "root", push_yy_packet,
	  (char *)yy_root_arg, "Command Name" },
{ YYCOMMAND_CREATE_TERRITORY, "create", push_yy_packet,
	  (char *)yy_create_arg, "Command Name" },
{ YYCOMMAND_DISPLAY_TERRITORY, "display", push_yy_packet,
	  (char *)yy_display_arg, "Command Name" },
{ YYCOMMAND_MOVE_TERRITORY, "move", push_yy_packet,
	  (char *)yy_move_arg, "Command Name" },
{ YYCOMMAND_RESIZE_TERRITORY, "resize", push_yy_packet,
	  (char *)yy_resize_arg, "Command Name" },
{ YYCOMMAND_DESTROY_TERRITORY, "destroy", push_yy_packet,
	  (char *)yy_destroy_arg, "Command Name" },
{ YYCOMMAND_REPARENT_TERRITORY, "reparent", push_yy_packet,
	  (char *)yy_reparent_arg, "Command Name" },
{ YYCOMMAND_RAISE_TERRITORY, "raise", push_yy_packet,
	  (char *)yy_raise_arg, "Command Name" },
{ YYCOMMAND_LOWER_TERRITORY, "lower", push_yy_packet,
	  (char *)yy_lower_arg, "Command Name" },
{ YYCOMMAND_DRAW_POINT, "draw-point", push_yy_packet,
	  (char *)yy_draw_point_arg, "Draw Point"},
{ YYCOMMAND_DRAW_LINE, "draw-line", push_yy_packet,
	  (char *)yy_draw_line_arg, "Draw Line"},
{ YYCOMMAND_DRAW_RECTANGLE, "draw-rectangle", push_yy_packet,
	  (char *)yy_draw_rectangle_arg, "Draw Rectangle"},
{ YYCOMMAND_DRAW_LINES, "draw-lines", push_yy_packet,
	  (char *)yy_draw_lines_arg, "Draw Lines"},
{ YYCOMMAND_DRAW_POLYGON, "draw-polygon", push_yy_packet,
	  (char *)yy_draw_polygon_arg, "Draw Polygon"},
{ YYCOMMAND_DRAW_CIRCLE, "draw-circle", push_yy_packet,
	  (char *)yy_draw_circle_arg, "Draw Circle"},
{ YYCOMMAND_DRAW_ARC, "draw-arc", push_yy_packet,
	  (char *)yy_draw_arc_arg, "Draw Arc"},
{ YYCOMMAND_LOAD_FONT, "load-font", push_yy_packet,
	  (char *)yy_load_font_arg, "Load Font"},
{ YYCOMMAND_DRAW_TEXT, "draw-text", push_yy_packet,
	  (char *)yy_draw_text_arg, "Draw Text"},
{ YYCOMMAND_DRAW_VTEXT, "draw-vtext", push_yy_packet,
	  (char *)yy_draw_text_arg, "Draw Text"},
{ YYCOMMAND_DRAW_RTEXT, "draw-rtext", push_yy_packet,
	  (char *)yy_draw_rtext_arg, "Draw Text"},
{ YYCOMMAND_SELECT_TERRITORY, "select-territory", push_yy_packet,
	  (char *)yy_select_territory_arg, "Select Territory"},
{ YYCOMMAND_SET_EVENT_MASK, "set-event-mask", push_yy_packet,
	  (char *)yy_set_event_mask_arg, "Set Event Mask"},
{ YYCOMMAND_CLEAR_TERRITORY, "clear-territory", push_yy_packet,
	  (char *)yy_clear_territory_arg, "Clear Territory"},
{ YYCOMMAND_DRAW_BACKGROUND, "draw-background", push_yy_packet,
	  (char *)yy_draw_background_arg, "Draw Background"},
{ YYCOMMAND_QUERY_COLOR, "query-color", push_yy_packet,
	  (char *)yy_query_color_arg, "Query Color"},
{ YYCOMMAND_SET_PAGE_ATTRIBUTE, "set-page-attribute", push_yy_packet,
      (char *)yy_set_page_attribute_arg, "Set Page Attribute"},
{ YYCOMMAND_MOVE_PAGE_TERRITORY, "move-page-territory", push_yy_packet,
      (char *)yy_move_page_territory_arg, "Move Page Territory"},
{ YYCOMMAND_DRAW_TEXT_ON_PAGE, "draw-text-on-page", push_yy_packet,
      (char *)yy_draw_text_on_page_arg, "Draw Text on Page"},
{ YYCOMMAND_CREATE_CURSOR_TERRITORY, "create-cursor", push_yy_packet,
	  (char *)yy_create_cursor_territory_arg, "Create Cursor Territory"},
{ YYCOMMAND_MOVE_CURSOR_HOTSPOT, "move-cursor-hotspot", push_yy_packet,
	  (char *)yy_move_cursor_hotspot_arg, "Move Cursor Hotspot"},
{ YYCOMMAND_DISPLAY_CURSOR, "display-cursor", push_yy_packet,
	  (char *)yy_display_cursor_arg, "Display Cursor"},
{ YYCOMMAND_DEBUG_SET_TIMER, "debug-set-timer", push_yy_packet,
	  (char *)yy_debug_set_timer_arg, "Debug"},
{ YYCOMMAND_DEBUG_RESET_TIMER, "debug-reset-timer", push_yy_packet,
	  (char *)yy_debug_reset_timer_arg, "Debug"},
{ YYCOMMAND_DEBUG_SHOW_TABLE, "debug-show-table", push_yy_packet,
	  (char *)yy_debug_show_table_arg, "Debug"},
{ YYCOMMAND_DEBUG_LIST_COLOR, "debug-list-color", push_yy_packet,
	  (char *)yy_debug_list_color_arg, "Debug"},
{ YYCOMMAND_DEBUG_LIST_TERRITORY, "debug-list-territory", push_yy_packet,
	  (char *)yy_debug_list_territory_arg, "Debug"},
} ;

/************************************************************************
 ************************************************************************
 ************************************************************************
 ************************************************************************/

static CMD *Ctrl = (CMD *)NULL;

void cleanup(code, fmt, a1, a2, a3, a4, a5, a6)
	int code;
	char *fmt;
{
	if (Ctrl != (CMD *)NULL) {
		if (fmt != (char *)NULL)
			cmd_fprintf(NULL, fmt, a1, a2, a3, a4, a5, a6);
		sleep(3);
		debug_term();
		cmd_term(Ctrl);
	} else if (fmt != (char *)NULL)
		fprintf(stderr, fmt, a1, a2, a3, a4, a5, a6);
	exit(code);
}

void intr_handler(sig, code)
	int sig, code;
{
	debug_term();
	cmd_fprintf(NULL, "SIGNAL#%d\n", sig);
	if (Ctrl != (CMD *)NULL)
		cmd_term(Ctrl);
	exit(0);
}

void my_debug_close()
{
}

main(argc, argv)
	int argc;
	char *argv[];
{
	int sock;
	int sock2;
	yy_comm_channel *ch;
	CMD *ctrl;

	YYPacketBlockSize = YYMAXONEPACKETSIZE;
	YYPacketBlockSize = 128;

	Ctrl = ctrl = cmd_init(ClientCmdTable, CMDTBLSIZE(ClientCmdTable));
	if (ctrl == (CMD *)NULL)
		exit(1);
	debug_init(".yydebug.client", NULL, cmd_fprintf, my_debug_close);
	signal(SIGIO, intr_handler);
	signal(SIGHUP, intr_handler);
	signal(SIGINT, intr_handler);
	signal(SIGQUIT, intr_handler);
	signal(SIGTERM, intr_handler);

	if (argc < 2) {
		sock = get_unix_domain(DEFAULTCHANNEL);
		send_packet_size(sock);
		sock2 = get_unix_domain(DEFAULTCHANNEL+1);
	} else {
		sock = get_inet_domain(argv[1], DEFAULTCHANNEL);
		send_packet_size(sock);
		sock2 = get_inet_domain(argv[1], DEFAULTCHANNEL+1);
	}
	if (sock >= 0) {
		int cmdno = 0;
		while (!CMDCHKEXIT(ctrl)) {
			recv_packet(sock);
			cmdno++;
			cmd_execute(ctrl, (char *)sock, "HOI[%d]> ", cmdno);
		}
	}
	cleanup(0, "\nGood-Bye\n");
}


#define CLIENTTIMEOUT_INSEC	0
#define CLIENTTIMEOUT_INUSEC	0
#define YYHEADERSIZE	sizeof(yy_packet_header)

int get_unix_domain(no)
	int no;
{
	int sock;
	struct sockaddr_un addr;
	bzero((char *)&addr, sizeof(addr));
	addr.sun_family = PF_UNIX;
	sprintf(addr.sun_path, "%s%d", YYPROTO_UNIX_PORT, no);
	fprintf(stderr, "Try '%s'/UNIX\n", addr.sun_path);
	if ((sock = socket(PF_UNIX, SOCK_STREAM, 0)) < 0) {
		perror("socket");
		return -1;
	}
	if (connect(sock, &addr, sizeof(addr)) < 0) {
		perror("connect");
		return -1;
	}
	fprintf(stderr, "Connect on %d/UNIX\n", sock);
	return sock;
}

int get_inet_domain(host, no)
	char *host;
	int no;
{
	int sock;
	struct sockaddr_in addr;
	struct hostent *hp;
	bzero((char *)&addr, sizeof(addr));
	if ((hp = gethostbyname(host)) == (struct hostent *)NULL) {
		fprintf(stderr, "Unknown host %s\n", host);
		return -1;
	}
	addr.sin_family = hp->h_addrtype;
	bcopy(*hp->h_addr_list, &addr.sin_addr, hp->h_length);
	addr.sin_port = htons(YYPROTO_INET_PORT+no);
	if ((sock = socket(PF_INET, SOCK_STREAM, 0)) < 0) {
		perror("socket");
		return -1;
	}
	if (connect(sock, &addr, sizeof(addr)) < 0) {
		perror("connect");
		return -1;
	}
	fprintf(stderr, "Connect on %d/INET\n", sock);
	return sock;
}

send_packet_size(fd)
	int fd;
{
	int leng, rlen;
	char buf[8];
	char *s;
	int magic = YYPROTO_MAGIC;
	int size = YYPacketBlockSize;

	debug_setfunc("network", "send_packet_size");
	bcopy((char *)&magic, buf, 4);
	bcopy((char *)&size, &buf[4], 4);
	debug_print(1, "We want to set packetsize %d\n", size);
	if ((rlen = send(fd, buf, 8, 0)) <= 0) {
		if (rlen < 0) {
			cleanup(EX_IOERR,
				"Output Error on YY Connection\n");
		}
		cleanup(EX_OK, "YY Connection has been Closed..\n");
	}
	debug_print(1, "We send it...\n");

	for (leng = 8, s = buf; leng > 0; ) {
		if ((rlen = recv(fd, buf, leng, 0)) <= 0) {
			if (rlen < 0) {
				cleanup(EX_IOERR,
					"Input Error on YY Connection\n");
			}
			cleanup(EX_OK, "YY Connection has been Closed..\n");
		}
		leng -= rlen;
		s += rlen;
	}
	bcopy(buf, (char *)&magic, 4);
	bcopy(&buf[4], (char *)&size, 4);
	debug_print(1, "YY-Server said it is %d\n", size);
	if (size < YYPacketBlockSize) {
		debug_print(1, " .. OK! We accept it\n", size);
		YYPacketBlockSize = (size & ~3);
	}
	debug_endfunc("set_packet_size");
}


send_packet(sock, pkt)
	yy_packet *pkt;
{
	yy_packet_block *blk;
	debug_setfunc("control", "send_packet");
	for (blk = &pkt->pktFirstBlock;
	     blk != (yy_packet_block *)NULL; blk = blk->pbNextBlock) {
		debug_print(1, "send packet (length=%d)\n", blk->pbLength);
		if (send(sock, blk->pbBuf, blk->pbLength, 0) <= 0)
			cleanup(1, "Send Error\n");
	}
	debug_endfunc("send_packet");
}

recv_packet(sock)
	int sock;
{
	yy_packet_system_queue que;
	debug_setfunc("control", "recv_packet");
	bzero((char *)&que, sizeof(que));
	while (recv_one_block(sock, &que)) {
		if (que.sysqRead) {
			register yy_packet *pkt;
			pkt = (yy_packet *)get_packet_from_readq(que);
			debug_print(1, "Recv Packet (Command:%d,Type:%d)\n",
				    pkt->pktCommand, pkt->pktType);
		}
	}
	debug_endfunc("control", "recv_packet");
}

recv_one_block(sock, que)
	int sock;
	yy_packet_system_queue *que;
{
	fd_set rfds;
	struct timeval timeout;
	int ret;

	debug_setfunc("network", "recv_yy_packet");
 retry:
	FD_ZERO(&rfds);
	FD_SET(sock, &rfds);
	timeout.tv_sec = CLIENTTIMEOUT_INSEC;
	timeout.tv_usec = CLIENTTIMEOUT_INUSEC;
	if ((ret = select(sock+1, &rfds, NULL, NULL, &timeout)) < 0) {
		perror("select");
		cleanup(1, "Error on select() system call\n");
	}
	if (ret > 0) {
		int leng, pleng, body;
		byte *bp = (byte *)xalloc(YYPacketBlockSize+10);
		/* Recv Header Info */
		if ((leng = recv(sock, bp, YYHEADERSIZE, 0)) != YYHEADERSIZE) {
			if (leng < 0 && errno == EWOULDBLOCK) {
				debug_print(9, "recv() call would block\n");
				return 0;
			}
			if (leng == 0)
				cleanup(EX_OK, "YY Connection has been Closed..\n");
			cleanup(EX_IOERR, "Input Error on YY Connection\n");
		}
		debug_print(5, "recv Header Info\n");

		/* Get Packet Length */
		bcopy(bp, (byte *)&pleng, 4);
		pleng = ((pleng & 07777) << 2);
		body = pleng - YYHEADERSIZE;
		debug_print(5, "Header saied length is %d\n", pleng);
		if ((leng = recv(sock, bp+YYHEADERSIZE, body, 0)) != body) {
			if (leng < 0 && errno == EWOULDBLOCK) {
				debug_print(9, "recv() call would block\n");
				return 0;
			}
			if (leng == 0)
				cleanup(EX_OK, "YY Connection has been Closed..\n");
			cleanup(EX_IOERR, "Input Error on YY Connection\n");
		}
		/* If we have fixed packet, it will be moved to read queue */
		debug_print(9, " recv one block (LENGTH:%d)\n", pleng);
		put_block_on_recvq(que, bp, pleng);
		debug_endfunc("recv_yy_packet");
		return 1;
	}
	debug_endfunc("recv_yy_packet");
	return 0; /* time out */
}
