;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;;
;;; $B#Y#Y(B  $B#o#n(B  $B#X(B $B$K$*$1$k(B $B#Y#Y(B $B%W%m%H%3%k(B 
;;;
;;; filename: yyprtcl-kosaka.lisp
;;;
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.0 90/06/01 by t.kosaka (kosaka@csrl.aoyama.ac.jp)
;;;   version 1.1 90/07/31 by t.kosaka
;;;   update 1.11 90/09/14 by t.kosaka
;;;   version 1.2 90/11/05 by t.kosaka

;;; Written By Yukio Ohta 1990.02.06
;;;      under supervision of Masayuki Ida
;;;
;;; change log
;;; Version 0.5 07-Feb-90
;;; Version 1.0 05-Mar-90
;;;
;;; Version 1.0   Updated by t.kosaka 1990-3-13
;;; Version 1.1   Updated by t.kosaka 1990-6-6
;;; Version 1.1   Updated by t.kosaka 1990-8-18
;;; Version 1.2   Update by T.kosaka 1990-10-3
;;;               Change I use unsigned-byte for C function inteface
;;;		  Added Symbolics code contribution of E.Shiota
;;; Version 1.21  Add close f;unction for Network
;;; Version 1.21  Modefy by T.kosaka 1990-11-30 
;;; Version 1.3   Update by T.kosaka 1991-1-9 
;;; Version 1.3   Change  porotocol number at yy-protocol-40 to 60
;;; Version 1.3   Change functionalty for return value and image-data handling 
;;;               at yy-protocol-60
;;; Version 1.3   Added functionalty for vector at make-command-packet 
;;; Version 1.3   Added yy-protocol-61 for put-image 

(in-package :yy)


;;; $B%m!<%I(B
(eval-when (eval load)
#+:EXCL
  (load-foreign (format nil "~a~a" *yy-source-path* "prtclif.o") "c")
)

#+LUCID
(lucid::def-foreign-function (c_setup_server 
			      (:return-type :fixnum))
			     (no :fixnum)
			     (string :simple-vector-type)
			     (dnumber :fixnum))
#+EXCL
(ff:defforeign 'c_setup_server
	       :arguments '(fixnum (array (unsigned-byte 8)) fixnum)
	       :return-type :fixnum)
#+LUCID
(lucid::def-foreign-function (c_write_internal
			      (:return-type :fixnum))
			     (string :simple-vector-type)
			     (no :fixnum))
#+EXCL
(ff:defforeign 'c_write_internal
	       :arguments '((array (unsigned-byte 8)) fixnum)
	       :return-type :fixnum)

#+LUCID
(lucid::def-foreign-function (c_read1_internal
			      (:return-type :fixnum))
			     (string :simple-vector-type)
			     (no :fixnum))
#+EXCL
(ff:defforeign 'c_read1_internal
	       :arguments '((array (unsigned-byte 8)) fixnum)
	       :return-type :fixnum)

#+LUCID
(lucid::def-foreign-function (c_read2
			      (:return-type :fixnum))
			     (string :simple-vector-type)
			     (no :fixnum))
#+EXCL
(ff:defforeign 'c_read2
	       :arguments '((array (unsigned-byte 8)) fixnum)
	       :return-type :fixnum)

#+LUCID
(lucid::def-foreign-function (c_access
			      (:return-type :unsigned-32bit))
			     (string :simple-vector-type)
			     (no :fixnum))
#+EXCL
(ff:defforeign 'c_access
	       :arguments '((array (unsigned-byte 8)) fixnum)
	       :return-type :integer)
#+LUCID
(lucid::def-foreign-function (c_store
			      (:return-type :unsigned-32bit))
			     (string :simple-vector-type)
			     (no1 :fixnum)
			     (no2 :unsigned-32bit))
#+EXCL
(ff:defforeign 'c_store
	       :arguments '((array (unsigned-byte 8)) fixnum integer)
	       :return-type :integer)

#+LUCID
(lucid::def-foreign-function (c_store2
			      (:return-type :unsigned-32bit))
                             (string :simple-vector-type)
                             (no1 :fixnum)
                             (no2 :signed-32bit))
#+EXCL
(ff:defforeign 'c_store2
	       :arguments '((array (unsigned-byte 8)) fixnum integer)
	       :return-type :integer)

;;; $B%Q%1%C%H$KJ8;zNs$r=q$-9~$`(B
#+LUCID
(lucid::def-foreign-function (c_store_string
			      (:return-type :unsigned-32bit))
			     (string :simple-vector-type)
			     (no :fixnum)
			     (data :simple-string)
			     (start :fixnum)
			     (length :fixnum))

#+(and EXCL (not ICS))
(ff:defforeign 'c_store_string 
	       :arguments '((array (unsigned-byte 8))
			    fixnum simple-string fixnum fixnum)
	       :return-type :integer)

#+(and EXCL ICS)
(ff:defforeign 'c_store_string_ics
	       :arguments '((array (unsigned-byte 8))
                            fixnum simple-string fixnum fixnum)
               :return-type :integer)

;;; $B%;%l%/%H(B
#+LUCID
(lucid::def-foreign-function (c_select2
			      (:return-type :unsigned-32bit)))

#+EXCL
(ff:defforeign 'c_select2
	       :return-type :integer)

;;; $B%$%a!<%8%Y%/%?!<(B
#+LUCID
(lucid::def-foreign-function (c_store_vector
			      (:return-type :unsigned-32bit))
			     (string :simple-vector-type)
			     (no :fixnum)
			     (data :simple-vector-type)
			     (start :fixnum)
			     (length :fixnum))
#+EXCL
(ff:defforeign 'c_store_vector
	       :arguments '((array (unsigned-byte 8))
			    fixnum (array (unsigned-byte 8)) fixnum fixnum)
	       :return-type :integer)

;;; $B%/%m!<%:(B
#+LUCID
(lucid::def-foreign-function (c_close
			      (:return-type :unsigned-32bit)))

#+EXCL
(ff:defforeign 'c_close
	       :return-type :integer)

;;;
;;; Symbolics codes bellow
;;;
#+Symbolics
(defvar *YYMAGIC* 14876.)

#+Symbolics
(neti:define-protocol :YY-on-X (:yy :byte-stream)
  (:desirability .9)
  (:invoke-with-stream ((fd1 :characters nil :force-output t))
    (let* ((arg (make-array 256. :element-type 'fixnum))
	   (array (make-array (* 4 256.) :element-type '(unsigned-byte 8) :displaced-to arg)))
      (setf (aref arg 0) *YYMAGIC*)
      (scl:send fd1 :clear-input)
      (scl:send fd1 :string-out array 0 4)
      (setf (aref arg 0) 256.)
      (scl:send fd1 :string-out array 0 4)
      (scl:send fd1 :force-output)
      (scl:send fd1 :string-in nil array 0 4)
      (format t "~% *YYMAGIC*: ~d ~d" *YYMAGIC* (aref arg 0))
      (if (= *YYMAGIC* (aref arg 0))
	  (progn
	    (multiple-value-bind (fd2 port)
		(scl:send fd1 :start-open-auxiliary-stream nil
		      :local-id nil :foreign-id :1+
		      :stream-options '(:characters nil :force-output t))
	      (format t "~% PORT : ~a ~a " port fd2 )
	      (close fd2 :abort t))
	    (scl:send fd1 :string-in nil array 0 4)
	    (format t "~% LENGTH : ~d" (aref arg 0))
	    (write array :array t)
	    (aref array 0))
	  (close fd1 :abort t))
      (close fd1 :abort t)
      )))

#+Symbolics
(neti:define-protocol :YY+1-on-X (:yy+1 :byte-stream)
  (:desirability .9)
  (:invoke-with-stream ((fd2 :characters nil :force-output t))
    fd2))

#+Symbolics
(tcp:add-tcp-port-for-protocol :YY-on-X 6750.)

#+Symbolics
(tcp:add-tcp-port-for-protocol :YY+1-on-X 6751.)

#+Symbolics
(defun get-YY-stream (host)
  (let ((host (neti:parse-host host)))
    (net:get-connection-for-service
      (or (car (neti:FIND-PATHs-TO-SERVICE-ON-HOST-1
		 :YY
		 (neti:FIND-PROTOCOL-NAMED :YY-on-X :YY)
		 host
		 :tcp))
	  (let ((plist (list
			 :service '((:YY :TCP :YY-on-X)))))
	    (scl:send host :set-property-list plist)
	    (car (neti:FIND-PATHs-TO-SERVICE-ON-HOST-1
		   :YY
		   (neti:FIND-PROTOCOL-NAMED :YY-on-X :YY)
		   host
		   :tcp))))
      :characters nil
      :force-output t)))

#+Symbolics
(defun get-YY+1-stream (host)
  (let ((host (neti:parse-host host)))
    (net:get-connection-for-service
      (or (car (neti:FIND-PATHs-TO-SERVICE-ON-HOST-1
		 :YY+1
		 (neti:FIND-PROTOCOL-NAMED :YY+1-on-X :YY+1)
		 host
		 :tcp))
	  (let ((plist (list
			 :service '((:YY+1 :TCP :YY+1-on-X)))))
	    (scl:send host :set-property-list plist)
	    (car (neti:FIND-PATHs-TO-SERVICE-ON-HOST-1
		   :YY+1
		   (neti:FIND-PROTOCOL-NAMED :YY+1-on-X :YY+1)
		   host
		   :tcp))))
      :characters nil
      :force-output t)))

#+Symbolics
(defvar *fd1* nil)
#+Symbolics
(defvar *fd2* nil)

#+Symbolics
(defun c_setup_server (network hostname &optional dnumber)
  (declare (ignore dnumber))
  (let* ((data-fixnum (make-array 1 :element-type 'fixnum))
	 (data-array (make-array 4 :element-type '(unsigned-byte 8)
				 :displaced-to data-fixnum)))
    (if network
	(setf *fd1* (get-YY-stream hostname))
	(setf *fd1* (get-YY-stream "local")))
    (setf (aref data-fixnum 0) (convert-to-yy-fixnum *YYMAGIC*))
    (scl:send *fd1* :string-out data-array 0 4)
    (scl:send *fd1* :force-output)
    (scl:send *fd1* :clear-output)
    (setf (aref data-fixnum 0) (convert-to-yy-fixnum 256.))
    (scl:send *fd1* :string-out data-array 0 4)
    (scl:send *fd1* :force-output)
    (scl:send *fd1* :clear-output)
    (scl:send *fd1* :string-in nil data-array 0 4)
    (cond
      ((scl:neq *YYMAGIC* (convert-to-yy-fixnum (aref data-fixnum 0)))
       (close *fd1* :abort t)
       0)
      (t
       (scl:send *fd1* :string-in nil data-array 0 4)
       (if network
	   (setf *fd2* (get-YY+1-stream hostname))
	   (setf *fd2* (get-YY+1-stream "local")))
       (convert-to-yy-fixnum (aref data-fixnum 0) )))))

#+Symbolics
(defun convert-to-yy-fixnum (data)
  (logior (ash (get-one-byte data 0) 24.)
	  (ash (get-one-byte data 1) 16.)
	  (ash (get-one-byte data 2)  8.)
	  (get-one-byte data 3)))

#+Symbolics
(defun c_write_internal (pack lng)
  (let ((array (make-array (* 4 lng) :element-type '(unsigned-byte 8)
			   :displaced-to pack))
	(string (make-array (* 4 lng) :element-type 'string-char
			    :displaced-to pack)))
    (scl:send *fd1* :string-out array 0 (* lng 4))
    (ignore string)
;;    (format t "~% c_write_internal : ~a ~%" string)
    (scl:send *fd1* :force-output)))

#+Symbolics
(defun c_read1_internal (retpack retlng)
  (let ((array (make-array (* 4 retlng) :element-type '(unsigned-byte 8)
			   :displaced-to retpack))
	(string (make-array (* 4 retlng) :element-type 'string-char
			    :displaced-to retpack)))
    (scl:send *fd1* :string-in nil array 0 (* retlng 4))
    (ignore string)
;    (format t "~% c_read1_internal : ~a ~%" string)
    ))

#+Symbolics
(defun c_read2 (retpack retlng)
  (let ((array (make-array (* 4 retlng) :element-type '(unsigned-byte 8)
			   :displaced-to retpack))
	(string (make-array (* 4 retlng) :element-type 'string-char
			    :displaced-to retpack)))
    (scl:send *fd2* :string-in nil array 0 (* retlng 4))
    (ignore string)
;    (format t "~% c_read1_internal : ~a ~%" string)
    ))

#+Symbolics
;;; element-type is changed to '(unsigned-byte 8)
(defun c_access (data no)
  (let ((n (* no 4)))
    (logior (ash (aref data (+ 0 n)) 24)
	    (ash (aref data (+ 1 n)) 16)
	    (ash (aref data (+ 2 n))  8)
	    (ash (aref data (+ 3 n))  0)
	    )))

#+Symbolics
(defun c_store (data no1 no2)
  (let ((n (* no1 4)))
    (setf (aref data (+ 0 n)) (get-one-byte no2 3)
	  (aref data (+ 1 n)) (get-one-byte no2 2)
	  (aref data (+ 2 n)) (get-one-byte no2 1)
	  (aref data (+ 3 n)) (get-one-byte no2 0)
	  )))

#+Symbolics
(defun c_store2 (data no1 no2)
  (let ((n (* no1 4)))
    (setf (aref data (+ 0 n)) (get-one-byte no2 3)
	  (aref data (+ 1 n)) (get-one-byte no2 2)
	  (aref data (+ 2 n)) (get-one-byte no2 1)
	  (aref data (+ 3 n)) (get-one-byte no2 0)
	  )))

#+Symbolics
(defun c_store_string (pack no string start length)
  (loop ;for i below length
        for i from start to (1- length)
	for j from (* 4 no) 
	do
    (setf (aref pack j) (char-code (aref string i))))
  length)


#+Symbolics
(defun c_store_vector (pack no string start length)
  (loop ;for i below length
        for i from start to (1- length)
	for j from (* 4 no) 
	do
    (setf (aref pack j) (aref string i)))
  length)


;;; $B%;%l%/%H(B
;;; It is dummy.
#+Symbolics
(defun c_select () 1)

;;; $B%m!<%I(B
(eval-when (eval load)
#+:LUCID
  (load-foreign (format nil "~a~a" *yy-source-path* "prtclif.o") "c")
)


;;; $B<u?.H/9T2s?t(B

(DEFPARAMETER *MAX-RECEIPT-TIME* 0)
(DEFPARAMETER *RECEIPT-TIME* 0)

;;; $B%Q%1%C%H<oJL(B
(defvar *ALONE-PACKET-TYPE* 0)
(defvar *START-PACKET-TYPE* 1)
(defvar *CONT-PACKET-TYPE* 2)
(defvar *END-PACKET-TYPE* 3)

;;; $B%a%C%;!<%8%G!<%?NN0h(B
(defparameter *max-message-size* 0)
(defparameter *max-receive-size* 0)

(defun make-packet (&optional (packet-size *max-message-size*))
  (make-array (* packet-size 4) :element-type '(unsigned-byte 8))
  )


(defun real-integer (data)
  (if (not (zerop (logand #x80000000 data)))
      (- 0 (+ (logxor #xFFFFFFFF data) 1))
    data))

;;;$B%3%^%s%I%P%C%U%"!<(B
(defvar *send* nil)

;;; $B%3%^%s%ILa$jCM%P%C%U%!!<(B $B%X%C%@!<It(B $B#8%P%$%H$O$J$$(B
(defvar *send-receive* nil)

;;;$BDLCN%P%C%U%!!<(B  $B%X%C%@!<It(B $B#8%P%$%H$O$J$$(B
(defvar *receive* nil)

;;; $B%X%C%@!<%G!<%?%P%C%U%!!<(B
(defvar *header* (make-packet 2))
(defvar *header2* (make-packet 2))

;;; packet-send
;;; $B%Q%1%C%H$NAw?.$r9T$&(B
;;; $B$3$N$H$-%3%^%s%IH/9T2s?t$,(B*max-receipt-time*$B0J>e$G$"$l$P<+F0E*$K<u?.$r$^$D(B
;;; $BC"$7!"(Bsync-p$B$,(Bnil $B$N>l9g$O$=$N8B$j$G$O$J$$(B
(defun packet-send (&optional (sync-p t))
  (declare (special *ALONE-PACKET-TYPE* *START-PACKET-TYPE* 
		    *CONT-PACKET-TYPE* *END-PACKET-TYPE* *send*
		    *header*)
	   (inline lognad car >= = incf))
  (let* ((len (logand #x00FFFFFF (c_access (car *send*) 0)))
	 (type (c_access (car *send*) 1)))

    (if (= type *ALONE-PACKET-TYPE*)
	;;; 1 $B8D$N%Q%1%C%H(B
      (progn
       (c_write_internal (car *send*) len)
       (when sync-p
	   (incf *receipt-time*)
	   (when (>= *receipt-time* *MAX-RECEIPT-TIME*)
		 (c_read1_internal *header* 2)
		 (setf *receipt-time* 0))))
	   
      ;;; $BJ#?t$N%Q%1%C%H(B
      (progn 
	(dolist (item *send*)
		(setf type (c_access item 1)
		      len (logand #x00FFFFFF (c_access item 0)))

		(c_write_internal item len)
		
		(if (= type *END-PACKET-TYPE*)
		    (return)))

	(when sync-p
           (incf *receipt-time*)
	   (when (>= *receipt-time* *MAX-RECEIPT-TIME*)

		 (setf  *receipt-time* 0)
		 (c_read1_internal *header* 2)))))
  (values)))

;;; packet-send-receive
;;; $B%Q%1%C%HAw?.8e!"<u?.$rBT$D(B
(defun packet-send-receive  ()
  (declare (special *END-PACKET-TYPE* *ALONE-PACKET-TYPE* *header* 
		    *max-receive-size* *send-receive* *send*)
	   (inline = logand incf))
  (let ((type 0) (no 0) (len 0))

    (setf *receipt-time* 0)
    (packet-send nil)

    ;;; $B%X%C%@!<$rFI$_$H$k(B
    (c_read1_internal *header* 2)
    (setf len (logand #x00FFFFFF (c_access *header* 0)))

    ;;; $B:G=i$N%Q%1%C%H$rFI$_$H$k(B
    (c_read1_internal (car *send-receive*) (- len 2))

    (loop
      (if (or (= (logand (setf type (c_access *header* 1))  3)
			   *END-PACKET-TYPE*)
	       (= (logand type 3) *ALONE-PACKET-TYPE*))
	 (return))

     (incf no)

     ;;; $B<!$N%j%9%H$,$"$k$+D4$Y$k(B
     (if (null (nth no *send-receive*))
	 (setf *send-receive* 
	       (nconc *send-receive* (list (make-packet *max-receive-size* )))))

     ;;; $B%X%C%@!<$rFI$_$H$k(B
     (c_read1_internal *header* 2)
     ;;; $B%Q%1%C%H?t$r5a$a$k(B
     (setf  len (logand #x00FFFFFF (c_access *header* 0)))
     ;;; $B%Q%1%C%H$NFI$_$H$j(B
    (c_read1_internal (nth no *send-receive*) (- len 2))
	 )

    *send-receive*))


;;; packet-send-single
;;; $B#18D$N%Q%1%C%H$NAw?.$r9T$&(B
;;; $B$3$N$H$-%3%^%s%IH/9T2s?t$,(B*max-receipt-time*$B0J>e$G$"$l$P<+F0E*$K<u?.$r$^$D(B
;;; $BC"$7!"(Bsync-p$B$,(Bnil $B$N>l9g$O$=$N8B$j$G$O$J$$(B
(defun packet-send-single (packet &optional (sync-p t))
  (declare (special *ALONE-PACKET-TYPE* *header*)
	   (inline logand >= incf))
  (let* ((len (logand #x00FFFFF (c_access packet 0))))

    (setf (c_access packet 1) *ALONE-PACKET-TYPE*)
    (c_write_internal packet len)
    (when sync-p
      (incf *receipt-time*)
      (when (>= *receipt-time* *MAX-RECEIPT-TIME*)
	(c_read1_internal *header* 2)
	(setf *receipt-time* 0))
      )))

;;; packet-send-receive-single
;;; $B#18D$N%Q%1%C%HAw?.8e!"J#?t$N<u?.$rBT$D(B
(defun packet-send-receive-single  (packet)
  (declare (special *END-PACKET-TYPE*  *header* 
		    *max-receive-size* *send-receive* )
	   (inline logand incf =))
  (let ((type 0) (no 0) (len 0))


    (setf *receipt-time* 0)
    (packet-send-single packet nil)

    ;;; $B%X%C%@!<$rFI$_$H$k(B
    (c_read1_internal *header* 2)

    ;;; $B%Q%1%C%H?t$r5a$a$k(B
    (setf len (logand #x00FFFFFF (c_access *header* 0)))

    ;;; $B:G=i$N%Q%1%C%H$rFI$_$H$k(B
    (c_read1_internal (car *send-receive*) (- len 2))

    (loop
      (if (or (= (logand (setf type (c_access *header* 1))  3)
			   *END-PACKET-TYPE*)
	       (= (logand type 3) *ALONE-PACKET-TYPE*))
	 (return))

     (incf no)

     ;;; $B<!$N%j%9%H$,$"$k$+D4$Y$k(B
     (if (null (nth no *send-receive*))
	 (setf *send-receive* 
	       (nconc *send-receive* (list (make-packet *max-receive-size* )))))

     ;;; $B%X%C%@!<$rFI$_$H$k(B
     (c_read1_internal *header* 2)
     ;;; $B%Q%1%C%H?t$r5a$a$k(B
     (setf len (logand #x00FFFFFF (c_access *header* 0)))
     ;;; $B%Q%1%C%H$NFI$_$H$j(B
    (c_read1_internal (nth no *send-receive*) (- len 2))
	 )

    *send-receive*))

;;; packet-receive
;;; $BDLCNMQ(Bread
(defun packet-receive ()
  (declare (special *END-PACKET-TYPE* *ALONE-PACKET-TYPE* *header* *receive*
		    *max-receive-size*)
	   (inline car = logand incf))
  (let ((type 0) (no 0) (len 0) (command nil))

    ;;; $B%X%C%@!<$rFI$_$H$k(B
    (c_read2 *header2* 2)

    ;;; $B%Q%1%C%H?t$r5a$a$k(B
    (multiple-value-setq (command len) (decode-com-pac (c_access *header2* 0)))

    ;;; $B%Q%1%C%H$NFI$_$H$j(B
    (c_read2 (car *receive*) (- len 2))

    (loop
      (if (or (= (logand (setf type (c_access *header2* 1))  3)
			   *END-PACKET-TYPE*)
	       (= (logand type 3) *ALONE-PACKET-TYPE*))
	 (return))

     (incf no)

     ;;; $B<!$N%j%9%H$,$"$k$+D4$Y$k(B
     (if (null (nth no *receive*))
         (nconc *receive* (list (make-packet *max-receive-size*))))

     ;;; $B%X%C%@!<$rFI$_$H$k(B
     (c_read2 *header2* 2)

     ;;; $B%Q%1%C%H?t$r5a$a$k(B
     (setf len (logand #x00FFFFFF (c_access *header2* 0)))
     
     ;;; $B%Q%1%C%H$NFI$_$H$j(B
     (c_read2 (nth no *receive*) (- len 2)))

    command))


;;; $BLa$jCM%Q%1%C%H5Z$SDLCN%Q%1%C%H$N;XDjHV9f$+$i$N%G!<%?$r<h$j=P$9(B
;;; packet -> *receive* $B$b$7$/$O(B *send-receive*
(defun get-packet-data (packet no &optional (string nil))
  (declare (special *max-message-size* *max-receive-size*)
	   (inline / floor = decf 1+ -))

  (let ((pno (floor (/ no (- *max-message-size* 2))))
	(data 0) (shino (mod no (- *max-message-size* 2))))

    (if  string
	(let ((j -1) 
	      (new-string (make-string string)))

	  (dotimes (sno string)
		   (when (= j -1)
		       (when (>= shino *max-receive-size*)
			   (setf pno   (1+ pno)
				 shino 0))
			       
			 (setf data (c_access (nth pno packet) shino)
			     j 3
			     shino (1+ shino)))

		   (setf (char new-string sno) (code-char (get-one-byte data j)))
		   (decf j))
	  new-string)
      (c_access (nth pno packet) shino))))


;;; $B;XDj$5$l$?%P%$%H$r<h$j=P$9(B
;;; #x00000000  <- fixnum
;;;    3 2 1 0  <- no
(defun get-one-byte (fixnum no)
  (declare (inline ash * logand))
  (logand #x000000FF (ash fixnum (* no -8))))


;;; $B%Q%1%C%H$r:n$j!"(B*send*$B$K@_Dj$9$k!#(B
;;; arg $B$O!"(B:string "data" :integer 1$B$N7A<0$G@_Dj$9$k(B
;;;
;;; added Symbolics code 31.Oct.90
(defun make-command-packet (commad &rest arg)
  (declare (special *send* *max-message-size*
		    *ALONE-PACKET-TYPE* *START-PACKET-TYPE*
                    *CONT-PACKET-TYPE* *END-PACKET-TYPE*)
	   (inline incf > / >= ceiling - decf * min nth))
  (let ((counter 0) (packet-count 2) (pno 0) 
	(length 0) (start 0) (c-length 0) (real-byte 0)
	(status *ALONE-PACKET-TYPE*))

    (setf (c_access (car *send*) 1) *ALONE-PACKET-TYPE*)

    (loop 
	     ;;; $B%Q%1%C%HCf$N%G!<%?!<$N?t$rD4$Y$k(B
	     (when (>= packet-count *max-message-size*)
		 (incf pno)
		 (if (null (nth pno *send*))
		     (setf *send* (nconc *send* (list  (make-packet)))))
		 (setf packet-count 2
		       (c_access (nth (- pno 1) *send*) 0) 
		       (encode-com-pac commad *max-message-size*)
		       (c_access (nth (- pno 1) *send*) 1)
		       (set-packet-type-cont status)
		       status *CONT-PACKET-TYPE*))
		       
	     (case (nth counter arg)
	           (:vector ;;; $B%Y%/%?!<(B
		    (incf counter)
		    (setf real-byte (length (nth counter arg))
			  (c_access (nth pno *send*) packet-count)
			  real-byte
			  start 0)
		    (incf packet-count)

		    (if (> real-byte 0)
			 (loop
			   (setf length 
			     (min  (* (- *max-message-size* packet-count) 4)
				   real-byte))
		      
			   (if (zerop real-byte)
			       (return))

			   (incf start (c_store_vector (nth pno *send*) 
						      packet-count 
						      (nth counter arg)
						      start
						      length))

			   (incf packet-count (ceiling (/ length 4)))
			   (decf real-byte length)

		           ;;; $B%Q%1%C%H?t$N%A%'%C%/(B
			   (when (>= packet-count *max-message-size*)
			     (incf pno)
			     (if (null (nth pno *send*))
				 (setf *send* 
				   (nconc *send* (list  (make-packet)))))
			    
			     (setf packet-count 2
				   (c_access (nth (- pno 1) *send*) 0)
				   (encode-com-pac commad *max-message-size*)
				   (c_access (nth (- pno 1) *send*) 1)
				   (set-packet-type-cont status)
                                   status *CONT-PACKET-TYPE*))
			   )
		       (incf packet-count))
                        )

		   (:string ;;; $BJ8;zNs(B
		     (incf counter)

		     (setf 
			 real-byte (real-length (nth counter arg))
			 (c_access (nth pno *send*) packet-count)
			   real-byte
			   c-length real-byte
			   start 0)

		     (incf packet-count)

		     (if (> real-byte 0)
			 (loop
			   (setf length 
			     (min  (* (- *max-message-size* packet-count) 4)
				   c-length))
		      
			   (if (zerop c-length)
			       (return))
#+(or LUCID (and EXCL (not ICS)) Symbolics);31.Oct.90 
			   (incf start(c_store_string (nth pno *send*) 
						      packet-count 
						      (nth counter arg)
						      start
						      length))

#+(and EXCL ICS)
			   (incf start (c_store_string_ics (nth pno *send*) 
							   packet-count
							   (nth counter arg)
							   start
							   length))

			   (incf packet-count (ceiling (/ length 4)))
			   (decf c-length length)

		           ;;; $B%Q%1%C%H?t$N%A%'%C%/(B
			   (when (>= packet-count *max-message-size*)
			     (incf pno)
			     (if (null (nth pno *send*))
				 (setf *send* 
				   (nconc *send* (list  (make-packet)))))
			    
			     (setf packet-count 2
				   (c_access (nth (- pno 1) *send*) 0)
				   (encode-com-pac commad *max-message-size*)
				   (c_access (nth (- pno 1) *send*) 1)
				   (set-packet-type-cont status)
				   status *CONT-PACKET-TYPE*))
			   )
		       (incf packet-count))
                        )

		   (:integer ;;; $B?t;z(B
			   (incf counter)
		           (c_store2 (nth pno *send*) packet-count 
				     (nth counter arg))
			   (incf packet-count))

		   (:end ;;; $B%Q%1%C%H$N=*$j(B
			(when (nth (+ pno 1) *send*)
			    (nbutlast *send*))
			(return))
		   (t
		    (error "Commad no ~a Args ~a Counter ~a" commad 
			   (nth counter arg)
			   counter)))
	     (incf counter))
    ;;; $B%3%^%s%I$H%Q%1%C%HD9$r@_Dj(B
    (setf (c_access (nth pno *send*) 0) (encode-com-pac commad packet-count)
	  (c_access (nth pno *send*) 1)
	  (set-packet-type status))
    ))

(defun set-packet-type-cont (status)
  (declare (special *ALONE-PACKET-TYPE* *CONT-PACKET-TYPE* *START-PACKET-TYPE*))
  (cond
   ((eq status *ALONE-PACKET-TYPE*)
    *START-PACKET-TYPE*)
   ((eq status *CONT-PACKET-TYPE*)
    *CONT-PACKET-TYPE*)))

(defun set-packet-type (status)
  (declare (special *ALONE-PACKET-TYPE* *CONT-PACKET-TYPE* *END-PACKET-TYPE*))
  (cond 
   ((eq status *ALONE-PACKET-TYPE*)
    *ALONE-PACKET-TYPE*)
   ((eq status *CONT-PACKET-TYPE*)
	*END-PACKET-TYPE*)))

(defun dump-all-packet ()
  (let ((count 0))
    (dolist (item *send*)
	    (multiple-value-bind (com no)
		 (decode-com-pac (c_access item 0))

		     
		 (format t "~%~a com-no ~a no ~a type ~a ~%"count com no 
			 (c_access item 1))
		 (dotimes (i (- no 2))
		   (format t "(~a)  ~x " (+ i 2) (c_access item (+ i 2)))
		   (if (zerop (mod (+ i 2) 5))
			      (terpri)))
		 (if (or (= (c_access item 1) *ALONE-PACKET-TYPE*)
			 (= (c_access item 1) *END-PACKET-TYPE*))
		     (return))
		 (incf count))
	    )
    ))


    

;;; real-length
;;; $BJ8;zNs$N(BEUC$B$H$7$?;~$ND9$5$r5a$a$k(B
;;; (real-length string)
;;; args. string = $BJ8;zNs(B
;;; vsl.  EUC$B$G$NJ8;z?t(B
;;; added Symbolics 31.Oct.90
(defun real-length (string)
(declare (inline > incf))
#+(or LUCID (and EXCL (not ICS)) Symbolics)
   (length string)
#+(and EXCL ICS)
  (let ((count 0)
	(len (length string)))
    (dotimes (i len)
      (if (> (char-code (char string i)) #xA1)
	  ;;; $B4A;z(B
	  (incf count 2)
	(incf count 1)))
    count))



;;; encode-com-pac
;;; $B%3%^%s%IHV9f$H%Q%1%C%HD9$r(Bencode$B$9$k(B
;;; (encode-com-pac com-num &optional (pac-lng)) -> fixnum
;;; args. com-num = $B%3%^%s%IHV9f(B
;;;	  pac-lng = $B%Q%1%C%HD9(B
;;; val.  fxnum = 4$B%P%$%HD9$N@0?t(B
;;; notice:
;;; $B$3$3$O8e$G=q$-49$($^$9(B(fmr$BMQ(B)
;;;
;;; Ex.)
;;; (encode-com-pac 1 6)
;;; -> 16777222 (#x01000006)
(defun encode-com-pac (com-num &optional (pac-lng 0))
  #+:gclisp
       (+ (* com-num #.(expt 2 24)) pac-lng)
  #-:gclisp
  (let ((tmp com-num))
    (setf tmp (ash tmp 24))
    (logior tmp pac-lng)))


;;; decode-com-pac
;;; $B%3%^%s%IHV9f$H%Q%1%C%HD9$KJ,2r$9$k(B
;;; (decode-com-pac fixnum) -> command packet-length
;;; (decode-com-pac #x12345678)
(defun decode-com-pac (fixnum)
;; symbolics cannot understand #u by shiota 
;  #+:gclisp
;  (values (floor (logand fixnum #x#uf000) #.(expt 2 24))
;	  (logand fixnum #x00ffffff))
;  #-:gclisp
  (declare (inline ash logand))
  (values (ash (logand fixnum #xff000000) -24) (logand fixnum #x00ffffff))
  )

;;; string-to-fixnum
;;; $BJ8;zNs$r(Bfixnum$B$KJQ49$7!"$=$N(Bfixnum$B$N%j%9%H$rJV$9!#(B
;;; char$B$NJ8;z%3!<%I$r(B4 $B%P%$%HKh$K6h@Z$j(Bfixnum$B$H$9$k!#(B
;;; (string-to-fixnum string) -> list-of-fixnum
;;; args. string = $BJ8;zNs(B
;;; val.  list-of-fixnum = fixnum$B$N%j%9%H(B
;;;
;;; Ex.)
;;; (string-to-fixnum "abcd")
;;; -> (1633837924) 
;;; (string-to-fixnum "abcdeghijk")
;;; -> (1633837924 1701275753 1785397248))
(defun string-to-fixnum (string)
  (declare (inline floor / + /= - mod logior =))
  (let* ((total (length string))
	 (data (* (floor (/ (+ total 3) 4)) 4))
	 (endlist nil) (fixnum 0))

    (dotimes (i total)
       (when (and (/= i 0) (= 0 (mod i 4)))
	     (push fixnum endlist)
	     (setf fixnum 0))

       (setf fixnum (logior (ash fixnum 8) (char-code (char string i)))))

    (dotimes (i (- data total))
	     (setf fixnum (logior (ash fixnum 8) 0)))

    (if (or (/= data total) (= (mod total 4) 0))
	(push fixnum endlist))

    (nreverse endlist)))

;;; fixnum-to-bytes
;;; 4$B%P%$%HD9$N@0?t$r(B1$B%P%$%H$:$D$KJ,2r$9$k(B
;;; (fixnum-to-bytes fixnum) -> byte1 byte2 byte3 byte4
;;;(fixnum-to-bytes #xffffffff)
(defun fixnum-to-bytes (fixnum)
  (values (get-one-byte fixnum 3)
	  (get-one-byte fixnum 2)
	  (get-one-byte fixnum 1)
	  (get-one-byte fixnum 0)))

;;; set-string-to-packet
;;; $BJ8;zNs$r%Q%1%C%H$KEPO?$9$k(B
;;; Args   packet      -> $B%Q%1%C%H(B
;;;        loaction-no -> $B3+;O0LCV(B
;;;        string      -> $BJ8;zNs(B
;;; return$BCM(B  $B$J$7(B
(defun set-string-to-string (packet location-no string)
#+(or LUCID (and EXCL (not ICS)) Symbolics);31.Oct.90
   (c_store_string packet location-no string 0 (length string))
#+(and EXCL ICS)
   (c_store_string_ics packet location-no string 0 (length string))
   )

;;; byte-paket-length (bate)
;;; $B%P%$%H?t$+$i%Q%1%C%H?t$r5a$a$k(B
;;; $B$b$7!"#0$J$i$P#1$rJV$9(B
(defun byte-packet-length (byte)
  (let ((c-l (ceiling byte 4)))
    (if (zerop c-l)
	1
      c-l)))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                                                                 ;;
;;                Entry of YY on X Protocol.                       ;;
;;                                                                 ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; #000 yy-protocol-0
;;; $B%5!<%P!<$H$N@\B3(B
;;; (yy-protocol-0 id vno rno responceno ntime sname return-struct)
;;; -> return-struct
;;; args. id = $B#Y#Y%W%m%H%3%k$N%Q%1%C%H$G$"$k$3$H$r<($9?t;z(B
;;;	  vno = $B%W%m%H%3%k%P!<%8%g%sHV9f(B
;;;	  rno = $B%j%j!<%9HV9f(B
;;;	  responceno = $B<u?.!?H/9T2s?t(B
;;;	  ntime = $B%^%&%9BZ:_;~4V(B  $B%_%jIC(B
;;;	  sname = $B@\B3$9$Y$-%5!<%P!<L>(B
;;;	  return-struct = $B9=B$BN(B yy-server-connection
;;; val.  return-struct = $B9=B$BN(B yy-server-connection
(defcommand yy-protocol-0 (id vno rno responceno ntime sname retstr
			      )
  (let ((receive nil) )
    (make-command-packet 0 :integer id
		       :integer vno :integer rno :integer responceno
		       :integer ntime :string sname :end)

    ;;; $BAw?.(B
    (setf receive (packet-send-receive))
    
    (if (= id (get-packet-data receive 0))
	(progn 
	
    ;;; return-struct$B$KCM$r@_Dj(B
	  (setf (yy-server-connection-yy-version retstr)
	    (get-packet-data receive 1)
	    (yy-server-connection-yy-release-no retstr)
	    (get-packet-data receive 2)
	    (yy-server-connection-yy-responce-no retstr)
	    (get-packet-data receive 3)
	    (yy-server-connection-yy-ntime retstr)
	    (get-packet-data receive 4)
	    (yy-server-connection-yy-width retstr)
	    (get-packet-data receive 5)
	    (yy-server-connection-yy-height retstr)
	    (get-packet-data receive 6)
	    (yy-server-connection-yy-label retstr)
	    (get-packet-data receive 8 (get-packet-data receive 7)))

	  (SETF *MAX-RECEIPT-TIME* 
		(YY-SERVER-CONNECTION-YY-RESPONCE-NO RETSTR))
	  retstr)
      nil)
  ))

;;; #001 yy-protocol-1
;;; $B%F%j%H%j$r:n@.$9$k(B
;;; (yy-protocol-1 x y width height parent visible &optional (drawable 1)) -> no
;;; args. x = $B?F%F%j%H%j$N:8>e$+$i$N:BI8(B X
;;;	  y = $B?F%F%j%H%j$N:8>e$+$i$N:BI8(B Y
;;;	  width = $B%F%j%H%j$NI}(B
;;;	  height = $B%F%j%H%j$N9b$5(B
;;;	  parent = $B?F$K$J$k%F%j%H%j(B
;;;	  visible = $BI=<(%U%i%0(B 1->$BI=<((B  0->$BHsI=<((B
;;; val.  no = 0$B$J$i$P<:GT!"$=$&$G$J$1$l$P%F%j%H%jHV9f(B
(defcommand yy-protocol-1 (x y width height parent visible 
				&optional (drawable 1))
  (let ((receive nil)
	(packet (car *send*)))

    (if (> 0 width) 
	(setf x (+ x width)
	      width (abs width)))

    (if (> 0 height)
	(setf y (+ y height)
	     height (abs height)))

    (setf 
     (c_access packet 0) (encode-com-pac 1 9))

    (c_store2 packet 2 x)
    (c_store2 packet 3 y)
    (c_store2 packet 4 width)
    (c_store2 packet 5 height)
    (c_store2 packet 6 parent)
    (c_store2 packet 7 visible)
    (c_store2 packet 8 drawable)
#|
    (make-command-packet 1
		       :integer x :integer y :integer width
		       :integer height :integer parent :integer visible 
		       :integer drawable :end)
|#
     ;;; $BAw?.(B
    (setf receive (packet-send-receive-single packet))
    (real-integer (get-packet-data receive 0))))

;;; #002 yy-protocol-2
;;; $B%F%j%H%j$NI=<(!?HsI=<((B
;;; (yy-protocol-2 no visible-p) -> 
;;; args. no = $B%F%j%H%j$NHV9f(B
;;;	  visible = $BI=<(%U%i%0(B 1->$BI=<((B 0->$BHsI=<((B
(defcommand yy-protocol-2 (no visible)
  (let ((packet (car *send*)))
    
    (setf
     (c_access packet 0) (encode-com-pac 2 4))
    (c_store2 packet 2 no)
    (c_store2 packet 3 visible)

#|
  (make-command-packet 2
		       :integer no :integer visible :end)
|#
  ;;; $BAw?.(B
  (packet-send-single packet)))

;;; #003 yy-protocol-3
;;; $B%F%j%H%j$N0\F0(B
;;; (yy-protocol-3 no x y) ->
;;; args. no = $B%F%j%H%j$NHV9f(B
;;;       x  = $B?F%F%j%H%j$N:8>e$+$i$N:BI8(B X
;;;	  y  = $B?F%F%j%H%j$N:8>e$+$i$N:BI8(B Y
(defcommand yy-protocol-3 (no x y)
  (let ((packet (car *send*)))

    (setf
     (c_access packet 0) (encode-com-pac 3 5))

    (c_store2 packet 2 no)
    (c_store2 packet 3 x)
    (c_store2 packet 4 y)
     
#|
  (make-command-packet 3
		       :integer no :integer x :integer y :end)
|#
  (packet-send-single packet)))

;;; #004 yy-protocol-4
;;; $B%F%j%H%j$N0LCVBg$-$5$NJQ99(B 
;;; (yy-protocol-4 no x y width height new-x new-y) ->
;;; args. no = $B%F%j%H%j$NHV9f(B
;;;       x  = $B?F%F%j%H%j$N:8>e$+$i$N:BI8(B X
;;;	  y  = $B?F%F%j%H%j$N:8>e$+$i$N:BI8(B Y
;;;	  width = $B%F%j%H%j$NI}(B
;;;	  height = $B%F%j%H%j$N9b$5(B
;;;       new-x =  $B?7$7$$%F%j%H%j$NIA2h86E@(B
;;;       new-y =  $B?7$7$$%F%j%H%j$NIA2h86E@(B
;;;    $B85$N%F%j%H%j$K3(IA$+$l$F$$$?3($,!"?7$7$$IA2h86E@$K%3%T!<$5$l$k!#(B
(defcommand yy-protocol-4 (no x y width height &optional (new-x 0) (new-y 0))
  (let ((packet (car *send*)))

    (setf
     (c_access packet 0) (encode-com-pac 4 9))
    (c_store2 packet 2 no)
    (c_store2 packet 3 x)
    (c_store2 packet 4 y)
    (c_store2 packet 5 width)
    (c_store2 packet 6 height)
    (c_store2 packet 7 new-x)
    (c_store2 packet 8 new-y)

#|
  (make-command-packet 4
		       :integer no :integer x :integer y :integer width
		       :integer height 
		       :integer new-x :integer new-y :end)
|#
  (packet-send-single packet)))

;;; #005 yy-protocol-5
;;; $B%F%j%H%j$NGK2u(B
;;; (yy-protocol-5 no) -> no
;;; args. no = $B%F%j%H%j$NHV9f(B
;;; val.  no = 0$B$J$i$P<:GT!"$=$&$G$J$1$l$PAw$C$?%F%j%H%jHV9f(B
(defcommand yy-protocol-5 (no)
  (let ((packet (car *send*))
	(receive nil))

    (setf
     (c_access packet 0) (encode-com-pac 5 3))

    (c_store2 packet 2 no)


;    (make-command-packet 5 :integer no :end)

    (setf receive (packet-send-receive-single packet))
    (get-packet-data receive 0)))
  

;;; #006 yy-protocol-6
;;; $B%F%j%H%j$N?FJQ99(B
;;; (yy-protocol-6 no pno x y) ->
;;; args. no  = $B%F%j%H%j$NHV9f(B
;;;	  pno = $B?F%F%j%H%j$NHV9f(B
;;;	  x   = $B?7$7$$?FFb$G$N0LCV(B X
;;;	  y   = $B?7$7$$?FFb$G$N0LCV(B Y
(defcommand yy-protocol-6 (no pno x y)
  (let ((packet (car *send*)))

    (setf
     (c_access packet 0) (encode-com-pac 6 6))
    (c_store2 packet 2 no)
    (c_store2 packet 3 pno)
    (c_store2 packet 4 x)
    (c_store2 packet 5 y)


;  (make-command-packet 6 :integer no :integer pno :integer x :integer y :end)

  (packet-send-single packet )))

;;; #007 yy-protocol-7
;;; $B%F%j%H%j$N@$BeJQ99!J0lHV>e$X!K(B
;;; (yy-protocol-7 no) ->
;;; args. no = $B%F%j%H%j$NHV9f(B
(defcommand yy-protocol-7 (no)
    (let ((packet (car *send*)))
      
      (setf
       (c_access packet 0) (encode-com-pac 7 3))
      (c_store2 packet 2 no)

;  (make-command-packet 7 :integer no :end)

  (packet-send-single packet )))

;;; #008 yy-protocol-8
;;; $B%F%j%H%j$N@$BeJQ99!J0lHV2<$X!K(B
;;; (yy-protocol-7 no) ->
;;; args. no = $B%F%j%H%j$NHV9f(B
(defcommand yy-protocol-8 (no)
  (let ((packet (car *send*)))

    (setf
     (c_access packet 0) (encode-com-pac 8 3))
    (c_store2 packet 2 no)

;  (make-command-packet 8 :integer no :end)
  (packet-send-single packet )))


;;; #009 yy-protocol-9
;;; reserved

;;; #010 yy-protocol-10
;;; $BJ8;z%U%)%s%H$N%m!<%I(B
;;; (yy-protocol-10 name text-font) -> text-font
;;; args. name = $B%U%)%s%HL>(B
;;;	  text-font = class text-font
;;; val.  text-font = class text-font
(defcommand yy-protocol-10 (name text-font)
  (let ((receive nil)
	(font-char-data (slot-value text-font 'ascii-font)))

    (make-command-packet 10 :string name :end)

    (setf receive (packet-send-receive))

    ;;; text-font $B$X$N=q$-9~$_(B
    (setf (slot-value text-font 'font-name) name
	  (slot-value text-font 'internal-font-no) (get-packet-data receive 0)
	  (slot-value text-font 'kanji-width)  (get-packet-data receive 1)
	  (slot-value text-font 'kanji-height) (get-packet-data receive 2)
	  (slot-value text-font 'kanji-base-line) (get-packet-data receive 3))

      (dotimes (i 256)
	(multiple-value-bind (cc cw ch cb) (fixnum-to-bytes
					    (get-packet-data receive (+ i 4)))
        ;; $BI,$:(B256$B8D$J$1$l$P$J$i$J$$(B
	(if (numberp cc)
	    (let ((font-char (elt font-char-data i)))
	      (setf (slot-value font-char 'character-width) cw
		    (slot-value font-char 'character-height) ch
		    (slot-value font-char 'character-base-line) cb)
	      )
	  )))
      text-font
      ))


;;; #011 yy-protocol-11
;;; reserved

;;; #012 yy-protocol-12
;;; reserved

;;; #013 yy-protocol-13
;;; reserved

;;; #014 yy-protocol-14
;;; reserved

;;; #015 yy-protocol-15
;;; reserved

;;; #016 yy-protocol-16
;;; reserved

;;; #017 yy-protocol-17
;;; reserved

;;; #018 yy-protocol-18
;;; reserved

;;; #019 yy-protocol-19
;;; reserved


;;; #020 yy-protocol-20
;;; $BE@$NIA2h(B
;;; (yy-protocol-20 no x y op color) ->
;;; args. no = $B%F%j%H%j$NHV9f(B
;;;	  x  = $B%F%j%H%j$N:8>e$+$i$N:BI8(B X
;;;	  y  = $B%F%j%H%j$N:8>e$+$i$N:BI8(B Y
;;;	  op = $B%i%9%?!<%*%Z%l!<%7%g%s(B X-window $B$NCM$K=>$&(B
;;;	  color = $B?'$N;XDj(B
(defcommand yy-protocol-20 (no x y op color)
  (let ((packet (car *send*)))

    (setf
     (c_access packet 0) (encode-com-pac 20 7))
    (c_store2 packet 2 no)
    (c_store2 packet 3 x)
    (c_store2 packet 4 y)
    (c_store2 packet 5 op)
    (c_store2 packet 6 color)

;  (make-command-packet 20 :integer no :integer x :integer y 
;    :integer op :integer color :end)

  (packet-send-single packet)))


;;; #021 yy-protocol-21
;;; $B@~$NIA2h(B
;;; (yy-protocol-21 no x1 y1 x2 y2 width op edge color dashing)
;;; args. no = $B%F%j%H%j$NHV9f(B
;;;	  x1 = $B%F%j%H%j$N:8>e$+$i$N;OE@:BI8(B X
;;;	  y1 = $B%F%j%H%j$N:8>e$+$i$N;OE@:BI8(B Y
;;;       x2 = $B%F%j%H%j$N:8>e$+$i$N=*E@:BI8(B X
;;;	  y2 = $B%F%j%H%j$N:8>e$+$i$N=*E@:BI8(B Y
;;;		$B0J>e$NCM$O@~$NCf?4(B
;;;	  width = $B@~$NI}(B $BCf?4$+$i$G$O$J$$(B
;;;	  op = $B%i%9%?!<%*%Z%l!<%7%g%s(B X-window $B$NCM$K=>$&(B
;;;	  edge = $B@~$NC<E@$N7A(B X-window $B$NCM$K=>$&(B
;;;	  color = $B?'$N;XDj(B
;;;	  dashing = $B%@%C%7%s%0$h$&$N(Bchar$B$NG[Ns$,F~$C$F$$$k!#(B
;;;		    $B%U%)%s%H$N%m!<%I$HF1MM$G!"CM$O(BX_window$B$NCM$K=>$&(B
(defcommand yy-protocol-21 (no x1 y1 x2 y2 width op edge color dashing)
  (let* ((r-length (real-length dashing))
	 (p-length (byte-packet-length r-length)))
    (if (< (+ p-length 12) *max-message-size*)
	  (let ((packet (car *send*)))

	    (setf
	     (c_access packet 0) (encode-com-pac 21 (+ p-length 12)))
	    (c_store2 packet 2 no)
	    (c_store2 packet 3 x1)
	    (c_store2 packet 4 y1)
	    (c_store2 packet 5 x2)
	    (c_store2 packet 6 y2)
	    (c_store2 packet 7 width)
	    (c_store2 packet 8 op)
	    (c_store2 packet 9 edge)
	    (c_store2 packet 10 color)
	    (c_store2 packet 11 r-length)
	    (set-string-to-string packet 12 dashing)

	    (packet-send-single packet))
      (progn 
	(make-command-packet 21 :integer no :integer x1 :integer Y1 
		      :integer x2 :integer y2
		      :integer width :integer op :integer edge :integer color
		      :string dashing :end)
	(packet-send)))))


;;; #022 yy-protocol-22
;;; $B1_$NIA2h(B
;;; (yy-protocol-22 no x y radius width op color dashing) ->
;;; args. no = $B%F%j%H%j$NHV9f(B
;;;	  x = $B%F%j%H%j$N:8>e$+$i$NCf?4:BI8(B X
;;;	  y = $B%F%j%H%j$N:8>e$+$i$NCf?4:BI8(B Y
;;;	  radius = $B1_$NH>7B(B
;;;	  width = $B@~$NB@$5(B $BH>7B$NFbB&$KB@$/$J$k(B
;;;	  op = $B%i%9%?!<%*%Z%l!<%7%g%s(B X-window $B$NCM$K=>$&(B
;;;	  color = $B?'$N;XDj(B
;;;	  dashing = $B%@%C%7%s%0$h$&$N(Bchar$B$NG[Ns$,F~$C$F$$$k!#(B
;;;		    $B%U%)%s%H$N%m!<%I$HF1MM$G!"CM$O(BX_window$B$NCM$K=>$&(B
(defcommand yy-protocol-22 (no x y radius width op color dashing)
  (let* ((r-length (real-length dashing))
	 (p-length (byte-packet-length r-length)))
    (if (< (+ p-length 10) *max-message-size*)
	  (let ((packet (car *send*)))

	    (setf
	     (c_access packet 0) (encode-com-pac 22 (+ p-length 10)))
	    (c_store2 packet 2 no)
	    (c_store2 packet 3 x)
	    (c_store2 packet 4 y)
	    (c_store2 packet 5 radius)
	    (c_store2 packet 6 width)
	    (c_store2 packet 7 op)
	    (c_store2 packet 8 color)
	    (c_store2 packet 9 r-length)
	    (set-string-to-string packet 10 dashing)
	    
	    (packet-send-single packet))
      (progn
	(make-command-packet 22 :integer no :integer x :integer y :integer radius
		       :integer width :integer op :integer color
		       :string dashing :end)
	(packet-send)))))


;;; #023 yy-protocol-23
;;; $B@^$l@~$NIA2h(B
;;; (yy-protocol-23 no xys-list width op edge connect color
;;;                 dashing) -> ?
;;; args. no = $B%F%j%H%j$NHV9f(B
;;;	  xys-list = $B0J2<$NDL$j(B
;;;	    x1 = $B%F%j%H%j$N:8>e$+$i$N;OE@:BI8(B X
;;;	    y1 = $B%F%j%H%j$N:8>e$+$i$N;OE@:BI8(B Y
;;;	    x2 = $B%F%j%H%j$N:8>e$+$i$NBh#2E@L\$N:BI8(B X
;;;	    y2 = $B%F%j%H%j$N:8>e$+$i$NBh#2E@L\$N:BI8(B Y
;;;	    xm = $B%F%j%H%j$N:8>e$+$i$N=*E@:BI8(B X
;;;	    ym = $B%F%j%H%j$N:8>e$+$i$N=*E@:BI8(B Y
;;;		$B0J>e$NCM$O@~$NCf?4(B
;;;	  width = $B@~$NB@$5(B $BCf?4$+$i$G$O$J$$(B
;;;	  op = $B%i%9%?!<%*%Z%l!<%7%g%s(B X-window $B$NCM$K=>$&(B
;;;	  edge = $B@~$NC<E@$N7A(B X_window $B$NCM$K=>$&(B
;;;	  connect = $B@\B3E@$N7A(B X_window $B$NCM$K=>$&(B
;;;	  color = $B?'$N;XDj(B
;;;	  dashing = $B%@%C%7%s%0$h$&$N(Bchar$B$NG[Ns$,F~$C$F$$$k!#(B
;;;		    $B%U%)%s%H$N%m!<%I$HF1MM$G!"CM$O(BX_window$B$NCM$K=>$&(B
;;; val.  ?
(defcommand yy-protocol-23 (no xys-list width op edge connect color dashing)
(let ((args nil) (points (round (length xys-list) 2)))
;  (territory-check no)
    (setf args
          `(23 :integer ,no
               :integer ,points
               ,.(mapcan #'(lambda (p) (list :integer p))
                         xys-list)
               :integer ,width :integer ,op :integer ,edge
               :integer ,connect :integer ,color
               :string ,dashing :end))
    (apply 'make-command-packet args)
    (packet-send)))

#|      Old definition
(defcommand yy-protocol-23 (no xys-list width op edge connect color dashing)
  (let ((args nil) (points 0))
    (dolist (item xys-list)
            (push :integer args)
            (push item args))
    (setf args (nreverse args))
    (push 23 args)
    (setf args (nconc args (list :integer no :integer width :integer op :intege\
r edge
                                 :integer connect :integer color
                                 :string dashing :end)))
    (apply 'make-command-packet args)
    (packet-send)))
|#



;;; #024 yy-protocol-24
;;; $BB?3Q7A$NIA2h(B
;;; (yy-protocol-24 no xys-list width op connect color dashing)
;;; args. no = $B%F%j%H%j$NHV9f(B
;;;	  xys-list = $B0J2<$NDL$j(B
;;;	    x1 = $B%F%j%H%j$N:8>e$+$i$N;OE@:BI8(B X
;;;	    y1 = $B%F%j%H%j$N:8>e$+$i$N;OE@:BI8(B Y
;;;	    x2 = $B%F%j%H%j$N:8>e$+$i$NBh#2E@L\$N:BI8(B X
;;;	    y2 = $B%F%j%H%j$N:8>e$+$i$NBh#2E@L\$N:BI8(B Y
;;;	    xm = $B%F%j%H%j$N:8>e$+$i$N=*E@:BI8(B X
;;;	    ym = $B%F%j%H%j$N:8>e$+$i$N=*E@:BI8(B Y
;;;		$B0J>e$NCM$O@~$NCf?4(B
;;;	  width = $B@~$NB@$5(B $BCf?4$+$i$G$O$J$$(B
;;;	  op = $B%i%9%?!<%*%Z%l!<%7%g%s(B X-window $B$NCM$K=>$&(B
;;;	  connect = $B@\B3E@$N7A(B X_window $B$NCM$K=>$&(B
;;;	  color = $B?'$N;XDj(B
;;;	  dashing = $B%@%C%7%s%0$h$&$N(Bchar$B$NG[Ns$,F~$C$F$$$k!#(B
;;;		    $B%U%)%s%H$N%m!<%I$HF1MM$G!"CM$O(BX_window$B$NCM$K=>$&(B
;;; val.  ?
(defcommand yy-protocol-24 (no xys-list width op connect color dashing)
  (let ((args nil) (points (round (length xys-list) 2)))
;    (territory-check no)
    (setf args
          `(24 :integer ,no :integer ,points
               ,.(mapcan #'(lambda (p) (list :integer p))
                         xys-list)
               :integer ,width :integer ,op
               :integer ,connect :integer ,color
               :string ,dashing :end))
    (apply 'make-command-packet args)
    (packet-send)))

#|      Old definition
(defcommand yy-protocol-24 (no xys-list width op connect color dashing)
  (let ((args nil))
    (dolist (item xys-list)
            (push :integer args)
            (push item args))
    (setf args (nreverse args))
    (push 24 args)
    (setf args (nconc args (list :integer no :integer width :integer op
                                :integer connect :integer color
                                :string dashing :end)))
    (apply 'make-command-packet args)
    (packet-send)))
|#

;;; #025 yy-protocol-25
;;; $B1_8L$NIA2h(B
;;; (yy-protocol-25 no x y radius theta1 theta2 width op color dashing) -> ?
;;; args. no = $B%F%j%H%j$NHV9f(B
;;;	  x = $B%F%j%H%j$N:8>e$+$i$NCf?4:BI8(B X
;;;	  y = $B%F%j%H%j$N:8>e$+$i$NCf?4:BI8(B Y
;;;	  radius = $BH>7B(B
;;;	  theta1 = $B1_8L3+;OE@$N#X<4$+$i$N3QEY!J%G%#%0%j!<!K(B
;;;		   1/64$BEYC10L(B
;;;	  theta2 = $B1_8L3+=*E@$N#X<4$+$i$N3QEY!J%G%#%0%j!<!K(B
;;;		   1/64$BEYC10L(B
;;;	  width = $B@~$NB@$5(B $B!JH>7B$+$i1[$($J$$!K(B
;;;	  op = $B%i%9%?!<%*%Z%l!<%7%g%s(B X-window $B$NCM$K=>$&(B
;;;	  color = $B?'$N;XDj(B
;;;	  dashing = $B%@%C%7%s%0$h$&$N(Bchar$B$NG[Ns$,F~$C$F$$$k!#(B
;;;		    $B%U%)%s%H$N%m!<%I$HF1MM$G!"CM$O(BX_window$B$NCM$K=>$&(B
;;; val.  ?
(defcommand yy-protocol-25 (no x y radius theta1 theta2 width op color dashing)
  (let* ((r-length (real-length dashing))
	 (p-length (byte-packet-length r-length)))
    (if (< (+ p-length 12) *max-message-size*)
	  (let ((packet (car *send*)))

	    (setf
	     (c_access packet 0) (encode-com-pac 25 (+ p-length 12)))
	    (c_store2 packet 2 no)
	    (c_store2 packet 3 x)
	    (c_store2 packet 4 y)
	    (c_store2 packet 5 radius)
	    (c_store2 packet 6 theta1)
	    (c_store2 packet 7 theta2)
	    (c_store2 packet 8 width)
	    (c_store2 packet 9 op)
	    (c_store2 packet 10 color)
	    (c_store2 packet 11 r-length)
	    (set-string-to-string packet 12 dashing)
	    
	    (packet-send-single packet))
      (progn 
	(make-command-packet 25 :integer no :integer x :integer y :integer radius
		       :integer theta1 :integer theta2 :integer width 
		       :integer op :integer color :string dashing :end)
	(packet-send)))))


;;; #026 yy-protocol-26
;;; $B;M3Q7A$NIA2h(B
;;; (yy-protocol-26 no x y width height linewidt op color dashing) -> ?
;;; args. no = $B%F%j%H%j$NHV9f(B
;;;	  x = $B%F%j%H%j$N:8>e$+$i$N;OE@:BI8(B X
;;;	  y = $B%F%j%H%j$N:8>e$+$i$N;OE@:BI8(B Y
;;;	  width = $B;M3Q7A$NI}(B
;;;	  height = $B;M3Q7A$N9b$5(B
;;;	  linewidt = $B@~$NI}(B $B;XDj$7$?(Bwidth$B!"(Bheight$B$h$jFbB&(B
;;;	  op = $B%i%9%?!<%*%Z%l!<%7%g%s(B X-window $B$NCM$K=>$&(B
;;;	  color = $B?'$N;XDj(B
;;;	  dashing = $B%@%C%7%s%0$h$&$N(Bchar$B$NG[Ns$,F~$C$F$$$k!#(B
;;;		    $B%U%)%s%H$N%m!<%I$HF1MM$G!"CM$O(BX_window$B$NCM$K=>$&(B
;;; val.  ?
(defcommand yy-protocol-26 (no x y width height linewidt op color dashing)
  (let* ((r-length (real-length dashing))
	 (p-length (byte-packet-length r-length)))
    (if (< (+ p-length 11) *max-message-size*)
	  (let ((packet (car *send*)))

	    (setf
	     (c_access packet 0) (encode-com-pac 26 (+ p-length 11)))
	    (c_store2 packet 2 no)
	    (c_store2 packet 3 x)
	    (c_store2 packet 4 y)
	    (c_store2 packet 5 width)
	    (c_store2 packet 6 height)
	    (c_store2 packet 7 linewidt)
	    (c_store2 packet 8 op)
	    (c_store2 packet 9 color)
	    (c_store2 packet 10 r-length)
	    (set-string-to-string packet 11 dashing)
	    
	    (packet-send-single packet))
      (progn
	(make-command-packet 26 :integer no :integer x :integer y :integer width
			     :integer height :integer linewidt :integer op
			     :integer color :string dashing :end)
	(packet-send)))))
		      

;;; #027 yy-protocol-27
;;; $BEI$jDY$7B?3Q7A$NIA2h(B
;;; (yy-protocol-27 no xys-list op connect color fill pattarn)
;;; args. no = $B%F%j%H%j$NHV9f(B
;;;	  xys-list = $B0J2<$NDL$j(B
;;;	    x1 = $B%F%j%H%j$N:8>e$+$i$N;OE@:BI8(B X
;;;	    y1 = $B%F%j%H%j$N:8>e$+$i$N;OE@:BI8(B Y
;;;	    x2 = $B%F%j%H%j$N:8>e$+$i$NBh#2E@L\$N:BI8(B X
;;;	    y2 = $B%F%j%H%j$N:8>e$+$i$NBh#2E@L\$N:BI8(B Y
;;;	    xm = $B%F%j%H%j$N:8>e$+$i$N=*E@:BI8(B X
;;;	    ym = $B%F%j%H%j$N:8>e$+$i$N=*E@:BI8(B Y
;;;		$B0J>e$NCM$O@~$NCf?4(B
;;;	  op = $B%i%9%?!<%*%Z%l!<%7%g%s(B X-window $B$NCM$K=>$&(B
;;;	  connect = $B@\B3E@$N7A(B X_window $B$NCM$K=>$&(B
;;;	  color = $B?'$N;XDj(B
;;;	  fill = $BEI$jDY$7%k!<%k(B X_window$B$K=>$&(B
;;;	  pattern = $BEI$jDY$7%Q%?!<%s$N%F%j%H%jHV9f(B $B$b$7#0$J$i$P(B
;;;		   $B;XDj$5$l$??'$GEI$jDY$7$,9T$o$l$k(B
(defcommand yy-protocol-27 (no xys-list op connect color fill pattern)
  (let ((args nil) (points (round (length xys-list) 2)))
;    (territory-check no)
    (setf args
          `(27 :integer ,no :integer ,points
               ,.(mapcan #'(lambda (p) (list :integer p))
                         xys-list)
               :integer ,op :integer ,connect :integer ,color
               :integer ,fill :integer ,pattern :end))
    (apply 'make-command-packet args)
    (packet-send)))

#|      Old definition
(defcommand yy-protocol-27 (no xys-list op connect color fill pattern)
  (let ((args nil))
    (dolist (item xys-list)
            (push :integer args)
            (push item args))
    (setf args (nreverse args))
    (push 27 args)
    (setf args (nconc args (list :integer no :integer op :integer connect :inte\
ger color
                                 :integer fill :integer pattern :end)))
    (apply 'make-command-packet args)
    (packet-send)))
|#


;;; #028 yy-protocol-28
;;; $BEI$jDY$7;M3Q7A$NIA2h(B
;;; (yy-protocol-28 no x y width height op color pattern) -> ?
;;; args. no = $B%F%j%H%j$NHV9f(B
;;;	  x = $B%F%j%H%j$N:8>e$+$i$N;OE@:BI8(B X
;;;	  y = $B%F%j%H%j$N:8>e$+$i$N;OE@:BI8(B Y
;;;	  width = $B;M3Q7A$NI}(B
;;;	  height = $B;M3Q7A$N9b$5(B
;;;	  op = $B%i%9%?!<%*%Z%l!<%7%g%s(B X-window $B$NCM$K=>$&(B
;;;	  color = $B?'$N;XDj(B
;;;	  pattern = $BEI$jDY$7%Q%?!<%s$N%F%j%H%jHV9f(B $B$b$7#0$J$i$P(B
;;;		   $B;XDj$5$l$??'$GEI$jDY$7$,9T$o$l$k(B
(defcommand yy-protocol-28 (no x y width height op color pattern)
  (let ((packet (car *send*)))

    (setf
     (c_access packet 0) (encode-com-pac 28 10))
    (c_store2 packet 2 no)
    (c_store2 packet 3 x)
    (c_store2 packet 4 y)
    (c_store2 packet 5 width)
    (c_store2 packet 6 height)
    (c_store2 packet 7 op)
    (c_store2 packet 8 color)
    (c_store2 packet 9 pattern)
    
    (packet-send-single packet)))
#|
  (make-command-packet 28 :integer no :integer x :integer y :integer width
		       :integer height :integer op :integer color :integer pattern :end)
  (packet-send))
|#

;;; #029 yy-protocol-29
;;; $BEI$jDY$71_$NIA2h(B
;;; (yy-protocol-29 no x y radius op color pattern)
;;; args. no = $B%F%j%H%j$NHV9f(B
;;;	  x = $B%F%j%H%j$N:8>e$+$i$NCf?4:BI8(B X
;;;	  y = $B%F%j%H%j$N:8>e$+$i$NCf?4:BI8(B Y
;;;	  radius = $B1_$NH>7B(B
;;;	  op = $B%i%9%?!<%*%Z%l!<%7%g%s(B X-window $B$NCM$K=>$&(B
;;;	  color = $B?'$N;XDj(B
;;;	  pattern = $BEI$jDY$7%Q%?!<%s$N%F%j%H%jHV9f(B $B$b$7#0$J$i$P(B
;;;		   $B;XDj$5$l$??'$GEI$jDY$7$,9T$o$l$k(B
(defcommand yy-protocol-29 (no x y radius op color pattern)
  (let ((packet (car *send*)))

    (setf
     (c_access packet 0) (encode-com-pac 29 10))
    (c_store2 packet 2 no)
    (c_store2 packet 3 x)
    (c_store2 packet 4 y)
    (c_store2 packet 5 radius)
    (c_store2 packet 6 op)
    (c_store2 packet 7 color)
    (c_store2 packet 8 pattern)
    
    (packet-send-single packet)))

#|
  (make-command-packet 29 :integer no :integer x :integer y :integer radius
			:integer op :integer color :integer pattern :end)
  (packet-send))
|#   

;;; #030 yy-protocol-30
;;; $BEI$jDY$7@p7A$NIA2h(B
;;; (yy-protocol-30 no x y radius theta1 theta2 op color pattern a-mode) -> ?
;;; args. no = $B%F%j%H%j$NHV9f(B
;;;	  x = $B%F%j%H%j$N:8>e$+$i$NCf?4:BI8(B X
;;;	  y = $B%F%j%H%j$N:8>e$+$i$NCf?4:BI8(B Y
;;;	  radius = $BH>7B(B
;;;	  theta1 = $B1_8L3+;OE@$N#X<4$+$i$N3QEY!J%G%#%0%j!<!K(B
;;;		   1/64$BEYC10L(B
;;;	  theta2 = $B1_8L3+=*E@$N#X<4$+$i$N3QEY!J%G%#%0%j!<!K(B
;;;		   1/64$BEYC10L(B
;;;	  op = $B%i%9%?!<%*%Z%l!<%7%g%s(B X-window $B$NCM$K=>$&(B
;;;	  color = $B?'$N;XDj(B
;;;	  pattern = $BEI$jDY$7%Q%?!<%s$N%F%j%H%jHV9f(B $B$b$7#0$J$i$P(B
;;;		   $B;XDj$5$l$??'$GEI$jDY$7$,9T$o$l$k(B
;;;       a-mode = $B@p7?%b!<%I(B  
;;; val.  ?
(defcommand yy-protocol-30 (no x y radius theta1 theta2 op color pattern a-mode)
  (let ((packet (car *send*)))

    (setf
     (c_access packet 0) (encode-com-pac 30 12))
    (c_store2 packet 2 no)
    (c_store2 packet 3 x)
    (c_store2 packet 4 y)
    (c_store2 packet 5 radius)
    (c_store2 packet 6 theta1)
    (c_store2 packet 7 theta2)
    (c_store2 packet 8 op)
    (c_store2 packet 9 color)
    (c_store2 packet 10 pattern)
    (c_store2 packet 11 a-mode)
    
    (packet-send-single packet)))

#|
;  (territory-check no)
  (make-command-packet 30 :integer no :integer x :integer y
		       :integer radius :integer theta1 :integer theta2
		       :integer op :integer color :integer pattern 
		       :integer a-mode :end)
  (packet-send))
|#

;;; #031 yy-protocol-31
;;; $BJ8;zNs$NIA2h(B
;;; (yy-protocol-31 no x y op color fno string)
;;; args. no = $B%F%j%H%j$NHV9f(B
;;;	  x  = $B%F%j%H%j$N:8>e$+$i$N%Y!<%9%i%$%s:BI8(B X
;;;	  y  = $B%F%j%H%j$N:8>e$+$i$N%Y!<%9%i%$%s:BI8(B Y
;;;	  op = $B%i%9%?!<%*%Z%l!<%7%g%s(B X-window $B$NCM$K=>$&(B
;;;	  color = $B?'$N;XDj(B
;;;	  fno = font $B$NHV9f(B
;;;	  string = $BJ8;zNs(B
(defcommand yy-protocol-31 (no x y op color fno string)
  (let* ((r-length (real-length string))
	 (p-length (byte-packet-length r-length)))
    (if (< (+ p-length 9) *max-message-size*)
	  (let ((packet (car *send*)))

	    (setf
	     (c_access packet 0) (encode-com-pac 31 (+ p-length 9)))
	    (c_store2 packet 2 no)
	    (c_store2 packet 3 x)
	    (c_store2 packet 4 y)
	    (c_store2 packet 5 op)
	    (c_store2 packet 6 color)
	    (c_store2 packet 7 fno)
	    (c_store2 packet 8 r-length)
	    (set-string-to-string packet 9 string)
	    
	    (packet-send-single packet))
      (progn 
	(make-command-packet 31 :integer no :integer x :integer y :integer op
			     :integer color :integer fno :string string :end)
	(packet-send)))))


;;; #032 yy-protocol-32
;;; $BGX7J$NIA2h(B
;;; (yy-protocol-32 no color)
;;; args. no = $B%F%j%H%j$NHV9f(B
;;;	  color = $B?'$N;XDj(B
(defcommand yy-protocol-32 (no color)
  (let ((packet (car *send*)))

    (setf
     (c_access packet 0) (encode-com-pac 32 4))
    (c_store2 packet 2 no)
    (c_store2 packet 3 color)
    (packet-send-single packet)))
#|
  (make-command-packet 32 :integer no :integer color :end)
  (packet-send))
|#

;;; #033 yy-protocol-33
;;; $BGX7J%Q%?!<%s!J%S%C%H%^%C%W!K$NIA2h(B
;;; (yy-protocol-33 no pno)
;;; args. no = $B%F%j%H%j$NHV9f(B
;;;	  pno = $B%Q%?!<%s$,F~$C$F$$$k%F%j%H%j(B
(defcommand yy-protocol-33 (no pno)
  (let ((packet (car *send*)))

    (setf
     (c_access packet 0) (encode-com-pac 33 4))
    (c_store2 packet 2 no)
    (c_store2 packet 3 pno)
    (packet-send-single packet)))
#|
;  (territory-check no)
  (make-command-packet 33 :integer no :integer pno :end)
  (packet-send))
|#

;;; #034 yy-protocol-34
;;; $B%S%C%H%^%C%W$N:n@.(B
;;; (yy-protocol-34 no width height format pat)
;;; args. no = $B%F%j%H%j$NHV9f(B
;;;	  width = $B%Q%?!<%s$NI}(B
;;;	  height = $B%Q%?!<%s$N9b$5(B
;;;	  format = 1 --> Common Window $B%U%)!<%^%C%H(B
;;;		   2 --> X-window $B%U%)!<%^%C%H(B
;;;	  pat = $B%Q%?!<%s$,F~$C$F$$$kJ8;zNs(B
(defcommand yy-protocol-34 (no width height format pat)
  (make-command-packet 34 :integer no :integer width :integer height
		       :integer format :vector pat :end)
  (packet-send))

;;; #035 yy-protocol-35
;;; bitblt
;;; (yy-protocol-35 sno sx sy dno dx dy width height op)
;;; args. sno = $B%=!<%9%F%j%H%j$NHV9f(B
;;;	  sx = $B%=!<%9%F%j%H%j$N3+;O0LCV(B X
;;;	  sy = $B%=!<%9%F%j%H%j$N3+;O0LCV(B Y
;;;	  dno = $B%G%9%F%#%M!<%7%g%s%F%j%H%j$NHV9f(B
;;;	  dx = $B%G%9%F%#%M!<%7%g%s%F%j%H%jFb$KIA2h$5$l$k0LCV(B X
;;;	  dx = $B%G%9%F%#%M!<%7%g%s%F%j%H%jFb$KIA2h$5$l$k0LCV(B Y
;;;	  width = $B%G%9%F%#%M!<%7%g%s%F%j%H%jFb$KIA2h$5$l$kBg$-$5(B width
;;;	  height = $B%G%9%F%#%M!<%7%g%s%F%j%H%jFb$KIA2h$5$l$kBg$-$5(B height
;;;	  op = bitblt$B$9$k%*%Z%l!<%7%g%s(B
(defcommand yy-protocol-35 (sno sx sy dno dx dy width height op)
  (let ((packet (car *send*)))

    (setf
     (c_access packet 0) (encode-com-pac 35 11))
    (c_store2 packet 2 sno)
    (c_store2 packet 3 sx)
    (c_store2 packet 4 sy)
    (c_store2 packet 5 dno)
    (c_store2 packet 6 dx)
    (c_store2 packet 7 dy)
    (c_store2 packet 8 width)
    (c_store2 packet 9 height)
    (c_store2 packet 10 op)

    (packet-send-single packet)))
#|
  (make-command-packet 35 :integer sno :integer sx :integer sy :integer dno
		       :integer dx :integer dy :integer width :integer height
		       :integer op :end)
  (packet-send))
|#

;;; #036 yy-protocol-36
;;; $B%F%j%H%j$KIA2h$5$l$F$$$k3(>pJs$N%;!<%V#n8D(B
;;; (yy-protocol-36 return-string &rest territory-nos) -> return-string
;;;	  territory-nos = $B%F%j%H%jHV9f$N%j%9%H(B
;;; val.  return        = territory-nos$B$KIA2h$5$l$F$$$k3(%G!<%?$NJ8;zNs(B
(defcommand yy-protocol-36 (return-string &rest nos-list)
    (let ((args nil) (receive nil))
    (dolist (item nos-list)
            (push :integer args)
            (push item args))
    (push :end args)
    (setf args (nreverse args))
    (push 36 args)
    (apply 'make-command-packet args)
   
    (setf receive (packet-send-receive)
	  return-string
	  (get-packet-data receive 1 (get-packet-data receive 0)))
    ))

    

;;; #037 yy-protocol-37
;;; $B%F%j%H%j$KIA2h$5$l$F$$$k3(>pJs$N%m!<%I#n8D(B
;;; (yy-protocol-37 data-string &rest nos-list) -> flg
;;; args. data-string = $B3(%G!<%?J8;zNs(B
;;;	  nos-list = $B%F%j%H%jHV9f$N%j%9%H(B
;;; val.  flg = 0:ok  1:no good
(defcommand yy-protocol-37 (data-string &rest nos-list)
  (let ((args nil)(receive nil))
    (dolist (item nos-list)
	    (push :integer args)
            (push item args))
    (setf args (nreverse args))
    (push 37 args)
    (setf args (nconc args (list :string data-string)))

    (setf receive (packet-send-receive))

    (get-packet-data receive 0)))


;;; #038 yy-protocol-38
;;; $B%F%j%H%j$KIA2h$5$l$F$$$k3(>pJs$N3HBg!?=L>.(B
;;; (yy-protocol-38 sno dno x-ratio y-ratio)
;;; args. sno = $B3HBg!?=L>.$5$l$k%F%j%H%jHV9f(B
;;;       dno = $B3HBg!?=L>.$5$l$k%F%j%H%j$,==J,$KF~$k%F%j%H%j(B
;;;	  x-raito = X $BJ}8~$N3HBg!?=L>.G\N((B 1/100 $BC10L(B
;;;	  y-raito = Y $BJ}8~$N3HBg!?=L>.G\N((B 1/100 $BC10L(B
(defcommand yy-protocol-38 (sno dno x-ratio y-ratio)
  (let ((packet (car *send*)))

    (setf
     (c_access packet 0) (encode-com-pac 38 6))
    (c_store2 packet 2 sno)
    (c_store2 packet 3 dno)
    (c_store2 packet 4 x-ratio)
    (c_store2 packet 5 y-ratio)

    (packet-send-single packet)))

#|
  (make-command-packet 38 :integer sno :integer dno :integer x-raito
		       :integer y-raito :end)
  (packet-send))
|#

;;; #039 yy-protocol-39
;;; $B%F%j%H%j$KIA2h$5$l$F$$$k3(>pJs$N2sE>(B
;;; (yy-protocol-39 sno dno degree)
;;; args. sno = $B2sE>$5$l$k%F%j%H%jHV9f(B
;;;       dno = $B2sE>$5$l$k%F%j%H%j$,==J,$KF~$k%F%j%H%j(B
;;;	  degree = $B2sE>3Q(B 1/64$BEYC10L(B
(defcommand yy-protocol-39 (sno dno degree)
  (let ((packet (car *send*)))

    (setf
     (c_access packet 0) (encode-com-pac 39 5))
    (c_store2 packet 2 sno)
    (c_store2 packet 3 dno)
    (c_store2 packet 4 degree)
    (packet-send-single packet)))

#|
  (make-command-packet 39 :integer sno :integer dno :integer degree :end)
  (packet-send))
|#

;;; #040 $B$O(B60$B$KJQ99!#=>$C$F(B#040$B$OL$;HMQ(B

;;; #041 yy-protocol-41
;;; $BBJ1_8L$NIA2h(B
;;; (yy-protocol-41 no x y width height theta1 theta2 lwidth op color dashing)
;;; args. no = $B%F%j%H%j$NHV9f(B
;;;	  x = $B%F%j%H%j$N:8>e$+$i$NCf?4:BI8(B X
;;;	  y = $B%F%j%H%j$N:8>e$+$i$NCf?4:BI8(B Y
;;;	  width = $BBJ1_$NI}(B
;;;	  height = $BBJ1_$N9b$5(B
;;;	  theta1 = $B1_8L3+;OE@$N#X<4$+$i$N3QEY!J%G%#%0%j!<!K(B
;;;		   1/64$BEYC10L(B
;;;	  theta2 = $B1_8L3+=*E@$N#X<4$+$i$N3QEY!J%G%#%0%j!<!K(B
;;;		   1/64$BEYC10L(B
;;;	  lwidth = $B@~$NB@$5(B $B!JH>7B$+$i1[$($J$$!K(B
;;;	  op = $B%i%9%?!<%*%Z%l!<%7%g%s(B X-window $B$NCM$K=>$&(B
;;;	  color = $B?'$N;XDj(B
;;;	  dashing = $B%@%C%7%s%0$h$&$N(Bchar$B$NG[Ns$,F~$C$F$$$k!#(B
;;;		    $B%U%)%s%H$N%m!<%I$HF1MM$G!"CM$O(BX_window$B$NCM$K=>$&(B
(defcommand yy-protocol-41 (no x y width height theta1 theta2 lwidth op color dashing)
  (let* ((r-length (real-length dashing))
	 (p-length (byte-packet-length r-length)))
    (if (< (+ p-length 13) *max-message-size*)
          (let ((packet (car *send*)))

            (setf
             (c_access packet 0) (encode-com-pac 41 (+ p-length 13)))
            (c_store2 packet 2 no)
            (c_store2 packet 3 x)
            (c_store2 packet 4 y)
            (c_store2 packet 5 width)
            (c_store2 packet 6 height)
            (c_store2 packet 7 theta1)
            (c_store2 packet 8 theta2)
            (c_store2 packet 9 lwidth)
            (c_store2 packet 10 op)
	    (c_store2 packet 11 color)
	    (c_store2 packet 12 r-length)
            (set-string-to-string packet 13 dashing)

            (packet-send-single packet))
      (progn
	(make-command-packet 41 :integer no :integer x :integer y :integer width
			     :integer height 
			     :integer theta1 :integer theta2 :integer lwidth
			     :integer op :integer color :string dashing :end)

	(packet-send)))))
       


;;; #042 yy-protocol-42
;;; $BEI$jDY$7BJ1_8L$NIA2h(B
;;; (yy-protocol-42 no x y width height theta1 theta2 op color pattern arc_mode)
;;; args. no = $B%F%j%H%j$NHV9f(B
;;;	  x = $B%F%j%H%j$N:8>e$+$i$NCf?4:BI8(B X
;;;	  y = $B%F%j%H%j$N:8>e$+$i$NCf?4:BI8(B Y
;;;	  width = $BBJ1_$NI}(B
;;;	  height = $BBJ1_$N9b$5(B
;;;	  theta1 = $B1_8L3+;OE@$N#X<4$+$i$N3QEY!J%G%#%0%j!<!K(B
;;;		   1/64$BEYC10L(B
;;;	  theta2 = $B1_8L3+=*E@$N#X<4$+$i$N3QEY!J%G%#%0%j!<!K(B
;;;		   1/64$BEYC10L(B
;;;	  op = $B%i%9%?!<%*%Z%l!<%7%g%s(B X-window $B$NCM$K=>$&(B
;;;	  color = $B?'$N;XDj(B
;;;	  pattern = $BEI$jDY$7%Q%?!<%s$N%F%j%H%jHV9f(B  $B$b$7(B0 $B$J$i$P(B
;;;		   $B;XDj$5$l$??'$GEI$jDY$7$,9T$o$l$k(B
;;;	  arc_mode = arc_mode$B$O(B X$B%&%#%s%I%&$K=>$&(B
;;;		     arc_mode --> ArcPieSlice $B@p7?(B
;;;		     arc_mode --> ArcChord    $B5]7?(B
(defcommand yy-protocol-42 (no x y width height theta1 theta2 op color pattern arc_mode)
  (let ((packet (car *send*)))

    (setf
     (c_access packet 0) (encode-com-pac 42 13))
    (c_store2 packet 2 no)
    (c_store2 packet 3 x)
    (c_store2 packet 4 y)
    (c_store2 packet 5 width)
    (c_store2 packet 6 height)
    (c_store2 packet 7 theta1)
    (c_store2 packet 8 theta2)
    (c_store2 packet 9 op)
    (c_store2 packet 10 color)
    (c_store2 packet 11 pattern)
    (c_store2 packet 12 arc_mode)

    (packet-send-single packet)))

#|
  (make-command-packet 42 :integer no :integer x :integer y :integer width
		       :integer height :integer theta1 :integer theta2 :integer op
		       :integer color :integer pattern :integer arc_mode :end)
  (packet-send))
|#

;;; #043 yy-protocol-43
;;; $B=D=q$-J8;zNs$NIA2h(B
;;; (yy-protocol-43 no x y op color fno string)
;;; args. no = $B%F%j%H%j$NHV9f(B
;;;	  x  = $B%F%j%H%j$N:8>e$+$i$N%Y!<%9%i%$%s:BI8(B X
;;;	  y  = $B%F%j%H%j$N:8>e$+$i$N%Y!<%9%i%$%s:BI8(B Y
;;;	  op = $B%i%9%?!<%*%Z%l!<%7%g%s(B X-window $B$NCM$K=>$&(B
;;;	  color = $B?'$N;XDj(B
;;;	  fno = font $B$NHV9f(B
;;;	  string = $BJ8;zNs(B
(defcommand yy-protocol-43 (no x y op color fno string)
  (let* ((r-length (real-length string))
	 (p-length (byte-packet-length r-length)))
    (if (< (+ p-length 9) *max-message-size*)
          (let ((packet (car *send*)))

            (setf
             (c_access packet 0) (encode-com-pac 43 (+ p-length 9)))
            (c_store2 packet 2 no)
            (c_store2 packet 3 x)
            (c_store2 packet 4 y)
            (c_store2 packet 5 op)
            (c_store2 packet 6 color)
            (c_store2 packet 7 fno)
            (c_store2 packet 8 r-length)
            (set-string-to-string packet 9 string)

            (packet-send-single packet))
      (progn
	
	(make-command-packet 43 :integer no :integer x :integer y :integer op
			     :integer color :integer fno :string string :end)
	(packet-send)))))

;;; #044 yy-protocol-44
;;; $B2sE>9TNs$rH<$C$?J8;zNs$NIA2h(B
;;; (yy-protocol-44 no x y op color fno x-time y-time theta string)
;;; args. no = $B%F%j%H%j$NHV9f(B
;;;	  x  = $B%F%j%H%j$N:8>e$+$i$N%Y!<%9%i%$%s:BI8(B X
;;;	  y  = $B%F%j%H%j$N:8>e$+$i$N%Y!<%9%i%$%s:BI8(B Y
;;;	  op = $B%i%9%?!<%*%Z%l!<%7%g%s(B X-window $B$NCM$K=>$&(B
;;;	  color = $B?'$N;XDj(B
;;;	  fno = font $B$NHV9f(B
;;;	  x-time = $B2sE>9TNs$K$*$1$k#XJ}8~$NG\?t(B
;;;	  y-time = $B2sE>9TNs$K$*$1$k#YJ}8~$NG\?t(B
;;;	  theta = $B2sE>9TNs$K$*$1$k2sE>3QEY(B ($B%G%#%0%j!<(B)
;;;	  string = $BJ8;zNs(B
(defcommand yy-protocol-44 (no x y op color fno x-time y-time theta string)
  (let* ((r-length (real-length string))
	 (p-length (byte-packet-length r-length)))
    (if (< (+ p-length 12) *max-message-size*)
          (let ((packet (car *send*)))

            (setf
             (c_access packet 0) (encode-com-pac 44 (+ p-length 12)))
            (c_store2 packet 2 no)
            (c_store2 packet 3 x)
            (c_store2 packet 4 y)
            (c_store2 packet 5 op)
            (c_store2 packet 6 color)
            (c_store2 packet 7 fno)
            (c_store2 packet 8 x-time)
            (c_store2 packet 9 y-time)
	    (c_store2 packet 10 theta)
            (c_store2 packet 11 r-length)
            (set-string-to-string packet 12 string)

            (packet-send-single packet))
      (progn 
	(make-command-packet 44 :integer no :integer x :integer y :integer op
		     :integer color :integer fno :integer x-time :integer y-time
		     :integer theta :string string :end)

	(packet-send)))))

;;; #045 yy-protocol-45
;;; $B%+%i!<HV9f$r5a$a$k(B
;;; (yy-protocol-45 r g b) -> no
;;; args. r
;;;	  g
;;;	  b
;;; vals. no
(defcommand yy-protocol-45 (r g b)
  (let ((receive nil)
	(packet (car *send*)))
    (setf
     (c_access packet 0) (encode-com-pac 45 5))
    (c_store2 packet 2 r)
    (c_store2 packet 3 g)
    (c_store2 packet 4 b)

;    (make-command-packet 45 :integer r :integer g :integer b :end)

    (setf receive (packet-send-receive-single packet))

    (get-packet-data receive 0)))
  

;;; #046 yy-protocol-46
;;; $B%+%i!<L>$+$i%+%i!<HV9f$r5a$a$k(B
;;; (yy-protocol-46 name) -> no
;;; vals .no
(defcommand yy-protocol-46 (name)
  (let ((receive nil))
    (make-command-packet 46 :string name :end)

    (setf receive (packet-send-receive))

   (list (get-packet-data receive 0)
	 (get-packet-data receive 1)
	 (get-packet-data receive 2)
	 (get-packet-data receive 3))))


;;; #047 yy-protocol-47
;;; reserved

;;; #048 yy-protocol-48
;;; reserved

;;; #049 yy-protocol-49
;;; reserved

;;; #050 yy-protocol-50

;;;#050 yy-protocol-51
;;; $B%+%i!<$N(BRGB$BCM$rJQ99$9$k!#(B
;;; yy-protocol-51 color-no red green blue
;;; args.  color-no  $B%+%i!<HV9f(B
;;;        red       $B@V$N?'CM(B
;;;        green     $BNP$N?'CM(B
;;;        blue      $B@D$N?'CM(B
(defcommand yy-protocol-51 (color-no red green blue)
   (make-command-packet 51 :integer color-no
		 :integer red :integer green :integer blue :end)
   (packet-send))


;;; #052 yy-protocol-52
;;; $B%+%i!<$N2rJ|(B
;;; (yy-protocol-52 color-no-list
;;; args.  clolor-nos  $B%+%i!<HV9f(B
(defcommand yy-protocol-52 (color-no-list)
  (let* ((args (list 52 :integer (length color-no-list)))
	 (last (cddr args)))

    (dotimes (item color-no-list)
      (setf (cdr last) (list :integer item)
	    last (cddr last)))

    (apply #'make-command-packet args)
    (packet-send)))

;;; #053 yy-protocol-53
;;; $BE@$N%+%i!<HV9f$r5a$a$k(B
;;; yy-protocol-53 tno x y
;;; args.  tno    $B%F%j%H%j!<HV9f(B
;;;        x      $B0LCV(Bx
;;;        y      $B0LCV(By
(defcommand yy-protocol-53 (tno x y)
  (let ((receive nil))
    (make-command-packet 53 :integer tno :integer x :integer y :end)

    (setf receive (packet-send-receive))

    (get-packet-data receive 0)))


;;; #059 yy-protocol-59
;;; reserved

;;; #060 yy-protocol-60
;;; $BIA2h%$%a!<%8$N<h$j=P$7(B
;;; (yy-protocol-60 no width height format)
;;; args. no = $B%F%j%H%j$NHV9f(B
;;;       x     = $B%F%j%H%jFb$N3+;O0LCV(B 
;;;       y     = $B%F%j%H%jFb$N3+;O0LCV(B
;;;	  width = $B%Q%?!<%s$NI}(B
;;;	  height = $B%Q%?!<%s$N9b$5(B
;;;	  format = 1 --> Common Window $B%U%)!<%^%C%H(B
;;;		   2 --> X-window $B%U%)!<%^%C%H(B
;;; return value : (format width height $B%Q%?!<%s$,F~$C$F$$$k%Y%/%?!<(B)
(defcommand yy-protocol-60 (no x y width height format)
  (let ((receive nil))

    (make-command-packet 60 :integer no :integer x :integer y 
			 :integer width :integer height :integer format :end)

    (setf receive (packet-send-receive))
    
    (let* ((j 0) 
	   (pno (floor (/ 5 *max-receive-size*)))
	   (data 0)
	   (shino (mod 5 *max-receive-size*))
	   (end (get-packet-data receive 4))
	   (new-array (make-array end :element-type '(unsigned-byte 8))))

      (do ((sno 0 (incf sno)))
	  ((= sno (/ end 4)))

	(when (>= shino *max-receive-size*)
	  (setf pno   (1+ pno)
		shino 0))
	  
	(setf data (c_access (nth pno receive) shino)
	      shino (1+ shino))

	(multiple-value-bind (a1 a2 a3 a4)
	    (fixnum-to-bytes data)
	  (setf (elt new-array j) a1
		(elt new-array (incf j)) a2
		(elt new-array (incf j)) a3
		(elt new-array (incf j)) a4)
	  )
	(incf j))

      (list format (get-packet-data receive 1)  (get-packet-data receive 2)
	    new-array))))

;;; #061 yy-protocol-61
;;; $BIA2h%$%a!<%8$NIA2h(B
;;; (yy-protocol-61 no x y width height format image-vector)
;;; args. no = $B%F%j%H%j$NHV9f(B
;;;       x     = $B%F%j%H%jFb$N3+;O0LCV(B 
;;;       y     = $B%F%j%H%jFb$N3+;O0LCV(B
;;;	  width = $B%Q%?!<%s$NI}(B
;;;	  height = $B%Q%?!<%s$N9b$5(B
;;;	  format = 1 --> Common Window $B%U%)!<%^%C%H(B
;;;		   2 --> X-window $B%U%)!<%^%C%H(B
;;;       image-vector = $B%$%a!<%8%G!<%?(B
(defcommand yy-protocol-61 (no x y width height format image-data)

   (make-command-packet 61 :integer no :integer x :integer y 
			 :integer width :integer height :integer format 
			 :vector image-data :end)

   (packet-send))

;;; #070 yy-protocol-70
;;; $BJ8;zNs%$%Y%s%H$NF~NO(B
;;;

;;; #071 yy-protocol-71
;;; $B%F%j%H%j$NF~NO%;%l%/%7%g%s(B
;;; (yy-protocol-71 no)
;;; args. no = $B%F%j%H%jHV9f(B
(defcommand yy-protocol-71 (no)
  (let ((packet (car *send*)))

    (setf
     (c_access packet 0) (encode-com-pac 71 3))
    (c_store2 packet 2 no)
    (packet-send-single packet)))
#|
  (make-command-packet 71 :integer no :end)
  (packet-send))
|#

;;; #072 yy-protocol-72
;;; $B%F%j%H%j$NF~NO%^%9%/$N@_Dj(B
;;; (yy-protocol-72 no mask)
;;; args. no = $B%F%j%H%jHV9f(B
;;;	  mask = $BF~NO%^%9%/(B
(defcommand yy-protocol-72 (no mask)
  (let ((packet (car *send*)))

    (setf
     (c_access packet 0) (encode-com-pac 72 4))
    (c_store2 packet 2 no)
    (c_store2 packet 3 mask)
    (packet-send-single packet)))
  
#|
  (make-command-packet 72 :integer no :integer mask :end)
  (packet-send))
|#

;;; #073 yy-protocol-73
;;; $B%F%j%H%j$NF~NO%$%Y%s%H(B
;;;

;;; #074 yy-protocol-74
;;; $B%F%j%H%j$NF~NO%$%Y%s%HMW5a(B
;;; (yy-protocol-74 state)
;;; args. state = 1 --> $B%$%Y%s%HMW5a(B
;;;		  2 --> $B%$%Y%s%HF~NO5qH](B
(defcommand yy-protocol-74 (state)
  (let ((packet (car *send*)))

    (setf
     (c_access packet 0) (encode-com-pac 74 3))
    (c_store2 packet 2 state)
    (packet-send-single packet)))
#|
  (make-command-packet 74 :integer state :end)
  (packet-send))
|#

;;; #075 yy-protocol-75
;;;	    :

;;; #080 yy-protocol-80
;;; $B%Z!<%8%b!<%I%F%j%H%j!<$NB0@-@_Dj(B
;;; (yy-protocol-80 t-no f-no skip d-mode c-mode x y) -> 0-> good 1->fail
;;; args. t-no   = $B%F%j%H%j!<HV9f(B
;;;	  f-no   = $B%U%)%s%HHV9f(B
;;;	  skip   = $B%Y!<%9%i%$%s%9%-%C%W(B
;;;	  d-mode = $BJ8;zNs$NJ}8~!!#0!'2#=q$-!!#1!'=D=q$-(B
;;;	  c-mode = $B:BI87O!!!!!!!!#0!':8>e6y!!#1!':82<6y(B
;;;	  x      = $B%+%i%`0LCV(B
;;;       y      = $B9T0LCV(B
(defcommand yy-protocol-80  (t-no f-no skip d-mode c-mode x y)
  (let ((receive nil))
    (make-command-packet 80 :integer t-no :integer f-no :integer skip
     			    :integer d-mode :integer c-mode
			    :integer x :integer y :end)

    (setf receive (packet-send-receive))

    (if (zerop (get-packet-data receive 0))
    	(error "Can not set a page mode attibute"))
    ))

    
;;; #081 yy-protocol-81
;;; $B%Z!<%8%b!<%I%F%j%H%j!<$NB0@-@_Dj(B
;;; (yy-protocol-81 t-no tile tcolumn m-mode line column c-mode)
;;; args. t-no    = $B%F%j%H%j!<HV9f(B
;;;	  tline   = $B0\F0$9$k%F%j%H%j!<$N0\F00LCV!J9T!K(B
;;;	  tcolumn = $B0\F0$9$k%F%j%H%j!<$N0\F00LCV!J%+%i%`!K(B
;;;	  m-mode  = $B0\F0%b!<%I!!#0!'0\F0$;$:(B $B#1!'@dBP:BI8(B $B#2!'AjBP:BI8(B
;;;	  line    = $B%+!<%=%k$N9T0LCV(B
;;;	  column  = $B%+!<%=%k$N%+%i%`0LCV(B
;;;       c-mode  = $B%+!<%=%k$N0\F0%b!<%I!!#0!'0\F0$;$:(B $B#1!'@dBP:BI8(B $B#2!'AjBP:BI8(B
(defcommand yy-protocol-81 (t-no tline tcolumn m-mode line column c-mode)
  (make-command-packet 81 :integer t-no :integer tcolumn :integer tline 
			  :integer m-mode :integer column :integer line 
			  :integer c-mode :end)
  (packet-send))

      
;;; #082 yy-protocol-82
;;; $B%Z!<%8%b!<%I%F%j%H%j!<$NF~NO3+;O(B
;;; (yy-protocol-82 t-no x y type s-terminate-s terminate-s interrupt-s)
;;; args. t-no    = $B%F%j%H%j!<HV9f(B
;;;	  x       = $B3+;O9T(B
;;;	  y       = $B3+;O%+%i%`(B
;;;	  type    = $B%(%3!<%?%$%W!!#1!'%(%3!<!!#2!'%(%3!<$;$:!"%+!<%=%kI=<((B
;;;                               $B#3!'%(%3!<$;$:!"%+!<%=%kI=<(L5$7(B
;;;	  s-terminate-s = $BESCf7k2LAw?.%-!<$NJ8;zNs(B
;;;	  terminate-s   = $B:G=*7k2LAw?.%-!<$NJ8;zNs(B
;;;       interrupt-s   = $BF~NOCfCG%-!<$NJ8;zNs(B
(defcommand yy-protocol-82 (t-no x y type s-terminate-s terminate-s interrupt-s)
  (make-command-packet 82 :integer t-no :integer x :integer y
			  :integer type :string s-terminate-s
			  :string terminate-s :string interrupt-s :end)
  (packet-send))

;;; #083 yy-protocol-83
;;; $BF~NO=hM}$NCf;_(B
;;; (yy-protocol-83 t-no )
;;; args. t-no    = $B%F%j%H%j!<HV9f(B
(defcommand yy-protocol-83 (t-no)
  (make-command-packet 83 :integer t-no :end)
  (packet-send))

;;; Update 11/14 By T.kosaka
;;; Return value is a list for left, bottom, width, height ,colum and line

;;; #084 yy-protocol-84
;;; $B%Z!<%8%b!<%I%F%j%H%j!<$KBP$9$kJ8;zNs$NIA2h(B
;;; (yy-protocol-84 t-no op color font string) -> 
;;;              (list $BIA2h%j!<%8%g%s(B $B%+%i%`$H9T$N0LCV(B)
;;; args. t-no   = $B%F%j%H%j!<HV9f(B
;;;	  op     = $BI=<(%*%Z%l!<%7%g%s(B
;;;	  color  = $BI=<(%+%i!<HV9f(B
;;;       font   = $B%U%)%s%HHV9f(B
;;;	  string = $BJ8;zNs(B
(defcommand yy-protocol-84 (t-no op color font string)
  (let ((receive nil))

    (make-command-packet 84 :integer t-no :integer op :integer color
			    :integer font
			    :string string :end)

    (setf receive (packet-send-receive))

    (list (get-packet-data receive 0)
	  (get-packet-data receive 1)
	  (get-packet-data receive 2)
	  (get-packet-data receive 3)
	  (get-packet-data receive 4)
	  (get-packet-data receive 5))))
	
;;; #085 yy-protocol-85
;;; $B9T$H%+%i%`$N0LCV$h$j%j!<%8%g%s$r5a$a$k(B
;;; (yy-protocol-85 t-no column line) -> $B%j!<%8%g%s(B
;;; args. t-no   = $B%F%j%H%j!<HV9f(B
;;;	  colum  = $B%+%i%`(B
;;;	  line   = $B9T(B
(defcommand yy-protocol-85 (t-no column line)
  (let ((receive nil)
	(packet (car *send*)))

    (setf
     (c_access packet 0) (encode-com-pac 85 5))
    (c_store2 packet 2 t-no)
    (c_store2 packet 3 column)
    (c_store2 packet 4 line)

;    (make-command-packet 85 :integer t-no :integer column :integer line  :end)

    (setf receive (packet-send-receive-single packet))

    (list (get-packet-data receive 0)
	  (get-packet-data receive 1)
	  (get-packet-data receive 2)
	  (get-packet-data receive 3))))


;;; #085 yy-protocol-87
;;; $B8=:_$N9T$H%+%i%`$N0LCV$r5a$a$k(B
;;; (yy-protocol-87 t-no)
;;; args. t-no   = $B%F%j%H%j!<HV9f(B
(defcommand yy-protocol-87 (t-no)
  (let ((receive nil)
	(packet (car *send*)))

    (setf
     (c_access packet 0) (encode-com-pac 87 3))
    (c_store2 packet 2 t-no)

;    (make-command-packet 87 :integer t-no :end)

    (setf receive (packet-send-receive-single packet))

    (list (get-packet-data receive 0)
	  (get-packet-data receive 1))))



;;; #089 yy-protocol-89
;;; reserved


;;; #090 yy-protocol-90
;;; $B%^%&%9%+!<%=%k$N@8@.(B
;;; (yy-protocol-90 width height parent x-hot y-hot bitmap) -> no
;;; args. width = $B%F%j%H%j$NI}(B
;;;	  height = $B%F%j%H%j$N9b$5(B
;;;	  parent = $B?F$K$J$k%F%j%H%j(B
;;;	  x-hot = $B%[%C%H%9%]%C%H$N0LCV(B X
;;;	  y-hot = $B%[%C%H%9%]%C%H$N0LCV(B y
;;;	  bitmap = $B%S%C%H%^%C%W$,IA2h$5$l$F$$$k%F%j%H%j$NHV9f(B
;;;		   0 $B$G$"$k$J$i$P!"2?$bIA2h$5$l$F$$$J$$%S%C%H%^%C%W$K$J$k!#(B
;;; val.  no = 0 $B$J$i$P<:GT!"$=$&$G$J$1$l$P%F%j%H%jHV9f(B
(defcommand yy-protocol-90 (width height parent x-hot y-hot bitmap)
  (let ((receive nil))
    (make-command-packet 90 :integer width :integer height :integer parent
			 :integer x-hot :integer y-hot :integer bitmap :end)

    (setf receive (packet-send-receive))

    (get-packet-data receive 0)))

;;; #091 yy-protocol-91
;;; $B%^%&%9%+!<%=%k%[%C%H%9%]%C%H$N0LCVJQ99(B
;;; (yy-protocol-91 no x-hot y-hot)
;;; args. no = $B%^%&%9%+!<%=%k$N%F%j%H%j$NHV9f(B
;;;	  x-hot = $B%[%C%H%9%]%C%H$N0LCV(B X
;;;	  y-hot = $B%[%C%H%9%]%C%H$N0LCV(B y
(defcommand yy-protocol-91 (no x-hot y-hot)
  (make-command-packet 91 :integer no :integer x-hot :integer y-hot :end)
  (packet-send))

;;; #092 yy-protocol-92
;;; $B%^%&%9%+!<%=%k$N%S%C%H%^%C%W$NJQ99(B
;;; (yy-protocol-92 no bitmap)
;;; args. no = $B%^%&%9%+!<%=%k$N%F%j%H%j$NHV9f(B
;;;	  bitmap = $B%S%C%H%^%C%W$,IA2h$5$l$F$$$k%F%j%H%j$NHV9f(B
;;;		   0 $B$G$"$k$J$i$P!"2?$bIA2h$5$l$F$$$J$$%S%C%H%^%C%W$K$J$k!#(B
(defcommand yy-protocol-92 (no bitmap)
  (make-command-packet 92 :integer no :integer bitmap :end)
  (packet-send))

;;; #093 yy-protocol-93
;;; $B%^%&%9%+!<%=%k$N0LCVJQ99(B
;;; (yy-protocol-93 no pno x y)
;;; args. no = $B%^%&%9%+!<%=%k$N%F%j%H%j$NHV9f(B
;;;	  pno = $B0LCV$r;XDj$9$k%F%j%H%j$NHV9f(B
;;;	  x = $B@_Dj0LCV(B X
;;;	  y = $B@_Dj0LCV(B Y
(defcommand yy-protocol-93 (no pno x y)
  (make-command-packet 93 :integer no :integer pno :integer x :integer y :end)
  (packet-send))

;;; #094 yy-protocol-94
;;; $B%^%&%9%+!<%=%k>C5n(B
;;; (yy-protocol-94 no) -> no
;;; args. no = $B%^%&%9%+!<%=%k$N%F%j%H%j$NHV9f(B
;;; val.  no = 0 $B$J$i$P<:GT!"$=$&$G$J$1$l$P%F%j%H%jHV9f(B
(defcommand yy-protocol-94 (no)
  (let ((receive nil))
    (make-command-packet 94 :integer no :end)
    (setf receive (packet-send-receive))
    (get-packet-data receive 0)))

;;; #095 yy-protocol-95
;;; $B%^%&%9%+!<%=%k$N>uBV3MF@(B
;;; (yy-protocol-95 no interrupt-event) -> interrupt-event
;;; args. no = $B%^%&%9%+!<%=%k$N%F%j%H%j$NHV9f(B
;;;	  interrupt-event = $B%^%&%9!"3d$j9~$_%-!<%$%Y%s%H(B
;;; val.  interrupt-event = $B%^%&%9!"3d$j9~$_%-!<$N>uBV(B
(defcommand yy-protocol-95 (no interrupt-event)
  (let ((receive nil))
    (make-command-packet 95 :integer no :end)
    (setf receive (packet-send-receive)
	  (slot-value interrupt-event 'territory-no) 
	  (get-packet-data receive 0)
	  (slot-value interrupt-event 'event-mask)
	  (get-packet-data receive 1)
	  (position-x (slot-value interrupt-event 'event-position))
	  (get-packet-data receive 2)
	  (position-y (slot-value interrupt-event 'event-position))
	  (get-packet-data receive 3))
    interrupt-event)
  )

;;; #096 yy-protocol-96
;;; $B8=>u$N%^%&%9%+!<%=%k$NJQ99(B
;;; (yy-protocol-96 no)
;;; args. no = $B%^%&%9%+!<%=%k$N%F%j%H%j$NHV9f(B
(defcommand yy-protocol-96 (no)
  (make-command-packet 96 :integer no :end)
  (packet-send))

;;; #097 yy-protocol-97
;;;	    :
;;; #254 yy-protocol-254
;;; reserved


;;; #255 yy-protocol-255
;;; $B#Y#Y(B  $B#o#n(B  $B#X$N=*N;(B
;;; (yy-protocol-255 no)
;;; args. no = $B%k!<%H%F%j%H%j$NHV9f(B
(defcommand yy-protocol-255 (no)
  (make-command-packet 255 :integer no :end)
  (packet-send))

      

;;; $BDLCN(B
;;;
;;;
(defun yy-tuuchi (yy-keybord-event yy-interrupt-event yy-resize-event)
  (let ((command 0))

#+EXCL
    (loop
     (when (not (zerop (c_select2)))
         (setf command (packet-receive))
         (return))
     (sleep 0.1))
#+(or LUCID Symbolics)
     (setf command (packet-receive))

      (case command
	;; $BJ8;zNs$NF~NO(B
	(70
	 (setf (slot-value yy-keybord-event 'territory-no)
	       (get-packet-data *receive* 0) ; $B%F%j%H%jHV9f(B
	       (slot-value yy-keybord-event 'event-string)
	       (get-packet-data *receive* 2 (get-packet-data *receive* 1)))
	 (values yy-keybord-event 2))
	;; $B%^%&%9!"3d$j9~$_%-!<%$%Y%s%H(B
	(73
	 (setf (slot-value yy-interrupt-event 'territory-no)
	       (get-packet-data *receive* 0) ; $B%F%j%H%jHV9f(B
	       (slot-value yy-interrupt-event 'event-mask)
	       (get-packet-data *receive* 1)  ;;; $B%^%9%/(B
	       (position-x (slot-value  yy-interrupt-event 'event-position))
	       (real-integer (get-packet-data *receive* 2))
	       (position-y (slot-value yy-interrupt-event 'event-position))
	       (real-integer (get-packet-data *receive* 3)))
	 (values yy-interrupt-event 1))
	;;; $B%F%j%H%j!<$NBg$-$5JQ99%$%Y%s%H(B
	(86
	 (setf (slot-value yy-resize-event 'territory-no)
 	       (get-packet-data *receive* 0) ; $B%F%j%H%jHV9f(B
 	       (region-left (slot-value yy-resize-event 'event-region))
 	       (real-integer (get-packet-data *receive* 1))
 	       (region-bottom (slot-value yy-resize-event 'event-region))
 	       (real-integer (get-packet-data *receive* 2))
 	       (region-width (slot-value yy-resize-event 'event-region))
 	       (real-integer (get-packet-data *receive* 3))
 	       (region-height (slot-value yy-resize-event 'event-region))
 	       (real-integer (get-packet-data *receive* 4)))
 	  (values yy-resize-event 3))
	)
      )
)

#|
;;; Debug $B%F%j%H%j!<$NB0@-%A%'%C%/(B $B$b$7%F%j%H%j!<$,!"(B
;;; $BIA2h%b!<%I0J30$GIA2h$9$l$P%(%i!<(B
(defun territory-check (tno)
  (let ((mode (cdr (assoc tno *territory-attribute*))))
    (if (zerop (logand #x0100 mode))
	(error "This territory can not drawable!!")
      )))
|#