;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; $@%&%#%s%I%&%9%H%j!<%`$NItIJ4XO"(J
;;; window-parts.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.0 90/06/01 by t.kosaka (kosaka@csrl.aoyama.ac.jp)
;;;   version 1.1 90/07/31 by t.kosaka
;;;   update 1.11 90/09/14 by t.kosaka
;;;   version 1.2 90/11/05 by t.kosaka

;;; 7/27 1990 $@8E:d(J
;;; Version 1.0   Coded by t.kosaka 1990-7-27
;;; Change Log    Add page-mode class viewport-mode class  1990-8-29
;;;               Update world-region method               1990-8-29

(in-package :yy)

;;; $@%9%/%m!<%k%P!<BS$NI}(J
(defparameter *SCROLL-BAR-BELT* 12)

;;; $@%&%#%s%I%&$NItIJ%/%i%9(J
(defclass window-parts () 
  ((parent-window :initarg :parent-window
                  :accessor parent-window)))

;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $@%?%$%H%k%P!<%/%i%9(J ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass title-bar (event-drawable-piece window-parts)
  ((title-font :initarg :title-bar-font
	       :initform *DEFAULT-FONT*)

   (title-bar-string :initarg :title-bar-string
		     :initform "" )

   (title-bar-color :initarg :title-bar-color
		    :initform *BLACK-COLOR*)))


;;; $@%?%$%H%k%P!<(Jredisplay$@%a%=%C%I(J
(defgeneric redisplay-title-bar (title)
  (:method ((title title-bar))
  (declare (special *BLACK-COLOR* *WHITE-COLOR*))
	   (with-slots (title-font title-bar-string title-bar-color) title
             ;;; Territory back ground clear --> to default color
	     (draw-piece-color title title-bar-color)

    ;;; Draw string 
	     (draw-piece-string title 1 (font-kanji-base-line title-font)
				title-bar-string
		       :color *WHITE-COLOR*
		       :font title-font)
	     ))
  (:method (title)
#-:PCL
	   (declare (ignore title))
	   nil))


;;; $@%?%$%H%k%P!<%j!<%8%g%sJQ994X?t2?$b$7$J$$(J
(defgeneric set-title-bar-region (title region)
  (:method ((title title-bar) region)
	   (if (eq title region)
	       (with-real-object (title) (+ 1 1))
	     (with-real-object  (title)
				(set-region title region))))
  (:method (title region)
#-:PCL
	   (declare (ignore title region))
	   nil))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $@%o!<%k%I$N4pK\%/%i%9(J ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass world-primitive (region graphic-stream)
  ((world-territory-no :initarg :world-territory-no 
		       :accessor world-territory-no :initform 0)
   ;;; $@%F%j%H%j!<$N$R$@$j$9$_$2$s$F$s$+$i(J
   (world-x-start :initarg :world-x-start
		  :initform 0 :accessor world-x-start
		   :type integer) 
    ;;; $@%F%j%H%j!<$N$R$@$j$&$($2$s$F$s$+$i(J
   (world-y-start :initarg :world-y-start
		   :initform 0 :accessor world-y-start
		   :type integer) 
   (world-color :initarg :world-back-color :initform *WHITE-COLOR*
		:type color :accessor world-back-color)

   (drawing-region :initarg :drawing-region :initform nil
		   :type region :accessor drawing-region)

   (present-list :initarg :present-list :initform nil
		 :type list :accessor present-list)

   (presentation-instance :initform nil
			  :accessor presentation-instance)

   ;;; $@O@M}86E@$+$i$N%:%l(J x$@J}8~(J
   (world-x-offset :initarg :x-offset :initform 0)

   ;;; $@O@M}86E@$+$i$N%:%l(J y$@J}8~(J
   (world-y-offset :initarg :y-offset :initform 0)

   ;;; $@%j%5%$%:MQ$N%o!<%/%j!<%8%g%s(J
   (resize-work :initform (make-region) :accessor resize-work)
   ))

;;; X $@%*%U%;%C%HJQ99(J $@@dBPJQ99(J
(defun set-world-x-offset (new-value world)
    (let* ((width (region-width world))
	   (x (- new-value (world-x-start world))))

      (setf (region-left world) x
	    (region-width world) width
	    (slot-value world 'world-x-offset) new-value)
   
    ;;; $@%F%j%H%j!<$N0\F0(J
    (yy-protocol-3 (world-territory-no world) 
		   (region-left world) (region-bottom world)))
    new-value)


;;; X $@%*%U%;%C%HJQ99(J $@AjBPJQ99(J
(defun add-x-offset-world (world value)
  (let ((x (- (+ (slot-value world 'world-x-offset) value) 
	      (world-x-start world))))
    (setf (slot-value world 'world-x-offset) x)
    x))

;;; Y$@%*%U%;%C%H$NJQ99(J $@@dBPJQ99(J
(defun set-world-y-offset (new-value world)
  (let ((height (region-height world)))
	 
    (setf (region-bottom world) (- new-value (world-y-start world))
	  (region-height world) height
	  (slot-value world 'world-y-offset) new-value)
   
    ;;; $@%F%j%H%j!<$N0\F0(J
    (yy-protocol-3 (world-territory-no world) (region-left world)
		   (region-bottom world))))


;;; Y $@%*%U%;%C%HJQ99(J $@AjBPJQ99(J
(defun add-y-offset-world (world value)
  (let ((y (- (+ (slot-value world 'world-y-offset) value) 
	      (world-y-start world))))
    (setf (slot-value world 'world-y-offet) y)
    y))

;;; XY$@%*%U%;%C%H$NJQ99(J $@@dBPJQ99(J
(defun change-world-xy-offset-internal (world x y)
  (let ((height (region-height world))
	(width (region-width world))
	(t-l (region-left world))
	(t-b (region-bottom world)))

    (setf (region-left world) (- x (world-x-start world))
	  (region-width world) width
	  (slot-value world 'world-x-offset) x)
   
    (setf (region-bottom world) (- y (world-y-start world))
	  (region-height world) height
	  (slot-value world 'world-y-offset) y)
    
    (when (or (/= t-l (region-left world))
	      (/= t-b (region-bottom world)))
          ;;; $@%F%j%H%j!<$N0\F0(J
	(yy-protocol-3 (world-territory-no world) (region-left world)
	   (region-bottom world)))
    (values x y)))
    
;;;;;;;;;;;;;;;;;;;;;
;;; $@%Z!<%8%b!<%I(J ;;;;
;;;;;;;;;;;;;;;;;;;;;
(defclass page-mode ()
  (   ;;; $@%+%i%`(J
   (column :initarg :column :initform 0
	   :accessor page-column )
   ;;; $@9T(J
   (line :initarg :line :initform 0
	 :accessor page-line)))

;;;;;;;;;;;;;;;;;;;;;;;;
;;; $@%S%e%]!<%H%b!<%I(J ;;;
;;;;;;;;;;;;;;;;;;;;;;;;
(defclass viewport-mode () ())

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $@%&%#%s%I%&%I%m!<%"%V%k%o!<%k%I(J ;;;
;;; $@%S%e!<%]!<%H%b!<%I(J             ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass drawable-viewport-world 
  (viewport-mode world-primitive)
  ())
  
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $@%&%#%s%I%&%I%m!<%"%V%k%o!<%k%I(J ;;;
;;; $@%Z!<%8%b!<%I(J                   ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass drawable-page-world (page-mode world-primitive)
  ())

#|
   LTRB $@$N$P$"$$(J
    + 	+-----------------------------+ START-X START-Y
    |	|			      |   
    +	|  * $@$2$s$F$s(J                 |
	|			      |
	|			      |
	|			      |
    +	|  * $@$2$s$F$s(J		      |
    |	|			      |
    +	+-----------------------------+
  LBWH $@$N$P$"$$(J

	$@$2$s$F$s$O!"$3$F$$!#(J 
	$@%o!<%k%I%j!<%8%g%s$O!"$2$s$F$s$+$i!"$N$+$/$@$$!?$7$e$/$7$g$&(J
	$@$r$9$k!#$7$?$,$C$F!"%^%$%J%9$[$&$3$&$X$N$+$/$@$$$b$"$j$&$k!#(J
|#

;;; $@%o!<%/$rMxMQ$7$?(Jregion-union-no-copy
(defmethod region-union-no-copy-world ((world world-primitive)
				       region1 region2)
  (let ((region (resize-work world)))
    (with-slots ((l1 left) (b1 bottom) (r1 right) (t1 top)) region1
       (with-slots ((l2 left) (b2 bottom) (r2 right) (t2 top)) region2
	   (with-slots ((l3 left) (b3 bottom) (r3 right) (t3 top)) region
		(setf l3 (min l1 l2)
		      b3 (min b1 b2)
		      r3 (max r1 r2)
		      t3 (max t1 t2)))))
    region))

;;; $@%Z!<%8%b!<%I$N%o!<%k%I$N%5%$%:JQ99(J
;;; $@;XDj%5%$%:$,85$N$b$N$h$j>.$5$1$l$P2?$b$7$J$$(J
(defmethod resize-world ((new-region region) (world drawable-page-world))
  (force-resize-world-for-page new-region world)
  )
			

;;; $@%S%e%]!<%H%b!<%I$N%o!<%k%I$N%5%$%:JQ99(J
;;; $@;XDj%5%$%:$,85$N$b$N$h$j>.$5$1$l$P2?$b$7$J$$(J
(defmethod resize-world ((new-region region) 
			 (world drawable-viewport-world))

  (force-resize-world new-region world))


;;; $@6/@)%o!<%k%I%5%$%:$NJQ99F~NO;~$NJ8;zNsMQ(J
;;; $@C"$7;XDj%5%$%:$,85$N$b$N$h$j>.$5$1$l$P2?$b$7$J$$(J
;;; $@%o!<%k%I%j!<%8%g%s$O!":8>e6y86E@$N%j!<%8%g%s(J
;;; $@?7%j!<%8%g%s$b:8>e6y(J
(defun force-resize-world (new-region world)

  ;;; $@IA2h%j!<%8%g%s$N(J0,0$@$,86E@$N%o!<%k%I%j!<%8%g%s(J
  (declare (inline - + > <))
  (with-temp-region-args ((real-region) (work-region3 world)
	       :left (- (world-x-start world))
	       :bottom (- (world-y-start world))
	       :width (region-width world)
	       :height (region-height world))
    (let* ((x-start (world-x-start world)) 
	   (y-start (world-y-start world))
	   (x-offset (slot-value world 'world-x-offset))
	   (y-offset (slot-value world 'world-y-offset))
	   (tno (world-territory-no world))
	   (union-region 
	    (region-union-no-copy-world world real-region new-region))
	   (v-s nil) (h-s nil))

      (with-slots 
       (left bottom right top) world
       (when (or (> (region-width union-region) (- right left))
		 (> (region-height union-region) (- top bottom)))
	      ;;; $@Bg$-$5$NJQ99(J X$@J}8~(J

	    (when (> (region-width union-region) (- right left))

     	              ;;; $@%^%$%J%9J}8~$K9-$,$k$+(J
		     (if (< (region-left union-region) (- 0 x-start))
			 (setf (world-x-start world) 
			       (abs (region-left union-region))))
		     (setf left
			   (+ (region-left union-region) x-offset)
			   right 
			   (+ (region-width union-region) left)
			   h-s t))
	     ;;; $@Bg$-$5$NJQ99(J Y$@J}8~(J
	    (when (> (region-height union-region) (- top bottom))
    	            ;;; $@%^%$%J%9J}8~$K9-$,$k$+(J
		  (if (< (region-bottom union-region) (- 0 y-start))
		      (setf (world-y-start world) 
			    (abs (region-bottom union-region))))

		  (setf bottom
			(+ (region-bottom union-region) y-offset)
			top (+ bottom (region-height union-region))
			v-s t))

	    (yy-protocol-4 tno
		       left bottom 
		       (- right left)
		       (- top bottom)
		       (- (world-x-start world) x-start)
		       (- (world-y-start world) y-start))
	    )
      (values v-s h-s)))))


;;; $@C"$7;XDj%5%$%:$,85$N$b$N$h$j>.$5$1$l$P2?$b$7$J$$(J
;;; $@%o!<%k%I%j!<%8%g%s$O!":8>e6y86E@$N%j!<%8%g%s(J
;;; $@?7%j!<%8%g%s$b:8>e6y(J
(defun force-resize-world-for-page (new-region world)
      (let* ((x-start (world-x-start world)) 
	     (y-start (world-y-start world))
	     (x-offset (slot-value world 'world-x-offset))
	     (y-offset (slot-value world 'world-y-offset))
	     (shift-region (shift-region-position 
			    new-region (+ x-start x-offset)
					      (+ y-start y-offset)))
	     (union-region 
	      (region-union-no-copy-world world shift-region world))
	     (d-width (-  (region-width union-region) (region-width world)))
	     (d-height (- (region-height union-region) (region-height world)))
	     (c-width (region-width union-region))
	     (c-height (region-height union-region))
	     (v-s nil) (h-s nil))
	
	(when (or (> d-width 0) (> d-height 0))

	      (if (> d-width 0)
		  (setf h-s t))

	      (if (> d-height 0)
		  (setf v-s T))

	      ;;; $@%9%?!<%H0LCV$NJQ99(J
	      (when  (> d-width 0)
		(if (and (> 0 (region-left union-region))
			 (< (region-left union-region) (- x-start)))
		    (setf (world-x-start world) 
		      (abs (region-left union-region)))))

	      (when (> d-height 0)
		(if (and (> 0 (region-bottom union-region))
			 (< (region-bottom union-region) (- y-start)))
		    (setf (world-y-start world)
		      (abs (region-bottom union-region)))))
    
	      (setf (region-left world) (- x-offset (world-x-start world))
		    (region-bottom world) (- y-offset (world-y-start world))
		    (region-width world) c-width
		    (region-height world) c-height))
	(values v-s h-s)))
	      
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $@%&%#%s%I%&%U%l!<%`%/%i%9(J  ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass window-frame (region window-parts)
  ((frame-territory-no :initform 0 :accessor frame-territory-no
			  :type integer 
			  :initarg :frame-territory-no
			  :reader territory)

   (frame-visible :initform T :accessor frame-visible
		     :initarg :frame-visible)

   (child-object-list :initarg :child-object-list
		      :initform nil :accessor child-object-list)))

(defmethod print-object ((frame window-frame) stream)
	   (format stream "\#<Widnow-Frame width: ~a height ~a >"
		   (region-width frame) (region-height frame)))
	 

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $@%U%l!<%`$N%5%$%:JQ99(J   ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defmethod set-frame-region ((frame window-frame) new-region)
  (unless (eq frame new-region)
    ;;; $@%j!<%8%g%s%5%$%:$NJQ99(J
    (set-region frame  new-region))
  ;;; $@%F%j%H%j!<%5%$%:$NJQ99(J
  (yy-protocol-4 (frame-territory-no frame)
		 (region-left new-region)
		 (region-bottom new-region)
		 (region-width new-region)
		 (region-height new-region))
    )

;;;$@%&%#%s%I%&%U%l!<%`I=<(>uBV$NJQ99(J
(defmethod (setf frame-visible) :after (new (frame window-frame))
  (if new
	(yy-protocol-2 (frame-territory-no frame) 1)
    (yy-protocol-2 (frame-territory-no frame) 0)))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $@%9%/%m!<%k%P!<%/%i%9(J ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass scroll-bar (event-drawable-piece window-parts)
  ((scroll-bar-color :initform *black-color*
		     :initarg :scroll-bar-color
		     :accessor scroll-bar-color)))

;;;  $@%9%/%m!<%k%P!<$N%j!<%8%g%sJQ99(J NULL $@$N>l9g(J
(defmethod set-scroll-region (region (ob NULL))
#-:PCL
  (declare (ignore region))
  (values))

;;; $@%9%/%m!<%k%P!<$N%j!<%8%g%sJQ99(J
(defmethod set-scroll-region (new-region
			      (scroll scroll-bar))
  (if (not (eq new-region scroll))
      (with-real-object (scroll)
			(set-region scroll new-region))
    (with-real-object (scroll) (values)))
	
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $@=DJ}8~$N%9%/%m!<%k%P!<%/%i%9(J ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass vertical-scroll-bar (scroll-bar)
  ((vdisplay-start :initarg :vdisplay-start :initform 0
   			    :accessor vdisplay-start)

   (sdisplay-height :initarg :sdisplay-height :initform nil
   		    :accessor sdisplay-height)

   (world-height :initarg :world-height 
		 :reader world-height
		 :initform 0)

   (frame-height :initarg frame-heigth
		 :reader frame-height 
		 :initform 0)

   (coordinate :initarg :coordinate
	      :initform :left-top
	      :accessor coordinate)

   ;;; $@O@M}86E@$+$i$N%:%l(J y$@J}8~(J
   (world-y-offset :initarg :y-offset :initform 0)))

;;; print-object
(defmethod print-object ((ob vertical-scroll-bar) stream)
  (format stream "#\<Vertical Scroll Bar :Offset ~a>"
	  (slot-value ob 'world-y-offset)))


;;; $@%o!<%k%I$N%*%U%;%C%H$r@_Dj(J
(defgeneric set-vertical-world-y-offset (scroll new-v)
  (:method ((scroll vertical-scroll-bar) new-v)
	   (setf (slot-value scroll 'world-y-offset) new-v))
  (:method ((scroll NULL) new-v)
#-:PCL
(declare (ignore new-v))
  ))


;;; world-height $@$N(Jsetf$@%a%=%C%I(J
;;; $@=DJ}8~$N%9%/%m!<%k%P%$%s%9%?%s%9$,$J$$;~$K$O2?$b$7$J$$(J
(defmethod (setf world-height) (val (ob vertical-scroll-bar))
     (setf (slot-value ob 'world-height) val))
(defmethod (setf world-height) (val (ob NULL))
#-:PCL
  (declare (ignore val))
  (values))

;;; frame-height$@$N(Jsetf$@%a%=%C%I(J
;;; $@=DJ}8~$N%9%/%m!<%k%P%$%s%9%?%s%9$,$J$$;~$K$O2?$b$7$J$$(J
(defmethod (setf frame-height) (val (ob vertical-scroll-bar))
  (setf (slot-value ob 'frame-height) val))
(defmethod (setf frame-height) (val (ob NULL))
#-:PCL
  (declare (ignore val))
  (values))

;;; $@=DJ}8~%9%/%m!<%k%P!<$,Dj5A$5$l$F$$$J$1$l$P2?$b$7$J$$(J
(defmethod redisplay-vertical-scroll ((vscroll null))
  (values))


;;; $@:FI=<(=DJ}8~%9%/%m!<%k%P!<(J
(defmethod redisplay-vertical-scroll ((vscroll vertical-scroll-bar))
  (declare (special *WHITE-COLOR*)
	   (inline - / round * + /=))
  (WITH-INHIBIT-SCHEDULING
  
  (let* ((s-height (region-height vscroll))
         (w-height (slot-value vscroll 'world-height))
	 (v-height (slot-value vscroll 'frame-height))
	 (y-offset (slot-value vscroll 'world-y-offset))
	 (color (slot-value vscroll 'scroll-bar-color))
	 (vh (round (/-yy (* s-height v-height) w-height)))
	 (vs 0))

	 ;;; $@:BI87O$r$7$i$Y$k(J
	 (if (eq (coordinate vscroll) :left-bottom)
	 	;;; $@$R$@$j$7$?(J
	    (setf vs (- s-height (- vh (round (/-yy (* s-height (- y-offset)) 
						 w-height)) )))
   	          ;;; $@$R$@$j$&$((J
	    (setf vs (round (/-yy (* (- y-offset) s-height) w-height))))
    
         ;;; $@=q$-D>$7$,I,MW$+D4$Y$k(J
	 (with-slots (sdisplay-height vdisplay-start) vscroll
	    (when (or (/= vs vdisplay-start)
		      (/= vh (if sdisplay-height
				 sdisplay-height
			       0)))

   	           ;;; $@OH$NIA2h(J $@=i4|@_Dj;~(J
		  (if (null sdisplay-height)
		      (progn 
  		         ;;; $@0lEY>C5n(J
			(draw-piece-color vscroll *WHITE-COLOR*)
	                ;;; $@OHI=<((J
			(draw-piece-rectangle vscroll
					      0 0 (region-width vscroll)
					      s-height
					      :color color))
	    
 	            ;;; $@A0$N%9%/%m!<%k%P!<$NI=<($r>C5n$HOHI=<((J
		    (progn 
		       ;;; $@OHI=<((J
		      (draw-piece-rectangle vscroll
					    0 0 (region-width vscroll)
					    s-height :color color)

		       ;;; $@A0$N%9%/%m!<%k%P!<$N>C5n(J
		      (draw-piece-filled-rectangle vscroll
			   3 (+ vdisplay-start  1)
			   (- *SCROLL-BAR-BELT* 6)
			   (- sdisplay-height 2) 
			   :color *WHITE-COLOR*)))
		 
                   ;;; $@%+%l%s%HNN0h$r;XDj$5$l$??'$K$9$k(J
		  (draw-piece-filled-rectangle vscroll
		       3 (+ vs 1) (- *SCROLL-BAR-BELT* 6) (- vh 2)
		       :color color)

		  (setf vdisplay-start vs
			sdisplay-height vh)
		  
		  )
	    )))
  (values))


;;; $@=DJ}8~%9%/%m!<%k%P!<$N%j!<%8%g%sJQ99(J
(defmethod set-scroll-region :after (new-region (scroll vertical-scroll-bar))
#-:PCL
    (declare (ignore new-region))
    (setf (slot-value scroll 'sdisplay-height) nil))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $@2#J}8~$N%9%/%m!<%k%P!<%/%i%9(J ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass horizontal-scroll-bar (scroll-bar)
  ((hdisplay-start :initarg :hdisplay-start :initform 0
		   :accessor hdisplay-start)

   (sdisplay-width :initarg :sdisplay-width :initform nil
   		   :accessor sdisplay-width)

   (world-width :initarg :world-with
		:reader world-width
		:initform 0)

   (frame-width :initarg frame-width
		 :reader frame-width)
   
   ;;; $@O@M}86E@$+$i$N%:%l(J x $@J}8~(J
   (world-x-offset :initarg :world-x-offset :initform 0
		)))

;;; print-object
(defmethod print-object ((ob horizontal-scroll-bar) stream)
  (format stream "#\<Horizontal Scroll Bar :Offset ~a>"
	  (slot-value ob 'world-x-offset)))

;;; $@%o!<%k%I$N%*%U%;%C%H$r@_Dj(J
(defgeneric set-horizontal-world-x-offset (scroll new-v)
  (:method ((scroll horizontal-scroll-bar) new-v)
	   (setf (slot-value scroll 'world-x-offset) new-v))
  (:method ((scroll NULL) new-v)
#-:PCL
(declare (ignore new-v))
  ))

;;; world-width $@$N(Jsetf$@%a%=%C%I(J
;;; $@2#J}8~$N%9%/%m!<%k%P%$%s%9%?%s%9$,$J$$;~$K$O2?$b$7$J$$(J
(defmethod (setf world-width) (val (ob horizontal-scroll-bar))
     (setf (slot-value ob 'world-width) val))
(defmethod (setf world-width) (val (ob NULL))
#-:PCL
  (declare (ignore val))
  (values))

;;; frame-width$@$N(Jsetf$@%a%=%C%I(J
;;; $@2#J}8~$N%9%/%m!<%k%P%$%s%9%?%s%9$,$J$$;~$K$O2?$b$7$J$$(J
(defmethod (setf frame-width) (val (ob horizontal-scroll-bar))
  (setf (slot-value ob 'frame-width) val))
(defmethod (setf frame-width) (val (ob NULL))
#-:PCL
  (declare (ignore val))
  (values))


;;; $@:FI=<(2#J}8~%9%/%m!<%k%P!<(J NULL $@$N>l9g(J
(defmethod redisplay-horizontal-scroll ((hscroll NULL))
  (values))

;;; $@:FI=<(2#J}8~%9%/%m!<%k%P!<(J
(defmethod redisplay-horizontal-scroll ((hscroll horizontal-scroll-bar))
  (declare (special *WHITE-COLOR*)
	   (inline / * /= + - round))
  (WITH-INHIBIT-SCHEDULING
  (let* ((s-width (region-width hscroll))
         (w-width (slot-value hscroll 'world-width))
	 (v-width (slot-value hscroll 'frame-width))
	 (color (slot-value hscroll 'scroll-bar-color))
	 (x-offset (- (slot-value hscroll 'world-x-offset)))
	 (vw (round (/-yy (* s-width v-width) w-width)))
	 (vs (round (/-yy (* x-offset s-width) w-width))))

    (with-slots (hdisplay-start sdisplay-width) hscroll
	(when (or (/= hdisplay-start vs)
		  (/= (if sdisplay-width 
			  sdisplay-width
			0) vw))

	  ;;; $@OH$rI=<($9$k(J $@=i4|>uBV$N$_(J
	      (if (null sdisplay-width)
		  (progn 
	             ;;; $@0lEY>C5n(J
		    (draw-piece-color hscroll *WHITE-COLOR*)
                    ;;; $@OH$rIA2h(J
		    (draw-piece-rectangle hscroll
					  0 0 s-width
					  (region-height hscroll)
					  :color color))

                 ;;; $@I=<(NN0h$N%/%j%"!<$HOH$rIA2h(J
		(progn 
	           ;;; $@OH$rIA2h(J
		  (draw-piece-rectangle hscroll
					0 0 s-width  (region-height hscroll)
					:color color)
	           ;;; $@I=<(NN0h$N%/%j%"!<(J
		  (draw-piece-filled-rectangle hscroll 
					       (+ hdisplay-start 1) 3
					       (- sdisplay-width 2)
					       (- *SCROLL-BAR-BELT* 6)
					       :color *WHITE-COLOR*)))
	  
	      
              ;;; $@%+%l%s%HNN0h$r;XDj$5$l$??'$K$9$k(J
	      (draw-piece-filled-rectangle hscroll 
			  (+ vs 1) 3 (- vw 2) (- *SCROLL-BAR-BELT* 6)
			  :color color)

	      (setf hdisplay-start vs
		    sdisplay-width vw)
	      ))))
  (values))

;;; $@2#J}8~%9%/%m!<%k%P!<$N%j!<%8%g%sJQ99(J
(defmethod set-scroll-region :after (new-region	(hscroll horizontal-scroll-bar))
#-:PCL
  (declare (ignore new-region))
  (setf (slot-value hscroll 'sdisplay-width) nil))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $@:BI87OI=<(%(%j%"%/%i%9(J ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass coordinate-area (piece-region window-parts)
  ((coordinate :accessor coordinate :initform :left-top
	       :initarg :coordinate)
   (coordinate-area-color :initform *black-color*
			 :accessor coordinate-area-color
			 :initarg :coordinate-area-color)))
;;; $@I=<(%a%=%C%I(J
(defmethod print-object ((ob coordinate-area) stream)
  (format stream "\#<Coordinate area>"))

;;; $@:BI87OI=<(%(%j%"$N:FI=<((J
(defmethod redisplay-coordinate-area ((coordinate NULL))
  (values))

;;; $@:BI87OI=<(%(%j%"$N:FI=<((J
(defmethod redisplay-coordinate-area ((coordinate coordinate-area))
  (declare (special *WHITE-COLOR* )
	   (inline + / - round ))
  (let ((color (coordinate-area-color coordinate))
	(width (region-width coordinate))
	(height (region-height coordinate)))
    
    ;;; $@%P%C%/%0%i%&%s%I$r%/%j%"!<(J
    (draw-piece-color coordinate *WHITE-COLOR*)

     ;;; $@OH$NIA2h(J
    (draw-piece-rectangle coordinate
	0 0 (region-width coordinate)
	(region-height coordinate)
	:color color)

    ;;; $@:BI87O$NI=<((J
    (if (eq (coordinate coordinate) :left-top)
	(progn 
	  ;;; $@@~(J
	  (draw-piece-polyline coordinate 3 (- height 3)
			       3 3 (- width 3) 3 :color color)
	  ;;; $@Lp0u(J
	  (draw-piece-polygon coordinate (- width 3) 1
				     (- width 3) 5 width 3
				     :color color)
	  ;;; $@Lp0u(J
	  (draw-piece-polygon coordinate 1 (- height 3)
				     5 (- height 3) 3 height
				     :color color))
      (progn
	;;; $@@~(J
	(draw-piece-polyline coordinate 3 3
			     3 (- height 3) (- width 3) (- height 3)
			     :color color)
	;;; $@Lp0u(J
	(draw-piece-polygon coordinate 3 0
			           1 3 5 3
				   :color color)
	;;; $@Lp0u(J
	(draw-piece-polygon coordinate (- width 3) (- height 5)
			           (- width 3) (- height 1)
				   width (- height 3)
				   :color color))
      )
    (values)))

;;; $@:BI87OI=<(%(%j%"$N2<$N0LCVJQ99(J NULL$@$J$i$P2?$b$7$J$$(J
(defmethod set-coordinate-area-region (new-region (coordinate NULL))
#-:PCL
  (declare (ignore new-region))
  (values))

;;; $@:BI87OI=<(%(%j%"$N2<$N0LCVJQ99(J
(defmethod set-coordinate-area-region (new-region
				       (coordinate coordinate-area))
  (if (eq new-region coordinate)
      (with-real-object (coordinate))
    (with-real-object (coordinate)
       (setf (region-bottom coordinate) (region-bottom new-region)
	     (region-left coordinate) (region-left new-region)))
    )
  (values))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $@%&%#%s%I%&$N%\!<%@!<%/%i%9(J  ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass window-border (event-method-mixin window-parts)
  ())

;;; $@I=<(%*%V%8%'%/%H(J
(defmethod print-object ((ob window-border) stream)
  (format stream "\#<Window Border>"))


;;; $@%&%#%s%I%&%9%H%j!<%`$+!)(J
(defun window-streamp (object)
   (typep object 'window-stream))

(defun /-yy (arg1 arg2)
  (declare (inline / zerop))
  (if (zerop arg2)
      0
    (/ arg1 arg2)))

;;; $@;XDj%-!<%o!<%I%j%9%H$r=|$$$?%j%9%H$rJV$9(J
(defun delete-keyword-form-rest (keyword rest)
  (let ((flg nil))
    (mapcan #'(lambda (x)
		(if (find x keyword)
		    (progn (setf flg t) (values))
		  (if flg
		      (progn (setf flg nil) (values))
		    (list x))))
	    rest)))
	    
