;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; $B%F%j%H%j!<$K0MB8$9$kItJ,$rDj5A(B
;;; territory.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.0 90/06/01 by t.kosaka (kosaka@csrl.aoyama.ac.jp)
;;;   version 1.1 90/07/31 by t.kosaka
;;;   update 1.11 90/09/14 by t.kosaka
;;;   version 1.2 90/11/05 by t.kosaka

;;; 7/27 1990 $B8E:d(B
;;; Version 1.0   Coded by t.kosaka 1990-7-27

(in-package :yy )


;;; $B%F%j%H%*%jHV9f$H(BLISP$B%*%V%8%'%/%H$r4IM}$9$k9=B$BN(B
(defstruct territory-object 
           territory-no      ;;; $B%F%j%H%j!<HV9f(B
           lisp-object       ;;; LISP$B%*%V%8%'%/%H(B
	   bigger            ;;; $BBg$-$$$b$N$,F~$k(B
	   smaller           ;;; $B>.$5$$$b$N$,F~$k(B
	   )

;;; $B%F%j%H%*%jHV9f$H(BLISP$B%*%V%8%'%/%H$r4XO"IU$1$k!#(B
(defun set-territory-object (no object)
  (declare (special *territory-lisp-object*)
	   (inline > < ))
    (if *territory-lisp-object*
      (let ((next *territory-lisp-object*))
	(loop  
	 (cond 
	  ;;; next$B$,(B NIL$B$N$H$-(B
	  ((null next)
	   (return nil))

	  ;;; no$B$O(Bnext$B$NHV9f$h$jBg$-$$(B
	  ((> no (territory-object-territory-no next))
	    ;;; $B?7$7$/@8@.$+(B
	    (if (null (territory-object-bigger next))
	     (return (setf (territory-object-bigger next) 
			   (make-territory-object :territory-no no
						 :lisp-object object)))
	      ;;; $B4{$K$"$k(B
	     (setf next (territory-object-bigger next))))

  	  ;;; no$B$O(Bnext$B$NHV9f$h$j>.$5$$(B
	  ((< no (territory-object-territory-no next))
	    ;;; $B?7$7$/@8@.$+(B
	    (if (null (territory-object-smaller next))
	     (return (setf (territory-object-smaller next)
			  (make-territory-object :territory-no no
						 :lisp-object object)))
	   ;;; $B4{$K$"$k(B
	     (setf next (territory-object-smaller next))))

	  ;;; $BB?J,F1$8HV9f(B
	  (t 
	   (if (null (territory-object-lisp-object next))
	      (return
		(setf (territory-object-lisp-object next) object))
		
	      (return nil)))
	)))
      	(setf *territory-lisp-object*  
	      (make-territory-object :territory-no no
				     :lisp-object object)))
	)
    

;;; $B$"$kHV9f$+$i(Blisp-object$B$r5a$a$k!#$J$$;~$O(BNIL
(defun get-lisp-object (no)
  (declare (special *territory-lisp-object*)
	   (inline > <))
  (let ((next *territory-lisp-object*))
    (loop
     (cond
      ;;; next$B$,(BNIL$B$N$H$-(B
      ((null next)
       (return nil))

      ;;; no$B$O(Bnext$B$NHV9f$h$jBg$-$$(B
      ((> no (territory-object-territory-no next))
	;;; bigge$B%*%V%8%'%/%H$,$"$k$+(B
	(if (null (territory-object-bigger next))
	    (return nil)
	    ;;; $B4{$K$"$k(B
	    (setf next (territory-object-bigger next))))

      ;;; no$B$O(Bnext$B$NHV9f$h$j>.$5$$(B
      ((< no (territory-object-territory-no next))
	;;; smaller$B%*%V%8%'%/%H$,$"$k$+(B
	(if (null (territory-object-smaller next))
	     (return nil)
	   ;;; $B4{$K$"$k(B
	   (setf next (territory-object-smaller next))))

	;;; $BB?J,F1$8HV9f(B
	(t 
	  (if (null (territory-object-lisp-object next))
	      (return nil)
	    (return (territory-object-lisp-object next))))
	))))
	    
;;; $B$"$kHV9f$+$i(Blisp-object$B$r%G%j!<%H$9$k!#$J$$;~$O(BNIL
(defun delete-lisp-object (no)
  (declare (special *territory-lisp-object*))
  (let ((next *territory-lisp-object*))
    (loop
     (cond

      ;;; next$B$,(BNIL$B$N$H$-(B
      ((null next)
       (return nil))

      ;;; no$B$O(Bnext$B$NHV9f$h$jBg$-$$(B
      ((> no (territory-object-territory-no next))
	;;; bigge$B%*%V%8%'%/%H$,$"$k$+(B
	(if (null (territory-object-bigger next))
	    (return nil)
	    ;;; $B4{$K$"$k(B
	    (setf next (territory-object-bigger next))))

      ;;; no$B$O(Bnext$B$NHV9f$h$j>.$5$$(B
      ((< no (territory-object-territory-no next))
	;;; smaller$B%*%V%8%'%/%H$,$"$k$+(B
	(if (null (territory-object-smaller next))
	     (return nil)
	   ;;; $B4{$K$"$k(B
	   (setf next (territory-object-smaller next))))

	;;; $BB?J,F1$8HV9f(B
	(t 
	  (if (null (territory-object-lisp-object next))
	      (return nil)
	    (progn
	     (setf (territory-object-lisp-object next) nil)
	     (return T))))
	))))

;(defvar *territory-attributte* nil)

;;; $B%F%j%H%j$N@8@.(B
(defun make-territory (&key (x 0) (y 0) (width 0) (height 0)
			    (parent -1) (visible t) (drawable t)
			    (fence nil) (window-mode nil)
			    (transparent nil))
  (declare (special *ROOT-TERRITORY-NO*)
	   (inline /=))
    (if (and (/= *ROOT-TERRITORY-NO* -1) (= parent -1))
      (setf parent *ROOT-TERRITORY-NO*))

    (if (null parent)
	(setq parent *ROOT-TERRITORY-NO*))

    (if (null visible)
      (setf visible 0)
      (setf visible 1))
    
    (let ((mode 0))
      
      (if (null drawable)
	  (if fence
	      (setf mode #x0001)
	    (setf mode #x0000))
	(if (null window-mode)
	    (setf mode #x0100)    ;;; $B%Z!<%8(B
	  (if transparent
	      (setf mode #x0103)           ;;; $BF)L@%F%j%H%j!<(B
	    (setf mode #x0101)))) 	  ;;; $B%S%e!<%]!<%H%b!<%I(B

      
      ;;; $B%W%m%H%3%k@8@.$HAw=P(B
      (let ((val nil))
	(if (zerop (setf val
			 (yy-protocol-1 x y  width height parent visible mode)))
	    (error "Can not make a TERRITORY!!!"))
	val)))


#|

;;; debug for territory attriburte
     (if (= parent 0)
	 (setf *territory-attribute* nil))


           (let ((val nil))
	     (if (zerop (setf val 
			(yy-protocol-1 x y  width height parent visible mode)))
		 (error "Can not make a TERRITORY!!!")
	       (progn 
		 ;;; Debug
		 (setf *territory-attribute* 
		       (acons val mode *territory-attribute*))
	       val)))
      ))
|#








