;;; -*- Mode: LISP; Syntax: Common-lisp; Package: user; Base: 10 -*-
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.0 90/06/01 by t.kosaka (kosaka@csrl.aoyama.ac.jp)
;;;   version 1.1 90/07/31 by t.kosaka
;;;   update 1.11 90/09/14 by t.kosaka
;;;   version 1.2 90/11/05 by t.kosaka

;;;; YY $B%7%9%F%`$N%m!<%I=g(B
;;; Version 1.0   Corded by t.kosaka 1990-3-13
;;; Update T.kosaka 1990-5-10
;;; Update T.kosaka 1990-6-1
;;; Symbolics Codes contribution of E.Shiota

#+ :EXCL
(setf (sys:gsgc-parameter :generation-spread) 2000)

#-Symbolics
(eval-when (load eval)
(if (not (find-package :yy))
    #+ (and EXCL :PCL)
    (make-package :yy :use '(pcl lisp system))
    
    #+ (and :EXCL (not :PCL))
    (make-package :yy :use '(lisp system))

    #+LUCID
       (make-package :yy :use '(lisp system LUCID-COMMON-LISP))
))
    
#-Symbolics
(in-package :yy)


(proclaim '(optimize (speed 3) (space 0) (safety 0) (compilation-speed 0)))

#+Symbolics
(eval-when (eval load compile)
(DEFPACKAGE YY
  (:SIZE 500)
  (:USE CLOS COMMON-LISP)
  (:shadow
    READ-CHAR PEEK-CHAR UNREAD-CHAR LISTEN READ-LINE CLEAR-INPUT READ-CHAR-NO-HANG
    WRITE-CHAR FRESH-LINE TERPRI WRITE-STRING WRITE-LINE FORCE-OUTPUT FINISH-OUTPUT
    READ-BYTE MAKE-STRING-INPUT-STREAM CLEAR-OUTPUT
    ;;;INPUT-STREAM-P OUTPUT-STREAM-P
    OUTPUT-STREAM-P STREAMP READ
    ;;;MAKE-STRING-OUTPUT-STREAM GET-OUTPUT-STREAM-STRING
    ;; Followings are only symbolics version
    SETF DOCUMENTATION
    )
  (:import-from CLOS SETF DOCUMENTATION)
  (:IMPORT )
  (:EXPORT ))

(in-package :yy)
)

(defvar *YY-VERSION-DATE* "YY Client 1991-03-20 Version1.3(Alpha)")

(defvar *YY-SOURCE-PATH*
;    #-Symbolics "/home/green-hill/csrl/yohta/yy-client/ver1.12/"
    #-Symbolics "/home/green-hill/csrl/kosaka/yy/system/"
;;;             ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^  Edit here 
    #+Symbolics ">ida>yy>")

#+ :LUCID
(change-memory-management :GROWTH-LIMIT 2560 :EXPAND-P T)

;;;  YY  Window Tool Kit features
;(push :YY1.3 *features*)

(defvar *load-mode* :load)

(defvar *define-macro* nil)
(defvar *global-variables* nil)
(defvar *primitive* nil)
(defvar *parts-primitive* nil)
(defvar *territory* nil)
(defvar *text-font* nil)
(defvar *yy-color* nil)
(defvar	*graphic-primitive* nil)
(defvar *window-parts* nil)
(defvar *yy-input-stream* nil)
(defvar *presentation* nil)
(defvar	*yy-stream* nil)
(defvar	*text-output* nil)
(defvar	*x3j13-streams* nil)
(defvar	*server-dependent* nil)
(defvar *yy-image* nil)
(defvar *bitmap* nil)
(defvar	*graphic-method* nil)
(defvar	*graphic-image* nil)
(defvar	*accessry* nil)
(defvar	*active-region* nil)
(defvar	*popup-menu* nil)
(defvar	*prtclif-ohta* nil)
(defvar *yyprtcl-kosaka* nil)
(defvar *default-pop-up-menu-euc* nil)
(defvar *window-method* nil)
(defvar *window-parts-method* nil)
(defvar *bitmap-stream* nil)
(defvar *mouse-cursor* nil)
(defvar *extended-graphics* nil)
(defvar *sample-window* nil)
(defvar *graphic-test* nil)

(defvar *source-sfix* ".lisp")
;(defvar *binary-sfix* ".sbin")
(defparameter *binary-sfix*  #+Lucid  ".sbin"
                             #+Excl   ".fasl"
			     #+Symbolics ".bin")

  
;;; YY$B%7%9%F%`$N<+F0%m!<%I(B
(defun auto-yy-load ()
  (declare (special *yy-source-path*))

  (setf *global-variables* (load-new-file "global-variables" *global-variables*)
        *define-macro* (load-new-file "define-macro" *define-macro*)
        *primitive* (load-new-file "primitive" *primitive*)
	*prtclif-ohta* (load-new-file "prtclif-ohta" *prtclif-ohta*)
	*yyprtcl-kosaka* (load-new-file "yyprtcl-kosaka" *yyprtcl-kosaka*)
	*territory* (load-new-file "territory" *territory*)
	*yy-color* (load-new-file "yy-color" *yy-color*)
	*graphic-primitive* (load-new-file "graphic-primitive" *graphic-primitive*)
	*text-font* (load-new-file "text-font" *text-font*)
	*yy-image* (load-new-file "yy-image" *yy-image*)
	*bitmap* (load-new-file "bitmap" *bitmap*)
	*yy-input-stream* (load-new-file "yy-input-stream" *yy-input-stream*)
	*parts-primitive* (load-new-file "parts-primitive" *parts-primitive*)
	*window-parts* (load-new-file "window-parts" *window-parts*)
	*bitmap-stream* (load-new-file "bitmap-stream" *bitmap-stream*)
	*mouse-cursor* (load-new-file "mouse-cursor" *mouse-cursor*)
	*presentation* (load-new-file "presentation" *presentation*)
	*yy-stream* (load-new-file "yy-stream" *yy-stream*)
	*window-parts-method* (load-new-file "window-parts-method" 
					     *window-parts-method*)
	*window-method* (load-new-file "window-method" *window-method*)
	*text-output* (load-new-file "text-output" *text-output*)
	*graphic-method* (load-new-file "graphic-method" *graphic-method*)
	*x3j13-streams* (load-new-file "x3j13-streams" *x3j13-streams*)
	*graphic-image* (load-new-file "graphic-image" *graphic-image*)
	*active-region* (load-new-file "active-region" *active-region*)
	*accessry* (load-new-file "accessry" *accessry*)
	*popup-menu* (load-new-file "popup-menu" *popup-menu*)
	*default-pop-up-menu-euc* 
	(load-new-file "default-pop-up-menu-euc" *default-pop-up-menu-euc*)
	*extended-graphics* 
	(load-new-file "extended-graphics" *extended-graphics*)
	*server-dependent* (load-new-file "server-dependent" *server-dependent*)
	*sample-window* (load-new-file "sample-window" *sample-window*)
	*graphic-test* (load-new-file "graphic-test" *graphic-test*)
	)

  )

;;; $B%3%s%Q%$%k$9$k$+7hDj$7!"(B
;;; $B%P%$%J%j!<$NJ}$,8E$1$l$P!"%3%s%Q%$%k$9$k(B
;;; $B%P%$%J%j!<$r%m!<%I$9$k;~$O!"(Bsatus$B$,(BNIL
(defun load-new-file (fname satus)
  (let* ((sname (lisp::format nil "~a~a~a" *yy-source-path* fname *source-sfix*))
	 (bname (lisp::format nil "~a~a~a" *yy-source-path* fname *binary-sfix*))
	 (sdata (if (probe-file sname)
		    (file-write-date sname)
		  0))
	 (bdate (if (probe-file bname)
		    (file-write-date bname)
		  0)))
		    

  (if (> bdate sdata)
       (if (null satus)
             (load bname))
    (progn

#+:Symbolics
      (load sname)

      (compile-file sname)
      (load  bname)))
  T))

(defun auto-compile ()
   (let ((file '("global-variables" "define-macro" "primitive" 
		 "prtclif-ohta"  "yyprtcl-kosaka"
		 "text-font" "yy-color" "graphic-primitive" "yy-input-stream"
		  "presentation" "yy-stream" "text-output" 
		  "x3j13-streams" "server-dependent"
		  "bitmap" "yy-image"
		  "graphic-method" "graphic-image" "accessry" "active-region"
		  "popup-menu" "mouse-cursor" "bitmap-stream"
		  "extended-graphics"
		  "window-method" "default-pop-up-menu-euc")))
     (dolist (name file)
	     (compile-file (format nil "~a~a" name *source-sfix*)))
     ))


#-Symbolics
(eval-when (eval load)
(shadow '(READ-CHAR PEEK-CHAR UNREAD-CHAR LISTEN READ-LINE CLEAR-INPUT READ-CHAR-NO-HANG
	  WRITE-CHAR FRESH-LINE TERPRI WRITE-STRING WRITE-LINE FORCE-OUTPUT FINISH-OUTPUT
	  READ-BYTE MAKE-STRING-INPUT-STREAM CLEAR-OUTPUT ;;;INPUT-STREAM-P OUTPUT-STREAM-P
	  OUTPUT-STREAM-P STREAMP READ
	  ;;;  MAKE-STRING-OUTPUT-STREAM GET-OUTPUT-STREAM-STRING
	  ) :yy))

#+:PCL 
(shadow '(defgeneric) :yy)

(auto-yy-load)


;(initialize-yy :x-server-name "noa:0" :server-name "noa"  :responce 20 
	;       :network t)

;(initialize-yy :x-server-name "tirl9:0" :server-name "tirl9"  :responce 20 
	;       :network t)

;(initialize-yy :x-server-name "prophet:0" :server-name "prophet" :newtwork T)
;
;(initialize-yy :x-server-name "daichi:0" :responce 20)
;(initialize-yy :x-server-name "aoyama:0" :responce 20)
;(initialize-yy :x-server-name "prophet:0" :responce 20)
;#-Symbolics
;(initialize-yy :x-server-name "apocripha:0" :responce 20)
;(initialize-yy :x-server-name "133.2.1.91:0" :responce 20)

#+ignore
(yy::initialize-yy :SERVER-NAME "internet|133.2.1.2" :x-server-name "133.2.1.91:0" :responce 20)
#+ignore
(yy::initialize-yy :SERVER-NAME "green-hill"
			 :x-server-name "apocripha:0" :responce 20)

#+ignore				;for use Symbolics only
(yy::reset-yy-internal)









