;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; $B%5!<%P!<0MB8$9$kItJ,$rDj5A(B
;;; server-dependent.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.0 90/06/01 by t.kosaka (kosaka@csrl.aoyama.ac.jp)
;;;   version 1.1 90/07/31 by t.kosaka
;;;   update 1.11 90/09/14 by t.kosaka
;;;   version 1.2 90/11/05 by t.kosaka

;;; $B%5!<%P!<0MB8$9$kItJ,$rDj5A(B
;;; 2/27 1990 $B8E:d(B
;;; Version 1.0   Coded by t.kosaka 1990-2-27

(in-package :yy )

(defvar *TOP-COLOR-TABEL* nil)
(defvar *DEMO-WINDOW1* nil)
(defvar *DEMO-WINDOW2* nil)
(defvar *DEMO-WINDOW3* nil)

;;; YY$B%5!<%P!<$H$N@\B3$r<($99=B$BN(B
(defvar *SERVER-COMMUNICATION* (make-yy-server-connection))

;(initial-yy-internal :x-server-name "aoyama:0" )

;;;YY$B$N%$%K%7%c%i%$%:4X?t$N%$%s%?!<%J%k(B
(defun initialize-yy (&key (version 1)
				 (release 1)
				 (responce 20)
				 (ntime 10)
				 (x-server-name "")
				 (server-name "")
				 (x 0)
				 (y 0)
				 (width 900)
				 (height 650)
				 (network nil)
				 (domain-no 0))
  (declare (special *SERVER-COMMUNICATION* *YY-MAGIC-NO* 
		    *DEFAULT-FONT* *territory-lisp-object*
		    *ROOT-TERRITORY-NO* *ROOT-WINDOW* 
		    *LISP-LISTENER* *MAX-RECEIPT-TIME* 
		    *RECEIPT-TIME* *max-receive-size* *max-message-size* 
		    *receive* *send-receive* *YY-VERSION-DATE* 
		    *GET-POSITION-MOUSE-CURSOR* 
		    *pop-up-menu-window* *icon-pop-up-menu-window*)
	   (function MAKE-TIME-TITLE-WINDOW () T))

  ;;; $B%P!<%8%g%s$N=PNO(B
  (format t "~a ~%" *YY-VERSION-DATE*)
  (setf *top-color-tabel* NIL)

  ;;; $B$b$78E$$$b$N$,@\B3$5$l$F$$$?$i!"%/%m!<%:(B
  ;(c_close)

  (setf  *SYSTEM-MOUSE-STATE* (make-mouse-state)
	 *SYSTEM-INTERRUPT-EVENT* (make-instance 'yy-interrupt-event))
  
  ;;; $BF~NO%W%m%;%9$N>CLG(B
;  (if *listener-process*
;      (killed-process *listener-process*))

  (setf *ROOT-TERRITORY-NO* -1
	*ROOT-WINDOW* nil
	*LISP-LISTENER* nil
	*territory-lisp-object* nil)

  ;;; YY$B%5!<%P!<$H$N@\B3(B
  (if network
      (setf *max-message-size* (c_setup_server 1 
				    (make-array-string server-name) domain-no))
    (setf *max-message-size* (c_setup_server 0 
				  (make-array-string server-name) domain-no)))

  (setf *max-receive-size* (- *max-message-size* 2))

  ;;; $B%Q%1%C%H%P%C%U%!!<$r:n$k(B
 (setf *send* (list (make-packet))
        *receive* (list (make-packet  *max-receive-size*))
	*send-receive* (list (make-packet *max-receive-size*)))
  

  ;;; X$B%5!<%P!<$H$N@\B3(B
  (unless
      (yy-protocol-0 *yy-magic-no* version release responce ntime x-server-name
		 *SERVER-COMMUNICATION*)
    (error "Set Up connection"))

  ;;; $B%G%U%)%k%H%U%)%s%H$N%m!<%I(B a14
  (setf *DEFAULT-FONT* (load-font :font-name "a14"))

  ;;; $B>.$5$$%U%)%s%H$N%m!<%I(B
 ; (setf *SMALL-FONT* (load-font :font-name "5x8"))

  ;;; $B%+%i!<%F!<%V%k$N=i4|2=(B
  (setf *all-colors* nil)

  ;;; $B9u$N%+%i!<$r:n$k(B
  (setf *BLACK-COLOR* (make-color :red 0 :green 0 :blue 0))

  ;;; $BGr$N%+%i!<$r:n$k(B
  (setf  *WHITE-COLOR* (make-color :red 65535 :green 65535 :blue 65535))

  ;;; $BF)L@?'$r:n$k(B
#+:YY1.3
  (setf *transparent* (make-color :red -1 :green -1 :blue -1))
#-YY1.3
  (setf *transparent* (make-color :red 65535 :green 65535 :blue 65535))
    

  ;;; $B%k!<%H%F%j%H%j$r:n$k(B
  (setf *ROOT-TERRITORY-NO* (make-territory :x x :y y :width width 
					    :height height
					    :parent 0 :drawable nil))

  ;;; $B%k!<%H%&%#%s%I%&$r:n$k(B
  (setf *ROOT-WINDOW* (make-window-instance 'viewport-window-stream
		       :window-region (make-region :width width
						   :height height)
		       :border-visible nil
		       :title-bar nil :horizontal-scroll-bar nil
		       :vertical-scroll-bar nil
		       :coordinate-area nil))

  ;;; $B%G%U%)%k%H$N%^%&%9%+!<%=%k$r:n$k(B
;  (change-mouse-cursor (make-default-mosue-cursor))

  ;;; get position$BMQ%^%&%9%+!<%=%k$r:n$k(B
;  (setf *GET-POSITION-MOUSE-CURSOR* (make-get-position-mouse-cursor))

  ;;; $B%&%#%s%I%&MQ$N%]%C%W%"%C%W%a%K%e$r:n$k(B
 (setf *pop-up-menu-window* (default-window-pop-up-menu))

 ;;; $B%^%&%9%a%=%C%I$rL5$7$9$k(B
 (disnable-event *pop-up-menu-window* *mouse-right-1*)

 (set-window-border-method *pop-up-menu-window* nil 
			   :event-mask *mouse-right-1*)

 (setf *icon-pop-up-menu-window* (default-icon-pop-up-menu))

 (disnable-event *icon-pop-up-menu-window* *mouse-right-1*)

 (set-window-border-method *icon-pop-up-menu-window* nil 
			   :event-mask *mouse-right-1*)

  (setf *prompt-window* (make-window-instance 'viewport-window-stream
			 :window-region (make-region :left 0 :bottom 
			     (- height (font-kanji-height *default-font*) 5)
			     :width width  
			     :height (+ (font-kanji-height *default-font*) 3))
			  :title-bar nil
			  :vertical-scroll-bar nil
			  :horizontal-scroll-bar nil
			  :coordinate-area nil))

  (setq *lisp-listener*
    (make-window-instance 'lisp-listener
			:window-region (make-region :left 10 :bottom 10
						    :width 400 :height 250)
			:title-bar-string "Lisp Listener"
			:title-bar 'switch-title-bar
			:window-frame 'lisp-listener-frame))

  (setq *demo-window1* 
    (make-time-title-window))

#|
  (setq *demo-window2*
    (make-window-instance 'switch-window :window-region 
			  (make-region :left 250 :bottom 50 :width 600 
				       :height 300)
			  :title-bar 'switch-title-bar
			  :window-frame 'switch-frame
			  :transform-matrix (make-transform-matrix)
			  :title-bar-string "Demo Window 2"))
|#

  (setq *demo-window3* 
    (make-window-instance 'viewport-window-stream
			  :title-bar 'switch-title-bar
			  :title-bar-string "Demo Window 3"
			  :vertical-scroll-bar 'switch-vertical-scroll-bar
			  :horizontal-scroll-bar 'switch-horizontal-scroll-bar
			  :window-region (make-region
					  :left 65 :bottom 290
					  :width 400 :height 300)))


  ;;;$BF~NO%W%m%;%9$N@8@.(B
;   (event-dispatch)
  (setf *event-process* (run-process 'event-dispatch))
  (setf *listener-process*  (run-process 'yy-lisp-listener *lisp-listener*))
  (format t "; If you want to play graphics sample ~%; try (make-test-window)")
  )


;;; $B%?%$%H%k%P!<$rDj5A(B
(defclass switch-title-bar (title-bar)
  ((switch :initform nil :accessor switch)))

;;; $B%9%$%C%A%/%i%9(B
(defclass switch (event-drawable-piece)
  ((switch-stream :initform nil :accessor switch-stream
  				  :initarg :switch-stream)
   (current-state :initform nil :accessor current-state)
   (switch-value  :initform nil :accessor switch-value
   				  :initarg :switch-value)))
(defvar *image-yy* 
    (make-image-from-array (make-array 
			    '(12 2)
			    :element-type '(unsigned-byte 8)
			    :initial-contents 
			    '((#x0 #x0) (#x7F #xFE) (#x4 #x3E)
			      (#x4E #x3E) (#X64 #x60) (#x70 #x32)
			      (#x71 #X86) (#x79 #XCE) (#x7B #xCE)
			      (#x73 #x9E) (#X61 #xE)  (#x0 #x0)))))


;;; $B%?%$%H%k%P!<$N:FI=<(%a%=%C%I(B after$B%a%=%C%I(B
(defmethod redisplay-title-bar :after ((title switch-title-bar))
  (declare (special *mouse-button-down-1* *default-font* *image-yy*))
  (if (null (switch title))
    (let ((ob (make-instance 'switch
    		     :object-parent title
		     :draw-piece-visible T
    		     :switch-stream (object-parent title)
    			 :bottom 1 :left (- (region-width title) 18)
			 :width 18 :height (- (region-height title) 2))))
      (with-event-object (ob)
		 (setf (button1-method ob) 'icon-exec
		       (get 'icon-exec 'single-process) t
	    	   (slot-value ob 'event-mask) *mouse-button-down-1*))

      (setf (switch title) ob)
      (draw-piece-put-image ob 1 0 *image-yy*))

    (let ((region (switch title)))
      (with-real-object (region)
			(setf (region-left region) 
			  (- (region-width title) 18)
			  (region-width region) 18))
			  
      (draw-piece-put-image region 1 0 *image-yy*))
    ))
		

;;; $B%"%$%3%s2=(B
(defmethod icon-exec ((ob switch) state)
  (declare (ignore state))
  (shrink (switch-stream ob)))


;;; $B%j%9%W%j%9%J!<MQ$N%U%l!<%`(B
(defclass lisp-listener-frame (window-frame) 
  ((listener-width :accessor listener-width :initform 0)
   (listener-height :accessor listener-height :initform 0)))

(defmethod set-frame-region :before ((frame lisp-listener-frame) new-region)
  ;;; $B>o$K(B15$B%I%C%H>.$5$$(B
  (when (and (> (region-width new-region) (listener-width frame))
	     (> (region-height new-region) (listener-height frame)))

	  (incf (region-left new-region) 15)
	  (incf (region-bottom new-region) 15)
	  (decf (region-right new-region) 15)
	  (decf (region-top  new-region) 15)

	  (setf (listener-width frame) (region-width new-region)
		(listener-height frame) (region-height new-region)))
  )

;;; $B%j%9%W%j%J!<%&%#%s%I%&(B
(defclass lisp-listener (page-window-stream) ())

;;; $B:FI=<((B
(defmethod redisplay-window :after ((window lisp-listener))
  (declare (special *SCROLL-BAR-BELT* *default-font* *black-color*
                     *white-color*))
  (let* ((region (window-frame window))
	 (width (region-width region))
	 (height (region-height region)))
    (draw-piece-color window *black-color*)
    (with-slots 
     (left bottom right top) region
     (draw-piece-filled-rectangle window left (- bottom 10) width
				  (+ height 20) :color *white-color*)
     (draw-piece-filled-rectangle window (- left 10) bottom
				  (+ width 20) height :color *white-color*)

     (draw-piece-filled-circle window left bottom 10 *white-color*)
     (draw-piece-filled-circle window left top 10 *white-color*)
     (draw-piece-filled-circle window right top 10 *white-color*)
     (draw-piece-filled-circle window right bottom 10 *white-color*))))
     
			       

#+Symbolics
(defun reset-yy-internal ()
  (progn (close yy::*fd2* :abort t)
	 (close yy::*fd1* :abort t)
	 ;(KILLED-PROCESS *event-process*)
	 ))

;;; $BJ8;zNs$r%"%l!<$K$9$k!#(B
#-Symbolics
(defun make-array-string (string)
  (let* ((len (+ (real-length string) 1))
	 (array (make-array len :element-type '(unsigned-byte 8)))
	 (code 0)
	 (ii 0))
	 
    (dotimes (i (length string))
      (setf code (char-code (char string i)))
      (if (> code #xA1)
	  (setf (aref array ii) (ash code -8)
		(aref array (incf ii)) (logand #xFF code))
	(setf (aref array ii) code))
      (incf ii))
    (setf (aref array ii) 0)
    array))

#+Symbolics
(defun make-array-string (string)
  string)