;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; ɥΥץ
;;; This file is EUC code.
;;; sample-window.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;	      All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.3 91/02/26 by t.kosaka
;;;

;;;  ʲΥ᥽åɤؿ饹ϡɥΩ夬äƤ

(in-package :yy)

;;; -------------- ȥС򥫥ޥ ----------

;;; ȥС˸ߤλ֤ɽ륿ȥС
(defclass time-title-bar (switch-title-bar)
  ((time-string :initform "" :accessor time-string)
  (start-x :initform 0 :accessor start-x)))

 ;;; ɥؿ
(defun make-time-title-window ()
  (let ((stream (make-window-instance 'viewport-window-stream
				:translate-coordinate :left-bottom
				:window-region 
				(make-region :left 520 :bottom 400
					     :width 300 :height 200)
				:title-bar 'time-title-bar)))
	;;; ץεư
	(run-process 'one-min-display stream)
	
	stream))
    
;;; ɽ᥽åɤ
(defmethod redisplay-title-bar :after ((title time-title-bar))
  (write-time-titiel title))

;;; ʬɽؿ
(defun one-min-display (window)
  (loop
   (write-time-titiel (window-title-bar window))
   (sleep 60)))

;;; ֤ɽ
(defun write-time-titiel (title)
  (declare (special *BLACK-COLOR* *default-font* *WHITE-COLOR*))
  (multiple-value-bind (b f j n tu) (get-decoded-time)
    (declare (ignore b))
    (let* ((time (format nil "~a~a~a~aʬ" tu n j f))
	   (len (font-string-length *default-font* time))
	   (width (region-width title)))

      ;;; λ֤ä
      (draw-piece-string title (start-x title)
			 (font-kanji-base-line *default-font*)
			 (time-string title) :color *BLACK-COLOR*
			 :font *default-font*)

      (draw-piece-string title (- width len 20)
			 (font-kanji-base-line *default-font*)
			 time :color *WHITE-COLOR*
			 :font *default-font*)
      (setf (time-string title) time
	    (start-x title) (- width len 20)))
    ))

;;; ----------- ɥ乽Ǥ򥫥ޥˡ--------
;;;             ܥ᥽åɤ⤿                    

;;; åդΥɥ륹åμϰʲ˼̤
;;; ȥС˥󲽤륹å
;;; С˥եåȤ򣰤ˤ륹å
;;; ɥʥɤǤϤʤˤ˽Ľ񤭡񤭤򥹥å
;;; ȥޥȥå򥹥å롣

#| server-dependent.lisp ǴѤ
;;; ȥС
(defclass switch-title-bar (title-bar)
  ((switch :initform nil :accessor switch)))

;;; å饹
(defclass switch (event-drawable-piece)
  ((switch-stream :initform nil :accessor switch-stream
  				  :initarg :switch-stream)
   (current-state :initform nil :accessor current-state)
   (switch-value  :initform nil :accessor switch-value
   				  :initarg :switch-value)))

;;; ȥСκɽ᥽å after᥽å
(defmethod redisplay-title-bar :after ((title switch-title-bar))
  (declare (special *mouse-button-down-1* *default-font* *image-yy*))
  (if (null (switch title))
    (let ((ob (make-instance 'switch
    		     :object-parent title
		     :draw-piece-visible T
    		     :switch-stream (object-parent title)
    			 :bottom 1 :left (- (region-width title) 17)
			 :width 17 :height (- (region-height title) 2))))
      (with-event-object (ob)
		 (setf (button1-method ob) 'icon-exec
		       (get 'icon-exec 'single-process) t
	    	   (slot-value ob 'event-mask) *mouse-button-down-1*))

      (setf (switch title) ob)
      (draw-piece-put-image ob 1 0 *image-yy*))

    (let ((region (switch title)))
      (with-real-object (region)
			(setf (region-left region) 
			  (- (region-width title) 20)))
      (draw-piece-put-image region 1 0 *image-yy*)
		)))

;;; 
(defmethod icon-exec ((ob switch) state)
  (declare (ignore state))
  (shrink (switch-stream ob)))

|#

;;; åդνĥС
(defclass switch-vertical-scroll-bar (vertical-scroll-bar)
  ((switch-0 :initform nil :initarg :switch-0 :accessor switch-0)
   (switch-1 :initform nil :initarg :switch-1 :accessor switch-1)))

;;; åդνĥСɽ
(defmethod redisplay-vertical-scroll :after 
  ((vscroll switch-vertical-scroll-bar))
   ;;; å-> make-instanceafter᥽åɤǤϽʤ
   ;;; β줿饹饤󥹥󥹤뤫
  (if (null (switch-0 vscroll))
      (let ((ob (make-instance 'switch :object-parent vscroll
			       :draw-piece-visible T
			       :width (region-width vscroll)
			       :height (region-width vscroll)
			       :switch-stream (object-parent vscroll))))
	(setf (switch-0 vscroll) ob)
	(with-event-object (ob)
		   (setf (button1-method ob) 'offset-top
			 (get 'left-top 'single-process) t
			 (slot-value ob 'event-mask) *mouse-button-down-1*))
	(draw-piece-rectangle ob 0 0 (region-width ob) (region-height ob))
	(with-accessors
	 ((w region-width) (h region-height)) ob
	 (draw-piece-polygon ob  (round (/ (- w 4) 2)) 2
			     2 (- h 2) (- w 2) (- h 2)))))
  
  (if (null (switch-1 vscroll))					      
      (let ((ob (make-instance 'switch :object-parent vscroll
			       :width (region-width vscroll)
			       :draw-piece-visible T
			       :bottom (- (region-height vscroll)
					  (region-width vscroll))
			       :height (region-width vscroll)  
			       :switch-stream (object-parent vscroll))))
	(setf (switch-1 vscroll) ob)
	(with-event-object 
	 (ob)
	 (setf (button1-method ob) 'offset-bottom
	       (get 'offset-bottom 'signle-process) t
	       (slot-value ob 'event-mask) *mouse-button-down-1*))
	(draw-piece-rectangle ob 0 0 (region-width ob) (region-height ob))
	(with-accessors 
	 ((w region-width) (h region-height)) ob
	 (draw-piece-polygon ob 2 2 (- w 2) 2
			     (round (/ (- w 4) 2)) (- h 2))))
    (let ((region (switch-1 vscroll)))
      (with-real-object (region)
	(setf (region-bottom region) (- (region-height vscroll)
					(region-width vscroll))))))
  )

;;; եåȤѹ¹ԥ᥽å
(defmethod offset-top ((ob switch) state)
  (declare (ignore state))
  (setf (world-y-offset (switch-stream ob))
	(- (world-y-start (switch-stream ob)))))

(defmethod offset-bottom ((ob switch) state)
  (declare (ignore state))
  (let* ((stream (switch-stream ob))
	 (sa (- (region-height stream)
		(region-height (window-frame stream)))))
    (setf (world-y-offset stream) sa)))


;;; åդβС
(defclass switch-horizontal-scroll-bar (horizontal-scroll-bar)
  ((switch-0 :initform nil :initarg :switch-0 :accessor switch-0)
   (switch-1 :initform nil :initarg :switch-1 :accessor switch-1)))
		
;;; åդβСɽ
(defmethod redisplay-horizontal-scroll :after
  ((hscroll switch-horizontal-scroll-bar))
   ;;; å-> make-instanceafter᥽åɤǤϽʤ
   ;;; β줿饹饤󥹥󥹤뤫
  (if (null (switch-0 hscroll))
      (let ((ob (make-instance 'switch :object-parent hscroll
			       :draw-piece-visible T
			       :right (region-height hscroll)
			       :top (region-height hscroll)
			       :switch-stream (object-parent hscroll))))
	(setf (switch-0 hscroll) ob)
	(with-event-object
	 (ob)
	 (setf (button1-method ob) 'offset-left
	       (get 'offset-left 'single-process) t
	       (slot-value ob 'event-mask) *mouse-button-down-1*))
	(draw-piece-rectangle ob 0 0 (region-width ob) (region-height ob))
	(with-accessors ((w region-width) (h region-height))
			ob
	 (draw-piece-polygon ob 2 (round (/ (- h 4) 2))
			     (- w 2) 2 (- w 2) (- h 2)))))

   (if (null (switch-1 hscroll))					      
       (let ((ob (make-instance 'switch :object-parent hscroll
				:draw-piece-visible T
				:left (- (region-width hscroll)
					 (region-height hscroll))
				:right (region-width hscroll)
				:top (region-height hscroll) 
				:switch-stream (object-parent hscroll))))
	 (setf (switch-1 hscroll) ob)
	 (with-event-object 
	  (ob)
	  (setf (button1-method ob) 'offset-right
		(get 'offset-right 'single-process) t
		(slot-value ob 'event-mask) *mouse-button-down-1*))
	 (draw-piece-rectangle ob 0 0 (region-width ob) (region-height ob))
	 (with-accessors ((w region-width) (h region-height))
			 ob
			 (draw-piece-polygon ob 2 2 2 (- h 2)
			      (- w 2) (round (/ (- h 4) 2)))))
     (let ((region (switch-1 hscroll)))
       (with-real-object 
	(region)
	(setf (region-left region) (- (region-width hscroll)
				  (region-height hscroll))))))
   )

;;; եåȤѹ¹ԥ᥽å
(defmethod offset-left ((ob switch) state)
   (declare (ignore state))
   (setf (world-x-offset (switch-stream ob))
	 (- (world-x-start (switch-stream ob)))))

(defmethod offset-right ((ob switch) state)
  (declare (ignore state))
  (let* ((stream (switch-stream ob))
	 (sa (- (region-width stream)
		(region-width (window-frame stream)))))
    (setf (world-x-offset stream) sa)))
		
