/* File is prtclif.c */
/**
*** Copyright (c) 1990  Aoyama Gakuin University
***
***            All Right Reserved
***
*** Permission to use, copy, modify, and distribute this software
*** and its documentation for any purpose and without fee is hereby granted,
*** provided that the above copyright notice appear in all copies and that
*** both that copyright notice and this permission notice appear in
*** supporting documentation, and that the name of Aoyama Gakuin
*** not be used in advertising or publicity pertaining to distribution of
*** the software without specific, written prior permission.
***
*** This software is made available AS IS, and Aoyama Gakuin make no
*** warranty about the software, its performance or its conformity to
*** any specification.
***
*** Any person obtaining a copy of this software is requested to send
*** their name and post office or electronic mail address to:
***    YY Coordinator
***    CSRL, Information Science Research Center
***    Aoyama Gakuin University
***    4-4-25 Shibuya, Shibuya-ku Tokyo, JAPAN 150
***    (yy-coordinator@csrl.aoyama.ac.jp)
***

*** Written By Yukio Ohta 1990.03.02
***      under supervision of Masayuki Ida
***
*** change log
*** Version 1.21 Add close function   By T.kosaka
**/


#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <netinet/in.h>
#include <netdb.h>

#define YYPROTO_UNIX_PORT               "/tmp/.YY."
#define YYPROTO_INET_PORT               6750
#define YYMAGIC                         14876


int fd1 = NULL;
int fd2 = NULL;

struct yy_message {
	unsigned int data;
	};

/*
	c_init
	$B=i4|2=(B
*/
c_setup_server(network,hostname,dnumber)
int network;
unsigned char *hostname;
int dnumber;
{
	int data;

	/* $B%A%'%C%/(B $B%M%C%H%o!<%/(B */
	if( network ) {
		/* $B%M%C%H%o!<%/(B */
		fd1 = get_inet_domain(hostname, dnumber);
	}
	else {
		fd1 = get_unix_domain(dnumber);
	}

	data = YYMAGIC;
	/* $B%^%8%C%/HV9fAw?.(B */
	write(fd1,&data,4);

	/* $B%Q%1%C%H%5%$%:(B $BAw?.(B */
	data = 256;
	write(fd1,&data,4);

	/* $B%^%8%C%/HV9f<u?.(B */
	read(fd1,&data,4);

	/* $B%A%'%C%/(B */
	if( data != YYMAGIC ){
		close(fd1);
		return(0);
	}
	dnumber++;
	
	/* $B%Q%1%C%H%5%$%:(B $B<u?.(B */
	read(fd1,&data,4);

	if(network) {
		fd2 = get_inet_domain(hostname, dnumber);
	}
	else {
		fd2 = get_unix_domain(dnumber);
	}
	return(data);
}

/* $B%3%M%/%7%g%s(B */
int get_unix_domain(no)
        int no;
{
        int sock;
        struct sockaddr_un addr;

        bzero((char *)&addr, sizeof(addr));
        addr.sun_family = PF_UNIX;
        sprintf(addr.sun_path, "%s%d", YYPROTO_UNIX_PORT, no);
        if ((sock = socket(PF_UNIX, SOCK_STREAM, 0)) < 0) {
                perror("socket");
                return -1;
        }
        if (connect(sock, &addr, sizeof(addr)) < 0) {
                perror("connect");
                return -1;
        }
        fprintf(stderr, "Connect on %d/INET\n", sock);
        return sock;
}

int get_inet_domain(host, no)
        char *host;
        int no;
{
        int sock;
        struct sockaddr_in addr;
        struct hostent *hp;
        bzero((char *)&addr, sizeof(addr));
        if ((hp = gethostbyname(host)) == (struct hostent *)NULL) {
                fprintf(stderr, "Unknown host %s\n", host);
                return -1;
        }
        addr.sin_family = hp->h_addrtype;
        bcopy(*hp->h_addr_list, &addr.sin_addr, hp->h_length);
        addr.sin_port = htons(YYPROTO_INET_PORT+no);
        if ((sock = socket(PF_INET, SOCK_STREAM, 0)) < 0) {
                perror("socket");
                return -1;
        }
        if (connect(sock, &addr, sizeof(addr)) < 0) {
                perror("connect");
                return -1;
        }
        fprintf(stderr, "Connect on %d/INET\n", sock);
        return sock;
}



/*
	c_write
	$B=q$-9~$_(B
	pack = $B%Q%1%C%H(B
	lng  = $B%Q%1%C%HD9(B
*/
c_write_internal (pack, lng)
unsigned char *pack;
long int  lng;
{
        int re,wr,ex,nfd,temp,bytes,retv,start;

        nfd = fd1 + 1;
	temp = 1 << fd1;
	bytes = sizeof(struct yy_message) * lng;
	start = 0;

	for (; ; ) {

		wr = temp;
		re = ex = 0;
		select(nfd,&re,&wr,&ex,(struct timeval *)&ex); 
		if ( wr & temp ) {
			if ((retv = send(fd1,(struct yy_message *)pack + start,
				 bytes,0)) < 0) {
			}
			else {
				if( retv != bytes ) {
					start = retv / 4;
					bytes = bytes - retv;
				} 
				else {
					break;
				}
			}
		}
/* 	write(fd1, (struct yy_message *)pack, sizeof(struct yy_message) * lng); */

	}
}

/*
	c_write-read
	$B=q$-9~$_$HFI$_9~$_(B
	pack = $B%Q%1%C%H(B
	lng  = $B%Q%1%C%HD9(B
*/

/*
	c_read1
	$BFI$_9~$_(B
	retpack = $BLa$j%Q%1%C%H(B
	retlng  = $BLa$j%Q%1%C%HD9(B
*/
c_read1_internal(retpack, retlng)
unsigned char *retpack;
long int  retlng;
{
	read(fd1, (struct yy_message *)retpack,
		  sizeof(struct yy_message) * retlng);
}

/*
	c_read2
	$BFI$_9~$_(B
	retpack = $BLa$j%Q%1%C%H(B
	retlng  = $BLa$j%Q%1%C%HD9(B
*/
c_read2 (retpack, retlng)
unsigned char *retpack;
long int  retlng;
{
	int ret;

	ret = read(fd2, (struct yy_message *)retpack,
		  sizeof(struct yy_message) * retlng);
	
}

/*
	c_access
	struct yy_message $B$N(B no$BHVL\$NMWAG$r<h$j=P$7JV5Q$9$k(B
	retpack = $B%Q%1%C%H(B
	no      = $B%Q%1%C%HHV9f(B
*/

int c_access (retpack,no)
unsigned char *retpack;
long int no;
{
	struct yy_message *yy_mes;
	
	yy_mes = (struct yy_message *)retpack;
	return((int)yy_mes[no].data);
}

c_store (pack, no, new)
unsigned char *pack;
unsigned int  no, new;
{
	struct yy_message *yy_mes;

	yy_mes = (struct yy_message *)pack;
	yy_mes[no].data = new;
}

c_store2 (pack, no, new)
unsigned char *pack;
int  no, new;
{
	struct yy_message *yy_mes;

	yy_mes = (struct yy_message *)pack;
	yy_mes[no].data = new;
}

c_store_string(pack,no,data,start,length)
unsigned char *pack,*data;
int no,start,length;
{
	struct yy_message *yy_mes;
	yy_mes = (struct yy_message *)pack;

/* 	strncpy((char *)&yy_mes[no].data,data + start,length); */
	byte_copy((unsigned char *)&yy_mes[no].data,data + start,length);

	return(length);
}

/* This is for image */
c_store_vector(pack,no,data,start,length)
unsigned char *pack,*data;
int no,start,length;
{
	struct yy_message *yy_mes;
	unsigned int *image;
	yy_mes = (struct yy_message *)pack;

	byte_copy((unsigned char *)&yy_mes[no].data,data + start,length);

	return(length);
}

byte_copy(data1,data2,len)
unsigned char *data1,*data2;
int len;
{
	while(len) {
	    *data1++ = *data2++;
            len--;
    }
}

c_store_string_ics(pack,no,data,start,length)
unsigned char *pack,*data;
int no,start,length;
{
	struct yy_message *yy_mes;
	
	yy_mes = (struct yy_message *)pack;
	
	return(strncpy_ics((char *)&yy_mes[no].data,data + start,length));
}

strncpy_ics(data1,data2,len)
unsigned char *data1,*data2;
int len;
{
	int i;
	i = 0;
	while(len) {
		if( *data2 ) {
/* printf("%x\n",*data2); */
			*data1++ = *data2;
			len--;
		}
		data2++;
		i++;
	}
	return(i);
}
			

debug_packet(pack,ret)
struct yy_message *pack;
int ret;
{
	int i;

	for( i = 0 ; i < ret ; i++) {
		printf("%d     %d\n",i,pack[i].data);
	}
}

/*
  prtclif.c
  31.Jul.90 $B?75,(B
*/
c_select2()
{
        int re,wr,ex,nfd;

        nfd = fd2 + 1;
        re = 1 << fd2;

        wr = ex = 0;
        select(nfd,&re,&wr,&ex,(struct timeval *)&ex); 
/*	select(nfd,&re,&wr,&ex,NULL); */

        if(re & 1 << fd2)
        {
                return(1);
        }
return(0);
}

/* c_close */
c_close ()
{
   if( fd1 )
   {
	   close(fd1);
	   fd1 = 0;
   }

   if( fd2 )
   {
	   close(fd2);
	   fd2 = 0;
   }
}
	








