;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; prtclif-ohta.lisp
;;; Foreign function interface and Process controlers.
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.0 90/06/01 by t.kosaka (kosaka@csrl.aoyama.ac.jp)
;;;   version 1.1 90/07/31 by t.kosaka
;;;   update 1.11 90/09/14 by t.kosaka
;;;   version 1.2 90/11/05 by t.kosaka

;;; Written By Yukio Ohta 1990.03.01
;;;      under supervision of Masayuki Ida
;;;
;;; change log
;;; 3/30 '90 T.kosaka DEFFOREGIN change ..
;;; 5/10 '90 T.kosaka Kill-process added ..
;;; 10/31'90 Contribution of E.Shiota
;;; 	     Run-process,

(in-package 'yy)

;;; *STACK-SIZE*
;;; $B%9%?%C%/%5%$%:(B
(DEFCONSTANT *STACK-SIZE* 5000) ; 20Kbyte

;;; *WHOSTATE*
;;; WHOSTATE
(DEFCONSTANT *WHOSTATE* "Wait Forever")

;;; RUN-PROCESS
;;; $B%W%m%;%9$r@8@.$7!"<B9T$9$k(B
;;; ARGS. FUNCTION	: $B4X?tL>(B (SYMBOL)
;;;	  ARGS		: FUNCTION$B$N(BARGUMENTS
;;; VALS. FUNCTION-RESULT
(DEFUN RUN-PROCESS (FUNCTION &REST ARGS)
  #+:LUCID
  (lucid::MAKE-PROCESS :NAME (STRING FUNCTION)
		:FUNCTION FUNCTION
		:ARGS ARGS
		:STACK-SIZE *STACK-SIZE*
;		:WAIT-FUNCTION
;		:WAIT-ARGS
		)
  #+:EXCL
  (apply #'MP:PROCESS-RUN-FUNCTION (STRING FUNCTION) FUNCTION ARGS)
  #+symbolics
  (apply 'process:PROCESS-RUN-FUNCTION
	 (STRING FUNCTION) FUNCTION args)
  #-(OR :LUCID :EXCL symbolics)
  (ERROR "RUN-PROCESS: Sorry. Your LISP implementation is not supported.")
  )

;;; WAIT-PROCESS
;;; $B$"$k>r7o$,@.N)$9$k$^$G%W%m%;%9$N<B9T$rDd;_$9$k(B
;;; ARGS. FUNCTION	: $B>r7o4X?t(B
;;;	  ARGS		: FUNCTION$B$N0z$-?t(B
;;; VALS. non-NIL
;;;  update 2.Nov.90 added apply
;;;  update 3.Nov.90 added apply
(DEFUN WAIT-PROCESS (FUNCTION &REST ARGS)
  #+:LUCID
  ;; added apply 3.Nov.90 yohta
  (apply #'lucid::PROCESS-WAIT *WHOSTATE* FUNCTION ARGS)
  #+:EXCL
  ;; added apply 3.Nov.90 yohta
  (apply #'MP:PROCESS-WAIT *WHOSTATE* FUNCTION ARGS)
  #+symbolics
  (apply 'process:process-wait *WHOSTATE* FUNCTION ARGS)
  #-(OR :LUCID :EXCL symbolics)
  (ERROR "WAIT-PROCESS: Sorry. Your LISP implementation is not supported.")
  )

;;; KILLED-PROCESS
;;; $B%W%m%;%9$r>CLG$5$;$k(B
;;; ARGS. PROCESS      : $B%W%m%;%9(B
;;; VALS. non-NIL
(DEFUN KILLED-PROCESS (PROCESS)
  #+:LUCID
  (lucid::kill-process process)
  #+:EXCL
  (mp:process-kill process)
  #+symbolics
  (process:process-kill process)
)

;;; 
;;; FOREIGN FUNCTION INTERFACE
;;;

;;; LOAD-FOREIGN
;;; ARGS. FILES		: STRING OR A-LIST-OF-STRINGS
;;;	  LIBRARIES	: STRING OR A-LIST-OF-STRINGS
;;; $BCm0U!*(B
;;; (1) Math. library is "m" in Allegro Common Lisp,
;;;     but the library is "-lm" in Lucid Common Lisp.
(DEFUN LOAD-FOREIGN (FILES &rest LIBRARIES)
  #+:LUCID
  (IF LIBRARIES
      (lucid::LOAD-FOREIGN-FILES FILES (set-l LIBRARIES))
    (lucid::LOAD-FOREIGN-FILES FILES))
  #+:EXCL
  (IF LIBRARIES
      (LOAD FILES
	    :SYSTEM-LIBRARIES LIBRARIES)
      (LOAD (IF (CONSP FILES) (CAR FILES) FILES)
	    :FOREIGN-FILES (IF (CONSP FILES) (CDR FILES))))
  #-(OR :LUCID :EXCL)
  (ERROR "LOAD-FOREIGN: Sorry. Your LISP implementation is not supported.")
  )

;;; Set -l to sting for LUCID 
(defun set-l (list)
  (let ((ret nil))
    (dotimes (i (length list))
	   (push (format nil "-l~a" (nth i list)) ret))
    ret))

#|
;;; DEFOREIGN
;;; 
;;; $BCm0U!*(B
;;; (1) RETURN-TYPE $B$K$D$$$F@09g$,$H$l$F$$$k$+L$3NG'$G$9(B
;;; <Lucid CL>
;;;  Promitive Data Types (Primitive foreign type <==> Lisp type)
;;;   :character			character
;;;   :signed-8bit			fixnum
;;;   :unsigned-8bit			fixnum
;;;   :signed-16bit			fixnum
;;;   :unsigned-16nit			fixnum
;;;   :signed-32bit			integer
;;;   :unsigned-32bit			integer
;;;   :single-float			float
;;;   :double-float			float
;;;   (:pointer foreign-type)		no equivalent type
;;;   (:field size position)		integer
;;;   (:signed-field size position)	integer
;;;   (:array foreign-type
;;;	      array-dimensions-list
;;;	      array-discipline)		no equivalent type
;;;  Passing C data to Lisp functions
;;;   :unsigned-32bit			(unsigned-byte 32)	:value
;;;   :signed-32bit			(signed-byte 32)	:value
;;;   :fixnum				fixnum			:value
;;;   :single-float			float			:value
;;;   :double-float			float			:value
;;;   :pointer				foreign-pointer		:reference
;;;   (:pointer foreign-type)		foreign-pointer		:reference
;;;   :simple-string			simple-string		:reference
;;;   :character			character		:value
;;;   :boolean				t			:value
;;;   :lisp				t			:value
;;;   :null				nil			nil
;;;  Passing Lisp data to C functions
;;;   (unsigned-byte 32)		:unsigned-32bit		:value
;;;   (signed-byte 32)			:signed-32bit		:value
;;;   fixnum				:fixnum			:value
;;;   float				:single-float		:value
;;;   float				:double-float		:value
;;;   foreign-pointer			:pointer		:reference
;;;   foreign-pointer			(:pointer foreign-type)	:reference
;;;   coercible-to-foreign-array	:array			:reference
;;;   (simple-array			:simple-vector-type	:reference
;;;	(not string-char) 1)
;;;   simple-string			:simple-string		:reference
;;;   c-string-type			:string			:reference
;;;   character				:character		:value
;;;   t					:boolean		:value
;;;   t					:lisp			:value
;;;   (or fixnum			:arbitrary		nil
;;;	  float
;;;	  integer
;;;	  character
;;;	  foreign-pointer
;;;	  c-string-type
;;;	  coercible-to-foreign-array)
;;;
;;;
(defvar *data-type-port*
    ;;YY-Type-Name          Native-Type-Name
    '((:character      .    #+:Lucid :character
			    #+:Excl  character)
      (:signed-8bit    .    #+:Lucid :signed-8bit
                            #+:Excl  fixnum)
      (:unsigned-8bit  .    #+:Lucid :unsigned-8bit
                            #+:Excl  fixnum)
      (:signed-16bit   .    #+:Lucid :signed-16bit
                            #+:Excl  fixnum)
      (:unsigned-16nit .    #+:Lucid :unsigned-16nit
                            #+:Excl  fixnum)
      (:signed-32bit   .    #+:Lucid :signed-32bit
                            #+:Excl  fxnum)
      (:unsigned-32bit .    #+:Lucid :unsigned-32bit
                            #+:Excl  fixnum)
      (:fixnum         .    #+:Lucid :fixnum
                            #+:Excl  fixnum)
      (:single-float   .    #+:Lucid :single-float
                            #+:Excl  single-float)
      (:double-float   .    #+:Lucid :double-float
                            #+:Excl  double-float)
      (:simple-string  .    #+:Lucid :simple-string
                            #+:Excl  string)))

(defvar *return-type-port*
    ;; YY-return-type  .    Native-return-type
    '((:fixnum         .    :fixnum)
      (:signed-32bit   .    #+:Lucid :signed-32bit
                            #+:Excl  :fixnum)
      (:unsigned-32bit .    #+:Lucid :unsigned-32bit
                            #+:Excl  :fixnum)
      (:single-float   .    :single-float)
      (:double-float   .    :double-float)
      (:character      .    :character)
      (:null           .    #+:Lucid :null
                            #+:Excl  :void)))

(defun native-data-type (yy-data-type)
  (let ((native-data-type (cdr (assoc yy-data-type *data-type-port*))))
    (if (null native-data-type)
	(error "Native-data-tyep : Undefined data type ~s." yy-data-type)
      native-data-type)))

(defun native-return-type (yy-return-type)
  (let ((native-return-type (cdr (assoc yy-return-type *return-type-port*))))
    (if (null native-return-type)
	(error "Native-return-type : Undefined return type ~s." yy-return-type)
      native-return-type)))

(DEFUN DEFOREIGN  (LNAME &KEY (ARGUMENTS) (RETURN-TYPE) (NAME))
  #+:LUCID
  (LET* ((NNAME (FORMAT NIL "_~a" NAME))
	(E-LIST (list 'lucid::DEF-FOREIGN-FUNCTION (list LNAME '(:LANGUAGE :C)
						  (list :name NNAME)
						  (list ':RETURN-TYPE RETURN-TYPE))))
	(val nil) (val2 nil) (end (length ARGUMENTS)) (i 0))

	(loop 
	 (if (>= i end)
	     (return))
	 
	   (setf val  (nth i ARGUMENTS))
	   (setf val2 (nth (incf i) ARGUMENTS))
	   (nconc E-LIST (list (list val val2)))
	   (incf i))
		


	(eval E-LIST))
	   

  #+:EXCL
  (let ((new-arguments nil) (i 1))
    (dolist (item ARGUMENTS)
	    (if (zerop (mod i 2))
		(setf new-arguments (nconc new-arguments 
					   (list (native-data-type item)))))
	    (incf i)
	    )
    (if return-type
	(setf return-type (native-return-type return-type))
      (setf return-type (native-return-type :fixnum)))
(format t "~a ~a ~a~%" name new-arguments return-type)
    (if name
	(ff:defforeign lname :arguments new-arguments
		             :return-type return-type
			     ; :entry-point (convert-to-lang name :language :c)
			     )
      (ff:defforeign lname :arguments new-arguments
		           :return-type return-type)
      )
    )
  )
|#




