;;; -*- Mode: LISP; Syntax: Common-lisp; Package: user; Base: 10 -*-
;;; presentation-class.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.2 90/12/15 by t.kosaka


(in-package :yy)


;;; $B%j%9%H$N@hF,$r$b$H$a$k(B
(defmethod get-top ((ob list))
  (get-top (car ob)))

(defmethod get-top (ob)
  ob)

(defmethod get-top ((ob NULL))
  nil)

;;;$B%-!<%o!<%I0z?t$r5a$a$k(B
(defmethod  get-key-word ((arg list))
  (let ((n 0)
	(ret nil))
    (dolist (item arg)
      (when (keywordp item)
	(setf ret (nthcdr n arg))
	(return))
      (incf n))
    ret))

(defmethod  get-key-word (arg)
  nil)

;;; Common Lisp $B%?%$%W(B
(defvar *cl-type-list*
    '(array atom bignum bit bit-vector character
                             common compiled-function complex cons double-float
                             fixnum float function hash-table integer keyword
                             list long-float nil null number package pathname
                             random-state ratio rational readtable sequence
                             short-float simple-array simple-bit-vector
                             simple-string simple-vector single-float
                             standard-char stream string string-char symbol
                             t vector signed-byte unsigned-byte))
   

;;;method strucure
;;;$B%a%=%C%I$N9=B$BN(B
(defstruct check-method function args)

;;; presentation-class$B$N@_Dj(B
;;; (define-presenatation-class (name super-class lambda-list &body body)
;;; name        -> $B7?$rI=$9%j%9%H$b$7$/$O%7%s%\%k(B
;;; super-class -> $B7Q>5$9$k7?(B $B%7%s%\%k$N%j%9%H(B
;;; lambda-list -> $B7?$r@bL@$9$k$?$a$N(Blambda-list$B!#@hF,$O!"Dj5A$7$?7?(B
;;;                $B$N%$%s%9%?%s%9$,F~$k!#(B
;;; body        -> $B7?$rH=Dj$9$k$?$a$N<0(B
(defmacro define-presenatation-class (name super-class
				     lambda-list &body body)
  (declare (special *presentation-class-name-list*))
  (let ((new-name (gentemp))
	(nname (gentemp))
	(arg1 (gentemp)))
  `(let* ((,nname (if (listp (quote ,name))
		      (get-top (quote ,name))
		    (quote ,name)))
	  (s-list (mapcan #'(lambda (x)
			      (if (get x 'yy-presentation)
				  (mapcan #'(lambda (y)
				    (list (class-name 
					  (class-of y))))
				    (get x 'yy-presentation))))
			  (list* (quote ,super-class))))
	  (s-class (mapcan #'(lambda (x)
			       (if (get x 'yy-presentation)
				   (get x 'yy-presentation)))
			   (list* (quote ,super-class))))

	  (new-lambda (nconc (list (list (quote ,arg1) (quote ,new-name) )
				   (get-top (quote ,lambda-list)))
			     (cdr (quote ,lambda-list))))

	  (method-s (make-check-method :function 
				       (if (quote ,lambda-list)
					   (quote ,new-name)
					 nil)
				       :args (cdr (quote ,lambda-list))))

	  (defc (list 'defclass (quote ,new-name) s-list
		      (list (list 'key-word ':initform 
				  (quote (get-key-word (list* (quote ,name))))
			      ':accessor 'key-word)
			    (list 'parent ':initform s-class
				  ':accessor 'presentation-paernt)
		    (list 'chek-methods ':initform  nil
				  ':accessor 'check-methods))))

	  (defm (nconc (list 'defmethod (quote ,new-name) new-lambda)
		       (quote ,body))))
		     
     (eval defc)

     (when (quote ,lambda-list)
       (eval defm))

     (pushnew (make-instance (quote ,new-name))
		(get ,nname 'yy-presentation))

     (dolist (item (list* (quote ,super-class)))
       (dolist (nitem (get item 'yy-presentation))
		 (setf (check-methods (car (get ,nname 'yy-presentation)))
		   (nconc (check-methods (car (get ,nname 'yy-presentation)))
			  (check-methods nitem)))
	   ))

     (if (check-method-function method-s)
	 (push method-s (check-methods (car (get ,nname 'yy-presentation)))))

     (quote ,name))))

#|
(define-presenatation-class integer () ((ob integer) 
				      &optional (x most-negative-fixnum)
				      (y most-positive-fixnum))
     (if (and (> ob x) (> y ob))
	 T
       nil))
|#

;;; make-yy-type-list 
;;; YY$B$N7?%?%$%W$K9g$C$?%j%9%H$r:n$k(B
;;; make-yy-type-list list
;;; list   ->  $B%j%9%H(B
;;; ret   <-   YY$B$K9g$C$?%j%9%H(B
(defun make-yy-type-list (list)
  (mapcar #'(lambda (X)
	      (case X
		(and 'and)
		(or  'or)
		(not 'not)
		(t 
		 (if (listp X)
		     X
		   (list x)))))
	  list))


#|
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $B%W%l%<%s%F!<%7%g%s%/%i%9!!(B;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass yy-presentation ()
 ((presentation-class :initarg :presentation-class
 		     :accessor presentation-class)
  (presntation-keyword :initarg :presntation-keyword
		       :accessor presentation-keyword)
  (instance :initarg :instance :accessor instance)
  (presentation-stream :initarg :presentation-stream
  		       :accessor presentation-stream)
  (drawing-sequence :initarg :drawing-sequence :initform '(nil)
  		    :accessor drawing-sequence)
  (after-drawing-list :accessor after-drawing-list
		      :initform '(nil))
  (presentation-territory-no :accessor presentation-territory-no)
  (presentation-region :initarg :presenation-region
		       :accessor presentation-region)
  (mouse-sence-mask :initarg :mouse-sence-mask
                    :accessor mouse-sence-mask)
  ))
|#

;;; member-tree
;;; $BLZ9=B$$N%j%9%HCf$G!"M?$($i$l$?%*%V%8%'%/%H$,$"$k$+D4$Y$k(B
;;; member-tree object tree-list
;;; object     ->  $BD4$Y$?$$%*%V%8%'%/%H$N%j%9%H(B
;;; tree-list  ->  $BD4$Y$?$$%j%9%H(B
(defmethod member-tree (object (tree-list list))
  (let ((ret nil))
    (dolist (item tree-list)
      (if (listp item)
         (if (setf ret (member-tree object item))
	    (return)) 
	(dolist (ob object)
         (when (equal ob item)
           (setf ret T)
           (return))
          ))
      )	
     ret))

;;; get-presentation-keyword
;;; $B%W%l%<%s%F!<%7%g%s%?%$%W$N%-!<%o!<%I$H!"%?%$%W$r5a$a$k(B
;;; and or not member$BEy$N@)8f%?%$%W$,$"$l$P%(%i!<$rH/@8$9$k(B
;;; get-presentation-keyword type-list
;;; type-list   ->  $B%?%$%W%j%9%H(B
;;; ret1        <-  $B%-!<%o!<%I$r=|$$$?%?%$%W%j%9%H(B
;;; ret2        <-  $B%-!<%o!<%I%j%9%H(B
(defmethod get-presentation-keyword ((type-list list))
   (let ((new-type  type-list)
         (ret1 nil)
         (ret2 nil))
    ;;; and or not member$B$,L5$$$3$H$rD4$Y$k(B
    (if (member-tree '(and or not member) type-list)
	(error "You can't set 'and 'or 'not 'member for presentation type")
     (if (listp (car new-type))
       ;;; $BB?J,%-!<%o!<%I$,$"$k(B
       (setf ret2 (cdr new-type)
             ret1 (car new-type))
      ;;; $B%-!<%o!<%I$,L5$$(B
      (setf ret1 new-type)))

   (values `(quote ,ret1) `(quote  ,ret2))))

;;; type-list $B$,%j%9%H$G$J$$!#(B
(defmethod get-presentation-keyword ((type-list T))
  (values `(qupte ,type-list) nil))


;;; with-output-as-presentation
;;; $BIA2h$7$?%*%V%8%'%/%H$r%W%l%<%s%F!<%7%g%s$K$9$k(B
;;; with-output-as-presentation (object &key :stream :type) form
;;; object    -> $B%"%/%;%W%H$5$l$?;~$KJV$k%*%V%8%'%/%H(B
;;; :stream   -> $BIA2hBP>]$N%&%#%s%I%&%9%H%j!<%`(B
;;; :type     -> $BIA2h$9$k%*%V%8%'%/%H$N%W%l%<%s%F!<%7%g%s%?%$%W(B
(defmacro with-output-as-presentation ((object &key (stream *root-window*)
						    (type 
						     (class-name 
						      (class-of object)))
					&rest form)
 (let ((instance (gentemp))
       (region (gentemp))
       (real-type (gentemp))
       (key-word (gentemp))
       (move-mode (gentemp))
       (active-region (gentemp)))
  `(let* ((,real-type nil)
  	  (,key-word nil)
	  (,move-mode (if (eq (class-name (class-of ,stream))
			      'viewport-window-stream)
			  :move-mode
			:non-move-mode))
	  (,instance (make-instance 'yy-presentation :instance ,object
				    :presentation-class 
				    (if (eq ,type (class-name
						    (class-of ,object)))
					nil
				      ,type)
				    :presentaion-mode-mode ,mode-mode
				    :presentation-stream ,stream))
          (,region (drawing-region ,stream)))
		   
     ;;; $B%W%l%<%s%F!<%7%g%s%?%$%W$H!"%-!<%o!<%I$r5a$a$k(B
     (multiple-value-setq (,real-type ,key-word)
        (get-presentation-keyword (quote ,type)))

     (setf (presentation-class ,instance) ,real-type
           (presentation-keyword ,instance) ,key-word
	   (presentation-instance ,stream) ,instance)

     (push ,instance (present-list ,stream))

     ;;; $B%$%s%9%?%s%9$NEPO?(B
     (add-presentation-class-name ,real-type ,instance)
     
     ;;; $BIA2h%j!<%8%g%s$N@_Dj(B
     (if (null ,region)
        (setf (drawing-region ,stream)
	              (make-region :left most-positive-fixnum
        			   :bottom most-positive-fixnum
        			   :right most-negative-fixnum
        			   :top most-negative-fixnum)
	      ,region (drawing-region ,stream))
      (setf (region-left (drawing-region ,stream)) most-positive-fixnum
      	    (region-bottom (drawing-region ,stream)) most-positive-fixnum
      	    (region-top (drawing-region ,stream)) most-negative-fixnum
      	    (region-right (drawing-region ,stream)) most-negative-fixnum))

     ;;; $B%U%)!<%`$N<B9T(B
     (flet ((draw-position-xy (stream x y) (p-draw-position-xy stream x y))
	    (draw-position (stream pos) (p-draw-position stream pos))
	    (draw-line-xy (stream x1 y1 x2 y2) (p-draw-line-xy stream x1 y1 x2 
							       y2))
	    (draw-line stream (position1 position2) (p-draw-line position1 
						     position2))
	    (draw-region-xy (stream x y width height)
	      (p-draw-region-xy stream x y width height))
	    (draw-region (stream pos width height)
	      (p-draw-region stream pos width height))
	    (draw-region-region (stream region)
	      (p-draw-region-region stream region))
	    (draw-polyline-xy (stream &rest xy-list)
	      (p-draw-polyline-xy stream xy-list))
	    (draw-polyline (stream &rest position-list)
	      (p-draw-polyline stream position-list))
	    (draw-polygon-xy (stream  &rest xy-list)
	      (p-draw-polygon-xy stream xy-list))
	    (draw-polygon (stream &rest position-list)
	      (p-draw-polygon stream position-list))
	    (draw-triangle-xy (stream x y width height)
	      (p-draw-triangle-xy stream x y width height))
	    (draw-triangle (stream position width height)
	      (p-draw-triangle stream position width height))
	    (draw-ellipse-xy (stream center-x center-y x-radius y-radius
			      &key (start-angle 0) (end-angle (* 2 pi)) 
				   (clockwize :clockwize))
	      (p-draw-ellipse-xy stream center-x center-y x-radius y-radius
				 :start-angle start-angle
				 :end-angle end-angle
				 :clockwize clockwize))
	    (draw-ellipse (stream posistion x-radius y-radius
			  &key (start-angle 0)
			       (end-angle (* 2 pi))
			       (clockwize :clockwize))
	      (p-draw-ellipse stream posistion x-radius y-radius
			      :start-angle start-angle
			      :end-angle end-angle
			      :clockwize clockwize))
	    (draw-circle-xy (stream center-x center-y radius
			     &key (start-angle 0) (end-angle (* 2 pi))
				  (clockwize :clockwize))
	      (p-draw-circle-xy stream center-x center-y radius
				:start-angle start-angle :end-angle end-angle
				:clockwize clockwize))
	    (draw-circle (stream position radius
			     &key (start-angle 0) (end-angle (* 2 pi))
				  (clockwize :clockwize))
	      (p-draw-circle stream position radius
			     :start-angle start-angle :end-angle end-angle
			     :clockwize clockwize))
	    (put-image-xy (stream image x y &optinal (width (image-width image))
			   (height (image-height image))
			   &key (image-x 0) (image-y 0))
	      (p-put-image-xy stream image x y width height
			      :image-x image-x :image-y image-y))
	    (put-image (stream image position
			&optinal (width (image-width image))
			(height (image-height image))
			&key (image-x 0) (image-y 0))
	      (p-put-image stream image position width height
			      :image-x image-x :image-y image-y))
	    (draw-image (d-stream s-stream position width height
			 &key (image-position nil))
	      (p-draw-image d-stream s-stream position width height
			    :image-position image-position))
	    (draw-image-xy (d-stream s-stream dx dy width height
			    &key (image-x 0) (image-y 0))
	      (p-draw-image-xy d-stream s-stream dx dy width height
			       :image-x image-x :image-y image-y)))
       
       ,@form)

     (setf (presentation-instance ,stream) nil)

     ;;; $BIA2h%j!<%8%g%s$r(B2$B%T%/%;%k9-$2$k(B
     (setf (region-left ,region) (- (region-left ,region) 2)
           (region-bottom ,region) (- (region-bottom ,region) 2)
           (region-top ,region) (+ (region-top ,region) 3)
           (region-right ,region) (+ (region-right ,region) 3))

     ;;; region$B$N@_Dj(B
     (setf (presentation-region  ,instance) (copy-region ,region))

     ;;; $B%W%l%<%s%F!<%7%g%s%F%j%H%j!<$N@_Dj(B
     (setf (yy-presentaion-territory-no ,instance)
	   (with-object-make-region-territory ,instance ,region
			   :fence (if (eq ,move-mode :move-mode)
				      nil
				    T)
			   :parent (world-territory-no ,stream))

	   ;;; $BIA2h%7!<%1%s%9$N@_Dj(B
	   (after-drawing-list ,instance) (cdr (after-drawing-list ,instance))
	   (mouse-cursor-in-method ,instance) 'draw-fence-allways
	   (mouse-cursor-out-method ,instace) 'draw-clear-allways
	   (right-button-down-1-method ,instance) 'selection-object

			   
           ;;; $B%7%s%0%k%W%m%;%9$G!"<B9T(B				
	   (get 'draw-fence 'single-process) t
	   (get 'draw-fence-allways 'single-process) t
	   (get 'draw-clear-allways 'single-process) t)

     (when (eq ,move-mode :move-mode)
	 (setf 
	     (left-button-down-1-method ,instace) 'presetation-popup
	     (get 'presetation-popup 'single-process) t)
       )

     ;;; $BIA2h(B
   (dolist (function (cdr (after-drawing-list ,instance)))
	   (funcall function (yy-presentaion-territory-no ,instance)
	      (- (region-left ,region)) (- (region-bottom ,region))))
     
   ;;; $B%W%l%<%s%H$5$l$?%$%s%9%?%s%9$HL>A0$rEPO?(B
   (set-class-and-instance ,real-type ,instance)
   (setf (drawing-region ,stream) nil)
   nil)
  ))


;;; $B%W%l%<%s%F!<%7%g%s%/%i%9L>$H%$%s%9%?%s%9%j%9%H(B
(defclass presentation-class-list ()
  ((class-name :accessor class-name :initarg :class-name)
   (instance-list :accessor instance-list :initarg :instace-list)))
	  
;;;presentation-class-list
;;; presentation-class-list$B$N%$%s%9%?%s%9$,3JG<$5$l$k%j%9%H(B
(defvar *presentation-class-list* nil)

;;; set-class-and-instance
;;; $B%W%l%<%s%H$5$l$?%$%s%9%?%s%9$HL>A0$r%R%9%H%j!<$KEPO?(B
(defun set-class-and-instance (type-list instance)
  (declare (special *presentation-class-list*))
  (let* ((real-name (car (m-list type-list)))
	 (ob (find-if #'(lambda (x) 
			 (if (presentation-subclassp real-name (class-name x))
			     x
			   nil)
			 ) *presentation-class-list*)))
    (if ob
	(push instace (instance-list a))
      (push (make-instace 'presentation-class-list
			  :class-name real-name
			  :instance-list (list instace))
	    *presentation-class-list*))
    *presentation-class-list*))



;;; get-default-insnatce
;;; $BEPO?$5$l$F$$$k%W%l%<%s%F!<%7%g%s$+$i:G$b:G6a$K(B
;;; $BEPO?$5$l$F$$$k%$%s%9%?%s%9$rJV$9(B
(defun get-default-instance (type-list)
  (declare (special *presentation-class-list*))

  (find-if #'(lambda (x)
	       (if (presentation-subclassp type-list (class-name x))
		   (dolist (item (instance-list x))
			   (if (presentantion-classp (instance item)
						     type-list)
			       (return (values item))))
		 nil))
	   *presentation-class-list*)
  )

;;; get-presentation-from-list
;;; $BEPO?$5$l$F$$$k%W%l%<%s%F!<%7%g%s$N0lCW$7$?%$%s%9%?%s%9$N(B
;;; $B%W%l%<%s%F!<%7%g%s$rJV$9(B
(defun get-presentation-from-list (object type-list)
  (declare (special  *presentation-class-list*))
  
  (find-if #'(lambda (x)
               (if (presentation-subclassp type-list (class-name x))
		   (dolist (item instance-list x)
			   (if (equal object (instance item))
			       (return (values item)))
			   )
		 nil))
	   *presentation-class-list*)
)
	   

;;; $B%W%l%<%s%F!<%7%g%s;~$N%^%&%9%+!<%=%k$,F~$C$?;~$K5/F0$9$k%U%i%0(B
(defvar *presentation-sence* nil)

;;; selection-objecxt
;;; $B%W%l%<%s%F!<%7%g%s$NA*Br(B
(defmethod selection-object ((presentation yy-presentation) state)
  (declare (special *white-color* *presentation-sence* *accept-class*))
  (let ((ret nil))
  (when (setf ret (presentation-checkp presentation *accept-class*))
    (setf (get ret 'yy-presentation-answer) (instance presentation))
    (draw-waku-exec presentation *white-colocr*)
    
    ;;; $B%$%Y%s%H$r@5>o$K$9$k(B
    (dolist (item *presentation-sence*)
      (enable-evnet item))

    (setf *presentation-sence* nil)
    (throw 'acept-wait (values (instance presentation) presentation)))
  ))
      
;;; draw-fence-allways
;;; $B7?$K0lCW$9$k%*%V%8%'%/%H$,$"$l$P!"OH$r0O$`(B
(defmethod draw-fence-allways ((presentation yy-presentation) state)
  (declare (special *black-color* *presentation-sence* *accept-class*))
  (let ((ret nil)
	(top T))
    (when (setf ret (presentation-checkp presentation *accept-class*))
      (draw-waku-exec presentation *black-color*) 
      (setf *presentation-sence* nil
	    top nil))

    (when top
	  (pushnew presentation *presentation-sence*)
	  ;;; $B0l;~E*$K%$%Y%s%H$NH/@8$r$H$a$k(B
	  (disnable-event presentation *mouse-in*)
  	  ;;; $B0lHV$7$?$K$9$k(B
	  (yy-protocol-8 (yy-presentaion-territory-no presentation)))
  ))

;;; draw-fence
;;; $B7?$K0lCW$9$k%*%V%8%'%/%H$,$"$l$P!"OH$r0O$`(B
(defmethod draw-fence ((presentation yy-presentation) state)
  (declare (special *black-color* *presentation-sence* *accept-class*))
  (let ((ret nil)
	(top T))
    (when (setf ret (presentation-checkp presentation *accept-class*))
      (draw-waku-exec presentation *black-color*) 
      (setf *presentation-sence* nil
	    top nil))

    (when top
	  (pushnew presentation  *presentation-sence*)
	  (disnable-event presentation *mouse-in*)
  	  ;;; $B0lHV$7$?$K$9$k(B
	  (yy-protocol-8 (yy-presentaion-territory-no presentation)))
  ))

;;; draw-clear-allways
;;; $B7?$K0lCW$9$k%*%V%8%'%/%H$,$"$l$P!"OH$r>C$9(B
(defmethod draw-clear-allways ((presentation yy-presentation) state)
  (declare (special *white-color* *presentation-sence* *accept-class*))
  (let ((ret nil))
    (when (setf ret (presentation-checkp presentation *accept-class*))
      (draw-waku-exec presentation *white-color*)
      )))
      

;;; $BOH$NIA2h!"HsIA2h$r$9$k(B
(defmethod draw-waku-exec ((presentaion yy-presentation)  color)
  ;;; $BOH$NI=<((B
  (let ((region (presentantion-region presentation)))
    (yy-protocol-26 (yy-presentation-territory-no presentation)
		    (region-left region)
		    (region-bottom region)
		    (region-width region)
		    (region-height region)
		    1 boole-1 (color-no color) ""))
  )

;;; accept$B$9$Y$-7?$rEPO?$9$k(B
(defvar *accept-class* nil)

;;; accept $B$GMW5a$5$l$?7?$rH=Dj(B
(defmethod presentation-checkp ((presentation yy-presentation) check-class)

  (if (presentation-class presentation)
      (presentation-subclassp check-class (presentation-class presentation))
    (presentation-classp (instance presentation) check-class)))


;;; Lisp listener read function
;;; $BF~NO$b<u$1IU$1$k(B
(defun read-from-listener (promot &optional (stream *lisp-listener*))
  (declare (special *selection-table*))
  (let* ((s-stream *selection-table*)
	 (default (get-default-instance *accept-class*))
	 (default-instnace (if default
			       (instace default)
			     nil)))

    (select-window stream)

    (multiple-value-bind (ans-object presentation)
	   (catch 'accept-wait
	     (loop
	      (if (null prompt)
		  (progn
		    (write-string (format nil "Accept Default[~a]>" 
					  default-instance) stream)
				
		    (force-output stream))
		(progn 
		  (write-string (format nil "~a Default[~a]>" (string prompt) 
					default-instance) stream)
		  (force-ourput stream)))

	      (let* ((data (read-line))
		     (object (if (string= data "")
				 nil
			       (read-form-string data))))
		
	      (if object
		  (when (presentation-classp (eval
					      (read-from-string read-object))
					     *accept-class*)
			(return (values 
				 (read-from-string read-object)
				 (get-presentation-from-list  object 
							      *accept-class*))))
		(return (values default-instance default))))))

	   (select-window s-stream)
	   (values ans-object presentation))
    ))

;;; accept
;;; $B%"%/%;%W%H(B
;;; accept type-list
;;; type-list     ->  $B5a$a$?$$%*%V%8%'%/%H$N%?%$%W(B
;;; ret           <-  $B%*%V%8%'%/%H(B
(defun accept (type-list)
    (mulitiple-value-bind (type keyword-list)
       (get-presentation-keyword type-list)

       (setf *presentation-sence* nil)
         ;;; $B%?%$%W%j%9%H$rDI2C(B
       (setf *accept-class* type)
       
       (multiple-value-bind (ans p-instance)
	(read-from-listener keyword-list)
	ans)))

;;; $B%]%C%W%"%C%W%a%K%e$NI=<((B
(defmethod presetation-popup ((presentation  yy-presentation) state)
  (declare (special *presentation-popup-menu*))
  (multiple-value-bind (x y) (position-from-root-window-xy
			      (mouse-state-x-position state)
			      (mouse-state-y-position state)
			      presentation)

    (display-popup-menu *presentation-popup-menu*
			x y presentation)))

;;; $B%W%l%<%s%H$5$l$?$b$N$N0\F0(B
;;; $B%]%C%W%"%C%W%a%K%e$+$i8F$P$l$k(B
(defmethod move-object ((presentation yy-presentation))
  (multiple-value-bind (x y) (get-position-xy 
			      (presentation-stream presentation))
    (move-presentation-object-xy presentation x y)))

;;; move-presentation-object-xy (presentation x y)
;;; $B%W%l%<%s%H$5$l$?%*%V%8%'%/%H$N0\F0(B
;;; ARGS.
;;;        presentation     =  $B%W%l%<%s%F!<%7%g%s%$%s%9%?%s%9(B
;;;        x y              =  $B:BI80LCV(B
(defemthod move-presentation-object-xy ((presentation yy-presentation)
					x y)
  (move-presentation-object-xy-internal presentation x y))

;;; move-presentation-object (presentaion position)
;;; $B%W%l%<%s%H$5$l$?%*%V%8%'%/%H$N0\F0(B
;;; ARGS.
;;;        presentation     =  $B%W%l%<%s%F!<%7%g%s%$%s%9%?%s%9(B
;;;        position              =  $B:BI80LCV(B
(defemthod move-presentation-object ((presentation yy-presentation)
				     (position position))
  (move-presentation-object-xy-internal presentation 
					(position-x position)
					(position-y position)))

;;; move-present-object$B$NAm>N4X?t(B
;;; $B%G%U%)%k%H$O2?$b$7$J$$!#(B
(defgeneric move-present-object (object x y))


;;; $B%W%l%<%s%H$5$l$?%*%V%8%'%/%H$N0\F0$N%$%s%?!<%J%k4X?t(B
(defun move-presentation-object-xy-internal (presentation x y)
  (let* ((window (presentation-stream presentation))
	 (region (presentation-region presentation))
	 (half-width (ceiling (/ (region-width region) 2)))
	 (half-height (ceiling (/ (region-height region) 2))))

    (with-translate-transform-xy ((new-x new-y) window x y)
      (with-temp-region-args ((p-region) (work-region1 window)
			      :left (- new-x half-width)
			      :bottom (- new-y half-height)
			      :width (region-width region)
			      :height (region-height region))
       ;;; $B%o!<%k%I%j!<%8%g%s$NJQ99(B
      (setf (world-region window) p-region)

      ;;; $B0\F0(B
      (yy-protocol-3 (yy-presentation-territory-no presentation)
		     (- new-x half-width)
		     (- new-y half-height))
      
      ;;; $B%*%V%8%'%/%H$N0\F0%a%=%C%I(B
      (move-present-object (instance presentation) x y)
      ))
    (values)))
      
;;; move-present-object-in-window-xy xy$BMQ(B
;;; $B%&%#%s%I%&%9%H%j!<%`Fb$K$"$k%W%l%<%s%H$5$l$?(B
;;; $B%*%V%8%'%/%H$r0\F0$9$k!#(B
;;; move-present-object-in-window-xy (window object x y &optional
;;;                                     (class (class-name (class-of object)))
;;; ARGS.
;;;          window      =   $B%&%$%s%I%&%9%H%j!<%`(B
;;;          object      =   $B%W%l%<%s%H$7$?%*%V%8%'%/%H(B
;;;          x y         =   $B%&%#%s%I%&%9%H%j!<%`Fb$N?7$7$$0LCV(B
;;;          class       =   $B%W%l%<%s%H$7$?;~$N%/%i%9(B
(defmethod move-present-object-in-window-xy ((window window-stream)
				     object x y
				     &optional 
				     (class (class-name (class-of object))))
  (move-present-object-in-window-internal window object x y class))

;;; move-present-object-in-window $B%]%8%7%g%sMQ(B
;;; $B%&%#%s%I%&%9%H%j!<%`Fb$K$"$k%W%l%<%s%H$5$l$?(B
;;; $B%*%V%8%'%/%H$r0\F0$9$k!#(B
;;; move-present-object-in-window (window object posisiton &optional
;;;                                   (class (class-name (class-of object)))
;;; ARGS.
;;;          window      =   $B%&%$%s%I%&%9%H%j!<%`(B
;;;          object      =   $B%W%l%<%s%H$7$?%*%V%8%'%/%H(B
;;;          position         =   $B%&%#%s%I%&%9%H%j!<%`Fb$N?7$7$$0LCV(B
;;;          class       =   $B%W%l%<%s%H$7$?;~$N%/%i%9(B
(defmethod move-present-object-in-window ((window window-stream)
				     object position &optional
				     (class (class-name (class-of object))))
  (move-present-object-in-window-internal window object 
					  (position-x position)
					  (position-y position)
					  class))
   

;;; move-present-object-in-window $B$N%$%s%?!<%J%k4X?t(B
(defun move-present-object-in-window-internal (window object x y class)
  (move-presentation-object-xy-internal 
   (find-presentation-object-from-window window object class)
                          x y)
  (values))

;;; $B%&%#%s%I%&$KEPO?$5$l$F$$$k%W%l%<%s%H$5$l$?(B
;;; $B%*%V%8%'%/%H$N%W%l%<%s%F!<%7%g%s%$%s%9%?%s%9$rC5$9(B
;;; find-presentation-object-from-window window object class
;;; ARGS.
;;;         window         =    $B%&%#%s%I%&%9%H%j!<%`(B
;;;         object         =    $B%W%l%<%s%H$7$?%*%V%8%'%/%H(B
;;;         class          =    $B%W%l%<%s%H$7$?%/%i%9(B
;;; RET.
;;;        $B%W%l%<%s%F!<%7%g%s%$%s%9%?%s%9(B
(defun find-presentation-object-from-window (window object class)
  (find-if #'(lambda (x)
	       (if (and (presentation-checkp x class)
			(equal object (instance x)))
		   t
		 nil))
	   (present-list window)))


;;; $B%W%l%<%s%H$5$l$?$b$N$NIA2h%7!<%1%s%9$N%3%T!<(B
;;; $B%]%C%W%"%C%W%a%K%e$+$i8F$P$l$k(B
(defmethod drawing-copy ((presentation yy-presentation))
  (let ((window (whicw-with-button)))
    (dolist (item (cdr (drawing-sequence presentation)))
      (funcall item stream)))
  (values))

;;; drawing-sequence-copy-to-window
;;; $B%W%l%<%s%H$5$l$F$$$k%*%V%8%'%/%H$NIA2h%7!<%1%s%9$r(B
;;; $BB>$N%&%#%s%I%&$K%3%T!<$9$k(B
;;; drawing-sequence-copy-to-window (s-window d-window object class)
;;; ARG.
;;;        s-window   =    $B%*%V%8%'%/%H$,%W%l%<%s%H$5$l$F$$$k%&%$%s%I%&(B
;;;        d-window   =    $BIA2h%7!<%1%s%9$r%3%T!<$9$k%&%#%s%I%&(B
;;;        object     =    $B%W%l%<%s%H$7$?%*%V%8%'%/%H(B
;;;        class      =    $B%W%l%<%s%H$7$?%*%V%8%'%/%H$N%/%i%9(B
(defmethod drawing-sequence-copy-to-window ((s-window window-stream)
				    (d-window window-stream)
				    object &optional
				    (class (class-name (class-of object))))
  (let ((present (find-presentation-object-from-window window object class)))
    (dolist (item (cdr (drawing-sequence present)))
	    (funcall item d-window))
    (values)))

;;; delete-presentation-instance
;;; $B%W%l%<%s%F!<%7%g%s%$%s%9%?%s%9$r%R%9%H%j!<$+$i$H$j=|$/(B
;;; delte-present-instace 
;;; ARG.       object      =    $B%W%l%<%s%F!<%7%g%s%$%s%9%?%s%9(B
(defmethod delete-presentation-instance ((object yy-presentation))
  (delete-presentation-instance-internal object))


;;; clear-history
;;; $B%W%l%<%s%H$5$l$?%R%9%H%j!<$r2rJ|$9$k(B
;;; clear-history
;;; ARG.
;;;        none
(defun clear-history ()
  (declare (special *presentation-class-list*))
  
  (dolist (item *presentation-class-list*)
      (dolist (present (instance-list item))
	   (setf (present-list (presentation-stream present)) nil)
	   (yy-protocol-5 (yy-presentation-territory-no present))
	   (delete-lisp-object (yy-presentation-territory-no present))))
  (setf *presentation-class-list* nil))


;;; $B%W%l%<%s%F!<%7%g%s%$%s%9%?%s%9$N>C5n$N%$%s%?!<%J%k4X?t(B
(defun delete-presentation-instance-internal (object)
  (declare (special *presentation-class-list*))
  (let ((p-set nil))
    
    (dolist (item *presentation-class-list*)
      (setf (instance-list item)
	(delete-if #'(lambda (x) (if (eq object (instance-list x))
				     (setf p-set item)
				   nil))
		   (instance-list item)))
      (if p-set
	  (return)))
    
    ;;; $B%W%l%<%s%H$7$F$$$k%&%#%s%I%&$+$i>C5n(B
    (setf  (present-list (presentation-stream object))
	(delete object (present-list (presentation-stream object))))

    ;;; instance-list$B$K%W%l%<%s%F!<%7%g%s$,$J$/$J$l$P>C5n(B
    (unless (instance-list p-set)
      (setf *presentation-class-list*
	(delete p-set *presentation-class-list*)))
    
    ;;;$B%F%j%H%j!<$N>CLG(B
    (yy-protocol-5 (yy-presentation-territory-no object))

    (delete-lisp-object (yy-presentation-territory-no object))

    (values)))


;;; delete-present-object-in-window
;;; $B%&%#%s%I%&$KI=<($7$F$"$k%W%l%<%s%H$5$l$?%*%V%8%'%/%H$N(B
;;; $B%W%l%<%s%F!<%7%g%s%$%s%9%?%s%9$rGK2u$9$k!#(B
;;; $B:G=i$K$_$D$+$C$?%*%V%8%'%/%H$N%W%l%<%s%F!<%7%g%s%$%s%9%?%s%9$rGK2u$9$k(B
;;; delete-present-object-in-window (window object &optional
;;;                          (clss-name (class-of object))
;;; ARG.
;;;     window    =  $B%&%#%s%I%&%9%H%j!<%`(B
;;;     object    =  $B%W%l%<%s%H$7$?%*%V%8%'%/%H(B
;;;     class      =  $B%W%l%<%s%H$7$?;~$N%W%l%<%s%F!<%7%g%s%/%i%9(B
(defmethod delete-present-object-in-window ((window window-stream)
				    object 
				    &optional
				    (class (class-name (class-of object))))
  (delete-presentation-instance-internal 
          (find-presentation-object-from-window window object class)))



(defun present (object &optional (stream *demo-window3*))
  (with-output-as-presentation (object :stream stream)
       (write-string (format nil "~a" object) stream)
       (force-output stream))
  (force-output stream))
