;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; $B%]%C%W%"%C%W%a%K%e4XO"(B
;;; popup-menu.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.0 90/06/01 by t.kosaka (kosaka@csrl.aoyama.ac.jp)
;;;   version 1.1 90/07/31 by t.kosaka
;;;   update 1.11 90/09/14 by t.kosaka
;;;   version 1.2 90/11/05 by t.kosaka

;;; $B%]%C%W%"%C%W%a%K%e(B
;;; 6/14 1990 $B8E:d(B
;;; Version 1.0   Coded by t.kosaka 1990-6-14

(in-package :yy)

;;; $B%]%C%W%"%C%W%a%K%e$r:n$k(B
;;; item-list '(("$BI=<(J8;zNs(B" $B%a%=%C%IL>(B "$B%W%m%s%W%H%&%#%s%I%&I=<((B") 
;;;             ("$BI=<(J8;zNs(B" $B%a%=%C%IL>(B "$B%W%m%s%W%H%&%#%s%I%&I=<((B") ..)
(defun make-popup-menu (item-list &key (title-string "")
				       (title-font *default-font*)
				       (item-font *default-font*))
  (let ((pop-window nil)
	(max-width (font-string-length title-font title-string))
	(temp-width 0)
	(max-height 0)
	(active-region nil)
	(yy 0)
	(y (font-kanji-base-line item-font)))
	
   (declare (inline incf >= round / car))
    ;;; $B:GBg9b$5$r5a$a$k(B
    (dolist (i item-list)
	    (incf max-height (font-kanji-height item-font)))

    (if title-string
	(incf max-height (font-kanji-height title-font)))

    (incf max-height 2)

    ;;; $B:GBgI}$r5a$a$k(B
    (dolist (i item-list)
	(if (>= (setf temp-width 
		      (font-string-length item-font (car i))) max-width)
	    (setf max-width temp-width))
	)


    ;;; $B%]%C%W%"%C%W%a%K%e$N%&%#%s%I%&$r@8@.(B
    (setf pop-window (make-window-instance 'viewport-window-stream
		      :window-region (make-region :width (incf max-width 4)
						  :height max-height)
		      
		      :visible nil
		      :title-bar-string title-string
		      :title-font title-font
		      :title-bar-visible
		      (if title-string
			  T
			NIL)
		      :horizontal-scroll-bar nil
		      :vertical-scroll-bar nil
		      :coordinate-area nil))
    ;;; $B%a%K%e$NJ8;zNs$rIA2h$H%"%/%F%#%V%j!<%8%g%s$N@_Dj(B
    (with-text-control ((font stream-font)) pop-window
	  (setf font item-font)

	  (dolist (i item-list)
	     (setf temp-width (font-string-length item-font (car i)))
             ;;; $B0LCV$ND4@0(B
	     (draw-string-xy pop-window (car i)
			     (round (/ (- max-width temp-width) 2))
			     y)
	     (setf active-region 
		   (make-active-region :left 0 
				 :bottom yy
				 :width max-width
				 :height (font-kanji-height item-font)
				 :parent pop-window))

	     ;;; $B<B9T%a%=%C%I$N@_Dj(B
	     (setf (get (active-region-symbol active-region) 'method)
		   (second i)
		   (get (active-region-symbol active-region) 'prompt)
		   (third i))

	     ;;; $B%a%=%C%I$N@_Dj(B
	     (setf (button-up-method active-region)
		   'popup-menu-selected
		   (get 'popup-menu-item-display 'single-process) t
		   (mouse-cursor-in-method active-region)
		   'popup-menu-item-display)

	     (incf yy (font-kanji-height item-font))

	     (incf y (font-kanji-height item-font))))

    ;;; $B%]%C%W%"%C%W%a%K%e$NIA2h>uBV$rJQ99(B
    (setf (graphic-operation pop-window)
	  (get-text-edit-operation (world-back-color pop-window)
				   (graphic-color pop-window))
	  (filled-type pop-window) *FillSolid*)
	  

    ;;; $B=*N;%a%=%C%I(B
    (set-window-method pop-window
			     'exit-popup-menu
			     :event-mask *mouse-out*)
    pop-window))

;;; $B%]%C%W%"%C%W%a%K%e(B $BI=<((B
(defmethod display-popup-menu ((popup-menu window-stream)
			       (root-x integer)
			       (root-y integer)
			       current-window)
  (declare (inline get - / round))
  (setf (get (window-symbol popup-menu) 'currnt) current-window)

  (move-xy popup-menu root-x 
            (- root-y (round (/ (region-height (window-region popup-menu)) 3))))

  (expose  popup-menu)
  (activate popup-menu))

;;; $B%]%C%W%"%C%W%a%K%e$N=*N;(B
(defmethod exit-popup-menu ((window window-stream) state)
#-:PCL
  (declare (ignore state))
  (let ((old-a (get (window-symbol window) 'old-region)))

    (when old-a
	  (draw-region-region window  old-a)
	  
	  (setf (get (window-symbol window) 'old-region) nil)

	  (deactivate window))
    ))

;;; $BI=<(NN0h$NH?E>(B
(defmethod popup-menu-item-display ((aregion active-region) state)
#-:PCL
   (declare (ignore state))
;  (format t "~b ~%" (button-state mouse-button-state))
 ; (if (/= (logand (mouse-state-button-state state) *mouse-button-down-1*) 0)
      (let* ((window (active-region-parent aregion))
	  (old-a (get (window-symbol window) 'old-region)))

	(if old-a
	    (draw-region-region window old-a))

	(draw-region-region window  aregion)

	(setf (get (window-symbol window) 'old-region) aregion)

        ;;; $B%W%m%s%W%H%&%#%s%I%&$X$NI=<((B
	(clear-window-stream *prompt-window*)
	(draw-prompt (get (active-region-symbol aregion) 'prompt)))
)

;	(deactivate (active-region-parent aregion))))




;;; $B%a%K%e$NA*Br(B
(defmethod popup-menu-selected ((aregion active-region) state)
#-:PCL
   (declare (ignore state))
  (let* ((p-window (active-region-parent aregion))
	 (window (get (window-symbol p-window) 'currnt))
	 (function (second (get (active-region-symbol aregion) 'method))))

    (deactivate p-window)
    (clear-window-stream *prompt-window*)

;(print function)
    ;;; $B%a%=%C%I$N<B9T(B
    (if function
	(apply function  (list window))))
)



