;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; $B%&%#%s%I%&%9%H%j!<%`$NItIJ$N4pK\%/%i%9$H%a%=%C%I(B
;;; parts-primitive.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.3 91/02/21 by t.kosaka

;;; Change Log   

(in-package :yy)

;;; $B%-!<%o!<%I$N%j%9%H:o=|(B
(defun make-xy-arg (arg)
  (do ((item arg (cdr item)))
      ((null item) arg)
    (when (keywordp (car item))
	(setf (cdr item) nil)
	(return (nbutlast arg)))
    ))


;;; $BIA2h%(%j%"$N4pK\%/%i%9(B
;;; $B:BI87O$O!":8>e6y(B
;;; $B$3$N4pK\%/%i%9$O!"%&%#%s%I%&$N%o!<%k%I$K$OIU$1$i$l$J$$!#(B
;;; $B%&%#%s%I%&IU$1$k>l9g$O!"%W%l%<%s%F!<%7%g%s$+!"%"%/%F%#%V%j!<%8%g%s(B
;;; $B$K$9$k$3$H!#(B
(defclass drawable-piece ()
  ((territory :initarg :territory :initform nil
	      :accessor territory)
   (draw-piece-visible :initarg :draw-piece-visible
		   :initform T :accessor draw-piece-visible))

  )

;;; $B%j!<%8%g%s$r7Q>5$9$kItIJ$K$J$k%/%i%9(B
(defclass piece-region (region drawable-piece) 
  ((object-parent :initarg :object-parent :accessor object-parent
		  :initform nil)
   (child-object-list :initarg :child-object-list
                      :initform nil :accessor child-object-list)))

;;; piece-region $B$r>C5n$9$k(B
;;; flush-draw-piece piece-region &optional (territory T)
;;; ARG.
;;;         piece-region =  $BIA2h%(%j%"(B
;;;         territory    =  $B$b$7(BT$B$J$i$P!"%F%j%H%j!<$N>C5n(B
(defmethod flush-draw-piece ((piece piece-region) &optional (territory T))
  (dolist (item (child-object-list piece))
    (flush-draw-piece item NIL))
  
  ;;; $B4XO"IU$1$r2r=|(B
  (delete-lisp-object (territory piece))

  ;;; $B?F$N$+$i<+J,$r<h$j=|$/(B
  (if (object-parent piece)
      (setf (child-object-list (object-parent piece))
	(delete piece (child-object-list (object-parent piece)))))
  
  (if territory
      (yy-protocol-5 (territory piece)))

  (setf (territory piece) nil)
  nil)


;;; $B%$%s%9%?%s%9@8@.$N(Bafter$B%a%=%C%I(B
;;; $B%F%j%H%j!<$H4XO"$:$1(B
(defmethod initialize-instance :after ((ob piece-region)
				       &rest arg &key &allow-other-keys)
  (unless (find-list :object-parent arg)
     ;;; $B%(%i!<$rH/@8(B
     (error ":Object-Parent argument is NULL.
             You should Make instance with :OBJECT-PARENT argument"))
  (let ((parent (find-list :object-parent arg)))
    
    (unless (territory ob)
      (push ob (child-object-list parent))
      (let ((x (find-list :left arg))
	    (y (find-list :bottom arg))
	    (r (find-list :right arg))
	    (tt (find-list :top arg))
	    (w (find-list :width arg))
	    (h (find-list :height arg)))
	(unless x (setf x 0))
	(unless y (setf y 0))
	(unless w (setf w  (if r (- r x) 1)))
	(unless h (setf h  (if tt (- tt y) 1)))

	(setf (territory ob)
	  (with-object-make-territory 
	   ob :x x :y y :width w :height h
	   :visible (find-list :draw-piece-visible arg)
	   :parent (territory parent)))
	))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; drawable piece$B$NIA2h%a%=%C%I(B ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; draw-piece-point 
;;; drawable piece $B$KE@$rBG$D(B
;;; draw-piece-point drawable-piece x y &key (color black-color*) (op *GCOPY*)
;;; ARG.
;;;        drawable-piece = $BIA2h%(%j%"(B
;;;        x y            = $BIA2h%(%j%"$J$$$N0LCV(B
;;;        color          = $B?'%$%s%9%?%s%9(B
;;;        op             = $B%*%Z%l!<%7%g%s(B
(defmethod draw-piece-point ((object drawable-piece)
			     (x integer) (y integer)
			     &key (color *black-color*) (op *GCOPY*))
  (yy-protocol-20 (territory object) x y op (color-no color)))

;;; draw-piece-line 
;;; drawable piece $B$K@~$r=q$/(B
;;; draw-piece-line drawable-piece x1 y1 x2 y2 &key (color *black-color*)
;;;            (width 1) (op *GCOPY*) (edge  *SQUEAR-LINE-EDGE*)
;;;            (dash "")
;;; ARG.
;;;       drawable-piece = $BIA2h%(%j%"(B
;;;       x1 y1 x2 y2    = $BIA2h%(%j%"$J$$$N0LCV(B
;;;       color          = $B?'%$%s%9%?%s%9(B
;;;       width          = $B@~$NI}(B
;;;       op             = $B%*%Z%l!<%7%g%s(B
;;;       edge           = $B%i%$%s$NC<$N7?(B
;;;       dash           = $BE@@~$N>uBV(B
(defmethod draw-piece-line ((object drawable-piece)
			    (x1 integer) (y1 integer)
			    (x2 integer) (y2 integer)
			    &key (width 1) (op *GCOPY*) 
			    (color *black-color*)
			    (edge  *SQUEAR-LINE-EDGE*)
			    (dash ""))
  (yy-protocol-21 (territory object)
		  x1 y1 x2 y2 width op edge (color-no color)
		  dash))


;;; draw-piece-circle
;;; drawable piece $B$K1_$r=q$/(B
;;; draw-piece-circle drawable-piece x y radius &key
;;;            (color *black-color*) (width 1) (op *GCOPY*) (dash "")
;;; ARG.
;;;       drawable-piece = $BIA2h%(%j%"(B
;;;       x y            = $BIA2h%(%j%"$J$$$N0LCV(B
;;;       radius         = $BH>7B(B
;;;       color          = $B?'%$%s%9%?%s%9(B
;;;       width          = $B@~$NI}(B
;;;       op             = $B%*%Z%l!<%7%g%s(B
;;;       dash           = $BE@@~$N>uBV(B
(defmethod draw-piece-circle ((object drawable-piece)
			    (x integer) (y integer)
			    (radius integer)
			    &key (color *black-color*) (width 1) (op *GCOPY*) 
			    (dash ""))
  (yy-protocol-22 (territory object)
		  x y radius width op (color-no color)
		  dash))

;;; draw-piece-polyline
;;; drawable piece $B$K@^$l@~$r=q$/(B
;;; draw-piece-polyline drawable-piece xy-list &key
;;;            (width 1) (op *GCOPY*) (edge *SQUEAR-LINE-EDGE*)
;;;            (connect *SHARP-JOINT*) (color *black-color*) (dash "")
;;; ARG.
;;;       drawable-piece = $BIA2h%(%j%"(B
;;;       xy-list        = $BIA2h%(%j%"$J$$$N0LCV(B
;;;       edge           = $B@~$NC<$N7A(B
;;;       connect        = $B@\B3E@$N7A(B
;;;       color          = $B?'%$%s%9%?%s%9(B
;;;       width          = $B@~$NI}(B
;;;       op             = $B%*%Z%l!<%7%g%s(B
;;;       dash           = $BE@@~$N>uBV(B
(defmethod draw-piece-polyline ((object drawable-piece)
			     &rest xy-list
			    &key (width 1) (op *GCOPY*) 
			    (dash "") (color *black-color*)
			    (edge *SQUEAR-LINE-EDGE*)
			    (connect *SHARP-JOINT*) &allow-other-keys)
  (yy-protocol-23 (territory object)
		  (make-xy-arg xy-list) width op edge connect (color-no color)
		  dash))

;;; draw-piece-polygon
;;; drawable piece $B$KB?3Q7A$r=q$/(B
;;; draw-piece-polygon drawable-piece xy-list &key
;;;            (op *GCOPY*) (width 1)
;;;            (connect *SHARP-JOINT*) (color *black-color*) (dash "")
;;; ARG.
;;;       drawable-piece = $BIA2h%(%j%"(B
;;;       xy-list        = $BIA2h%(%j%"$J$$$N0LCV(B
;;;       connect        = $B@\B3E@$N7A(B
;;;       color          = $B?'%$%s%9%?%s%9(B
;;;       width          = $B@~$NI}(B
;;;       op             = $B%*%Z%l!<%7%g%s(B
;;;       dash           = $BE@@~$N>uBV(B
(defmethod draw-piece-polygon ((object drawable-piece)
			     &rest xy-list
			    &key (width 1) (op *GCOPY*) 
			    (dash "") (color *black-color*)
			    (connect *SHARP-JOINT*) &allow-other-keys)
  (yy-protocol-24 (territory object)
		  (make-xy-arg xy-list) width op connect (color-no color)
		  dash))

;;; draw-piece-arc
;;; drawable piece $B$K1_8L$r=q$/(B $B3QEY$N;XDj$O!">o$K;~7W2s$j(B
;;;       $B3QEY$N;XDj$O!"%G%#%0%j!<$G!"Bh#4>]8=$rBh0l>]8=$N$4$H$/07$&(B
;;; draw-piece-arc drawable-piece x y radius  theta1 theta2 &key
;;;            (width 1) (op *GCOPY*) (dash "") (color *black-color*)
;;; ARG.
;;;       drawable-piece = $BIA2h%(%j%"(B
;;;       x y            = $BIA2h%(%j%"$J$$$N0LCV(B
;;;       radius         = $BH>7B(B
;;;       theta1         = $B3+;O3QEY(B $B%G%#%0%j!<(B
;;;       theta2         = $B=*N;3QEY(B $B%G%#%0%j!<(B
;;;       color          = $B?'%$%s%9%?%s%9(B
;;;       width          = $B@~$NI}(B
;;;       op             = $B%*%Z%l!<%7%g%s(B
;;;       dash           = $BE@@~$N>uBV(B
(defmethod draw-piece-arc ((object drawable-piece)
			    (x integer) (y integer)
			    (radius integer)
			    theta1 theta2
			    &key (width 1) (op *GCOPY*) 
			    (color *black-color*)
			    (dash ""))
  (yy-protocol-25 (territory object)
		  x y radius 
		  (ceiling (* theta1 64))
		  (ceiling (* theta2 64))
		  width op (color-no color)
		  dash))

;;; draw-piece-rectangle
;;; drawable piece $B$K6k7A$r=q$/(B
;;; draw-piece-rectangle drawable-piece x y width height &key
;;;            (line-width 1) (op *GCOPY*) (color *black-color*) (dash "")
;;; ARG.
;;;       drawable-piece = $BIA2h%(%j%"(B
;;;       x y            = $BIA2h%(%j%"$J$$$N0LCV(B
;;;       width height   = $BI}$H9b$5(B
;;;       color          = $B?'%$%s%9%?%s%9(B
;;;       line-width     = $B@~$NI}(B
;;;       op             = $B%*%Z%l!<%7%g%s(B
;;;       dash           = $BE@@~$N>uBV(B
(defmethod draw-piece-rectangle ((object drawable-piece)
			     (x integer) (y integer) (width integer)
			     (height integer)
			    &key (line-width 1) (op *GCOPY*) 
			    (dash "") (color *black-color*))
  (yy-protocol-26 (territory object)
		  x y width height line-width op (color-no color)
		  dash))
		  

;;; draw-piece-filled-polygon
;;; drawable piece $B$KB?3Q7A$NEI$j$D$V$7$rIA$/(B
;;; $B;XDj$5$l$??'$GEI$j$D$V$5$l$k(B
;;; draw-piece-filled-polygon drawable-piece xy-list &key
;;;            (op *GCOPY*) 
;;;            (connect *SHARP-JOINT*) (color *black-color*)
;;; ARG.
;;;       drawable-piece = $BIA2h%(%j%"(B
;;;       xy-list        = $BIA2h%(%j%"$J$$$N0LCV(B
;;;       connect        = $B@\B3E@$N7A(B
;;;       color          = $B?'%$%s%9%?%s%9(B
;;;       op             = $B%*%Z%l!<%7%g%s(B
(defmethod draw-piece-filled-polygon ((object drawable-piece)
			     &rest xy-list
			    &key (op *GCOPY*) 
			    (color *black-color*)
			    (connect *SHARP-JOINT*) &allow-other-keys)
  (yy-protocol-27 (territory object)
		  (make-xy-arg xy-list) op connect (color-no color)
		  *FillSolid* 0))

;;; draw-piece-filled-rectangle
;;; drawable piece $B$K6k7A$NEI$j$D$V$7$rIA$/(B
;;; $B;XDj$5$l$??'$GEI$j$D$V$5$l$k(B
;;; draw-piece-filled-rectangle drawable-piece x y width height &key
;;;            (op *GCOPY*) 
;;;            (connect *SHARP-JOINT*) (color *black-color*)
;;; ARG.
;;;       drawable-piece = $BIA2h%(%j%"(B
;;;       x y            = $BIA2h%(%j%"$J$$$N0LCV(B
;;;       width height   = $BI}$H9b$5(B
;;;       color          = $B?'%$%s%9%?%s%9(B
;;;       op             = $B%*%Z%l!<%7%g%s(B
(defmethod draw-piece-filled-rectangle ((object drawable-piece)
			    x y width height
			    &key (op *GCOPY*) 
			    (color *black-color*))
  (yy-protocol-28 (territory object)
		  x y width height op (color-no color)
		  0))

;;; draw-piece-filled-circle
;;; drawable piece $B$KEI$j$D$V$5$l$?1_$r=q$/(B
;;; draw-piece-filled-circle drawable-piece x y radius &key 
;;;            (color *black-color*)
;;;            (op *GCOPY*) 
;;; ARG.
;;;       drawable-piece = $BIA2h%(%j%"(B
;;;       x y            = $BIA2h%(%j%"$J$$$N0LCV(B
;;;       radius         = $BH>7B(B
;;;       color          = $B?'%$%s%9%?%s%9(B
;;;       op             = $B%*%Z%l!<%7%g%s(B
(defmethod draw-piece-filled-circle ((object drawable-piece)
				     (x integer) (y integer)
				     (radius integer)
				     (color color)
				     &key (op *GCOPY*) )
  (yy-protocol-29 (territory object)
		  x y radius op (color-no color) 0)
  )

;;; draw-piece-filled-arc
;;; drawable piece $B$KEI$j$D$V$5$l$?1_8LKt$O@p7?$r=q$/(B $B3QEY$N;XDj$O!">o$K;~7W2s$j(B
;;;       $B3QEY$N;XDj$O!"%G%#%0%j!<$G!"Bh#4>]8=$rBh0l>]8=$N$4$H$/07$&(B
;;; draw-piece-filled-arc drawable-piece x y radius theta1 theta2 &key
;;;             (op *GCOPY*) (color *black-color*) (arc-mode *ARCPIESLICE*)
;;; ARG.
;;;       drawable-piece = $BIA2h%(%j%"(B
;;;       x y            = $BIA2h%(%j%"$J$$$N0LCV(B
;;;       radius         = $BH>7B(B
;;;       theta1         = $B3+;O3QEY(B $B%G%#%0%j!<(B
;;;       theta2         = $B=*N;3QEY(B $B%G%#%0%j!<(B
;;;       color          = $B?'%$%s%9%?%s%9(B
;;;       op             = $B%*%Z%l!<%7%g%s(B
;;;       arc-mode       = $B1_8L$N%?%$%W(B($B@p7?$+5]7?(B)
(defmethod draw-piece-filled-arc ((object drawable-piece)
			    (x integer) (y integer)
			    (radius integer)
			    theta1 theta2
			    &key (op *GCOPY*) 
			    (color *black-color*)
			    (arc-mode *ARCPIESLICE*))
  (yy-protocol-30 (territory object)
		  x y radius 
		  (ceiling (* theta1 64))
		  (ceiling (* theta2 64))
		  op (color-no color) 0
		  arc-mode))

;;; draw-piece-string
;;; drawable piece$B$KJ8;zNs$rIA$/(B
;;; draw-piece-string drawable-piece x y string 
;;;             (op *GCOPY*) (color *black-color*) (font *default-font*)
;;; ARG.
;;;       drawable-piece = $BIA2h%(%j%"(B
;;;       x y            = $BIA2h%(%j%"$J$$$N0LCV(B
;;;       string         = $BJ8;zNs(B
;;;       color          = $B?'%$%s%9%?%s%9(B
;;;       op             = $B%*%Z%l!<%7%g%s(B
;;;       font           = $B%U%)%s%H(B
(defmethod draw-piece-string ((object drawable-piece)
			    (x integer) (y integer)
			    string
			    &key (op *GCOPY*) 
			    (color *black-color*)
			    (font *default-font*))
  (yy-protocol-31 (territory object)
		  x y op (color-no color) (font-no font)
		  string))

;;; draw-piece-copy
;;; drawable piece$B$K(Bbitmap$B$+(Bdrawable piece$B$rD%$jIU$1$k(B
;;; draw-piece-copy source-drawable-piece sx sy 
;;;                 distenation-drawable-piece dx dy width height &optional
;;;                 (op *GCOPY*)
;;; ARG.
;;;       source                     = $B%=!<%9IA2h%(%j%"$b$7$/$O%S%C%H%^%C%W(B
;;;       sx sy                      = $B%=!<%9IA2h%(%j%"$J$$$N0LCV(B
;;;       distenation-drawable-piece = $B%G%#%9%F%#%M!<%7%g%sIA2h%(%j%"(B
;;;       dx dy                      = $B%G%#%9%F%#%M!<%7%g%sIA2h%(%j%"$N0LCV(B
;;;       width height               = $BI}$H9b$5(B
;;;       op             = $B%*%Z%l!<%7%g%s(B
(defgeneric draw-piece-copy (s-object sx sy d-object dx dy
			     width height &optional op)
  (:method ((s-object drawable-piece)
	    (sx integer) (sy integer)
	    (d-object drawable-piece)
	    (dx integer) (dy integer) 
	    (width integer) (height integer)
	    &optional (op *GCOPY*))
	   (yy-protocol-35 (territory s-object)
			   sx sy 
			   (territory d-object)
			   dx dy width height op))
  (:method ((s-object bitmap)
	    (sx integer) (sy integer)
            (d-object drawable-piece)
            (dx integer) (dy integer)
            (width integer) (height integer)
            &optional (op *GCOPY*))
	   (yy-protocol-35 (bitmap-territory-no s-object)
			   sx sy
                           (territory d-object)
                           dx dy width height op))
  )

;;; draw-piece-color
;;; drawable piece$B$r;XDj$5$l$??'$GEI$j$D$V$9(B
;;; draw-piece-color drawable-piece color
;;; ARG.
;;;       drawable-piece = $BIA2h%(%j%"(B
;;;       color          = $B?'%$%s%9%?%s%9(B
(defmethod draw-piece-color ((object drawable-piece)
			     (color color))
  (yy-protocol-32 (territory object) (color-no color)))

		  
;;; draw-piece-put-image
;;; drawable piece$B$K%$%a!<%8$r$*$/(B
;;; draw-piece-put-image drawable-piece x y image
;;; ARG.
;;;       drawable-piece = $BIA2h%(%j%"(B
;;;       x y            = $BIA2h%(%j%"$N0LCV(B
;;;       image          = $B%$%a!<%8(B
(defmethod draw-piece-put-image ((object drawable-piece)
				 (x integer) (y integer)
				 (image image))
  (let* ((format1 (if (eq (image-format image) :yy)
                      2
                    1))
         (format (case (image-type image)
                   (:color
                    (logior #x8000 format1))
                   (:gray
                    (logior #x4000 format1))
                   (t
                    (logior #x2000 format1)))))

    (yy-protocol-61 (territory object) x y
		  (image-width image) (image-height image)
		  format (image-data image))))


;;; draw-piece-vertical-string
;;; drawable piece$B$K=D=q$-J8;zNs$rIA$/(B
;;; draw-piece-vertical-string drawable-piece x y string 
;;;             (op *GCOPY*) (color *black-color*) (font *default-font*)
;;; ARG.
;;;       drawable-piece = $BIA2h%(%j%"(B
;;;       x y            = $BIA2h%(%j%"$J$$$N0LCV(B
;;;       string         = $BJ8;zNs(B
;;;       color          = $B?'%$%s%9%?%s%9(B
;;;       op             = $B%*%Z%l!<%7%g%s(B
;;;       font           = $B%U%)%s%H(B
(defmethod draw-piece-vertical-string ((object drawable-piece)
			    (x integer) (y integer)
			    string
			    &key (op *GCOPY*) 
			    (color *black-color*)
			    (font *default-font*))
  (yy-protocol-43 (territory object)
		  x y op (color-no color) (font-no font)
		  string))

;;; draw-piece-ellipse
;;; drawable piece $B$KBJ1_$rIA$/(B
;;;       $B3QEY$N;XDj$O!"%G%#%0%j!<$G!"Bh#4>]8=$rBh0l>]8=$N$4$H$/07$&(B
;;; draw-piece-ellipse drawable-piece x-radius y-radius &key
;;;             (op *GCOPY*) (color *black-color*) (width 1)
;;;             (dash "") (theta1 0) (theta 360)
;;; ARG.
;;;       drawable-piece = $BIA2h%(%j%"(B
;;;       x y            = $BIA2h%(%j%"$J$$$N0LCV(B
;;;       x-radius       = X$B<4>e$NH>7B(B
;;;       y-radius       = Y$B<4>e$NH>7B(B
;;;       theta1         = $B3+;O3QEY(B $B%G%#%0%j!<(B
;;;       theta2         = $B=*N;3QEY(B $B%G%#%0%j!<(B
;;;       color          = $B?'%$%s%9%?%s%9(B
;;;       op             = $B%*%Z%l!<%7%g%s(B
;;;       dash           = $BE@@~$N%Q%?!<%s(B
(defmethod draw-piece-ellipse ((object drawable-piece)
			       (x integer) (y integer)
			       (x-radius integer)
			       (y-radius integer)
			       &key  (theta1 0) (theta2 360)
			       (width 1)
			       (op *GCOPY*) 
			       (color *black-color*)
			       (dash ""))
  (yy-protocol-41 (territory object)
		  x y (* 2 x-radius) (* 2 y-radius)
		  (ceiling (* theta1 64))
		  (ceiling (* theta2 64))
		  width  op (color-no color) dash))


;;; draw-piece-filled-ellipse
;;; drawable piece $B$KEI$j$D$V$7BJ1_$rIA$/(B
;;;       $B3QEY$N;XDj$O!"%G%#%0%j!<$G!"Bh#4>]8=$rBh0l>]8=$N$4$H$/07$&(B
;;; draw-piece-filled-ellipse drawable-piece x y x-radius y-radius &key
;;;             (op *GCOPY*) (color *black-color*) 
;;;             (theta1 0) (theta 360) (arc-mode *ARCPIESLICE*)
;;; ARG.
;;;       drawable-piece = $BIA2h%(%j%"(B
;;;       x y            = $BIA2h%(%j%"$J$$$N0LCV(B
;;;       x-radius       = X$B<4>e$NH>7B(B
;;;       y-radius       = Y$B<4>e$NH>7B(B
;;;       theta1         = $B3+;O3QEY(B $B%G%#%0%j!<(B
;;;       theta2         = $B=*N;3QEY(B $B%G%#%0%j!<(B
;;;       color          = $B?'%$%s%9%?%s%9(B
;;;       op             = $B%*%Z%l!<%7%g%s(B
;;;       arc-mode       = $B1_8L$N%?%$%W(B($B@p7?$+5]7?(B)
(defmethod draw-piece-filled-ellipse ((object drawable-piece)
				      (x integer) (y integer)
				      (x-radius integer)
				      (y-radius integer)
				      &key  (theta1 0) (theta2 360)
				      (arc-mode *ARCPIESLICE*)
				      (op *GCOPY*) 
				      (color *black-color*))
  (yy-protocol-42 (territory object)
		  x y (* 2 x-radius) (* 2 y-radius)
		  (ceiling (* theta1 64))
		  (ceiling (* theta2 64))
		  op (color-no color) 0 arc-mode))

;;; (setf draw-piece-visible)
;;; drawable piece $B$NI=<(>uBV$rJQ99$9$k(B
;;; (setf draw-piece-visible) val ob
;;; ARG.
;;;            val    =  T or NIL T:$BI=<((B NIL:$BHsI=<((B
;;;            ob     = $BIA2h%(%j%"(B
(defmethod (setf draw-piece-visible) :after (val (ob drawable-piece))
  (if val
      (yy-protocol-2 (territory ob) 1)
    (yy-protocol-2 (territory ob) 0)))


;;; with-real-object 
;;; with-real-object (draw-piece) form
;;; $B%F%j%H%j!<$N@)8f%a%=%C%I(B
;;; draw-piece$B$K$*$1$k%j!<%8%g%s$N%9%m%C%H$rJQ99$9$k(B
;;; $B>l9g$O!"I,$:2<5-$N%^%/%m$rMxMQ$9$k$3$H(B
;;  $B$b$7$=$&$G$J$1$l$P!"<B:]$N%*%V%8%'%/%H$NJQ99$O5/$3$i$J$$!#(B
(defmacro with-real-object ((draw-piece) &body body)
  (let ((ret (gentemp)))
    `(let ((,ret (multiple-value-list (progn ,@body))))
       (yy-protocol-4 (territory ,draw-piece)
		      (region-left ,draw-piece)
		      (region-bottom ,draw-piece)
		      (region-width ,draw-piece)
		      (region-height ,draw-piece)
		      0 0)
       (values-list ,ret))))


;;; $B%^%&%9%a%=%C%IIU$-$NIA2h%(%j%"(B
(defclass event-drawable-piece (piece-region event-method-mixin)
  ())

(defun get-avialble-mask (list)
 (declare (special *mouse-move* *mouse-in* *mouse-out* *mouse-wait*
                    *mouse-button-down-1* *mouse-right-1*
                    *mouse-middle-1* *mouse-left-1* *mouse-button-up*
                    *mouse-right-up* *mouse-middle-up* *mouse-left-up*
                    *mouse-button-down-2* *mouse-right-2* *mouse-middle-2*
                    *mouse-left-2*))
  (let ((mask 0))
    (do ((item-list list (cdr item-list)))
	((null item-list))
      (case (car item-list)
	(:button-1
	 (if (second item-list)
	     (setf mask (logior mask *mouse-button-down-1*))))
	(:left-button-down-1
	 (if (second item-list)
	     (setf mask (logior mask *mouse-left-1*))))
	(:middle-button-down-1
	 (if (second item-list)
	     (setf mask (logior mask *mouse-middle-1*))))
	(:right-button-down-1
	 (if (second item-list)
	     (setf mask (logior mask *mouse-right-1*))))
	(:button-up
	 (if (second item-list)
	     (setf mask (logior mask *mouse-button-up*))))
	(:left-button-up
	 (if (second item-list)
	     (setf mask (logior mask *mouse-left-up*))))
	(:middle-button-up
	 (if (second item-list)
	     (setf mask (logior mask *mouse-middle-up*))))
	(:right-button-up
	 (if (second item-list)
	     (setf mask (logior mask *mouse-right-up*))))
	(:button-2
	 (if (second item-list)
	     (setf mask (logior mask  *mouse-button-down-2*))))
	(:left-button-down-2
	 (if (second item-list)
	     (setf mask (logior mask *mouse-left-2*))))
	(:middle-button-down-2
	 (if (second item-list)
	     (setf mask (logior mask *mouse-middle-2*))))
	(:right-button-down-2
	 (if (second item-list)
	     (setf mask (logior mask *mouse-right-2*))))
	(:move-mouse-cursor
	 (if (second item-list)
	     (setf mask (logior mask *mouse-move*))))
	(:mouse-cursor-in
	 (if (second item-list)
	     (setf mask (logior mask *mouse-in*))))
	(:mouse-cursor-out
	 (if (second item-list)
	     (setf mask (logior mask *mouse-out*))))
	(:mouse-cursor-wait
	 (if (second item-list)
	     (setf mask (logior mask *mouse-wait*))))
	))
    mask))

;;; $B%^%&%9%a%=%C%I$N=i4|2=(B
(defmethod initialize-instance :after ((ob event-drawable-piece)
				       &rest arg)
  (let ((mask (get-avialble-mask arg)))
    ;;; $B%$%Y%s%H%^%9%/$N@_Dj(B
    (unless (find-list :object-parent arg)
     ;;; $B%(%i!<$rH/@8(B
     (error ":Object-Parent argument is NULL.
             You should Make instance with :OBJECT-PARENT argument"))
  
    (let ((parent (find-list :object-parent arg)))
      (unless (territory ob)
	(push ob (child-object-list parent))
	(let ((x (find-list :left arg))
	      (y (find-list :bottom arg))
	      (r (find-list :right arg))
	      (tt (find-list :top arg))
	      (w (find-list :width arg))
	      (h (find-list :height arg)))
	  (unless x (setf x 0))
	  (unless y (setf y 0))
	  (unless w (setf w  (if r (- r x) 1)))
	  (unless h (setf h  (if tt (- tt y) 1)))

	  (setf (territory ob)
	    (with-object-make-territory 
	     ob :x x :y y :width w :height h
	     :visible (find-list :draw-piece-visible arg)
	     :parent (territory parent))))
	
	(setf (slot-value ob 'event-mask) mask)
	(yy-protocol-72 (territory ob) mask)))))

;;; with-event-object
;;; with-event-object (draw-piece) form
;;; draw-piece$B$K$*$1$k%^%&%9%a%=%C%I$rDI2C$7$?$$>l9g$O(B
;;; $BI,$:$3$N%^%/%m$rMxMQ$9$k(B
(defmacro with-event-object ((draw-piece) &body body)
  (let ((ret (gentemp)))
    `(let ((,ret (multiple-value-list (progn ,@body))))
       (yy-protocol-72 (territory ,draw-piece) 
		       (slot-value ,draw-piece 'event-mask))
       (values-list ,ret))))


