;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; Bitmap-stream 
;;; bitmap-stream.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.0 90/06/01 by t.kosaka (kosaka@csrl.aoyama.ac.jp)
;;;   version 1.1 90/07/31 by t.kosaka
;;;   update 1.11 90/09/14 by t.kosaka
;;;   version 1.2 90/11/05 by t.kosaka

;;; $B%S%C%H%^%C%W%9%H%j!<%`%/%i%9(B
;;; 6/22 1990 $B8E:d(B
;;; Version 1.0   Coded by t.kosaka 1990-6-22

(in-package :yy)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $B%S%C%H%^%C%W%9%H%j!<%`%/%i%9(B ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass bitmap-stream (world-primitive) ())

;;; $B%S%C%H%^%C%W%9%H%j!<%`%/%i%9$r:n$k(B
(defun make-bitmap-stream (&rest rest &key (width 1) (height 1)
				(font *DEFAULT-FONT*)
				(coordinate :left-top)
				(class 'bitmap-stream)
				 &allow-other-keys)
  (apply #'make-instance class
	 :right width :top height
	 :translate-coordinate
	 (if (eq coordinate :left-bottom)
	     (make-instance
		 'translate-coordinate-left-bottom)
	   (make-instance
	       'translate-coordinate-left-top))
	 :text-font font
	 :line-feed (font-kanji-height font) rest))

(defmethod initialize-instance :after ((instance bitmap-stream) &rest rest
				       &key &allow-other-keys)
  (declare (special *DEFAULT-FONT* *ROOT-TERRITORY-NO*)
	   (ignore rest))
  (let ((font (stream-font instance))
	(tno 0)
	(width (region-width instance))
	(height (region-height instance)))

    ;;; $B%+!<%=%k%]%8%7%g%s$N=i4|@_Dj(B
    (setf (position-y (slot-value instance 'cursor-position)) 
	  (font-kanji-base-line font))

    (setf tno (with-object-make-territory instance :width width 
					  :height height 
					  :parent *ROOT-TERRITORY-NO*
					  :visible NIL 
					  :drawable T
					  :window-mode T))

    ;;; $B%F%j%H%j!<HV9f$r@_Dj(B
    (setf (world-territory-no instance) tno)

    instance))

;;; $B%S%C%H%^%C%W%9%H%j!<%`$NI=<(%a%=%C%I(B
(defmethod print-object ((bitmap bitmap-stream) stream)
  (let ((region bitmap))
    (format stream "\#<Bitmap Stream ~a X ~a>" (region-width region)
	    (region-height region))))

;;; $B%S%C%H%^%C%W%9%H%j!<%`$+!)(B
(defun bitmap-streamp (object)
  (typep object 'bitmap-stream))

;;; $B%S%C%H%^%C%W%9%H%j!<%`$N>C5n(B
(defmethod flush-bitmap-stream ((bitmap bitmap-stream))
  (let ((val (yy-protocol-5 (world-territory-no bitmap))))
    (if (zerop val)
	(error "Sorry ,can not remove ~a" bitmap)
      (progn 
	(delete-lisp-object (world-territory-no bitmap))
      nil)))
  )
  

  