;;; -*- Mode: LISP; Syntax: COMMON-LISP; Base: 10.; Package: XIT -*-
;;;_____________________________________________________________________________
;;;
;;;                       System: XAM
;;;                       Module: timers
;;;                       Version: 1.0
;;;
;;; Copyright (c): Forschungsgruppe DRUID, Juergen Herczeg
;;;                Universitaet Stuttgart
;;;
;;; File: /usr/local/lisp/xit/xam/timer-meta.lisp
;;; File Creation Date: 07/21/92 10:01:47
;;; Last Modification Time: 03/09/93 14:06:53
;;; Last Modification By: Juergen Herczeg
;;;
;;;
;;; Changes (worth to be mentioned):
;;; ================================
;;;
;;;_____________________________________________________________________________

(in-package :xit)

(defmethod select-meta-timer-sheet (object)
  (declare (ignore object))
  nil)

(defmethod select-meta-timer-sheet ((self timer-mixin))
  (declare (special *meta-pool*))
  (let ((sheet (get-pool-window *meta-pool* :meta-timer-sheet)))
    (setf (view-of sheet) self)
    (popup sheet)))

(defmethod make-meta-sheet-named ((key (eql :meta-timer-sheet)))
  (create-meta-property-sheet
   nil
   :title "Timer Options"
   :name :meta-timer-sheet
   :parts
   '((:class property-field
      :name :name
      :view-of :default
      :label "name"
      ;;:read-function identity
      :reactivity-entries ((:part-event (call :write))
			   (:read-event
			    (call :eval
				  (let ((value-part (part *self* :value))
					(old-value (value *self*))
					(timer-names
					 (timer-names
					  (view-of (part-of *self*)))))
				    (setf (parts value-part)
					(mapcar
					 #'(lambda (name)
					     `(:text ,(convert-to-string name)
						     :view-of ,name))
					 timer-names))
				    (setf (value *self*)
					(or old-value :default)))))
			   (:write-event
			    (call :part-of read-from-application)))
      :read-initially? nil
      :value-part
      (:class single-choice-text-menu-with-input
       :layouter (distance-layouter :orientation :right)))
     (:class text-property-field
      :name :interval
      :label "interval"
      :read-function (lambda (view-of)
		       (or (timer-interval view-of
			       (value (part (part-of *self*) :name)))
			   1))
      :read-transformation convert-nil-to-empty-string
      :write-function (lambda (view-of value)
			  (setf (timer-interval view-of
				  (value (part (part-of *self*) :name)))
			      value))
      :write-transformation convert-from-string
      :read-initially? nil)
     
     (:class text-property-field
      :name :value
      :label "value"
      :read-function (lambda (view-of)
			 (timer-value view-of
			  (value (part (part-of *self*) :name))))
      :read-transformation convert-nil-to-empty-string
      :write-function (lambda (view-of value)
			  (setf (timer-value view-of
				  (value (part (part-of *self*) :name)))
			      value))
      :write-transformation convert-from-string
      :read-initially? nil)
     (:label "status"
      :read-function (lambda (view-of)
			 (timer view-of
			  (value (part (part-of *self*) :name))))
      :read-transformation convert-from-boolean
      :write-function (lambda (view-of value)
			(let ((name-part (part (part-of *self*) :name)))
			  (if value
			      (add-timer view-of
					 (value name-part)
					 (value
					  (part (part-of *self*) :interval))
					 (value
					  (part (part-of *self*) :value)))
			    (delete-timer view-of
					  (value name-part)))
			  (read-from-application name-part)))
      :write-transformation convert-to-boolean
      :read-initially? nil
      :value-part
      (:class single-choice-text-menu
       :layouter (distance-layouter :orientation :right)
       :parts ((:view-of :no
		:action-docu "Remove timer"
		:text "Inactive")
	       (:view-of :yes
		:action-docu "Add timer"
		:text "Active"))))
     (:class text-property-field
      :label "action"
      :transformer list-transformer
      :read-initially? nil
      :reactivity-entries ((:read-event
			    (call :eval
				  (let ((actions 
					 (reactivity-actions-for
					  (view-of *self*)
					  (list :timer
						(value (part (part-of *self*)
							     :name))))))
				    (setf (value *self*)
					(unless (eq actions t) actions)))))
			   (:write-event
			    (call :eval
				  (apply #'change-reactivity
					 (view-of *self*)
					 (list :timer
					       (value (part (part-of *self*)
							    :name)))
					 (value *self*)))))
      ))))
    